/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.editor.PanZoomListener;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ActionsToolbar
implements DesignSurfaceListener,
Disposable,
PanZoomListener,
ConfigurationListener,
ModelListener {
    private static final int CONFIGURATION_UPDATE_FLAGS = 34;
    private final DesignSurface mySurface;
    private final JComponent myToolbarComponent;
    private ActionToolbar myNorthToolbar;
    private ActionToolbar myNorthEastToolbar;
    private ActionToolbarImpl myCenterToolbar;
    private ActionToolbar myEastToolbar;
    private final DefaultActionGroup myDynamicGroup;
    private Configuration myConfiguration;
    private DesignerEditorFileType myLayoutType;
    private ToolbarActionGroups myToolbarActionGroups;
    private NlModel myModel;

    public ActionsToolbar(@NotNull Disposable parent, @NotNull DesignSurface surface2) {
        if (parent == null) {
            ActionsToolbar.$$$reportNull$$$0(0);
        }
        if (surface2 == null) {
            ActionsToolbar.$$$reportNull$$$0(1);
        }
        this.myDynamicGroup = new DefaultActionGroup();
        this.myModel = null;
        Disposer.register((Disposable)parent, (Disposable)this);
        this.mySurface = surface2;
        this.mySurface.addListener(this);
        this.mySurface.addPanZoomListener(this);
        if (this.myConfiguration == null) {
            this.myConfiguration = (Configuration)Iterables.getFirst(this.mySurface.getConfigurations(), null);
            if (this.myConfiguration != null) {
                this.myConfiguration.addListener((ConfigurationListener)this);
            }
        }
        this.myToolbarComponent = ActionsToolbar.createToolbarComponent();
        this.updateActionGroups(surface2.getLayoutType());
        this.updateActions();
    }

    public void dispose() {
        this.mySurface.removePanZoomListener(this);
        this.mySurface.removeListener(this);
        if (this.myConfiguration != null) {
            this.myConfiguration.removeListener((ConfigurationListener)this);
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this);
            this.myModel = null;
        }
    }

    @NotNull
    public JComponent getToolbarComponent() {
        JComponent jComponent = this.myToolbarComponent;
        if (jComponent == null) {
            ActionsToolbar.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @TestOnly
    ActionToolbarImpl getCenterToolbar() {
        return this.myCenterToolbar;
    }

    @NotNull
    private static JComponent createToolbarComponent() {
        AdtPrimaryPanel panel2 = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        panel2.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)StudioColorsKt.getBorder()));
        AdtPrimaryPanel adtPrimaryPanel = panel2;
        if (adtPrimaryPanel == null) {
            ActionsToolbar.$$$reportNull$$$0(3);
        }
        return adtPrimaryPanel;
    }

    private void updateActionGroups(@NotNull DesignerEditorFileType layoutType) {
        if (layoutType == null) {
            ActionsToolbar.$$$reportNull$$$0(4);
        }
        this.myToolbarComponent.removeAll();
        if (this.myToolbarActionGroups != null) {
            Disposer.dispose((Disposable)this.myToolbarActionGroups);
        }
        this.myToolbarActionGroups = layoutType.getToolbarActionGroups(this.mySurface);
        Disposer.register((Disposable)this, (Disposable)this.myToolbarActionGroups);
        this.myNorthToolbar = ActionsToolbar.createActionToolbar("NlConfigToolbar", this.myToolbarActionGroups.getNorthGroup());
        this.myNorthToolbar.setLayoutPolicy(2);
        this.myNorthToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        JComponent northToolbarComponent = this.myNorthToolbar.getComponent();
        northToolbarComponent.setName("NlConfigToolbar");
        this.myNorthEastToolbar = ActionsToolbar.createActionToolbar("NlRhsConfigToolbar", this.myToolbarActionGroups.getNorthEastGroup());
        this.myNorthEastToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        JComponent northEastToolbarComponent = this.myNorthEastToolbar.getComponent();
        northEastToolbarComponent.setName("NlRhsConfigToolbar");
        this.myCenterToolbar = ActionsToolbar.createActionToolbar("NlLayoutToolbar", (ActionGroup)this.myDynamicGroup);
        this.myCenterToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        JComponent centerToolbarComponent = this.myCenterToolbar.getComponent();
        centerToolbarComponent.setName("NlLayoutToolbar");
        AdtPrimaryPanel centerToolbarComponentWrapper = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        centerToolbarComponentWrapper.add(centerToolbarComponent);
        this.myEastToolbar = ActionsToolbar.createActionToolbar("NlRhsToolbar", this.myToolbarActionGroups.getEastGroup());
        this.myEastToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        JComponent eastToolbarComponent = this.myEastToolbar.getComponent();
        eastToolbarComponent.setName("NlRhsToolbar");
        if (northToolbarComponent.isVisible() || northEastToolbarComponent.isVisible()) {
            AdtPrimaryPanel northPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
            northPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)StudioColorsKt.getBorder()));
            northPanel.add((Component)northToolbarComponent, "Center");
            northPanel.add((Component)northEastToolbarComponent, "East");
            this.myToolbarComponent.add((Component)northPanel, "North");
        }
        this.myToolbarComponent.add((Component)centerToolbarComponentWrapper, "Center");
        this.myToolbarComponent.add((Component)eastToolbarComponent, "East");
    }

    @NotNull
    private static ActionToolbarImpl createActionToolbar(@NotNull String place, @NotNull ActionGroup group) {
        if (place == null) {
            ActionsToolbar.$$$reportNull$$$0(5);
        }
        if (group == null) {
            ActionsToolbar.$$$reportNull$$$0(6);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(place, group, true);
        toolbar.setLayoutPolicy(1);
        if (group == ActionGroup.EMPTY_GROUP) {
            toolbar.getComponent().setVisible(false);
        }
        ActionToolbarUtil.makeToolbarNavigable((ActionToolbar)toolbar);
        ActionToolbarImpl actionToolbarImpl = (ActionToolbarImpl)toolbar;
        if (actionToolbarImpl == null) {
            ActionsToolbar.$$$reportNull$$$0(7);
        }
        return actionToolbarImpl;
    }

    public void updateActions() {
        SceneView view = this.mySurface.getFocusedSceneView();
        if (view != null) {
            SelectionModel selectionModel = view.getSelectionModel();
            List<NlComponent> selection = selectionModel.getSelection();
            if (selection.isEmpty()) {
                ImmutableList<NlComponent> roots = view.getModel().getComponents();
                if (roots.size() == 1) {
                    selection = Collections.singletonList((NlComponent)roots.get(0));
                } else {
                    this.updateBottomActionBarBorder();
                    return;
                }
            }
            this.updateActions(selection);
        }
    }

    private void updateActions(@NotNull List<NlComponent> newSelection) {
        SceneView screenView;
        if (newSelection == null) {
            ActionsToolbar.$$$reportNull$$$0(8);
        }
        if ((screenView = this.mySurface.getFocusedSceneView()) == null) {
            return;
        }
        DesignerEditorFileType surfaceLayoutType = this.mySurface.getLayoutType();
        DefaultActionGroup selectionToolbar = surfaceLayoutType.getSelectionContextToolbar(this.mySurface, newSelection);
        if (selectionToolbar.getChildrenCount() > 0) {
            this.myDynamicGroup.copyFromGroup(selectionToolbar);
        }
        this.updateBottomActionBarBorder();
        this.myCenterToolbar.clearPresentationCache();
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface2, @NotNull List<NlComponent> newSelection) {
        if (surface2 == null) {
            ActionsToolbar.$$$reportNull$$$0(9);
        }
        if (newSelection == null) {
            ActionsToolbar.$$$reportNull$$$0(10);
        }
        assert (surface2 == this.mySurface);
        if (!newSelection.isEmpty()) {
            this.updateActions(newSelection);
        } else {
            this.updateActions();
        }
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface2, @Nullable NlModel model2) {
        if (surface2 == null) {
            ActionsToolbar.$$$reportNull$$$0(11);
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this);
        }
        if (model2 != null) {
            model2.addListener(this);
        }
        this.myModel = model2;
        this.myNorthToolbar.updateActionsImmediately();
        this.myNorthEastToolbar.updateActionsImmediately();
        DesignerEditorFileType surfaceLayoutType = surface2.getLayoutType();
        if (surfaceLayoutType != this.myLayoutType) {
            this.myLayoutType = surfaceLayoutType;
            this.updateActionGroups(this.myLayoutType);
        }
        this.updateActions();
    }

    private void updateBottomActionBarBorder() {
        boolean hasBottomActionBar = this.myEastToolbar.getComponent().isVisible() || this.myDynamicGroup.getChildrenCount() > 0;
        int bottom2 = hasBottomActionBar ? 1 : 0;
        this.myToolbarComponent.setBorder(BorderFactory.createMatteBorder(0, 0, bottom2, 0, (Color)StudioColorsKt.getBorder()));
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface2, @NotNull NlComponent component) {
        if (surface2 == null) {
            ActionsToolbar.$$$reportNull$$$0(12);
        }
        if (component == null) {
            ActionsToolbar.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model2) {
        if (model2 == null) {
            ActionsToolbar.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.mySurface.getProject().isDisposed()) {
                return;
            }
            if (model2.getComponents().size() == 1) {
                this.updateActions();
            }
        });
    }

    public void zoomChanged(double previousScale, double newScale) {
        UIUtil.invokeLaterIfNeeded(() -> this.myNorthEastToolbar.updateActionsImmediately());
    }

    public void panningChanged(@NotNull AdjustmentEvent event) {
        if (event == null) {
            ActionsToolbar.$$$reportNull$$$0(15);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myNorthEastToolbar.updateActionsImmediately());
    }

    public boolean changed(int flags) {
        if ((flags & 0x22) > 0 && this.myNorthToolbar != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.myNorthEastToolbar.updateActionsImmediately());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/ActionsToolbar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/ActionsToolbar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateActionGroups";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "componentSelectionChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "modelDerivedDataChanged";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "panningChanged";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

