/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.surface.NlSupportedActions;
import com.android.tools.idea.uibuilder.surface.NlSupportedActionsKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.IconUtil;
import icons.StudioIcons;
import javax.swing.Icon;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public class IssueNotificationAction
extends ToggleAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final String DEFAULT_TOOLTIP = "Toggle visibility of issue panel";
    private static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)StudioIcons.Common.ERROR);

    @NotNull
    protected Pair<Icon, String> getNoErrorsIconAndDescription(@NotNull AnActionEvent event) {
        if (event == null) {
            IssueNotificationAction.$$$reportNull$$$0(0);
        }
        return new Pair(null, null);
    }

    @NotNull
    public static IssueNotificationAction getInstance() {
        IssueNotificationAction issueNotificationAction = (IssueNotificationAction)ActionManager.getInstance().getAction("Android.Designer.IssueNotificationAction");
        if (issueNotificationAction == null) {
            IssueNotificationAction.$$$reportNull$$$0(1);
        }
        return issueNotificationAction;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            IssueNotificationAction.$$$reportNull$$$0(2);
        }
        if (DesignerActionUtils.isActionEventFromJTextField(event)) {
            event.getPresentation().setEnabled(false);
            return;
        }
        super.update(event);
        DesignSurface surface2 = (DesignSurface)((Object)event.getData(DesignerDataKeys.DESIGN_SURFACE));
        Presentation presentation = event.getPresentation();
        if (surface2 == null || !NlSupportedActionsKt.isActionSupported(surface2, NlSupportedActions.TOGGLE_ISSUE_PANEL)) {
            event.getPresentation().setEnabled(false);
            presentation.setText(SHOW_ISSUE);
            presentation.setDescription(DEFAULT_TOOLTIP);
            presentation.setIcon(DISABLED_ICON);
        } else {
            event.getPresentation().setEnabled(true);
            IssueModel issueModel = surface2.getIssueModel();
            int markerCount = issueModel.getIssueCount();
            presentation.setDescription(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
            if (markerCount == 0) {
                Pair<Icon, String> iconAndDescription = this.getNoErrorsIconAndDescription(event);
                if (iconAndDescription.getSecond() != null) {
                    presentation.setText((String)iconAndDescription.getSecond());
                }
                if (iconAndDescription.getFirst() == null) {
                    presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
                } else {
                    presentation.setIcon((Icon)iconAndDescription.getFirst());
                }
            } else {
                presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
                presentation.setText(DEFAULT_TOOLTIP);
            }
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            IssueNotificationAction.$$$reportNull$$$0(3);
        }
        DesignSurface surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE));
        if (((Boolean)StudioFlags.NELE_SHOW_ISSUE_PANEL_IN_PROBLEMS.get()).booleanValue()) {
            if (surface2 == null) {
                return false;
            }
            IssuePanelService service = IssuePanelService.getInstance(surface2.getProject());
            if (service == null) {
                Logger.getInstance(IssueNotificationAction.class).warn("Cannot find issue panel service");
                return false;
            }
            if (service.isLayoutAndQualifierPanelVisible()) {
                return service.isIssueModelAttached(surface2.getIssueModel());
            }
            return false;
        }
        return surface2 != null && !surface2.getIssuePanel().isMinimized();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        DesignSurface surface2;
        if (e == null) {
            IssueNotificationAction.$$$reportNull$$$0(4);
        }
        if ((surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE))) == null) {
            return;
        }
        surface2.getAnalyticsManager().trackShowIssuePanel();
        if (((Boolean)StudioFlags.NELE_SHOW_ISSUE_PANEL_IN_PROBLEMS.get()).booleanValue()) {
            IssuePanelService issuePanelService = IssuePanelService.getInstance(surface2.getProject());
            if (issuePanelService == null) {
                Logger.getInstance(IssueNotificationAction.class).warn("Cannot find the issue panel service when set its visibility");
                return;
            }
            if (state) {
                issuePanelService.showCurrentFileAndQualifierTab();
                issuePanelService.attachIssueModel(surface2.getIssueModel(), surface2.getModel().getVirtualFile());
            } else {
                issuePanelService.detachIssueModel(surface2.getIssueModel());
                issuePanelService.hideIssuePanel();
            }
        } else {
            surface2.setShowIssuePanel(state, true);
        }
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel) {
        if (issueModel == null) {
            IssueNotificationAction.$$$reportNull$$$0(5);
        }
        Icon icon2 = issueModel.getErrorCount() > 0 ? StudioIcons.Common.ERROR : (issueModel.getWarningCount() > 0 ? StudioIcons.Common.WARNING : (issueModel.getIssueCount() > 0 ? StudioIcons.Common.INFO : DISABLED_ICON));
        Icon icon3 = icon2;
        if (icon3 == null) {
            IssueNotificationAction.$$$reportNull$$$0(6);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueTypeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNoErrorsIconAndDescription";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIssueTypeIcon";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

