/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.MockupToggleAction;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.mockup.editor.MockUpFileChooser;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupEditAction
extends AnAction {
    private static final String EDIT_ACTION_TITLE = "Edit Mockup";
    private static final String ADD_ACTION_TITLE = "Add Mockup";
    private final MockupToggleAction myMockupToggleAction;
    private final NlDesignSurface myDesignSurface;

    public MockupEditAction(@NotNull NlDesignSurface designSurface) {
        if (designSurface == null) {
            MockupEditAction.$$$reportNull$$$0(0);
        }
        super(ADD_ACTION_TITLE);
        if (!((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
            this.myMockupToggleAction = null;
            this.myDesignSurface = null;
            return;
        }
        this.myDesignSurface = designSurface;
        this.myMockupToggleAction = new MockupToggleAction(designSurface);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            MockupEditAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        if (!((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        NlComponent component = this.getFirstSelectedComponent();
        if (component == null) {
            presentation.setEnabled(false);
        } else if (component.getAttribute("http://schemas.android.com/tools", "mockup") != null) {
            presentation.setText(EDIT_ACTION_TITLE);
        } else {
            presentation.setText(ADD_ACTION_TITLE);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            MockupEditAction.$$$reportNull$$$0(2);
        }
        this.myMockupToggleAction.setSelected(event, true);
        NlComponent component = this.getFirstSelectedComponent();
        if (component == null) {
            return;
        }
        this.myMockupToggleAction.setSelected(event, true);
        MockUpFileChooser.INSTANCE.chooseMockUpFile(component, path -> NlWriteCommandActionUtil.run(component, Strings.nullToEmpty((String)event.getPresentation().getText()), () -> {
            component.setAttribute("http://schemas.android.com/tools", "mockup", (String)path);
            component.setAttribute("http://schemas.android.com/tools", "mockup_crop", "");
        }));
    }

    @Nullable
    public NlComponent getFirstSelectedComponent() {
        NlModel model2 = this.myDesignSurface.getModel();
        if (model2 == null) {
            return null;
        }
        List<NlComponent> selection = this.myDesignSurface.getSelectionModel().getSelection();
        if (selection.isEmpty()) {
            selection = model2.getComponents();
        }
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/actions/MockupEditAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

