/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.libcore.io;

import java.nio.ByteBuffer;
import libcore.io.BufferIterator;

public class BridgeBufferIterator
extends BufferIterator {
    private final long mSize;
    private final ByteBuffer mByteBuffer;

    public BridgeBufferIterator(long size, ByteBuffer buffer) {
        this.mSize = size;
        this.mByteBuffer = buffer;
    }

    @Override
    public void seek(int offset2) {
        assert ((long)offset2 <= this.mSize);
        this.mByteBuffer.position(offset2);
    }

    @Override
    public int pos() {
        return this.mByteBuffer.position();
    }

    @Override
    public void skip(int byteCount) {
        int newPosition = this.mByteBuffer.position() + byteCount;
        assert ((long)newPosition <= this.mSize);
        this.mByteBuffer.position(newPosition);
    }

    @Override
    public void readByteArray(byte[] dst, int dstOffset, int byteCount) {
        assert (dst.length >= dstOffset + byteCount);
        this.mByteBuffer.get(dst, dstOffset, byteCount);
    }

    @Override
    public byte readByte() {
        return this.mByteBuffer.get();
    }

    @Override
    public int readInt() {
        return this.mByteBuffer.getInt();
    }

    @Override
    public void readIntArray(int[] dst, int dstOffset, int intCount) {
        while (--intCount >= 0) {
            dst[dstOffset++] = this.mByteBuffer.getInt();
        }
    }

    @Override
    public void readLongArray(long[] dst, int dstOffset, int longCount) {
        while (--longCount >= 0) {
            dst[dstOffset++] = this.mByteBuffer.getLong();
        }
    }

    @Override
    public short readShort() {
        return this.mByteBuffer.getShort();
    }
}

