/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl.binding;

import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.binding.AdapterItem;

public class AdapterHelper {
    static Pair<View, Boolean> getView(AdapterItem item, AdapterItem parentItem, ViewGroup parent, LayoutlibCallback callback2, ResourceReference adapterRef, boolean skipCallbackParser) {
        DataBindingItem dataBindingItem = item.getDataBindingItem();
        BridgeContext context = RenderAction.getCurrentContext();
        Pair<View, Boolean> pair = context.inflateView(dataBindingItem.getViewReference(), parent, false, skipCallbackParser);
        View view = (View)pair.first;
        skipCallbackParser |= ((Boolean)pair.second).booleanValue();
        if (view != null) {
            AdapterHelper.fillView(context, view, item, parentItem, callback2, adapterRef);
        } else {
            TextView tv = new TextView(context);
            tv.setText("Unable to find layout: " + dataBindingItem.getViewReference().getName());
            view = tv;
        }
        return Pair.create(view, skipCallbackParser);
    }

    private static void fillView(BridgeContext context, View view, AdapterItem item, AdapterItem parentItem, LayoutlibCallback callback2, ResourceReference adapterRef) {
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                AdapterHelper.fillView(context, group.getChildAt(i), item, parentItem, callback2, adapterRef);
            }
        } else {
            ResourceReference resolvedRef;
            int id2 = view.getId();
            if (id2 != 0 && (resolvedRef = context.resolveId(id2)) != null) {
                Object value2;
                int parentPositionPerType;
                int fullPosition = item.getFullPosition();
                int positionPerType = item.getPositionPerType();
                int fullParentPosition = parentItem != null ? parentItem.getFullPosition() : 0;
                int n = parentPositionPerType = parentItem != null ? parentItem.getPositionPerType() : 0;
                if (view instanceof TextView) {
                    TextView tv = (TextView)view;
                    value2 = callback2.getAdapterItemValue(adapterRef, context.getViewKey(view), item.getDataBindingItem().getViewReference(), fullPosition, positionPerType, fullParentPosition, parentPositionPerType, resolvedRef, LayoutlibCallback.ViewAttribute.TEXT, (Object)tv.getText().toString());
                    if (value2 != null) {
                        if (value2.getClass() != LayoutlibCallback.ViewAttribute.TEXT.getAttributeClass()) {
                            Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected String, got %s", value2.getClass().getName()), null, null);
                        } else {
                            tv.setText((String)value2);
                        }
                    }
                }
                if (view instanceof Checkable) {
                    Checkable cb = (Checkable)((Object)view);
                    value2 = callback2.getAdapterItemValue(adapterRef, context.getViewKey(view), item.getDataBindingItem().getViewReference(), fullPosition, positionPerType, fullParentPosition, parentPositionPerType, resolvedRef, LayoutlibCallback.ViewAttribute.IS_CHECKED, (Object)cb.isChecked());
                    if (value2 != null) {
                        if (value2.getClass() != LayoutlibCallback.ViewAttribute.IS_CHECKED.getAttributeClass()) {
                            Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for IS_CHECKED. Expected Boolean, got %s", value2.getClass().getName()), null, null);
                        } else {
                            cb.setChecked((Boolean)value2);
                        }
                    }
                }
                if (view instanceof ImageView) {
                    ImageView iv = (ImageView)view;
                    value2 = callback2.getAdapterItemValue(adapterRef, context.getViewKey(view), item.getDataBindingItem().getViewReference(), fullPosition, positionPerType, fullParentPosition, parentPositionPerType, resolvedRef, LayoutlibCallback.ViewAttribute.SRC, (Object)iv.getDrawable());
                    if (value2 != null && value2.getClass() != LayoutlibCallback.ViewAttribute.SRC.getAttributeClass()) {
                        Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for SRC. Expected Boolean, got %s", value2.getClass().getName()), null, null);
                    }
                }
            }
        }
    }
}

