/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.res.BridgeAssetManager;
import android.content.res.ColorStateList;
import android.content.res.ComplexColor;
import android.content.res.ComplexColor_Accessor;
import android.content.res.GradientColor;
import android.content.res.Resources;
import android.content.res.StringBlock;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Typeface_Accessor;
import android.graphics.Typeface_Delegate;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.text.Annotation;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BulletSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.TypedValue;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.ninepatch.GraphicsUtilities;
import com.android.ninepatch.NinePatch;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.google.common.base.Strings;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResourceHelper {
    private static final BridgeContext.Key<Set<ResourceValue>> KEY_GET_DRAWABLE = BridgeContext.Key.create("ResourceHelper.getDrawable");
    private static final Pattern sFloatPattern = Pattern.compile("(-?[0-9]*(?:\\.[0-9]+)?)(.*)");
    private static final float[] sFloatOut = new float[1];
    private static final TypedValue mValue = new TypedValue();
    private static final UnitEntry[] sUnitNames = new UnitEntry[]{new UnitEntry("px", 5, 0, 1.0f), new UnitEntry("dip", 5, 1, 1.0f), new UnitEntry("dp", 5, 1, 1.0f), new UnitEntry("sp", 5, 2, 1.0f), new UnitEntry("pt", 5, 3, 1.0f), new UnitEntry("in", 5, 4, 1.0f), new UnitEntry("mm", 5, 5, 1.0f), new UnitEntry("%", 6, 0, 0.01f), new UnitEntry("%p", 6, 1, 0.01f)};

    public static int getColor(String value2) {
        if (value2 == null) {
            throw new NumberFormatException("null value");
        }
        int len = (value2 = value2.trim()).length();
        if (len < 2 || len > 9) {
            throw new NumberFormatException(String.format("Color value '%s' has wrong size. Format is either#AARRGGBB, #RRGGBB, #RGB, or #ARGB", value2));
        }
        if (value2.charAt(0) != '#') {
            if (value2.startsWith("?")) {
                throw new NumberFormatException(String.format("Attribute '%s' not found. Are you using the right theme?", value2));
            }
            throw new NumberFormatException(String.format("Color value '%s' must start with #", value2));
        }
        value2 = value2.substring(1);
        if (len == 4) {
            char[] color2 = new char[8];
            color2[1] = 70;
            color2[0] = 70;
            color2[2] = color2[3] = value2.charAt(0);
            color2[4] = color2[5] = value2.charAt(1);
            color2[6] = color2[7] = value2.charAt(2);
            value2 = new String(color2);
        } else if (len == 5) {
            char[] color3 = new char[8];
            color3[0] = color3[1] = value2.charAt(0);
            color3[2] = color3[3] = value2.charAt(1);
            color3[4] = color3[5] = value2.charAt(2);
            color3[6] = color3[7] = value2.charAt(3);
            value2 = new String(color3);
        } else if (len == 7) {
            value2 = "FF" + value2;
        }
        return (int)Long.parseLong(value2, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ComplexColor getInternalComplexColor(ResourceValue resValue, BridgeContext context, Resources.Theme theme, boolean allowGradients) {
        String value2 = resValue.getValue();
        if (value2 == null) return null;
        if ("@null".equals(value2)) {
            return null;
        }
        if (value2.trim().startsWith("#")) {
            try {
                int color2 = ResourceHelper.getColor(value2);
                return ColorStateList.valueOf(color2);
            }
            catch (NumberFormatException e) {
                Bridge.getLog().warning("resources.format", String.format("\"%1$s\" cannot be interpreted as a color.", value2), null, null);
                return null;
            }
        }
        try {
            BridgeXmlBlockParser blockParser = ResourceHelper.getXmlBlockParser(context, resValue);
            if (blockParser == null) return null;
            try {
                int type;
                while ((type = blockParser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    assert (false) : "No start tag found";
                    ComplexColor complexColor = null;
                    return complexColor;
                }
                String name = blockParser.getName();
                if (allowGradients && "gradient".equals(name)) {
                    GradientColor gradientColor = ComplexColor_Accessor.createGradientColorFromXmlInner(context.getResources(), blockParser, blockParser, theme);
                    return gradientColor;
                }
                if (!"selector".equals(name)) return null;
                ColorStateList colorStateList = ComplexColor_Accessor.createColorStateListFromXmlInner(context.getResources(), blockParser, blockParser, theme);
                return colorStateList;
            }
            finally {
                blockParser.ensurePopped();
            }
        }
        catch (XmlPullParserException e) {
            Bridge.getLog().error("broken", "Failed to configure parser for " + value2, (Throwable)e, null, null);
            return null;
        }
        catch (Exception e) {
            Bridge.getLog().error("resources.read", "Failed to parse file " + value2, (Throwable)e, null, null);
            return null;
        }
    }

    public static ColorStateList getColorStateList(ResourceValue resValue, BridgeContext context, Resources.Theme theme) {
        return (ColorStateList)ResourceHelper.getInternalComplexColor(resValue, context, theme != null ? theme : context.getTheme(), false);
    }

    public static ComplexColor getComplexColor(ResourceValue resValue, BridgeContext context, Resources.Theme theme) {
        return ResourceHelper.getInternalComplexColor(resValue, context, theme != null ? theme : context.getTheme(), true);
    }

    public static Drawable getDrawable(ResourceValue value2, BridgeContext context) {
        return ResourceHelper.getDrawable(value2, context, null);
    }

    public static BridgeXmlBlockParser getXmlBlockParser(BridgeContext context, ResourceValue value2) throws XmlPullParserException {
        ResourceNamespace namespace;
        String stringValue = value2.getValue();
        if ("@null".equals(stringValue)) {
            return null;
        }
        ILayoutPullParser parser = null;
        LayoutlibCallback layoutlibCallback = context.getLayoutlibCallback();
        if (!value2.isFramework()) {
            parser = layoutlibCallback.getParser(value2);
        }
        if (parser != null) {
            namespace = parser.getLayoutNamespace();
        } else {
            parser = ParserFactory.create(stringValue);
            namespace = value2.getNamespace();
        }
        return parser == null ? null : new BridgeXmlBlockParser((XmlPullParser)parser, context, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawable(ResourceValue value2, BridgeContext context, Resources.Theme theme) {
        String lowerCaseValue;
        if (value2 == null) {
            return null;
        }
        String stringValue = value2.getValue();
        if ("@null".equals(stringValue)) {
            return null;
        }
        if (stringValue.trim().startsWith("#")) {
            try {
                int color2 = ResourceHelper.getColor(stringValue);
                return new ColorDrawable(color2);
            }
            catch (NumberFormatException e) {
                Bridge.getLog().warning("resources.format", String.format("\"%1$s\" cannot be interpreted as a color.", stringValue), null, null);
                return null;
            }
        }
        Density density = Density.MEDIUM;
        if (value2 instanceof DensityBasedResourceValue && ((density = ((DensityBasedResourceValue)value2).getResourceDensity()) == Density.NODPI || density == Density.ANYDPI)) {
            density = Density.getEnum((int)context.getConfiguration().densityDpi);
        }
        if ((lowerCaseValue = stringValue.toLowerCase()).endsWith(".xml") || value2.getResourceType() == ResourceType.AAPT) {
            block22: {
                Drawable drawable2;
                BridgeXmlBlockParser blockParser = ResourceHelper.getXmlBlockParser(context, value2);
                if (blockParser == null) break block22;
                Set<ResourceValue> visitedValues = context.getUserData(KEY_GET_DRAWABLE);
                if (visitedValues == null) {
                    visitedValues = new HashSet<ResourceValue>();
                    context.putUserData(KEY_GET_DRAWABLE, visitedValues);
                }
                if (!visitedValues.add(value2)) {
                    Bridge.getLog().error(null, "Cyclic dependency in " + stringValue, null, null);
                    return null;
                }
                try {
                    drawable2 = Drawable.createFromXml(context.getResources(), blockParser, theme);
                    visitedValues.remove(value2);
                }
                catch (Throwable throwable) {
                    try {
                        visitedValues.remove(value2);
                        blockParser.ensurePopped();
                        throw throwable;
                    }
                    catch (Exception e) {
                        Bridge.getLog().error(null, "Failed to parse file " + stringValue, (Throwable)e, null, null);
                    }
                }
                blockParser.ensurePopped();
                return drawable2;
            }
            return null;
        }
        AssetRepository repository = ResourceHelper.getAssetRepository(context);
        if (repository.isFileResource(stringValue)) {
            try {
                Bitmap bitmap = Bridge.getCachedBitmap(stringValue, value2.isFramework() ? null : context.getProjectKey());
                if (bitmap == null) {
                    InputStream stream;
                    try {
                        stream = repository.openNonAsset(0, stringValue, 2);
                    }
                    catch (FileNotFoundException e) {
                        stream = null;
                    }
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inDensity = density.getDpiValue();
                    bitmap = BitmapFactory.decodeStream(stream, null, options);
                    if (bitmap != null && bitmap.getNinePatchChunk() == null && lowerCaseValue.endsWith(".9.png")) {
                        stream = repository.openNonAsset(0, stringValue, 2);
                        NinePatch ninePatch = NinePatch.load((InputStream)stream, (boolean)true, (boolean)false);
                        BufferedImage image = ninePatch.getImage();
                        int width = image.getWidth();
                        int height = image.getHeight();
                        int[] imageData = GraphicsUtilities.getPixels((BufferedImage)image, (int)0, (int)0, (int)width, (int)height, null);
                        bitmap = Bitmap.createBitmap(imageData, width, height, Bitmap.Config.ARGB_8888);
                        bitmap.setDensity(options.inDensity);
                        bitmap.setNinePatchChunk(ninePatch.getChunk().getSerializedChunk());
                    }
                    Bridge.setCachedBitmap(stringValue, bitmap, value2.isFramework() ? null : context.getProjectKey());
                }
                if (bitmap != null && bitmap.getNinePatchChunk() != null) {
                    return new NinePatchDrawable(context.getResources(), bitmap, bitmap.getNinePatchChunk(), new Rect(), lowerCaseValue);
                }
                return new BitmapDrawable(context.getResources(), bitmap);
            }
            catch (IOException e) {
                Bridge.getLog().error("resources.read", "Failed to load " + stringValue, (Throwable)e, null, null);
            }
        }
        return null;
    }

    private static AssetRepository getAssetRepository(BridgeContext context) {
        BridgeAssetManager assetManager = context.getAssets();
        return assetManager.getAssetRepository();
    }

    public static Typeface getFont(String fontName, BridgeContext context, Resources.Theme theme, boolean isFramework) {
        if (fontName == null) {
            return null;
        }
        if (Typeface_Accessor.isSystemFont(fontName)) {
            return null;
        }
        return Typeface_Delegate.createFromDisk(context, fontName, isFramework);
    }

    public static Typeface getFont(ResourceValue value2, BridgeContext context, Resources.Theme theme) {
        if (value2 == null) {
            return null;
        }
        return ResourceHelper.getFont(value2.getValue(), context, theme, value2.isFramework());
    }

    public static boolean getBooleanThemeValue(RenderResources resources, ResourceReference attr2, boolean defaultValue2) {
        ResourceValue value2 = resources.findItemInTheme(attr2);
        if ((value2 = resources.resolveResValue(value2)) == null) {
            return defaultValue2;
        }
        return XmlUtils.convertValueToBoolean(value2.getValue(), defaultValue2);
    }

    public static boolean getBooleanThemeFrameworkAttrValue(RenderResources resources, String name, boolean defaultValue2) {
        ResourceReference attrRef = BridgeContext.createFrameworkAttrReference(name);
        return ResourceHelper.getBooleanThemeValue(resources, attrRef, defaultValue2);
    }

    public static CharSequence parseHtml(String string2) {
        String str = string2.replaceAll("<li>", "<ul><li>").replaceAll("</li>", "</li></ul>");
        int firstTagIndex = str.indexOf(60);
        int lastTagIndex = str.lastIndexOf(62);
        final StringBuilder stringBuilder = new StringBuilder(str.substring(0, firstTagIndex));
        final ArrayList<Tag> tagList = new ArrayList<Tag>();
        final HashMap startStacks = new HashMap();
        Parser parser = new Parser();
        parser.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                if (!Strings.isNullOrEmpty((String)localName)) {
                    Tag tag = new Tag(localName);
                    tag.mStart = stringBuilder.length();
                    tag.mAttributes = attributes;
                    startStacks.computeIfAbsent(localName, key -> new ArrayDeque()).addFirst(tag);
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if (!Strings.isNullOrEmpty((String)localName)) {
                    Tag tag = (Tag)((Deque)startStacks.get(localName)).removeFirst();
                    tag.mEnd = stringBuilder.length();
                    tagList.add(tag);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                stringBuilder.append(ch, start, length);
            }
        });
        try {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", new HTMLSchema());
            parser.parse(new InputSource(new StringReader(str.substring(firstTagIndex, lastTagIndex + 1))));
        }
        catch (IOException | SAXException e) {
            Bridge.getLog().warning("resources.format", "The string " + str + " is not valid HTML", null, null);
            return str;
        }
        stringBuilder.append(str.substring(lastTagIndex + 1));
        return ResourceHelper.applyStyles(stringBuilder, tagList);
    }

    private static SpannedString applyStyles(StringBuilder stringBuilder, List<Tag> tagList) {
        SpannableString spannableString = new SpannableString(stringBuilder);
        for (Tag tag : tagList) {
            int start = tag.mStart;
            int end = tag.mEnd;
            Attributes attrs = tag.mAttributes;
            switch (tag.mLabel) {
                case "b": {
                    spannableString.setSpan(new StyleSpan(Typeface.BOLD), start, end, 33);
                    break;
                }
                case "i": {
                    spannableString.setSpan(new StyleSpan(Typeface.ITALIC), start, end, 33);
                    break;
                }
                case "u": {
                    spannableString.setSpan(new UnderlineSpan(), start, end, 33);
                    break;
                }
                case "tt": {
                    spannableString.setSpan(new TypefaceSpan("monospace"), start, end, 33);
                    break;
                }
                case "big": {
                    spannableString.setSpan(new RelativeSizeSpan(1.25f), start, end, 33);
                    break;
                }
                case "small": {
                    spannableString.setSpan(new RelativeSizeSpan(0.8f), start, end, 33);
                    break;
                }
                case "sup": {
                    spannableString.setSpan(new SuperscriptSpan(), start, end, 33);
                    break;
                }
                case "sub": {
                    spannableString.setSpan(new SubscriptSpan(), start, end, 33);
                    break;
                }
                case "strike": {
                    spannableString.setSpan(new StrikethroughSpan(), start, end, 33);
                    break;
                }
                case "li": {
                    StringBlock.addParagraphSpan(spannableString, new BulletSpan(10), start, end);
                    break;
                }
                case "marquee": {
                    spannableString.setSpan((Object)TextUtils.TruncateAt.MARQUEE, start, end, 18);
                    break;
                }
                case "font": {
                    String faceAttr;
                    String bgcolorAttr;
                    String colorAttr;
                    String fgcolorAttr;
                    String sizeAttr;
                    String heightAttr = attrs.getValue("height");
                    if (heightAttr != null) {
                        int height = Integer.parseInt(heightAttr);
                        StringBlock.addParagraphSpan(spannableString, new StringBlock.Height(height), start, end);
                    }
                    if ((sizeAttr = attrs.getValue("size")) != null) {
                        int size = Integer.parseInt(sizeAttr);
                        spannableString.setSpan(new AbsoluteSizeSpan(size, true), start, end, 33);
                    }
                    if ((fgcolorAttr = attrs.getValue("fgcolor")) != null) {
                        spannableString.setSpan(StringBlock.getColor(fgcolorAttr, true), start, end, 33);
                    }
                    if ((colorAttr = attrs.getValue("color")) != null) {
                        spannableString.setSpan(StringBlock.getColor(colorAttr, true), start, end, 33);
                    }
                    if ((bgcolorAttr = attrs.getValue("bgcolor")) != null) {
                        spannableString.setSpan(StringBlock.getColor(bgcolorAttr, false), start, end, 33);
                    }
                    if ((faceAttr = attrs.getValue("face")) == null) break;
                    spannableString.setSpan(new TypefaceSpan(faceAttr), start, end, 33);
                    break;
                }
                case "a": {
                    String href = tag.mAttributes.getValue("href");
                    if (href == null) break;
                    spannableString.setSpan(new URLSpan(href), start, end, 33);
                    break;
                }
                case "annotation": {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String key = attrs.getLocalName(i);
                        String value2 = attrs.getValue(i);
                        spannableString.setSpan(new Annotation(key, value2), start, end, 33);
                    }
                    break;
                }
            }
        }
        return new SpannedString(spannableString);
    }

    public static TypedValue getValue(String attribute, String value2, boolean requireUnit) {
        if (ResourceHelper.parseFloatAttribute(attribute, value2, mValue, requireUnit)) {
            return mValue;
        }
        return null;
    }

    public static boolean parseFloatAttribute(String attribute, String value2, TypedValue outValue, boolean requireUnit) {
        assert (!requireUnit || attribute != null);
        int len = (value2 = value2.trim()).length();
        if (len <= 0) {
            return false;
        }
        char[] buf = value2.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if ((buf[0] < '0' || buf[0] > '9') && buf[0] != '.' && buf[0] != '-' && buf[0] != '+') {
            return false;
        }
        Matcher m = sFloatPattern.matcher(value2);
        if (m.matches()) {
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (end.length() > 0 && end.charAt(0) != ' ') {
                if (ResourceHelper.parseUnit(end, outValue, sFloatOut)) {
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    return true;
                }
                return false;
            }
            if ((end = end.trim()).length() == 0 && outValue != null) {
                if (!requireUnit) {
                    outValue.type = 4;
                    outValue.data = Float.floatToIntBits(f);
                } else {
                    ResourceHelper.applyUnit(sUnitNames[1], outValue, sFloatOut);
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    Bridge.getLog().error("resources.resolve", String.format("Dimension \"%1$s\" in attribute \"%2$s\" is missing unit!", value2, attribute), null, null);
                }
                return true;
            }
        }
        return false;
    }

    private static void computeTypedValue(TypedValue outValue, float value2, float scale) {
        int shift;
        int radix;
        long bits;
        boolean neg;
        boolean bl = neg = (value2 *= scale) < 0.0f;
        if (neg) {
            value2 = -value2;
        }
        if (((bits = (long)(value2 * 8388608.0f + 0.5f)) & 0x7FFFFFL) == 0L) {
            radix = 0;
            shift = 23;
        } else if ((bits & 0xFFFFFFFFFF800000L) == 0L) {
            radix = 3;
            shift = 0;
        } else if ((bits & Integer.MIN_VALUE) == 0L) {
            radix = 2;
            shift = 8;
        } else if ((bits & 0xFFFFFF8000000000L) == 0L) {
            radix = 1;
            shift = 16;
        } else {
            radix = 0;
            shift = 23;
        }
        int mantissa = (int)(bits >> shift & 0xFFFFFFL);
        if (neg) {
            mantissa = -mantissa & 0xFFFFFF;
        }
        outValue.data |= radix << 4 | mantissa << 8;
    }

    private static boolean parseUnit(String str, TypedValue outValue, float[] outScale) {
        str = str.trim();
        for (UnitEntry unit : sUnitNames) {
            if (!unit.name.equals(str)) continue;
            ResourceHelper.applyUnit(unit, outValue, outScale);
            return true;
        }
        return false;
    }

    private static void applyUnit(UnitEntry unit, TypedValue outValue, float[] outScale) {
        outValue.type = unit.type;
        outValue.data = unit.unit << 0;
        outScale[0] = unit.scale;
    }

    private static class Tag {
        private String mLabel;
        private int mStart;
        private int mEnd;
        private Attributes mAttributes;

        private Tag(String label) {
            this.mLabel = label;
        }
    }

    private static final class UnitEntry {
        String name;
        int type;
        int unit;
        float scale;

        UnitEntry(String name, int type, int unit, float scale) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.scale = scale;
        }
    }
}

