/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.app.ActionBar;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowCallback;
import android.widget.ActionMenuPresenter;
import android.widget.ActionMenuView;
import android.widget.Toolbar;
import android.widget.Toolbar_Accessor;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.internal.app.ToolbarActionBar;
import com.android.internal.app.WindowDecorActionBar;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.ActionBarAccessor;
import com.android.internal.widget.ActionBarView;
import com.android.internal.widget.DecorToolbar;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.FrameworkActionBar;
import com.android.layoutlib.bridge.impl.ResourceHelper;

public abstract class FrameworkActionBarWrapper {
    protected ActionBar mActionBar;
    protected ActionBarCallback mCallback;
    protected BridgeContext mContext;

    public static FrameworkActionBarWrapper getActionBarWrapper(BridgeContext context, ActionBarCallback callback2, View decorContent) {
        Object view = decorContent.findViewById(16908710);
        if (view instanceof Toolbar) {
            return new ToolbarWrapper(context, callback2, (Toolbar)view);
        }
        if (view instanceof ActionBarView) {
            return new WindowActionBarWrapper(context, callback2, decorContent, (ActionBarView)view);
        }
        throw new IllegalStateException("Can't make an action bar out of " + view.getClass().getSimpleName());
    }

    FrameworkActionBarWrapper(BridgeContext context, ActionBarCallback callback2, ActionBar actionBar) {
        this.mActionBar = actionBar;
        this.mCallback = callback2;
        this.mContext = context;
    }

    protected void setupActionBar() {
    }

    public void setTitle(CharSequence title) {
        this.mActionBar.setTitle(title);
    }

    public void setSubTitle(CharSequence subTitle) {
        if (subTitle != null) {
            this.mActionBar.setSubtitle(subTitle);
        }
    }

    public void setHomeAsUp(boolean homeAsUp) {
        this.mActionBar.setDisplayHomeAsUpEnabled(homeAsUp);
    }

    public void setIcon(ResourceValue icon2) {
    }

    protected boolean isSplit() {
        return this.getDecorToolbar().isSplit();
    }

    protected boolean isOverflowPopupNeeded() {
        return this.mCallback.isOverflowPopupNeeded();
    }

    protected void inflateMenus() {
        MenuInflater inflater = new MenuInflater(this.getActionMenuContext());
        MenuBuilder menuBuilder = this.getMenuBuilder();
        for (ResourceReference menuId : this.mCallback.getMenuIds()) {
            int id2 = this.mContext.getResourceId(menuId, -1);
            if (id2 < 0) continue;
            inflater.inflate(id2, menuBuilder);
        }
    }

    protected Context getActionMenuContext() {
        return this.mActionBar.getThemedContext();
    }

    abstract Context getPopupContext();

    abstract MenuBuilder getMenuBuilder();

    abstract ActionMenuPresenter getActionMenuPresenter();

    abstract DecorToolbar getDecorToolbar();

    abstract int getMenuPopupElevation();

    abstract int getMenuPopupMargin();

    private static class WindowActionBarWrapper
    extends FrameworkActionBarWrapper {
        private final WindowDecorActionBar mActionBar;
        private final ActionBarView mActionBarView;
        private final View mDecorContentRoot;
        private MenuBuilder mMenuBuilder;

        public WindowActionBarWrapper(BridgeContext context, ActionBarCallback callback2, View decorContentRoot, ActionBarView actionBarView) {
            super(context, callback2, new WindowDecorActionBar(decorContentRoot));
            this.mActionBarView = actionBarView;
            this.mActionBar = (WindowDecorActionBar)((FrameworkActionBarWrapper)this).mActionBar;
            this.mDecorContentRoot = decorContentRoot;
        }

        @Override
        protected void setupActionBar() {
            ViewGroup splitView;
            int navMode = this.mCallback.getNavigationMode();
            this.mActionBar.setNavigationMode(navMode);
            if (navMode == 2) {
                this.setupTabs(3);
            }
            if ((splitView = (ViewGroup)this.mDecorContentRoot.findViewById(16909481)) != null) {
                this.mActionBarView.setSplitView(splitView);
                Resources res = this.mContext.getResources();
                boolean split = res.getBoolean(17891731) && this.mCallback.getSplitActionBarWhenNarrow();
                this.mActionBarView.setSplitToolbar(split);
            }
        }

        @Override
        public void setIcon(ResourceValue icon2) {
            Drawable iconDrawable;
            if (!this.mActionBar.hasIcon() && icon2 != null && (iconDrawable = this.getDrawable(icon2)) != null) {
                this.mActionBar.setIcon(iconDrawable);
            }
        }

        @Override
        protected void inflateMenus() {
            super.inflateMenus();
            this.mActionBarView.setMenu(this.getMenuBuilder(), null);
        }

        @Override
        Context getPopupContext() {
            return this.getActionMenuContext();
        }

        @Override
        MenuBuilder getMenuBuilder() {
            if (this.mMenuBuilder == null) {
                this.mMenuBuilder = new MenuBuilder(this.getActionMenuContext());
            }
            return this.mMenuBuilder;
        }

        @Override
        ActionMenuPresenter getActionMenuPresenter() {
            return ActionBarAccessor.getActionMenuPresenter(this.mActionBarView);
        }

        @Override
        ActionBarView getDecorToolbar() {
            return this.mActionBarView;
        }

        @Override
        int getMenuPopupElevation() {
            return 0;
        }

        @Override
        int getMenuPopupMargin() {
            return -FrameworkActionBar.getPixelValue("10dp", this.mContext.getMetrics());
        }

        private void setupTabs(int num) {
            for (int i = 1; i <= num; ++i) {
                ActionBar.Tab tab = this.mActionBar.newTab().setText("Tab" + i).setTabListener(new ActionBar.TabListener(){

                    @Override
                    public void onTabUnselected(ActionBar.Tab t, FragmentTransaction ft) {
                    }

                    @Override
                    public void onTabSelected(ActionBar.Tab t, FragmentTransaction ft) {
                    }

                    @Override
                    public void onTabReselected(ActionBar.Tab t, FragmentTransaction ft) {
                    }
                });
                this.mActionBar.addTab(tab);
            }
        }

        private Drawable getDrawable(ResourceValue value2) {
            RenderResources res = this.mContext.getRenderResources();
            value2 = res.resolveResValue(value2);
            if (value2 != null) {
                return ResourceHelper.getDrawable(value2, this.mContext);
            }
            return null;
        }
    }

    private static class ToolbarWrapper
    extends FrameworkActionBarWrapper {
        private final Toolbar mToolbar;

        ToolbarWrapper(BridgeContext context, ActionBarCallback callback2, Toolbar toolbar) {
            super(context, callback2, new ToolbarActionBar(toolbar, "", new WindowCallback()));
            this.mToolbar = toolbar;
        }

        @Override
        protected void inflateMenus() {
            super.inflateMenus();
            MenuBuilder menu2 = this.getMenuBuilder();
            DecorToolbar decorToolbar = this.getDecorToolbar();
            decorToolbar.setMenu(new MenuBuilder(this.getActionMenuContext()), null);
            ActionMenuPresenter presenter = this.getActionMenuPresenter();
            if (presenter != null) {
                presenter.setMenuView(new ActionMenuView(this.getPopupContext()));
            }
            decorToolbar.setMenu(menu2, null);
        }

        @Override
        Context getPopupContext() {
            return Toolbar_Accessor.getPopupContext(this.mToolbar);
        }

        @Override
        MenuBuilder getMenuBuilder() {
            return (MenuBuilder)this.mToolbar.getMenu();
        }

        @Override
        ActionMenuPresenter getActionMenuPresenter() {
            return Toolbar_Accessor.getActionMenuPresenter(this.mToolbar);
        }

        @Override
        DecorToolbar getDecorToolbar() {
            return this.mToolbar.getWrapper();
        }

        @Override
        int getMenuPopupElevation() {
            return 10;
        }

        @Override
        int getMenuPopupMargin() {
            return 0;
        }
    }
}

