/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android.support;

import android.content.Context;
import android.view.View;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.common.util.ReflectionUtils;

public class RecyclerViewUtil {
    public static final String[] CN_RECYCLER_VIEW = new String[]{"android.support.v7.widget.RecyclerView", "androidx.recyclerview.widget.RecyclerView"};
    private static final Class<?>[] LLM_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class};

    public static void setAdapter(View recyclerView, BridgeContext context, LayoutlibCallback layoutlibCallback, int adapterLayout, int itemCount) {
        String recyclerViewClassName = ReflectionUtils.getParentClass(recyclerView, CN_RECYCLER_VIEW);
        String adapterClassName = recyclerViewClassName + "$Adapter";
        String layoutMgrClassName = recyclerViewClassName + "$LayoutManager";
        try {
            RecyclerViewUtil.setLayoutManager(recyclerView, layoutMgrClassName, context, layoutlibCallback);
            Object adapter = RecyclerViewUtil.createAdapter(layoutlibCallback, adapterClassName);
            if (adapter != null) {
                RecyclerViewUtil.setProperty((Object)recyclerView, adapterClassName, adapter, "setAdapter");
                RecyclerViewUtil.setProperty(adapter, Integer.TYPE, (Object)adapterLayout, "setLayoutId");
                if (itemCount != -1) {
                    RecyclerViewUtil.setProperty(adapter, Integer.TYPE, (Object)itemCount, "setItemCount");
                }
            }
        }
        catch (ReflectionUtils.ReflectionException e) {
            Throwable cause = ReflectionUtils.getCause(e);
            Bridge.getLog().error("broken", "Error occurred while trying to setup RecyclerView.", cause, null, null);
        }
    }

    private static void setLayoutManager(View recyclerView, String layoutMgrClassName, BridgeContext context, LayoutlibCallback callback2) throws ReflectionUtils.ReflectionException {
        String linearLayoutMgrClassManager;
        Object layoutManager;
        if (RecyclerViewUtil.getLayoutManager(recyclerView) == null && (layoutManager = RecyclerViewUtil.createLayoutManager(context, linearLayoutMgrClassManager = recyclerView.getClass().getPackage().getName() + ".LinearLayoutManager", callback2)) != null) {
            RecyclerViewUtil.setProperty((Object)recyclerView, layoutMgrClassName, layoutManager, "setLayoutManager");
        }
    }

    private static Object createLayoutManager(Context context, String linearLayoutMgrClassName, LayoutlibCallback callback2) throws ReflectionUtils.ReflectionException {
        try {
            return callback2.loadClass(linearLayoutMgrClassName, (Class[])LLM_CONSTRUCTOR_SIGNATURE, new Object[]{context});
        }
        catch (Exception e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    private static Object getLayoutManager(View recyclerView) throws ReflectionUtils.ReflectionException {
        return ReflectionUtils.invoke(ReflectionUtils.getMethod(recyclerView.getClass(), "getLayoutManager", new Class[0]), recyclerView, new Object[0]);
    }

    private static Object createAdapter(LayoutlibCallback layoutlibCallback, String adapterClassName) throws ReflectionUtils.ReflectionException {
        Boolean ideSupport = (Boolean)layoutlibCallback.getFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT);
        if (ideSupport != Boolean.TRUE) {
            return null;
        }
        try {
            return layoutlibCallback.loadClass(adapterClassName, new Class[0], new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    private static void setProperty(Object object, String propertyClassName, Object propertyValue, String propertySetter) throws ReflectionUtils.ReflectionException {
        Class<?> propertyClass = ReflectionUtils.getClassInstance(propertyValue, propertyClassName);
        RecyclerViewUtil.setProperty(object, propertyClass, propertyValue, propertySetter);
    }

    private static void setProperty(Object object, Class<?> propertyClass, Object propertyValue, String propertySetter) throws ReflectionUtils.ReflectionException {
        ReflectionUtils.invoke(ReflectionUtils.getMethod(object.getClass(), propertySetter, propertyClass), object, propertyValue);
    }
}

