/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.input.InputManager;
import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Slog;
import android.view.ISystemGestureExclusionListener;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowInsets;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerPolicyConstants;
import java.util.ArrayList;

public class PointerLocationView
extends View
implements InputManager.InputDeviceListener,
WindowManagerPolicyConstants.PointerEventListener {
    private static final String TAG = "Pointer";
    private static final String ALT_STRATEGY_PROPERY_KEY = "debug.velocitytracker.alt";
    private static final String GESTURE_EXCLUSION_PROP = "debug.pointerlocation.showexclusion";
    private final InputManager mIm;
    private final ViewConfiguration mVC;
    private final Paint mTextPaint;
    private final Paint mTextBackgroundPaint;
    private final Paint mTextLevelPaint;
    private final Paint mPaint;
    private final Paint mCurrentPointPaint;
    private final Paint mTargetPaint;
    private final Paint mPathPaint;
    private final Paint.FontMetricsInt mTextMetrics = new Paint.FontMetricsInt();
    private int mHeaderBottom;
    private int mHeaderPaddingTop = 0;
    @UnsupportedAppUsage
    private boolean mCurDown;
    @UnsupportedAppUsage
    private int mCurNumPointers;
    @UnsupportedAppUsage
    private int mMaxNumPointers;
    private int mActivePointerId;
    @UnsupportedAppUsage
    private final ArrayList<PointerState> mPointers = new ArrayList();
    private final MotionEvent.PointerCoords mTempCoords = new MotionEvent.PointerCoords();
    private final Region mSystemGestureExclusion = new Region();
    private final Region mSystemGestureExclusionRejected = new Region();
    private final Path mSystemGestureExclusionPath = new Path();
    private final Paint mSystemGestureExclusionPaint;
    private final Paint mSystemGestureExclusionRejectedPaint;
    private final VelocityTracker mVelocity;
    private final VelocityTracker mAltVelocity;
    private final FasterStringBuilder mText = new FasterStringBuilder();
    @UnsupportedAppUsage
    private boolean mPrintCoords = true;
    private RectF mReusableOvalRect = new RectF();
    private ISystemGestureExclusionListener mSystemGestureExclusionListener = new ISystemGestureExclusionListener.Stub(){

        @Override
        public void onSystemGestureExclusionChanged(int displayId, Region systemGestureExclusion, Region systemGestureExclusionUnrestricted) {
            Handler handler;
            Region exclusion = Region.obtain(systemGestureExclusion);
            Region rejected = Region.obtain();
            if (systemGestureExclusionUnrestricted != null) {
                rejected.set(systemGestureExclusionUnrestricted);
                rejected.op(exclusion, Region.Op.DIFFERENCE);
            }
            if ((handler = PointerLocationView.this.getHandler()) != null) {
                handler.post(() -> {
                    PointerLocationView.this.mSystemGestureExclusion.set(exclusion);
                    PointerLocationView.this.mSystemGestureExclusionRejected.set(rejected);
                    exclusion.recycle();
                    PointerLocationView.this.invalidate();
                });
            }
        }
    };

    public PointerLocationView(Context c) {
        super(c);
        this.setFocusableInTouchMode(true);
        this.mIm = c.getSystemService(InputManager.class);
        this.mVC = ViewConfiguration.get(c);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(10.0f * this.getResources().getDisplayMetrics().density);
        this.mTextPaint.setARGB(255, 0, 0, 0);
        this.mTextBackgroundPaint = new Paint();
        this.mTextBackgroundPaint.setAntiAlias(false);
        this.mTextBackgroundPaint.setARGB(128, 255, 255, 255);
        this.mTextLevelPaint = new Paint();
        this.mTextLevelPaint.setAntiAlias(false);
        this.mTextLevelPaint.setARGB(192, 255, 0, 0);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setARGB(255, 255, 255, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f);
        this.mCurrentPointPaint = new Paint();
        this.mCurrentPointPaint.setAntiAlias(true);
        this.mCurrentPointPaint.setARGB(255, 255, 0, 0);
        this.mCurrentPointPaint.setStyle(Paint.Style.STROKE);
        this.mCurrentPointPaint.setStrokeWidth(2.0f);
        this.mTargetPaint = new Paint();
        this.mTargetPaint.setAntiAlias(false);
        this.mTargetPaint.setARGB(255, 0, 0, 192);
        this.mPathPaint = new Paint();
        this.mPathPaint.setAntiAlias(false);
        this.mPathPaint.setARGB(255, 0, 96, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(1.0f);
        this.mSystemGestureExclusionPaint = new Paint();
        this.mSystemGestureExclusionPaint.setARGB(25, 255, 0, 0);
        this.mSystemGestureExclusionPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mSystemGestureExclusionRejectedPaint = new Paint();
        this.mSystemGestureExclusionRejectedPaint.setARGB(25, 0, 0, 255);
        this.mSystemGestureExclusionRejectedPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        PointerState ps = new PointerState();
        this.mPointers.add(ps);
        this.mActivePointerId = 0;
        this.mVelocity = VelocityTracker.obtain();
        String altStrategy = SystemProperties.get(ALT_STRATEGY_PROPERY_KEY);
        if (altStrategy.length() != 0) {
            Log.d(TAG, "Comparing default velocity tracker strategy with " + altStrategy);
            this.mAltVelocity = VelocityTracker.obtain(altStrategy);
        } else {
            this.mAltVelocity = null;
        }
    }

    public void setPrintCoords(boolean state) {
        this.mPrintCoords = state;
    }

    @Override
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        this.mHeaderPaddingTop = insets.getDisplayCutout() != null ? insets.getDisplayCutout().getSafeInsetTop() : 0;
        return super.onApplyWindowInsets(insets);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mTextPaint.getFontMetricsInt(this.mTextMetrics);
        this.mHeaderBottom = this.mHeaderPaddingTop - this.mTextMetrics.ascent + this.mTextMetrics.descent + 2;
    }

    private void drawOval(Canvas canvas, float x, float y, float major, float minor, float angle, Paint paint) {
        canvas.save(1);
        canvas.rotate((float)((double)(angle * 180.0f) / Math.PI), x, y);
        this.mReusableOvalRect.left = x - minor / 2.0f;
        this.mReusableOvalRect.right = x + minor / 2.0f;
        this.mReusableOvalRect.top = y - major / 2.0f;
        this.mReusableOvalRect.bottom = y + major / 2.0f;
        canvas.drawOval(this.mReusableOvalRect, paint);
        canvas.restore();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        int w = this.getWidth();
        int itemW = w / 7;
        int base = this.mHeaderPaddingTop - this.mTextMetrics.ascent + 1;
        int bottom2 = this.mHeaderBottom;
        int NP = this.mPointers.size();
        if (!this.mSystemGestureExclusion.isEmpty()) {
            this.mSystemGestureExclusionPath.reset();
            this.mSystemGestureExclusion.getBoundaryPath(this.mSystemGestureExclusionPath);
            canvas.drawPath(this.mSystemGestureExclusionPath, this.mSystemGestureExclusionPaint);
        }
        if (!this.mSystemGestureExclusionRejected.isEmpty()) {
            this.mSystemGestureExclusionPath.reset();
            this.mSystemGestureExclusionRejected.getBoundaryPath(this.mSystemGestureExclusionPath);
            canvas.drawPath(this.mSystemGestureExclusionPath, this.mSystemGestureExclusionRejectedPaint);
        }
        if (this.mActivePointerId >= 0) {
            PointerState ps = this.mPointers.get(this.mActivePointerId);
            canvas.drawRect(0.0f, this.mHeaderPaddingTop, itemW - 1, bottom2, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("P: ").append(this.mCurNumPointers).append(" / ").append(this.mMaxNumPointers).toString(), 1.0f, base, this.mTextPaint);
            int N = ps.mTraceCount;
            if (this.mCurDown && ps.mCurDown || N == 0) {
                canvas.drawRect(itemW, this.mHeaderPaddingTop, itemW * 2 - 1, bottom2, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("X: ").append(((PointerState)ps).mCoords.x, 1).toString(), 1 + itemW, base, this.mTextPaint);
                canvas.drawRect(itemW * 2, this.mHeaderPaddingTop, itemW * 3 - 1, bottom2, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("Y: ").append(((PointerState)ps).mCoords.y, 1).toString(), 1 + itemW * 2, base, this.mTextPaint);
            } else {
                float dx = ps.mTraceX[N - 1] - ps.mTraceX[0];
                float dy = ps.mTraceY[N - 1] - ps.mTraceY[0];
                canvas.drawRect(itemW, this.mHeaderPaddingTop, itemW * 2 - 1, bottom2, Math.abs(dx) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
                canvas.drawText(this.mText.clear().append("dX: ").append(dx, 1).toString(), 1 + itemW, base, this.mTextPaint);
                canvas.drawRect(itemW * 2, this.mHeaderPaddingTop, itemW * 3 - 1, bottom2, Math.abs(dy) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
                canvas.drawText(this.mText.clear().append("dY: ").append(dy, 1).toString(), 1 + itemW * 2, base, this.mTextPaint);
            }
            canvas.drawRect(itemW * 3, this.mHeaderPaddingTop, itemW * 4 - 1, bottom2, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("Xv: ").append(ps.mXVelocity, 3).toString(), 1 + itemW * 3, base, this.mTextPaint);
            canvas.drawRect(itemW * 4, this.mHeaderPaddingTop, itemW * 5 - 1, bottom2, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("Yv: ").append(ps.mYVelocity, 3).toString(), 1 + itemW * 4, base, this.mTextPaint);
            canvas.drawRect(itemW * 5, this.mHeaderPaddingTop, itemW * 6 - 1, bottom2, this.mTextBackgroundPaint);
            canvas.drawRect(itemW * 5, this.mHeaderPaddingTop, (float)(itemW * 5) + ((PointerState)ps).mCoords.pressure * (float)itemW - 1.0f, bottom2, this.mTextLevelPaint);
            canvas.drawText(this.mText.clear().append("Prs: ").append(((PointerState)ps).mCoords.pressure, 2).toString(), 1 + itemW * 5, base, this.mTextPaint);
            canvas.drawRect(itemW * 6, this.mHeaderPaddingTop, w, bottom2, this.mTextBackgroundPaint);
            canvas.drawRect(itemW * 6, this.mHeaderPaddingTop, (float)(itemW * 6) + ((PointerState)ps).mCoords.size * (float)itemW - 1.0f, bottom2, this.mTextLevelPaint);
            canvas.drawText(this.mText.clear().append("Size: ").append(((PointerState)ps).mCoords.size, 2).toString(), 1 + itemW * 6, base, this.mTextPaint);
        }
        for (int p = 0; p < NP; ++p) {
            PointerState ps = this.mPointers.get(p);
            int N = ps.mTraceCount;
            float lastX = 0.0f;
            float lastY = 0.0f;
            boolean haveLast = false;
            boolean drawn = false;
            this.mPaint.setARGB(255, 128, 255, 255);
            for (int i = 0; i < N; ++i) {
                float x = ps.mTraceX[i];
                float y = ps.mTraceY[i];
                if (Float.isNaN(x)) {
                    haveLast = false;
                    continue;
                }
                if (haveLast) {
                    canvas.drawLine(lastX, lastY, x, y, this.mPathPaint);
                    Paint paint = ps.mTraceCurrent[i - 1] ? this.mCurrentPointPaint : this.mPaint;
                    canvas.drawPoint(lastX, lastY, paint);
                    drawn = true;
                }
                lastX = x;
                lastY = y;
                haveLast = true;
            }
            if (drawn) {
                this.mPaint.setARGB(255, 255, 64, 128);
                float xVel = ps.mXVelocity * 16.0f;
                float yVel = ps.mYVelocity * 16.0f;
                canvas.drawLine(lastX, lastY, lastX + xVel, lastY + yVel, this.mPaint);
                if (this.mAltVelocity != null) {
                    this.mPaint.setARGB(255, 64, 255, 128);
                    xVel = ps.mAltXVelocity * 16.0f;
                    yVel = ps.mAltYVelocity * 16.0f;
                    canvas.drawLine(lastX, lastY, lastX + xVel, lastY + yVel, this.mPaint);
                }
            }
            if (!this.mCurDown || !ps.mCurDown) continue;
            canvas.drawLine(0.0f, ((PointerState)ps).mCoords.y, this.getWidth(), ((PointerState)ps).mCoords.y, this.mTargetPaint);
            canvas.drawLine(((PointerState)ps).mCoords.x, -this.getHeight(), ((PointerState)ps).mCoords.x, Math.max(this.getHeight(), this.getWidth()), this.mTargetPaint);
            int pressureLevel = (int)(((PointerState)ps).mCoords.pressure * 255.0f);
            this.mPaint.setARGB(255, pressureLevel, 255, 255 - pressureLevel);
            canvas.drawPoint(((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, this.mPaint);
            this.mPaint.setARGB(255, pressureLevel, 255 - pressureLevel, 128);
            this.drawOval(canvas, ((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, ((PointerState)ps).mCoords.touchMajor, ((PointerState)ps).mCoords.touchMinor, ((PointerState)ps).mCoords.orientation, this.mPaint);
            this.mPaint.setARGB(255, pressureLevel, 128, 255 - pressureLevel);
            this.drawOval(canvas, ((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, ((PointerState)ps).mCoords.toolMajor, ((PointerState)ps).mCoords.toolMinor, ((PointerState)ps).mCoords.orientation, this.mPaint);
            float arrowSize = ((PointerState)ps).mCoords.toolMajor * 0.7f;
            if (arrowSize < 20.0f) {
                arrowSize = 20.0f;
            }
            this.mPaint.setARGB(255, pressureLevel, 255, 0);
            float orientationVectorX = (float)(Math.sin(((PointerState)ps).mCoords.orientation) * (double)arrowSize);
            float orientationVectorY = (float)(-Math.cos(((PointerState)ps).mCoords.orientation) * (double)arrowSize);
            if (ps.mToolType == 2 || ps.mToolType == 4) {
                canvas.drawLine(((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, ((PointerState)ps).mCoords.x + orientationVectorX, ((PointerState)ps).mCoords.y + orientationVectorY, this.mPaint);
            } else {
                canvas.drawLine(((PointerState)ps).mCoords.x - orientationVectorX, ((PointerState)ps).mCoords.y - orientationVectorY, ((PointerState)ps).mCoords.x + orientationVectorX, ((PointerState)ps).mCoords.y + orientationVectorY, this.mPaint);
            }
            float tiltScale = (float)Math.sin(ps.mCoords.getAxisValue(25));
            canvas.drawCircle(((PointerState)ps).mCoords.x + orientationVectorX * tiltScale, ((PointerState)ps).mCoords.y + orientationVectorY * tiltScale, 3.0f, this.mPaint);
            if (!ps.mHasBoundingBox) continue;
            canvas.drawRect(ps.mBoundingLeft, ps.mBoundingTop, ps.mBoundingRight, ps.mBoundingBottom, this.mPaint);
        }
    }

    private void logMotionEvent(String type, MotionEvent event) {
        int action2 = event.getAction();
        int N = event.getHistorySize();
        int NI = event.getPointerCount();
        for (int historyPos = 0; historyPos < N; ++historyPos) {
            for (int i = 0; i < NI; ++i) {
                int id2 = event.getPointerId(i);
                event.getHistoricalPointerCoords(i, historyPos, this.mTempCoords);
                this.logCoords(type, action2, i, this.mTempCoords, id2, event);
            }
        }
        for (int i = 0; i < NI; ++i) {
            int id3 = event.getPointerId(i);
            event.getPointerCoords(i, this.mTempCoords);
            this.logCoords(type, action2, i, this.mTempCoords, id3, event);
        }
    }

    private void logCoords(String type, int action2, int index, MotionEvent.PointerCoords coords, int id2, MotionEvent event) {
        String prefix;
        int toolType = event.getToolType(index);
        int buttonState = event.getButtonState();
        switch (action2 & 0xFF) {
            case 0: {
                prefix = "DOWN";
                break;
            }
            case 1: {
                prefix = "UP";
                break;
            }
            case 2: {
                prefix = "MOVE";
                break;
            }
            case 3: {
                prefix = "CANCEL";
                break;
            }
            case 4: {
                prefix = "OUTSIDE";
                break;
            }
            case 5: {
                if (index == (action2 & 0xFF00) >> 8) {
                    prefix = "DOWN";
                    break;
                }
                prefix = "MOVE";
                break;
            }
            case 6: {
                if (index == (action2 & 0xFF00) >> 8) {
                    prefix = "UP";
                    break;
                }
                prefix = "MOVE";
                break;
            }
            case 7: {
                prefix = "HOVER MOVE";
                break;
            }
            case 9: {
                prefix = "HOVER ENTER";
                break;
            }
            case 10: {
                prefix = "HOVER EXIT";
                break;
            }
            case 8: {
                prefix = "SCROLL";
                break;
            }
            default: {
                prefix = Integer.toString(action2);
            }
        }
        Log.i(TAG, this.mText.clear().append(type).append(" id ").append(id2 + 1).append(": ").append(prefix).append(" (").append(coords.x, 3).append(", ").append(coords.y, 3).append(") Pressure=").append(coords.pressure, 3).append(" Size=").append(coords.size, 3).append(" TouchMajor=").append(coords.touchMajor, 3).append(" TouchMinor=").append(coords.touchMinor, 3).append(" ToolMajor=").append(coords.toolMajor, 3).append(" ToolMinor=").append(coords.toolMinor, 3).append(" Orientation=").append((float)((double)(coords.orientation * 180.0f) / Math.PI), 1).append("deg").append(" Tilt=").append((float)((double)(coords.getAxisValue(25) * 180.0f) / Math.PI), 1).append("deg").append(" Distance=").append(coords.getAxisValue(24), 1).append(" VScroll=").append(coords.getAxisValue(9), 1).append(" HScroll=").append(coords.getAxisValue(10), 1).append(" BoundingBox=[(").append(event.getAxisValue(32), 3).append(", ").append(event.getAxisValue(33), 3).append(")").append(", (").append(event.getAxisValue(34), 3).append(", ").append(event.getAxisValue(35), 3).append(")]").append(" ToolType=").append(MotionEvent.toolTypeToString(toolType)).append(" ButtonState=").append(MotionEvent.buttonStateToString(buttonState)).toString());
    }

    @Override
    public void onPointerEvent(MotionEvent event) {
        int action2 = event.getAction();
        int NP = this.mPointers.size();
        if (action2 == 0 || (action2 & 0xFF) == 5) {
            PointerState ps;
            int index = (action2 & 0xFF00) >> 8;
            if (action2 == 0) {
                for (int p = 0; p < NP; ++p) {
                    ps = this.mPointers.get(p);
                    ps.clearTrace();
                    ps.mCurDown = false;
                }
                this.mCurDown = true;
                this.mCurNumPointers = 0;
                this.mMaxNumPointers = 0;
                this.mVelocity.clear();
                if (this.mAltVelocity != null) {
                    this.mAltVelocity.clear();
                }
            }
            ++this.mCurNumPointers;
            if (this.mMaxNumPointers < this.mCurNumPointers) {
                this.mMaxNumPointers = this.mCurNumPointers;
            }
            int id2 = event.getPointerId(index);
            while (NP <= id2) {
                ps = new PointerState();
                this.mPointers.add(ps);
                ++NP;
            }
            if (this.mActivePointerId < 0 || !this.mPointers.get(this.mActivePointerId).mCurDown) {
                this.mActivePointerId = id2;
            }
            ps = this.mPointers.get(id2);
            ps.mCurDown = true;
            InputDevice device = InputDevice.getDevice(event.getDeviceId());
            ps.mHasBoundingBox = device != null && device.getMotionRange(32) != null;
        }
        int NI = event.getPointerCount();
        this.mVelocity.addMovement(event);
        this.mVelocity.computeCurrentVelocity(1);
        if (this.mAltVelocity != null) {
            this.mAltVelocity.addMovement(event);
            this.mAltVelocity.computeCurrentVelocity(1);
        }
        int N = event.getHistorySize();
        for (int historyPos = 0; historyPos < N; ++historyPos) {
            for (int i = 0; i < NI; ++i) {
                int id3 = event.getPointerId(i);
                PointerState ps = this.mCurDown ? this.mPointers.get(id3) : null;
                MotionEvent.PointerCoords coords = ps != null ? ps.mCoords : this.mTempCoords;
                event.getHistoricalPointerCoords(i, historyPos, coords);
                if (this.mPrintCoords) {
                    this.logCoords(TAG, action2, i, coords, id3, event);
                }
                if (ps == null) continue;
                ps.addTrace(coords.x, coords.y, false);
            }
        }
        for (int i = 0; i < NI; ++i) {
            int id4 = event.getPointerId(i);
            PointerState ps = this.mCurDown ? this.mPointers.get(id4) : null;
            MotionEvent.PointerCoords coords = ps != null ? ps.mCoords : this.mTempCoords;
            event.getPointerCoords(i, coords);
            if (this.mPrintCoords) {
                this.logCoords(TAG, action2, i, coords, id4, event);
            }
            if (ps == null) continue;
            ps.addTrace(coords.x, coords.y, true);
            ps.mXVelocity = this.mVelocity.getXVelocity(id4);
            ps.mYVelocity = this.mVelocity.getYVelocity(id4);
            this.mVelocity.getEstimator(id4, ps.mEstimator);
            if (this.mAltVelocity != null) {
                ps.mAltXVelocity = this.mAltVelocity.getXVelocity(id4);
                ps.mAltYVelocity = this.mAltVelocity.getYVelocity(id4);
                this.mAltVelocity.getEstimator(id4, ps.mAltEstimator);
            }
            ps.mToolType = event.getToolType(i);
            if (!ps.mHasBoundingBox) continue;
            ps.mBoundingLeft = event.getAxisValue(32, i);
            ps.mBoundingTop = event.getAxisValue(33, i);
            ps.mBoundingRight = event.getAxisValue(34, i);
            ps.mBoundingBottom = event.getAxisValue(35, i);
        }
        if (action2 == 1 || action2 == 3 || (action2 & 0xFF) == 6) {
            int index = (action2 & 0xFF00) >> 8;
            int id5 = event.getPointerId(index);
            if (id5 >= NP) {
                Slog.wtf(TAG, "Got pointer ID out of bounds: id=" + id5 + " arraysize=" + NP + " pointerindex=" + index + " action=0x" + Integer.toHexString(action2));
                return;
            }
            PointerState ps = this.mPointers.get(id5);
            ps.mCurDown = false;
            if (action2 == 1 || action2 == 3) {
                this.mCurDown = false;
                this.mCurNumPointers = 0;
            } else {
                --this.mCurNumPointers;
                if (this.mActivePointerId == id5) {
                    this.mActivePointerId = event.getPointerId(index == 0 ? 1 : 0);
                }
                ps.addTrace(Float.NaN, Float.NaN, false);
            }
        }
        this.invalidate();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        this.onPointerEvent(event);
        if (event.getAction() == 0 && !this.isFocused()) {
            this.requestFocus();
        }
        return true;
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        int source = event.getSource();
        if ((source & 2) != 0) {
            this.onPointerEvent(event);
        } else if ((source & 0x10) != 0) {
            this.logMotionEvent("Joystick", event);
        } else if ((source & 8) != 0) {
            this.logMotionEvent("Position", event);
        } else {
            this.logMotionEvent("Generic", event);
        }
        return true;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (PointerLocationView.shouldLogKey(keyCode)) {
            int repeatCount = event.getRepeatCount();
            if (repeatCount == 0) {
                Log.i(TAG, "Key Down: " + event);
            } else {
                Log.i(TAG, "Key Repeat #" + repeatCount + ": " + event);
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (PointerLocationView.shouldLogKey(keyCode)) {
            Log.i(TAG, "Key Up: " + event);
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private static boolean shouldLogKey(int keyCode) {
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return KeyEvent.isGamepadButton(keyCode) || KeyEvent.isModifierKey(keyCode);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        this.logMotionEvent("Trackball", event);
        return true;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIm.registerInputDeviceListener(this, this.getHandler());
        if (PointerLocationView.shouldShowSystemGestureExclusion()) {
            try {
                WindowManagerGlobal.getWindowManagerService().registerSystemGestureExclusionListener(this.mSystemGestureExclusionListener, this.mContext.getDisplayId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            int alpha = PointerLocationView.systemGestureExclusionOpacity();
            this.mSystemGestureExclusionPaint.setAlpha(alpha);
            this.mSystemGestureExclusionRejectedPaint.setAlpha(alpha);
        } else {
            this.mSystemGestureExclusion.setEmpty();
        }
        this.logInputDevices();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIm.unregisterInputDeviceListener(this);
        try {
            WindowManagerGlobal.getWindowManagerService().unregisterSystemGestureExclusionListener(this.mSystemGestureExclusionListener, this.mContext.getDisplayId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void onInputDeviceAdded(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Added");
    }

    @Override
    public void onInputDeviceChanged(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Changed");
    }

    @Override
    public void onInputDeviceRemoved(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Removed");
    }

    private void logInputDevices() {
        int[] deviceIds = InputDevice.getDeviceIds();
        for (int i = 0; i < deviceIds.length; ++i) {
            this.logInputDeviceState(deviceIds[i], "Device Enumerated");
        }
    }

    private void logInputDeviceState(int deviceId, String state) {
        InputDevice device = this.mIm.getInputDevice(deviceId);
        if (device != null) {
            Log.i(TAG, state + ": " + device);
        } else {
            Log.i(TAG, state + ": " + deviceId);
        }
    }

    private static boolean shouldShowSystemGestureExclusion() {
        return PointerLocationView.systemGestureExclusionOpacity() > 0;
    }

    private static int systemGestureExclusionOpacity() {
        int x = SystemProperties.getInt(GESTURE_EXCLUSION_PROP, 0);
        return x >= 0 && x <= 255 ? x : 0;
    }

    private static class FasterStringBuilder {
        private char[] mChars = new char[64];
        private int mLength;

        public FasterStringBuilder clear() {
            this.mLength = 0;
            return this;
        }

        public FasterStringBuilder append(String value2) {
            int valueLength = value2.length();
            int index = this.reserve(valueLength);
            value2.getChars(0, valueLength, this.mChars, index);
            this.mLength += valueLength;
            return this;
        }

        public FasterStringBuilder append(int value2) {
            return this.append(value2, 0);
        }

        public FasterStringBuilder append(int value2, int zeroPadWidth) {
            int divisor;
            boolean negative;
            boolean bl = negative = value2 < 0;
            if (negative && (value2 = -value2) < 0) {
                this.append("-2147483648");
                return this;
            }
            int index = this.reserve(11);
            char[] chars = this.mChars;
            if (value2 == 0) {
                chars[index++] = 48;
                ++this.mLength;
                return this;
            }
            if (negative) {
                chars[index++] = 45;
            }
            int numberWidth = 10;
            for (divisor = 1000000000; value2 < divisor; divisor /= 10) {
                if (--numberWidth >= zeroPadWidth) continue;
                chars[index++] = 48;
            }
            do {
                int digit = value2 / divisor;
                value2 -= digit * divisor;
                chars[index++] = (char)(digit + 48);
            } while ((divisor /= 10) != 0);
            this.mLength = index;
            return this;
        }

        public FasterStringBuilder append(float value2, int precision) {
            int scale = 1;
            for (int i = 0; i < precision; ++i) {
                scale *= 10;
            }
            if ((int)(value2 = (float)(Math.rint(value2 * (float)scale) / (double)scale)) == 0 && value2 < 0.0f) {
                this.append("-");
            }
            this.append((int)value2);
            if (precision != 0) {
                this.append(".");
                value2 = Math.abs(value2);
                value2 = (float)((double)value2 - Math.floor(value2));
                this.append((int)(value2 * (float)scale), precision);
            }
            return this;
        }

        public String toString() {
            return new String(this.mChars, 0, this.mLength);
        }

        private int reserve(int length) {
            int oldLength = this.mLength;
            int newLength = this.mLength + length;
            char[] oldChars = this.mChars;
            int oldCapacity = oldChars.length;
            if (newLength > oldCapacity) {
                int newCapacity = oldCapacity * 2;
                char[] newChars = new char[newCapacity];
                System.arraycopy(oldChars, 0, newChars, 0, oldLength);
                this.mChars = newChars;
            }
            return oldLength;
        }
    }

    public static class PointerState {
        private float[] mTraceX = new float[32];
        private float[] mTraceY = new float[32];
        private boolean[] mTraceCurrent = new boolean[32];
        private int mTraceCount;
        @UnsupportedAppUsage
        private boolean mCurDown;
        private MotionEvent.PointerCoords mCoords = new MotionEvent.PointerCoords();
        private int mToolType;
        private float mXVelocity;
        private float mYVelocity;
        private float mAltXVelocity;
        private float mAltYVelocity;
        private boolean mHasBoundingBox;
        private float mBoundingLeft;
        private float mBoundingTop;
        private float mBoundingRight;
        private float mBoundingBottom;
        private VelocityTracker.Estimator mEstimator = new VelocityTracker.Estimator();
        private VelocityTracker.Estimator mAltEstimator = new VelocityTracker.Estimator();

        @UnsupportedAppUsage
        public PointerState() {
        }

        public void clearTrace() {
            this.mTraceCount = 0;
        }

        public void addTrace(float x, float y, boolean current) {
            int traceCapacity = this.mTraceX.length;
            if (this.mTraceCount == traceCapacity) {
                float[] newTraceX = new float[traceCapacity *= 2];
                System.arraycopy(this.mTraceX, 0, newTraceX, 0, this.mTraceCount);
                this.mTraceX = newTraceX;
                float[] newTraceY = new float[traceCapacity];
                System.arraycopy(this.mTraceY, 0, newTraceY, 0, this.mTraceCount);
                this.mTraceY = newTraceY;
                boolean[] newTraceCurrent = new boolean[traceCapacity];
                System.arraycopy(this.mTraceCurrent, 0, newTraceCurrent, 0, this.mTraceCount);
                this.mTraceCurrent = newTraceCurrent;
            }
            this.mTraceX[this.mTraceCount] = x;
            this.mTraceY[this.mTraceCount] = y;
            this.mTraceCurrent[this.mTraceCount] = current;
            ++this.mTraceCount;
        }
    }
}

