/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.widget.IMessagingLayout;

@RemoteViews.RemoteView
public class MessagingLinearLayout
extends ViewGroup {
    private int mSpacing;
    private int mMaxDisplayedLines = Integer.MAX_VALUE;

    public MessagingLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MessagingLinearLayout, 0, 0);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    this.mSpacing = a.getDimensionPixelSize(i, 0);
                }
            }
        }
        a.recycle();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int targetHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        switch (View.MeasureSpec.getMode(heightMeasureSpec)) {
            case 0: {
                targetHeight = Integer.MAX_VALUE;
            }
        }
        int measuredWidth = this.mPaddingLeft + this.mPaddingRight;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.hide = true;
            if (!(child instanceof MessagingChild)) continue;
            MessagingChild messagingChild = (MessagingChild)((Object)child);
            messagingChild.setIsFirstInLayout(true);
        }
        int totalHeight = this.mPaddingTop + this.mPaddingBottom;
        boolean first = true;
        int linesRemaining = this.mMaxDisplayedLines;
        MessagingChild previousChild = null;
        View previousView = null;
        int previousChildHeight = 0;
        int previousTotalHeight = 0;
        int previousLinesConsumed = 0;
        for (int i = count - 1; i >= 0 && totalHeight < targetHeight; --i) {
            boolean showView;
            if (this.getChildAt(i).getVisibility() == 8) continue;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            MessagingChild messagingChild = null;
            int spacing = this.mSpacing;
            int previousChildIncrease = 0;
            if (child instanceof MessagingChild) {
                if (previousChild != null && previousChild.hasDifferentHeightWhenFirst()) {
                    previousChild.setIsFirstInLayout(false);
                    this.measureChildWithMargins(previousView, widthMeasureSpec, 0, heightMeasureSpec, previousTotalHeight - previousChildHeight);
                    previousChildIncrease = previousView.getMeasuredHeight() - previousChildHeight;
                    linesRemaining -= previousChild.getConsumedLines() - previousLinesConsumed;
                }
                messagingChild = (MessagingChild)((Object)child);
                messagingChild.setMaxDisplayedLines(linesRemaining);
                spacing += messagingChild.getExtraSpacing();
            }
            spacing = first ? 0 : spacing;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, totalHeight - this.mPaddingTop - this.mPaddingBottom + spacing);
            int childHeight = child.getMeasuredHeight();
            int newHeight = Math.max(totalHeight, totalHeight + childHeight + lp.topMargin + lp.bottomMargin + spacing + previousChildIncrease);
            int measureType = 0;
            if (messagingChild != null) {
                measureType = messagingChild.getMeasuredType();
            }
            boolean isTooSmall = measureType == 2 && !first;
            boolean isShortened = measureType == 1 || measureType == 2 && first;
            boolean bl = showView = newHeight <= targetHeight && !isTooSmall;
            if (showView) {
                if (messagingChild != null) {
                    previousLinesConsumed = messagingChild.getConsumedLines();
                    linesRemaining -= previousLinesConsumed;
                    previousChild = messagingChild;
                    previousView = child;
                    previousChildHeight = childHeight;
                    previousTotalHeight = totalHeight;
                }
                totalHeight = newHeight;
                measuredWidth = Math.max(measuredWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin + this.mPaddingLeft + this.mPaddingRight);
                lp.hide = false;
                if (isShortened || linesRemaining <= 0) {
                    break;
                }
            } else {
                if (previousChild == null || !previousChild.hasDifferentHeightWhenFirst()) break;
                previousChild.setIsFirstInLayout(true);
                this.measureChildWithMargins(previousView, widthMeasureSpec, 0, heightMeasureSpec, previousTotalHeight - previousChildHeight);
                break;
            }
            first = false;
        }
        this.setMeasuredDimension(MessagingLinearLayout.resolveSize(Math.max(this.getSuggestedMinimumWidth(), measuredWidth), widthMeasureSpec), Math.max(this.getSuggestedMinimumHeight(), totalHeight));
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right2, int bottom2) {
        int paddingLeft = this.mPaddingLeft;
        int width = right2 - left;
        int childRight = width - this.mPaddingRight;
        int layoutDirection = this.getLayoutDirection();
        int count = this.getChildCount();
        int childTop = this.mPaddingTop;
        boolean first = true;
        boolean shown = this.isShown();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            MessagingChild messagingChild = (MessagingChild)((Object)child);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childLeft = layoutDirection == 1 ? childRight - childWidth - lp.rightMargin : paddingLeft + lp.leftMargin;
            if (lp.hide) {
                if (shown && lp.visibleBefore) {
                    child.layout(childLeft, childTop, childLeft + childWidth, childTop + lp.lastVisibleHeight);
                    messagingChild.hideAnimated();
                }
                lp.visibleBefore = false;
                continue;
            }
            lp.visibleBefore = true;
            lp.lastVisibleHeight = childHeight;
            if (!first) {
                childTop += this.mSpacing;
            }
            child.layout(childLeft, childTop += lp.topMargin, childLeft + childWidth, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
            first = false;
        }
    }

    @Override
    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        MessagingChild messagingChild;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.hide && !(messagingChild = (MessagingChild)((Object)child)).isHidingAnimated()) {
            return true;
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    public void setSpacing(int spacing) {
        if (this.mSpacing != spacing) {
            this.mSpacing = spacing;
            this.requestLayout();
        }
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.mContext, attrs);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        LayoutParams copy = new LayoutParams(lp.width, lp.height);
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            copy.copyMarginsFrom((ViewGroup.MarginLayoutParams)lp);
        }
        return copy;
    }

    public static boolean isGone(View view) {
        if (view.getVisibility() == 8) {
            return true;
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        return lp instanceof LayoutParams && ((LayoutParams)lp).hide;
    }

    @RemotableViewMethod
    public void setMaxDisplayedLines(int numberLines) {
        this.mMaxDisplayedLines = numberLines;
    }

    public IMessagingLayout getMessagingLayout() {
        ViewParent p;
        View view = this;
        while ((p = view.getParent()) instanceof View) {
            view = (View)((Object)p);
            if (!(view instanceof IMessagingLayout)) continue;
            return (IMessagingLayout)((Object)view);
        }
        return null;
    }

    @Override
    public int getBaseline() {
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (MessagingLinearLayout.isGone(child)) continue;
            int childBaseline = child.getBaseline();
            if (childBaseline == -1) {
                return -1;
            }
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            return lp.topMargin + childBaseline;
        }
        return super.getBaseline();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public boolean hide = false;
        public boolean visibleBefore = false;
        public int lastVisibleHeight;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }
    }

    public static interface MessagingChild {
        public static final int MEASURED_NORMAL = 0;
        public static final int MEASURED_SHORTENED = 1;
        public static final int MEASURED_TOO_SMALL = 2;

        public int getMeasuredType();

        public int getConsumedLines();

        public void setMaxDisplayedLines(int var1);

        public void hideAnimated();

        public boolean isHidingAnimated();

        default public void setIsFirstInLayout(boolean first) {
        }

        default public boolean hasDifferentHeightWhenFirst() {
            return false;
        }

        default public int getExtraSpacing() {
            return 0;
        }
    }
}

