/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.AsyncTask;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockscreenCredential;
import com.android.internal.widget.VerifyCredentialResponse;

public class LockPatternChecker {
    public static AsyncTask<?, ?, ?> verifyCredential(final LockPatternUtils utils, LockscreenCredential credential, final int userId, final int flags, final OnVerifyCallback callback2) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, VerifyCredentialResponse> task = new AsyncTask<Void, Void, VerifyCredentialResponse>(){

            protected VerifyCredentialResponse doInBackground(Void ... args) {
                return utils.verifyCredential(credentialCopy, userId, flags);
            }

            @Override
            protected void onPostExecute(VerifyCredentialResponse result) {
                callback2.onVerified(result, result.getTimeout());
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static AsyncTask<?, ?, ?> checkCredential(final LockPatternUtils utils, LockscreenCredential credential, final int userId, final OnCheckCallback callback2) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, Boolean> task = new AsyncTask<Void, Void, Boolean>(){
            private int mThrottleTimeout;

            protected Boolean doInBackground(Void ... args) {
                try {
                    return utils.checkCredential(credentialCopy, userId, callback2::onEarlyMatched);
                }
                catch (LockPatternUtils.RequestThrottledException ex) {
                    this.mThrottleTimeout = ex.getTimeoutMs();
                    return false;
                }
            }

            @Override
            protected void onPostExecute(Boolean result) {
                callback2.onChecked(result, this.mThrottleTimeout);
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                callback2.onCancelled();
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static AsyncTask<?, ?, ?> verifyTiedProfileChallenge(final LockPatternUtils utils, LockscreenCredential credential, final int userId, final int flags, final OnVerifyCallback callback2) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, VerifyCredentialResponse> task = new AsyncTask<Void, Void, VerifyCredentialResponse>(){

            protected VerifyCredentialResponse doInBackground(Void ... args) {
                return utils.verifyTiedProfileChallenge(credentialCopy, userId, flags);
            }

            @Override
            protected void onPostExecute(VerifyCredentialResponse response) {
                callback2.onVerified(response, response.getTimeout());
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static interface OnVerifyCallback {
        public void onVerified(VerifyCredentialResponse var1, int var2);
    }

    public static interface OnCheckCallback {
        default public void onEarlyMatched() {
        }

        public void onChecked(boolean var1, int var2);

        default public void onCancelled() {
        }
    }
}

