/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.ImageDecoder;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.util.Size;
import java.io.IOException;

public class LocalImageResolver {
    private static final String TAG = LocalImageResolver.class.getSimpleName();
    private static final int MAX_SAFE_ICON_SIZE_PX = 480;

    public static Drawable resolveImage(Uri uri, Context context) throws IOException {
        ImageDecoder.Source source = ImageDecoder.createSource(context.getContentResolver(), uri);
        Drawable drawable2 = ImageDecoder.decodeDrawable(source, LocalImageResolver::onHeaderDecoded);
        return drawable2;
    }

    public static Drawable resolveImage(Icon icon2, Context context) throws IOException {
        Uri uri = LocalImageResolver.getResolvableUri(icon2);
        if (uri != null) {
            Drawable result = LocalImageResolver.resolveImage(uri, context);
            if (icon2.hasTint()) {
                result.mutate();
                result.setTintList(icon2.getTintList());
                result.setTintBlendMode(icon2.getTintBlendMode());
            }
            return result;
        }
        return icon2.loadDrawable(context);
    }

    public static Drawable resolveImage(Uri uri, Context context, int maxWidth, int maxHeight) throws IOException {
        ImageDecoder.Source source = ImageDecoder.createSource(context.getContentResolver(), uri);
        return ImageDecoder.decodeDrawable(source, (decoder, info, unused) -> {
            Size size = info.getSize();
            if (size.getWidth() > size.getHeight()) {
                if (size.getWidth() > maxWidth) {
                    int targetHeight = size.getHeight() * maxWidth / size.getWidth();
                    decoder.setTargetSize(maxWidth, targetHeight);
                }
            } else if (size.getHeight() > maxHeight) {
                int targetWidth = size.getWidth() * maxHeight / size.getHeight();
                decoder.setTargetSize(targetWidth, maxHeight);
            }
        });
    }

    private static int getPowerOfTwoForSampleRatio(double ratio) {
        int k = Integer.highestOneBit((int)Math.floor(ratio));
        return Math.max(1, k);
    }

    private static void onHeaderDecoded(ImageDecoder decoder, ImageDecoder.ImageInfo info, ImageDecoder.Source source) {
        Size size = info.getSize();
        int originalSize = Math.max(size.getHeight(), size.getWidth());
        double ratio = originalSize > 480 ? (double)((float)originalSize * 1.0f / 480.0f) : 1.0;
        decoder.setTargetSampleSize(LocalImageResolver.getPowerOfTwoForSampleRatio(ratio));
    }

    public static Uri getResolvableUri(Icon icon2) {
        if (icon2 == null || icon2.getType() != 4 && icon2.getType() != 6) {
            return null;
        }
        return icon2.getUri();
    }
}

