/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Size;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.ArrayAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FloatingToolbar {
    public static final String FLOATING_TOOLBAR_TAG = "floating_toolbar";
    private static final MenuItem.OnMenuItemClickListener NO_OP_MENUITEM_CLICK_LISTENER = item -> false;
    private final Context mContext;
    private final Window mWindow;
    private final FloatingToolbarPopup mPopup;
    private final Rect mContentRect = new Rect();
    private final Rect mPreviousContentRect = new Rect();
    private Menu mMenu;
    private MenuItem.OnMenuItemClickListener mMenuItemClickListener = NO_OP_MENUITEM_CLICK_LISTENER;
    private int mSuggestedWidth;
    private boolean mWidthChanged = true;
    private final View.OnLayoutChangeListener mOrientationChangeHandler = new View.OnLayoutChangeListener(){
        private final Rect mNewRect = new Rect();
        private final Rect mOldRect = new Rect();

        @Override
        public void onLayoutChange(View view, int newLeft, int newRight, int newTop, int newBottom, int oldLeft, int oldRight, int oldTop, int oldBottom) {
            this.mNewRect.set(newLeft, newRight, newTop, newBottom);
            this.mOldRect.set(oldLeft, oldRight, oldTop, oldBottom);
            if (FloatingToolbar.this.mPopup.isShowing() && !this.mNewRect.equals(this.mOldRect)) {
                FloatingToolbar.this.mWidthChanged = true;
                FloatingToolbar.this.updateLayout();
            }
        }
    };
    private final Comparator<MenuItem> mMenuItemComparator = (menuItem1, menuItem2) -> {
        if (menuItem1.getItemId() == 16908353) {
            return menuItem2.getItemId() == 16908353 ? 0 : -1;
        }
        if (menuItem2.getItemId() == 16908353) {
            return 1;
        }
        if (menuItem1.requiresActionButton()) {
            return menuItem2.requiresActionButton() ? 0 : -1;
        }
        if (menuItem2.requiresActionButton()) {
            return 1;
        }
        if (menuItem1.requiresOverflow()) {
            return menuItem2.requiresOverflow() ? 0 : 1;
        }
        if (menuItem2.requiresOverflow()) {
            return -1;
        }
        return menuItem1.getOrder() - menuItem2.getOrder();
    };

    public FloatingToolbar(Window window) {
        this.mContext = FloatingToolbar.applyDefaultTheme(window.getContext());
        this.mWindow = Objects.requireNonNull(window);
        this.mPopup = new FloatingToolbarPopup(this.mContext, window.getDecorView());
    }

    public FloatingToolbar setMenu(Menu menu2) {
        this.mMenu = Objects.requireNonNull(menu2);
        return this;
    }

    public FloatingToolbar setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener menuItemClickListener) {
        this.mMenuItemClickListener = menuItemClickListener != null ? menuItemClickListener : NO_OP_MENUITEM_CLICK_LISTENER;
        return this;
    }

    public FloatingToolbar setContentRect(Rect rect) {
        this.mContentRect.set(Objects.requireNonNull(rect));
        return this;
    }

    public FloatingToolbar setSuggestedWidth(int suggestedWidth) {
        int difference = Math.abs(suggestedWidth - this.mSuggestedWidth);
        this.mWidthChanged = (double)difference > (double)this.mSuggestedWidth * 0.2;
        this.mSuggestedWidth = suggestedWidth;
        return this;
    }

    public FloatingToolbar show() {
        this.registerOrientationHandler();
        this.doShow();
        return this;
    }

    public FloatingToolbar updateLayout() {
        if (this.mPopup.isShowing()) {
            this.doShow();
        }
        return this;
    }

    public void dismiss() {
        this.unregisterOrientationHandler();
        this.mPopup.dismiss();
    }

    public void hide() {
        this.mPopup.hide();
    }

    public boolean isShowing() {
        return this.mPopup.isShowing();
    }

    public boolean isHidden() {
        return this.mPopup.isHidden();
    }

    public void setOutsideTouchable(boolean outsideTouchable, PopupWindow.OnDismissListener onDismiss) {
        this.mPopup.setOutsideTouchable(outsideTouchable, onDismiss);
    }

    private void doShow() {
        List<MenuItem> menuItems = FloatingToolbar.getVisibleAndEnabledMenuItems(this.mMenu);
        menuItems.sort(this.mMenuItemComparator);
        if (this.mPopup.isLayoutRequired(menuItems) || this.mWidthChanged) {
            this.mPopup.dismiss();
            this.mPopup.layoutMenuItems(menuItems, this.mMenuItemClickListener, this.mSuggestedWidth);
        } else {
            this.mPopup.updateMenuItems(menuItems, this.mMenuItemClickListener);
        }
        if (!this.mPopup.isShowing()) {
            this.mPopup.show(this.mContentRect);
        } else if (!this.mPreviousContentRect.equals(this.mContentRect)) {
            this.mPopup.updateCoordinates(this.mContentRect);
        }
        this.mWidthChanged = false;
        this.mPreviousContentRect.set(this.mContentRect);
    }

    private static List<MenuItem> getVisibleAndEnabledMenuItems(Menu menu2) {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        for (int i = 0; menu2 != null && i < menu2.size(); ++i) {
            MenuItem menuItem = menu2.getItem(i);
            if (!menuItem.isVisible() || !menuItem.isEnabled()) continue;
            SubMenu subMenu = menuItem.getSubMenu();
            if (subMenu != null) {
                menuItems.addAll(FloatingToolbar.getVisibleAndEnabledMenuItems(subMenu));
                continue;
            }
            menuItems.add(menuItem);
        }
        return menuItems;
    }

    private void registerOrientationHandler() {
        this.unregisterOrientationHandler();
        this.mWindow.getDecorView().addOnLayoutChangeListener(this.mOrientationChangeHandler);
    }

    private void unregisterOrientationHandler() {
        this.mWindow.getDecorView().removeOnLayoutChangeListener(this.mOrientationChangeHandler);
    }

    private static View createMenuItemButton(Context context, MenuItem menuItem, int iconTextSpacing, boolean showIcon) {
        View menuItemButton = LayoutInflater.from(context).inflate(17367161, null);
        if (menuItem != null) {
            FloatingToolbar.updateMenuItemButton(menuItemButton, menuItem, iconTextSpacing, showIcon);
        }
        return menuItemButton;
    }

    private static void updateMenuItemButton(View menuItemButton, MenuItem menuItem, int iconTextSpacing, boolean showIcon) {
        CharSequence contentDescription;
        TextView buttonText = (TextView)menuItemButton.findViewById(16909019);
        buttonText.setEllipsize(null);
        if (TextUtils.isEmpty(menuItem.getTitle())) {
            buttonText.setVisibility(8);
        } else {
            buttonText.setVisibility(0);
            buttonText.setText(menuItem.getTitle());
        }
        ImageView buttonIcon = (ImageView)menuItemButton.findViewById(16909017);
        if (menuItem.getIcon() == null || !showIcon) {
            buttonIcon.setVisibility(8);
            if (buttonText != null) {
                buttonText.setPaddingRelative(0, 0, 0, 0);
            }
        } else {
            buttonIcon.setVisibility(0);
            buttonIcon.setImageDrawable(menuItem.getIcon());
            if (buttonText != null) {
                buttonText.setPaddingRelative(iconTextSpacing, 0, 0, 0);
            }
        }
        if (TextUtils.isEmpty(contentDescription = menuItem.getContentDescription())) {
            menuItemButton.setContentDescription(menuItem.getTitle());
        } else {
            menuItemButton.setContentDescription(contentDescription);
        }
    }

    private static ViewGroup createContentContainer(Context context) {
        ViewGroup contentContainer = (ViewGroup)LayoutInflater.from(context).inflate(17367160, null);
        contentContainer.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        contentContainer.setTag(FLOATING_TOOLBAR_TAG);
        contentContainer.setClipToOutline(true);
        return contentContainer;
    }

    private static PopupWindow createPopupWindow(ViewGroup content2) {
        LinearLayout popupContentHolder = new LinearLayout(content2.getContext());
        PopupWindow popupWindow = new PopupWindow(popupContentHolder);
        popupWindow.setClippingEnabled(false);
        popupWindow.setWindowLayoutType(1005);
        popupWindow.setAnimationStyle(0);
        popupWindow.setBackgroundDrawable(new ColorDrawable(0));
        content2.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        popupContentHolder.addView(content2);
        return popupWindow;
    }

    private static AnimatorSet createEnterAnimation(View view) {
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 1.0f).setDuration(150L));
        return animation;
    }

    private static AnimatorSet createExitAnimation(View view, int startDelay, Animator.AnimatorListener listener2) {
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(ObjectAnimator.ofFloat(view, View.ALPHA, 1.0f, 0.0f).setDuration(100L));
        animation.setStartDelay(startDelay);
        animation.addListener(listener2);
        return animation;
    }

    private static Context applyDefaultTheme(Context originalContext) {
        TypedArray a = originalContext.obtainStyledAttributes(new int[]{16844176});
        boolean isLightTheme = a.getBoolean(0, true);
        int themeId = isLightTheme ? 16974123 : 16974120;
        a.recycle();
        return new ContextThemeWrapper(originalContext, themeId);
    }

    @VisibleForTesting
    public static class MenuItemRepr {
        public final int itemId;
        public final int groupId;
        public final String title;
        private final Drawable mIcon;

        private MenuItemRepr(int itemId, int groupId, CharSequence title, Drawable icon2) {
            this.itemId = itemId;
            this.groupId = groupId;
            this.title = title == null ? null : title.toString();
            this.mIcon = icon2;
        }

        public static MenuItemRepr of(MenuItem menuItem) {
            return new MenuItemRepr(menuItem.getItemId(), menuItem.getGroupId(), menuItem.getTitle(), menuItem.getIcon());
        }

        public int hashCode() {
            return Objects.hash(this.itemId, this.groupId, this.title, this.mIcon);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MenuItemRepr)) {
                return false;
            }
            MenuItemRepr other = (MenuItemRepr)o;
            return this.itemId == other.itemId && this.groupId == other.groupId && TextUtils.equals(this.title, other.title) && Objects.equals(this.mIcon, other.mIcon);
        }

        public static boolean reprEquals(Collection<MenuItem> menuItems1, Collection<MenuItem> menuItems2) {
            if (menuItems1.size() != menuItems2.size()) {
                return false;
            }
            Iterator<MenuItem> menuItems2Iter = menuItems2.iterator();
            for (MenuItem menuItem1 : menuItems1) {
                MenuItem menuItem2 = menuItems2Iter.next();
                if (MenuItemRepr.of(menuItem1).equals(MenuItemRepr.of(menuItem2))) continue;
                return false;
            }
            return true;
        }
    }

    private static class FloatingToolbarPopup {
        private static final int MIN_OVERFLOW_SIZE = 2;
        private static final int MAX_OVERFLOW_SIZE = 4;
        private final Context mContext;
        private final View mParent;
        private final PopupWindow mPopupWindow;
        private final int mMarginHorizontal;
        private final int mMarginVertical;
        private final ViewGroup mContentContainer;
        private final ViewGroup mMainPanel;
        private final OverflowPanel mOverflowPanel;
        private final ImageButton mOverflowButton;
        private final Drawable mArrow;
        private final Drawable mOverflow;
        private final AnimatedVectorDrawable mToArrow;
        private final AnimatedVectorDrawable mToOverflow;
        private final OverflowPanelViewHelper mOverflowPanelViewHelper;
        private final Interpolator mLogAccelerateInterpolator;
        private final Interpolator mFastOutSlowInInterpolator;
        private final Interpolator mLinearOutSlowInInterpolator;
        private final Interpolator mFastOutLinearInInterpolator;
        private final AnimatorSet mShowAnimation;
        private final AnimatorSet mDismissAnimation;
        private final AnimatorSet mHideAnimation;
        private final AnimationSet mOpenOverflowAnimation;
        private final AnimationSet mCloseOverflowAnimation;
        private final Animation.AnimationListener mOverflowAnimationListener;
        private final Rect mViewPortOnScreen = new Rect();
        private final Point mCoordsOnWindow = new Point();
        private final int[] mTmpCoords = new int[2];
        private final Region mTouchableRegion = new Region();
        private final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer = info -> {
            info.contentInsets.setEmpty();
            info.visibleInsets.setEmpty();
            info.touchableRegion.set(this.mTouchableRegion);
            info.setTouchableInsets(3);
        };
        private final int mLineHeight;
        private final int mIconTextSpacing;
        private final Runnable mPreparePopupContentRTLHelper = new Runnable(){

            @Override
            public void run() {
                this.setPanelsStatesAtRestingPosition();
                this.setContentAreaAsTouchableSurface();
                mContentContainer.setAlpha(1.0f);
            }
        };
        private boolean mDismissed = true;
        private boolean mHidden;
        private final Size mOverflowButtonSize;
        private Size mOverflowPanelSize;
        private Size mMainPanelSize;
        private final Map<MenuItemRepr, MenuItem> mMenuItems = new LinkedHashMap<MenuItemRepr, MenuItem>();
        private MenuItem.OnMenuItemClickListener mOnMenuItemClickListener;
        private final View.OnClickListener mMenuItemButtonOnClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View v) {
                if (mOnMenuItemClickListener == null) {
                    return;
                }
                Object tag = v.getTag();
                if (!(tag instanceof MenuItemRepr)) {
                    return;
                }
                MenuItem menuItem = (MenuItem)mMenuItems.get((MenuItemRepr)tag);
                if (menuItem == null) {
                    return;
                }
                mOnMenuItemClickListener.onMenuItemClick(menuItem);
            }
        };
        private boolean mOpenOverflowUpwards;
        private boolean mIsOverflowOpen;
        private int mTransitionDurationScale;

        public FloatingToolbarPopup(Context context, View parent) {
            this.mParent = Objects.requireNonNull(parent);
            this.mContext = Objects.requireNonNull(context);
            this.mContentContainer = FloatingToolbar.createContentContainer(context);
            this.mPopupWindow = FloatingToolbar.createPopupWindow(this.mContentContainer);
            this.mMarginHorizontal = parent.getResources().getDimensionPixelSize(17105211);
            this.mMarginVertical = parent.getResources().getDimensionPixelSize(17105224);
            this.mLineHeight = context.getResources().getDimensionPixelSize(17105210);
            this.mIconTextSpacing = context.getResources().getDimensionPixelSize(17105212);
            this.mLogAccelerateInterpolator = new LogAccelerateInterpolator();
            this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563661);
            this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563662);
            this.mFastOutLinearInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563663);
            this.mArrow = this.mContext.getResources().getDrawable(17302267, this.mContext.getTheme());
            this.mArrow.setAutoMirrored(true);
            this.mOverflow = this.mContext.getResources().getDrawable(17302265, this.mContext.getTheme());
            this.mOverflow.setAutoMirrored(true);
            this.mToArrow = (AnimatedVectorDrawable)this.mContext.getResources().getDrawable(17302266, this.mContext.getTheme());
            this.mToArrow.setAutoMirrored(true);
            this.mToOverflow = (AnimatedVectorDrawable)this.mContext.getResources().getDrawable(17302268, this.mContext.getTheme());
            this.mToOverflow.setAutoMirrored(true);
            this.mOverflowButton = this.createOverflowButton();
            this.mOverflowButtonSize = FloatingToolbarPopup.measure(this.mOverflowButton);
            this.mMainPanel = this.createMainPanel();
            this.mOverflowPanelViewHelper = new OverflowPanelViewHelper(this.mContext, this.mIconTextSpacing);
            this.mOverflowPanel = this.createOverflowPanel();
            this.mOverflowAnimationListener = this.createOverflowAnimationListener();
            this.mOpenOverflowAnimation = new AnimationSet(true);
            this.mOpenOverflowAnimation.setAnimationListener(this.mOverflowAnimationListener);
            this.mCloseOverflowAnimation = new AnimationSet(true);
            this.mCloseOverflowAnimation.setAnimationListener(this.mOverflowAnimationListener);
            this.mShowAnimation = FloatingToolbar.createEnterAnimation(this.mContentContainer);
            this.mDismissAnimation = FloatingToolbar.createExitAnimation(this.mContentContainer, 150, new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    mPopupWindow.dismiss();
                    mContentContainer.removeAllViews();
                }
            });
            this.mHideAnimation = FloatingToolbar.createExitAnimation(this.mContentContainer, 0, new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    mPopupWindow.dismiss();
                }
            });
        }

        public boolean setOutsideTouchable(boolean outsideTouchable, PopupWindow.OnDismissListener onDismiss) {
            boolean ret = false;
            if (this.mPopupWindow.isOutsideTouchable() ^ outsideTouchable) {
                this.mPopupWindow.setOutsideTouchable(outsideTouchable);
                this.mPopupWindow.setFocusable(!outsideTouchable);
                this.mPopupWindow.update();
                ret = true;
            }
            this.mPopupWindow.setOnDismissListener(onDismiss);
            return ret;
        }

        public void layoutMenuItems(List<MenuItem> menuItems, MenuItem.OnMenuItemClickListener menuItemClickListener, int suggestedWidth) {
            this.cancelOverflowAnimations();
            this.clearPanels();
            this.updateMenuItems(menuItems, menuItemClickListener);
            menuItems = this.layoutMainPanelItems(menuItems, this.getAdjustedToolbarWidth(suggestedWidth));
            if (!menuItems.isEmpty()) {
                this.layoutOverflowPanelItems(menuItems);
            }
            this.updatePopupSize();
        }

        public void updateMenuItems(List<MenuItem> menuItems, MenuItem.OnMenuItemClickListener menuItemClickListener) {
            this.mMenuItems.clear();
            for (MenuItem menuItem : menuItems) {
                this.mMenuItems.put(MenuItemRepr.of(menuItem), menuItem);
            }
            this.mOnMenuItemClickListener = menuItemClickListener;
        }

        public boolean isLayoutRequired(List<MenuItem> menuItems) {
            return !MenuItemRepr.reprEquals(menuItems, this.mMenuItems.values());
        }

        public void show(Rect contentRectOnScreen) {
            Objects.requireNonNull(contentRectOnScreen);
            if (this.isShowing()) {
                return;
            }
            this.mHidden = false;
            this.mDismissed = false;
            this.cancelDismissAndHideAnimations();
            this.cancelOverflowAnimations();
            this.refreshCoordinatesAndOverflowDirection(contentRectOnScreen);
            this.preparePopupContent();
            this.mPopupWindow.showAtLocation(this.mParent, 0, this.mCoordsOnWindow.x, this.mCoordsOnWindow.y);
            this.setTouchableSurfaceInsetsComputer();
            this.runShowAnimation();
        }

        public void dismiss() {
            if (this.mDismissed) {
                return;
            }
            this.mHidden = false;
            this.mDismissed = true;
            this.mHideAnimation.cancel();
            this.runDismissAnimation();
            this.setZeroTouchableSurface();
        }

        public void hide() {
            if (!this.isShowing()) {
                return;
            }
            this.mHidden = true;
            this.runHideAnimation();
            this.setZeroTouchableSurface();
        }

        public boolean isShowing() {
            return !this.mDismissed && !this.mHidden;
        }

        public boolean isHidden() {
            return this.mHidden;
        }

        public void updateCoordinates(Rect contentRectOnScreen) {
            Objects.requireNonNull(contentRectOnScreen);
            if (!this.isShowing() || !this.mPopupWindow.isShowing()) {
                return;
            }
            this.cancelOverflowAnimations();
            this.refreshCoordinatesAndOverflowDirection(contentRectOnScreen);
            this.preparePopupContent();
            this.mPopupWindow.update(this.mCoordsOnWindow.x, this.mCoordsOnWindow.y, this.mPopupWindow.getWidth(), this.mPopupWindow.getHeight());
        }

        private void refreshCoordinatesAndOverflowDirection(Rect contentRectOnScreen) {
            int y;
            this.refreshViewPort();
            int x = Math.min(contentRectOnScreen.centerX() - this.mPopupWindow.getWidth() / 2, this.mViewPortOnScreen.right - this.mPopupWindow.getWidth());
            int availableHeightAboveContent = contentRectOnScreen.top - this.mViewPortOnScreen.top;
            int availableHeightBelowContent = this.mViewPortOnScreen.bottom - contentRectOnScreen.bottom;
            int margin = 2 * this.mMarginVertical;
            int toolbarHeightWithVerticalMargin = this.mLineHeight + margin;
            if (!this.hasOverflow()) {
                y = availableHeightAboveContent >= toolbarHeightWithVerticalMargin ? contentRectOnScreen.top - toolbarHeightWithVerticalMargin : (availableHeightBelowContent >= toolbarHeightWithVerticalMargin ? contentRectOnScreen.bottom : (availableHeightBelowContent >= this.mLineHeight ? contentRectOnScreen.bottom - this.mMarginVertical : Math.max(this.mViewPortOnScreen.top, contentRectOnScreen.top - toolbarHeightWithVerticalMargin)));
            } else {
                int minimumOverflowHeightWithMargin = this.calculateOverflowHeight(2) + margin;
                int availableHeightThroughContentDown = this.mViewPortOnScreen.bottom - contentRectOnScreen.top + toolbarHeightWithVerticalMargin;
                int availableHeightThroughContentUp = contentRectOnScreen.bottom - this.mViewPortOnScreen.top + toolbarHeightWithVerticalMargin;
                if (availableHeightAboveContent >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightAboveContent - margin);
                    y = contentRectOnScreen.top - this.mPopupWindow.getHeight();
                    this.mOpenOverflowUpwards = true;
                } else if (availableHeightAboveContent >= toolbarHeightWithVerticalMargin && availableHeightThroughContentDown >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightThroughContentDown - margin);
                    y = contentRectOnScreen.top - toolbarHeightWithVerticalMargin;
                    this.mOpenOverflowUpwards = false;
                } else if (availableHeightBelowContent >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightBelowContent - margin);
                    y = contentRectOnScreen.bottom;
                    this.mOpenOverflowUpwards = false;
                } else if (availableHeightBelowContent >= toolbarHeightWithVerticalMargin && this.mViewPortOnScreen.height() >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightThroughContentUp - margin);
                    y = contentRectOnScreen.bottom + toolbarHeightWithVerticalMargin - this.mPopupWindow.getHeight();
                    this.mOpenOverflowUpwards = true;
                } else {
                    this.updateOverflowHeight(this.mViewPortOnScreen.height() - margin);
                    y = this.mViewPortOnScreen.top;
                    this.mOpenOverflowUpwards = false;
                }
            }
            this.mParent.getRootView().getLocationOnScreen(this.mTmpCoords);
            int rootViewLeftOnScreen = this.mTmpCoords[0];
            int rootViewTopOnScreen = this.mTmpCoords[1];
            this.mParent.getRootView().getLocationInWindow(this.mTmpCoords);
            int rootViewLeftOnWindow = this.mTmpCoords[0];
            int rootViewTopOnWindow = this.mTmpCoords[1];
            int windowLeftOnScreen = rootViewLeftOnScreen - rootViewLeftOnWindow;
            int windowTopOnScreen = rootViewTopOnScreen - rootViewTopOnWindow;
            this.mCoordsOnWindow.set(Math.max(0, x - windowLeftOnScreen), Math.max(0, y - windowTopOnScreen));
        }

        private void runShowAnimation() {
            this.mShowAnimation.start();
        }

        private void runDismissAnimation() {
            this.mDismissAnimation.start();
        }

        private void runHideAnimation() {
            this.mHideAnimation.start();
        }

        private void cancelDismissAndHideAnimations() {
            this.mDismissAnimation.cancel();
            this.mHideAnimation.cancel();
        }

        private void cancelOverflowAnimations() {
            this.mContentContainer.clearAnimation();
            this.mMainPanel.animate().cancel();
            this.mOverflowPanel.animate().cancel();
            this.mToArrow.stop();
            this.mToOverflow.stop();
        }

        private void openOverflow() {
            final int targetWidth = this.mOverflowPanelSize.getWidth();
            final int targetHeight = this.mOverflowPanelSize.getHeight();
            final int startWidth = this.mContentContainer.getWidth();
            final int startHeight = this.mContentContainer.getHeight();
            final float startY = this.mContentContainer.getY();
            final float left = this.mContentContainer.getX();
            final float right2 = left + (float)this.mContentContainer.getWidth();
            Animation widthAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    int deltaWidth = (int)(interpolatedTime * (float)(targetWidth - startWidth));
                    FloatingToolbarPopup.setWidth(mContentContainer, startWidth + deltaWidth);
                    if (this.isInRTLMode()) {
                        mContentContainer.setX(left);
                        mMainPanel.setX(0.0f);
                        mOverflowPanel.setX(0.0f);
                    } else {
                        mContentContainer.setX(right2 - (float)mContentContainer.getWidth());
                        mMainPanel.setX(mContentContainer.getWidth() - startWidth);
                        mOverflowPanel.setX(mContentContainer.getWidth() - targetWidth);
                    }
                }
            };
            Animation heightAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    int deltaHeight = (int)(interpolatedTime * (float)(targetHeight - startHeight));
                    FloatingToolbarPopup.setHeight(mContentContainer, startHeight + deltaHeight);
                    if (mOpenOverflowUpwards) {
                        mContentContainer.setY(startY - (float)(mContentContainer.getHeight() - startHeight));
                        this.positionContentYCoordinatesIfOpeningOverflowUpwards();
                    }
                }
            };
            final float overflowButtonStartX = this.mOverflowButton.getX();
            final float overflowButtonTargetX = this.isInRTLMode() ? overflowButtonStartX + (float)targetWidth - (float)this.mOverflowButton.getWidth() : overflowButtonStartX - (float)targetWidth + (float)this.mOverflowButton.getWidth();
            Animation overflowButtonAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    float overflowButtonX = overflowButtonStartX + interpolatedTime * (overflowButtonTargetX - overflowButtonStartX);
                    float deltaContainerWidth = this.isInRTLMode() ? 0.0f : (float)(mContentContainer.getWidth() - startWidth);
                    float actualOverflowButtonX = overflowButtonX + deltaContainerWidth;
                    mOverflowButton.setX(actualOverflowButtonX);
                }
            };
            widthAnimation.setInterpolator(this.mLogAccelerateInterpolator);
            widthAnimation.setDuration(this.getAdjustedDuration(250));
            heightAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
            heightAnimation.setDuration(this.getAdjustedDuration(250));
            overflowButtonAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
            overflowButtonAnimation.setDuration(this.getAdjustedDuration(250));
            this.mOpenOverflowAnimation.getAnimations().clear();
            this.mOpenOverflowAnimation.getAnimations().clear();
            this.mOpenOverflowAnimation.addAnimation(widthAnimation);
            this.mOpenOverflowAnimation.addAnimation(heightAnimation);
            this.mOpenOverflowAnimation.addAnimation(overflowButtonAnimation);
            this.mContentContainer.startAnimation(this.mOpenOverflowAnimation);
            this.mIsOverflowOpen = true;
            this.mMainPanel.animate().alpha(0.0f).withLayer().setInterpolator(this.mLinearOutSlowInInterpolator).setDuration(250L).start();
            this.mOverflowPanel.setAlpha(1.0f);
        }

        private void closeOverflow() {
            final int targetWidth = this.mMainPanelSize.getWidth();
            final int startWidth = this.mContentContainer.getWidth();
            final float left = this.mContentContainer.getX();
            final float right2 = left + (float)this.mContentContainer.getWidth();
            Animation widthAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    int deltaWidth = (int)(interpolatedTime * (float)(targetWidth - startWidth));
                    FloatingToolbarPopup.setWidth(mContentContainer, startWidth + deltaWidth);
                    if (this.isInRTLMode()) {
                        mContentContainer.setX(left);
                        mMainPanel.setX(0.0f);
                        mOverflowPanel.setX(0.0f);
                    } else {
                        mContentContainer.setX(right2 - (float)mContentContainer.getWidth());
                        mMainPanel.setX(mContentContainer.getWidth() - targetWidth);
                        mOverflowPanel.setX(mContentContainer.getWidth() - startWidth);
                    }
                }
            };
            final int targetHeight = this.mMainPanelSize.getHeight();
            final int startHeight = this.mContentContainer.getHeight();
            final float bottom2 = this.mContentContainer.getY() + (float)this.mContentContainer.getHeight();
            Animation heightAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    int deltaHeight = (int)(interpolatedTime * (float)(targetHeight - startHeight));
                    FloatingToolbarPopup.setHeight(mContentContainer, startHeight + deltaHeight);
                    if (mOpenOverflowUpwards) {
                        mContentContainer.setY(bottom2 - (float)mContentContainer.getHeight());
                        this.positionContentYCoordinatesIfOpeningOverflowUpwards();
                    }
                }
            };
            final float overflowButtonStartX = this.mOverflowButton.getX();
            final float overflowButtonTargetX = this.isInRTLMode() ? overflowButtonStartX - (float)startWidth + (float)this.mOverflowButton.getWidth() : overflowButtonStartX + (float)startWidth - (float)this.mOverflowButton.getWidth();
            Animation overflowButtonAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    float overflowButtonX = overflowButtonStartX + interpolatedTime * (overflowButtonTargetX - overflowButtonStartX);
                    float deltaContainerWidth = this.isInRTLMode() ? 0.0f : (float)(mContentContainer.getWidth() - startWidth);
                    float actualOverflowButtonX = overflowButtonX + deltaContainerWidth;
                    mOverflowButton.setX(actualOverflowButtonX);
                }
            };
            widthAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
            widthAnimation.setDuration(this.getAdjustedDuration(250));
            heightAnimation.setInterpolator(this.mLogAccelerateInterpolator);
            heightAnimation.setDuration(this.getAdjustedDuration(250));
            overflowButtonAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
            overflowButtonAnimation.setDuration(this.getAdjustedDuration(250));
            this.mCloseOverflowAnimation.getAnimations().clear();
            this.mCloseOverflowAnimation.addAnimation(widthAnimation);
            this.mCloseOverflowAnimation.addAnimation(heightAnimation);
            this.mCloseOverflowAnimation.addAnimation(overflowButtonAnimation);
            this.mContentContainer.startAnimation(this.mCloseOverflowAnimation);
            this.mIsOverflowOpen = false;
            this.mMainPanel.animate().alpha(1.0f).withLayer().setInterpolator(this.mFastOutLinearInInterpolator).setDuration(100L).start();
            this.mOverflowPanel.animate().alpha(0.0f).withLayer().setInterpolator(this.mLinearOutSlowInInterpolator).setDuration(150L).start();
        }

        private void setPanelsStatesAtRestingPosition() {
            this.mOverflowButton.setEnabled(true);
            this.mOverflowPanel.awakenScrollBars();
            if (this.mIsOverflowOpen) {
                Size containerSize = this.mOverflowPanelSize;
                FloatingToolbarPopup.setSize(this.mContentContainer, containerSize);
                this.mMainPanel.setAlpha(0.0f);
                this.mMainPanel.setVisibility(4);
                this.mOverflowPanel.setAlpha(1.0f);
                this.mOverflowPanel.setVisibility(0);
                this.mOverflowButton.setImageDrawable(this.mArrow);
                this.mOverflowButton.setContentDescription(this.mContext.getString(17040290));
                if (this.isInRTLMode()) {
                    this.mContentContainer.setX(this.mMarginHorizontal);
                    this.mMainPanel.setX(0.0f);
                    this.mOverflowButton.setX(containerSize.getWidth() - this.mOverflowButtonSize.getWidth());
                    this.mOverflowPanel.setX(0.0f);
                } else {
                    this.mContentContainer.setX(this.mPopupWindow.getWidth() - containerSize.getWidth() - this.mMarginHorizontal);
                    this.mMainPanel.setX(-this.mContentContainer.getX());
                    this.mOverflowButton.setX(0.0f);
                    this.mOverflowPanel.setX(0.0f);
                }
                if (this.mOpenOverflowUpwards) {
                    this.mContentContainer.setY(this.mMarginVertical);
                    this.mMainPanel.setY(containerSize.getHeight() - this.mContentContainer.getHeight());
                    this.mOverflowButton.setY(containerSize.getHeight() - this.mOverflowButtonSize.getHeight());
                    this.mOverflowPanel.setY(0.0f);
                } else {
                    this.mContentContainer.setY(this.mMarginVertical);
                    this.mMainPanel.setY(0.0f);
                    this.mOverflowButton.setY(0.0f);
                    this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
                }
            } else {
                Size containerSize = this.mMainPanelSize;
                FloatingToolbarPopup.setSize(this.mContentContainer, containerSize);
                this.mMainPanel.setAlpha(1.0f);
                this.mMainPanel.setVisibility(0);
                this.mOverflowPanel.setAlpha(0.0f);
                this.mOverflowPanel.setVisibility(4);
                this.mOverflowButton.setImageDrawable(this.mOverflow);
                this.mOverflowButton.setContentDescription(this.mContext.getString(17040291));
                if (this.hasOverflow()) {
                    if (this.isInRTLMode()) {
                        this.mContentContainer.setX(this.mMarginHorizontal);
                        this.mMainPanel.setX(0.0f);
                        this.mOverflowButton.setX(0.0f);
                        this.mOverflowPanel.setX(0.0f);
                    } else {
                        this.mContentContainer.setX(this.mPopupWindow.getWidth() - containerSize.getWidth() - this.mMarginHorizontal);
                        this.mMainPanel.setX(0.0f);
                        this.mOverflowButton.setX(containerSize.getWidth() - this.mOverflowButtonSize.getWidth());
                        this.mOverflowPanel.setX(containerSize.getWidth() - this.mOverflowPanelSize.getWidth());
                    }
                    if (this.mOpenOverflowUpwards) {
                        this.mContentContainer.setY(this.mMarginVertical + this.mOverflowPanelSize.getHeight() - containerSize.getHeight());
                        this.mMainPanel.setY(0.0f);
                        this.mOverflowButton.setY(0.0f);
                        this.mOverflowPanel.setY(containerSize.getHeight() - this.mOverflowPanelSize.getHeight());
                    } else {
                        this.mContentContainer.setY(this.mMarginVertical);
                        this.mMainPanel.setY(0.0f);
                        this.mOverflowButton.setY(0.0f);
                        this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
                    }
                } else {
                    this.mContentContainer.setX(this.mMarginHorizontal);
                    this.mContentContainer.setY(this.mMarginVertical);
                    this.mMainPanel.setX(0.0f);
                    this.mMainPanel.setY(0.0f);
                }
            }
        }

        private void updateOverflowHeight(int suggestedHeight) {
            if (this.hasOverflow()) {
                int maxItemSize = (suggestedHeight - this.mOverflowButtonSize.getHeight()) / this.mLineHeight;
                int newHeight = this.calculateOverflowHeight(maxItemSize);
                if (this.mOverflowPanelSize.getHeight() != newHeight) {
                    this.mOverflowPanelSize = new Size(this.mOverflowPanelSize.getWidth(), newHeight);
                }
                FloatingToolbarPopup.setSize(this.mOverflowPanel, this.mOverflowPanelSize);
                if (this.mIsOverflowOpen) {
                    FloatingToolbarPopup.setSize(this.mContentContainer, this.mOverflowPanelSize);
                    if (this.mOpenOverflowUpwards) {
                        int deltaHeight = this.mOverflowPanelSize.getHeight() - newHeight;
                        this.mContentContainer.setY(this.mContentContainer.getY() + (float)deltaHeight);
                        this.mOverflowButton.setY(this.mOverflowButton.getY() - (float)deltaHeight);
                    }
                } else {
                    FloatingToolbarPopup.setSize(this.mContentContainer, this.mMainPanelSize);
                }
                this.updatePopupSize();
            }
        }

        private void updatePopupSize() {
            int width = 0;
            int height = 0;
            if (this.mMainPanelSize != null) {
                width = Math.max(width, this.mMainPanelSize.getWidth());
                height = Math.max(height, this.mMainPanelSize.getHeight());
            }
            if (this.mOverflowPanelSize != null) {
                width = Math.max(width, this.mOverflowPanelSize.getWidth());
                height = Math.max(height, this.mOverflowPanelSize.getHeight());
            }
            this.mPopupWindow.setWidth(width + this.mMarginHorizontal * 2);
            this.mPopupWindow.setHeight(height + this.mMarginVertical * 2);
            this.maybeComputeTransitionDurationScale();
        }

        private void refreshViewPort() {
            this.mParent.getWindowVisibleDisplayFrame(this.mViewPortOnScreen);
        }

        private int getAdjustedToolbarWidth(int suggestedWidth) {
            int width = suggestedWidth;
            this.refreshViewPort();
            int maximumWidth = this.mViewPortOnScreen.width() - 2 * this.mParent.getResources().getDimensionPixelSize(17105211);
            if (width <= 0) {
                width = this.mParent.getResources().getDimensionPixelSize(17105222);
            }
            return Math.min(width, maximumWidth);
        }

        private void setZeroTouchableSurface() {
            this.mTouchableRegion.setEmpty();
        }

        private void setContentAreaAsTouchableSurface() {
            int height;
            int width;
            Objects.requireNonNull(this.mMainPanelSize);
            if (this.mIsOverflowOpen) {
                Objects.requireNonNull(this.mOverflowPanelSize);
                width = this.mOverflowPanelSize.getWidth();
                height = this.mOverflowPanelSize.getHeight();
            } else {
                width = this.mMainPanelSize.getWidth();
                height = this.mMainPanelSize.getHeight();
            }
            this.mTouchableRegion.set((int)this.mContentContainer.getX(), (int)this.mContentContainer.getY(), (int)this.mContentContainer.getX() + width, (int)this.mContentContainer.getY() + height);
        }

        private void setTouchableSurfaceInsetsComputer() {
            ViewTreeObserver viewTreeObserver = this.mPopupWindow.getContentView().getRootView().getViewTreeObserver();
            viewTreeObserver.removeOnComputeInternalInsetsListener(this.mInsetsComputer);
            viewTreeObserver.addOnComputeInternalInsetsListener(this.mInsetsComputer);
        }

        private boolean isInRTLMode() {
            return this.mContext.getApplicationInfo().hasRtlSupport() && this.mContext.getResources().getConfiguration().getLayoutDirection() == 1;
        }

        private boolean hasOverflow() {
            return this.mOverflowPanelSize != null;
        }

        public List<MenuItem> layoutMainPanelItems(List<MenuItem> menuItems, int toolbarWidth) {
            Objects.requireNonNull(menuItems);
            int availableWidth = toolbarWidth;
            LinkedList<MenuItem> remainingMenuItems = new LinkedList<MenuItem>();
            LinkedList<MenuItem> overflowMenuItems = new LinkedList<MenuItem>();
            for (MenuItem menuItem : menuItems) {
                if (menuItem.getItemId() != 16908353 && menuItem.requiresOverflow()) {
                    overflowMenuItems.add(menuItem);
                    continue;
                }
                remainingMenuItems.add(menuItem);
            }
            remainingMenuItems.addAll(overflowMenuItems);
            this.mMainPanel.removeAllViews();
            this.mMainPanel.setPaddingRelative(0, 0, 0, 0);
            int lastGroupId = -1;
            boolean isFirstItem = true;
            while (!remainingMenuItems.isEmpty()) {
                boolean canFitNoOverflow;
                boolean isLastItem;
                MenuItem menuItem = (MenuItem)remainingMenuItems.peek();
                if (!isFirstItem && menuItem.requiresOverflow()) break;
                boolean showIcon = isFirstItem && menuItem.getItemId() == 16908353;
                View menuItemButton = FloatingToolbar.createMenuItemButton(this.mContext, menuItem, this.mIconTextSpacing, showIcon);
                if (!showIcon && menuItemButton instanceof LinearLayout) {
                    ((LinearLayout)menuItemButton).setGravity(17);
                }
                if (isFirstItem) {
                    menuItemButton.setPaddingRelative((int)(1.5 * (double)menuItemButton.getPaddingStart()), menuItemButton.getPaddingTop(), menuItemButton.getPaddingEnd(), menuItemButton.getPaddingBottom());
                }
                boolean bl = isLastItem = remainingMenuItems.size() == 1;
                if (isLastItem) {
                    menuItemButton.setPaddingRelative(menuItemButton.getPaddingStart(), menuItemButton.getPaddingTop(), (int)(1.5 * (double)menuItemButton.getPaddingEnd()), menuItemButton.getPaddingBottom());
                }
                menuItemButton.measure(0, 0);
                int menuItemButtonWidth = Math.min(menuItemButton.getMeasuredWidth(), toolbarWidth);
                boolean canFitWithOverflow = menuItemButtonWidth <= availableWidth - this.mOverflowButtonSize.getWidth();
                boolean bl2 = canFitNoOverflow = isLastItem && menuItemButtonWidth <= availableWidth;
                if (!canFitWithOverflow && !canFitNoOverflow) break;
                this.setButtonTagAndClickListener(menuItemButton, menuItem);
                menuItemButton.setTooltipText(menuItem.getTooltipText());
                this.mMainPanel.addView(menuItemButton);
                ViewGroup.LayoutParams params = menuItemButton.getLayoutParams();
                params.width = menuItemButtonWidth;
                menuItemButton.setLayoutParams(params);
                availableWidth -= menuItemButtonWidth;
                remainingMenuItems.pop();
                lastGroupId = menuItem.getGroupId();
                isFirstItem = false;
            }
            if (!remainingMenuItems.isEmpty()) {
                this.mMainPanel.setPaddingRelative(0, 0, this.mOverflowButtonSize.getWidth(), 0);
            }
            this.mMainPanelSize = FloatingToolbarPopup.measure(this.mMainPanel);
            return remainingMenuItems;
        }

        private void layoutOverflowPanelItems(List<MenuItem> menuItems) {
            ArrayAdapter overflowPanelAdapter = (ArrayAdapter)this.mOverflowPanel.getAdapter();
            overflowPanelAdapter.clear();
            int size = menuItems.size();
            for (int i = 0; i < size; ++i) {
                overflowPanelAdapter.add(menuItems.get(i));
            }
            this.mOverflowPanel.setAdapter(overflowPanelAdapter);
            if (this.mOpenOverflowUpwards) {
                this.mOverflowPanel.setY(0.0f);
            } else {
                this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
            }
            int width = Math.max(this.getOverflowWidth(), this.mOverflowButtonSize.getWidth());
            int height = this.calculateOverflowHeight(4);
            this.mOverflowPanelSize = new Size(width, height);
            FloatingToolbarPopup.setSize(this.mOverflowPanel, this.mOverflowPanelSize);
        }

        private void preparePopupContent() {
            this.mContentContainer.removeAllViews();
            if (this.hasOverflow()) {
                this.mContentContainer.addView(this.mOverflowPanel);
            }
            this.mContentContainer.addView(this.mMainPanel);
            if (this.hasOverflow()) {
                this.mContentContainer.addView(this.mOverflowButton);
            }
            this.setPanelsStatesAtRestingPosition();
            this.setContentAreaAsTouchableSurface();
            if (this.isInRTLMode()) {
                this.mContentContainer.setAlpha(0.0f);
                this.mContentContainer.post(this.mPreparePopupContentRTLHelper);
            }
        }

        private void clearPanels() {
            this.mOverflowPanelSize = null;
            this.mMainPanelSize = null;
            this.mIsOverflowOpen = false;
            this.mMainPanel.removeAllViews();
            ArrayAdapter overflowPanelAdapter = (ArrayAdapter)this.mOverflowPanel.getAdapter();
            overflowPanelAdapter.clear();
            this.mOverflowPanel.setAdapter(overflowPanelAdapter);
            this.mContentContainer.removeAllViews();
        }

        private void positionContentYCoordinatesIfOpeningOverflowUpwards() {
            if (this.mOpenOverflowUpwards) {
                this.mMainPanel.setY(this.mContentContainer.getHeight() - this.mMainPanelSize.getHeight());
                this.mOverflowButton.setY(this.mContentContainer.getHeight() - this.mOverflowButton.getHeight());
                this.mOverflowPanel.setY(this.mContentContainer.getHeight() - this.mOverflowPanelSize.getHeight());
            }
        }

        private int getOverflowWidth() {
            int overflowWidth = 0;
            int count = this.mOverflowPanel.getAdapter().getCount();
            for (int i = 0; i < count; ++i) {
                MenuItem menuItem = (MenuItem)this.mOverflowPanel.getAdapter().getItem(i);
                overflowWidth = Math.max(this.mOverflowPanelViewHelper.calculateWidth(menuItem), overflowWidth);
            }
            return overflowWidth;
        }

        private int calculateOverflowHeight(int maxItemSize) {
            int actualSize = Math.min(4, Math.min(Math.max(2, maxItemSize), this.mOverflowPanel.getCount()));
            int extension = 0;
            if (actualSize < this.mOverflowPanel.getCount()) {
                extension = (int)((float)this.mLineHeight * 0.5f);
            }
            return actualSize * this.mLineHeight + this.mOverflowButtonSize.getHeight() + extension;
        }

        private void setButtonTagAndClickListener(View menuItemButton, MenuItem menuItem) {
            menuItemButton.setTag(MenuItemRepr.of(menuItem));
            menuItemButton.setOnClickListener(this.mMenuItemButtonOnClickListener);
        }

        private int getAdjustedDuration(int originalDuration) {
            if (this.mTransitionDurationScale < 150) {
                return Math.max(originalDuration - 50, 0);
            }
            if (this.mTransitionDurationScale > 300) {
                return originalDuration + 50;
            }
            return (int)((float)originalDuration * ValueAnimator.getDurationScale());
        }

        private void maybeComputeTransitionDurationScale() {
            if (this.mMainPanelSize != null && this.mOverflowPanelSize != null) {
                int w = this.mMainPanelSize.getWidth() - this.mOverflowPanelSize.getWidth();
                int h = this.mOverflowPanelSize.getHeight() - this.mMainPanelSize.getHeight();
                this.mTransitionDurationScale = (int)(Math.sqrt(w * w + h * h) / (double)this.mContentContainer.getContext().getResources().getDisplayMetrics().density);
            }
        }

        private ViewGroup createMainPanel() {
            LinearLayout mainPanel = new LinearLayout(this.mContext){

                @Override
                protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    if (this.isOverflowAnimating()) {
                        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(mMainPanelSize.getWidth(), 0x40000000);
                    }
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                }

                @Override
                public boolean onInterceptTouchEvent(MotionEvent ev) {
                    return this.isOverflowAnimating();
                }
            };
            return mainPanel;
        }

        private ImageButton createOverflowButton() {
            ImageButton overflowButton = (ImageButton)LayoutInflater.from(this.mContext).inflate(17367163, null);
            overflowButton.setImageDrawable(this.mOverflow);
            overflowButton.setOnClickListener(v -> {
                if (this.mIsOverflowOpen) {
                    overflowButton.setImageDrawable(this.mToOverflow);
                    this.mToOverflow.start();
                    this.closeOverflow();
                } else {
                    overflowButton.setImageDrawable(this.mToArrow);
                    this.mToArrow.start();
                    this.openOverflow();
                }
            });
            return overflowButton;
        }

        private OverflowPanel createOverflowPanel() {
            OverflowPanel overflowPanel = new OverflowPanel(this);
            overflowPanel.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            overflowPanel.setDivider(null);
            overflowPanel.setDividerHeight(0);
            ArrayAdapter<MenuItem> adapter = new ArrayAdapter<MenuItem>(this.mContext, 0){

                @Override
                public View getView(int position, View convertView, ViewGroup parent) {
                    return mOverflowPanelViewHelper.getView((MenuItem)this.getItem(position), mOverflowPanelSize.getWidth(), convertView);
                }
            };
            overflowPanel.setAdapter(adapter);
            overflowPanel.setOnItemClickListener((parent, view, position, id2) -> {
                MenuItem menuItem = (MenuItem)overflowPanel.getAdapter().getItem(position);
                if (this.mOnMenuItemClickListener != null) {
                    this.mOnMenuItemClickListener.onMenuItemClick(menuItem);
                }
            });
            return overflowPanel;
        }

        private boolean isOverflowAnimating() {
            boolean overflowOpening = this.mOpenOverflowAnimation.hasStarted() && !this.mOpenOverflowAnimation.hasEnded();
            boolean overflowClosing = this.mCloseOverflowAnimation.hasStarted() && !this.mCloseOverflowAnimation.hasEnded();
            return overflowOpening || overflowClosing;
        }

        private Animation.AnimationListener createOverflowAnimationListener() {
            Animation.AnimationListener listener2 = new Animation.AnimationListener(){

                @Override
                public void onAnimationStart(Animation animation) {
                    mOverflowButton.setEnabled(false);
                    mMainPanel.setVisibility(0);
                    mOverflowPanel.setVisibility(0);
                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    mContentContainer.post(() -> {
                        this.setPanelsStatesAtRestingPosition();
                        this.setContentAreaAsTouchableSurface();
                    });
                }

                @Override
                public void onAnimationRepeat(Animation animation) {
                }
            };
            return listener2;
        }

        private static Size measure(View view) {
            Preconditions.checkState(view.getParent() == null);
            view.measure(0, 0);
            return new Size(view.getMeasuredWidth(), view.getMeasuredHeight());
        }

        private static void setSize(View view, int width, int height) {
            view.setMinimumWidth(width);
            view.setMinimumHeight(height);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            params = params == null ? new ViewGroup.LayoutParams(0, 0) : params;
            params.width = width;
            params.height = height;
            view.setLayoutParams(params);
        }

        private static void setSize(View view, Size size) {
            FloatingToolbarPopup.setSize(view, size.getWidth(), size.getHeight());
        }

        private static void setWidth(View view, int width) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            FloatingToolbarPopup.setSize(view, width, params.height);
        }

        private static void setHeight(View view, int height) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            FloatingToolbarPopup.setSize(view, params.width, height);
        }

        private static class OverflowPanelViewHelper {
            private final View mCalculator;
            private final int mIconTextSpacing;
            private final int mSidePadding;
            private final Context mContext;

            public OverflowPanelViewHelper(Context context, int iconTextSpacing) {
                this.mContext = Objects.requireNonNull(context);
                this.mIconTextSpacing = iconTextSpacing;
                this.mSidePadding = context.getResources().getDimensionPixelSize(17105221);
                this.mCalculator = this.createMenuButton(null);
            }

            public View getView(MenuItem menuItem, int minimumWidth, View convertView) {
                Objects.requireNonNull(menuItem);
                if (convertView != null) {
                    FloatingToolbar.updateMenuItemButton(convertView, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
                } else {
                    convertView = this.createMenuButton(menuItem);
                }
                convertView.setMinimumWidth(minimumWidth);
                return convertView;
            }

            public int calculateWidth(MenuItem menuItem) {
                FloatingToolbar.updateMenuItemButton(this.mCalculator, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
                this.mCalculator.measure(0, 0);
                return this.mCalculator.getMeasuredWidth();
            }

            private View createMenuButton(MenuItem menuItem) {
                View button = FloatingToolbar.createMenuItemButton(this.mContext, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
                button.setPadding(this.mSidePadding, 0, this.mSidePadding, 0);
                return button;
            }

            private boolean shouldShowIcon(MenuItem menuItem) {
                if (menuItem != null) {
                    return menuItem.getGroupId() == 16908353;
                }
                return false;
            }
        }

        private static class LogAccelerateInterpolator
        implements Interpolator {
            private static final int BASE = 100;
            private static final float LOGS_SCALE = 1.0f / LogAccelerateInterpolator.computeLog(1.0f, 100);

            private LogAccelerateInterpolator() {
            }

            private static float computeLog(float t, int base) {
                return (float)(1.0 - Math.pow(base, -t));
            }

            @Override
            public float getInterpolation(float t) {
                return 1.0f - LogAccelerateInterpolator.computeLog(1.0f - t, 100) * LOGS_SCALE;
            }
        }

        private static class OverflowPanel
        extends ListView {
            private final FloatingToolbarPopup mPopup;

            OverflowPanel(FloatingToolbarPopup popup2) {
                super(Objects.requireNonNull(popup2).mContext);
                this.mPopup = popup2;
                this.setScrollBarDefaultDelayBeforeFade(ViewConfiguration.getScrollDefaultDelay() * 3);
                this.setScrollIndicators(3);
            }

            @Override
            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                int height = this.mPopup.mOverflowPanelSize.getHeight() - this.mPopup.mOverflowButtonSize.getHeight();
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }

            @Override
            public boolean dispatchTouchEvent(MotionEvent ev) {
                if (this.mPopup.isOverflowAnimating()) {
                    return true;
                }
                return super.dispatchTouchEvent(ev);
            }

            @Override
            protected boolean awakenScrollBars() {
                return super.awakenScrollBars();
            }
        }
    }
}

