/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.IntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;

public abstract class ExploreByTouchHelper
extends View.AccessibilityDelegate {
    public static final int INVALID_ID = Integer.MIN_VALUE;
    public static final int HOST_ID = -1;
    private static final String DEFAULT_CLASS_NAME = View.class.getName();
    private static final Rect INVALID_PARENT_BOUNDS = new Rect(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    private Rect mTempScreenRect;
    private Rect mTempParentRect;
    private int[] mTempGlobalRect;
    private Rect mTempVisibleRect;
    private IntArray mTempArray;
    private final AccessibilityManager mManager;
    private final View mView;
    private final Context mContext;
    private ExploreByTouchNodeProvider mNodeProvider;
    private int mFocusedVirtualViewId = Integer.MIN_VALUE;
    private int mHoveredVirtualViewId = Integer.MIN_VALUE;

    public ExploreByTouchHelper(View forView) {
        if (forView == null) {
            throw new IllegalArgumentException("View may not be null");
        }
        this.mView = forView;
        this.mContext = forView.getContext();
        this.mManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
    }

    @Override
    public AccessibilityNodeProvider getAccessibilityNodeProvider(View host) {
        if (this.mNodeProvider == null) {
            this.mNodeProvider = new ExploreByTouchNodeProvider();
        }
        return this.mNodeProvider;
    }

    public boolean dispatchHoverEvent(MotionEvent event) {
        if (!this.mManager.isEnabled() || !this.mManager.isTouchExplorationEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 7: 
            case 9: {
                int virtualViewId = this.getVirtualViewAt(event.getX(), event.getY());
                this.updateHoveredVirtualView(virtualViewId);
                return virtualViewId != Integer.MIN_VALUE;
            }
            case 10: {
                if (this.mHoveredVirtualViewId != Integer.MIN_VALUE) {
                    this.updateHoveredVirtualView(Integer.MIN_VALUE);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean sendEventForVirtualView(int virtualViewId, int eventType) {
        if (virtualViewId == Integer.MIN_VALUE || !this.mManager.isEnabled()) {
            return false;
        }
        ViewParent parent = this.mView.getParent();
        if (parent == null) {
            return false;
        }
        AccessibilityEvent event = this.createEvent(virtualViewId, eventType);
        return parent.requestSendAccessibilityEvent(this.mView, event);
    }

    public void invalidateRoot() {
        this.invalidateVirtualView(-1, 1);
    }

    public void invalidateVirtualView(int virtualViewId) {
        this.invalidateVirtualView(virtualViewId, 0);
    }

    public void invalidateVirtualView(int virtualViewId, int changeTypes) {
        ViewParent parent;
        if (virtualViewId != Integer.MIN_VALUE && this.mManager.isEnabled() && (parent = this.mView.getParent()) != null) {
            AccessibilityEvent event = this.createEvent(virtualViewId, 2048);
            event.setContentChangeTypes(changeTypes);
            parent.requestSendAccessibilityEvent(this.mView, event);
        }
    }

    public int getFocusedVirtualView() {
        return this.mFocusedVirtualViewId;
    }

    private void updateHoveredVirtualView(int virtualViewId) {
        if (this.mHoveredVirtualViewId == virtualViewId) {
            return;
        }
        int previousVirtualViewId = this.mHoveredVirtualViewId;
        this.mHoveredVirtualViewId = virtualViewId;
        this.sendEventForVirtualView(virtualViewId, 128);
        this.sendEventForVirtualView(previousVirtualViewId, 256);
    }

    private AccessibilityEvent createEvent(int virtualViewId, int eventType) {
        switch (virtualViewId) {
            case -1: {
                return this.createEventForHost(eventType);
            }
        }
        return this.createEventForChild(virtualViewId, eventType);
    }

    private AccessibilityEvent createEventForHost(int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
        this.mView.onInitializeAccessibilityEvent(event);
        this.onPopulateEventForHost(event);
        return event;
    }

    private AccessibilityEvent createEventForChild(int virtualViewId, int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
        event.setEnabled(true);
        event.setClassName(DEFAULT_CLASS_NAME);
        this.onPopulateEventForVirtualView(virtualViewId, event);
        if (event.getText().isEmpty() && event.getContentDescription() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateEventForVirtualViewId()");
        }
        event.setPackageName(this.mView.getContext().getPackageName());
        event.setSource(this.mView, virtualViewId);
        return event;
    }

    private AccessibilityNodeInfo createNode(int virtualViewId) {
        switch (virtualViewId) {
            case -1: {
                return this.createNodeForHost();
            }
        }
        return this.createNodeForChild(virtualViewId);
    }

    private AccessibilityNodeInfo createNodeForHost() {
        AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain(this.mView);
        this.mView.onInitializeAccessibilityNodeInfo(node);
        int realNodeCount = node.getChildCount();
        this.onPopulateNodeForHost(node);
        if (this.mTempArray == null) {
            this.mTempArray = new IntArray();
        } else {
            this.mTempArray.clear();
        }
        IntArray virtualViewIds = this.mTempArray;
        this.getVisibleVirtualViews(virtualViewIds);
        if (realNodeCount > 0 && virtualViewIds.size() > 0) {
            throw new RuntimeException("Views cannot have both real and virtual children");
        }
        int N = virtualViewIds.size();
        for (int i = 0; i < N; ++i) {
            node.addChild(this.mView, virtualViewIds.get(i));
        }
        return node;
    }

    private AccessibilityNodeInfo createNodeForChild(int virtualViewId) {
        this.ensureTempRects();
        Rect tempParentRect = this.mTempParentRect;
        int[] tempGlobalRect = this.mTempGlobalRect;
        Rect tempScreenRect = this.mTempScreenRect;
        AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain();
        node.setEnabled(true);
        node.setClassName(DEFAULT_CLASS_NAME);
        node.setBoundsInParent(INVALID_PARENT_BOUNDS);
        this.onPopulateNodeForVirtualView(virtualViewId, node);
        if (node.getText() == null && node.getContentDescription() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateNodeForVirtualViewId()");
        }
        node.getBoundsInParent(tempParentRect);
        if (tempParentRect.equals(INVALID_PARENT_BOUNDS)) {
            throw new RuntimeException("Callbacks must set parent bounds in populateNodeForVirtualViewId()");
        }
        int actions2 = node.getActions();
        if ((actions2 & 0x40) != 0) {
            throw new RuntimeException("Callbacks must not add ACTION_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
        }
        if ((actions2 & 0x80) != 0) {
            throw new RuntimeException("Callbacks must not add ACTION_CLEAR_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
        }
        node.setPackageName(this.mView.getContext().getPackageName());
        node.setSource(this.mView, virtualViewId);
        node.setParent(this.mView);
        if (this.mFocusedVirtualViewId == virtualViewId) {
            node.setAccessibilityFocused(true);
            node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLEAR_ACCESSIBILITY_FOCUS);
        } else {
            node.setAccessibilityFocused(false);
            node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_ACCESSIBILITY_FOCUS);
        }
        if (this.intersectVisibleToUser(tempParentRect)) {
            node.setVisibleToUser(true);
            node.setBoundsInParent(tempParentRect);
        }
        this.mView.getLocationOnScreen(tempGlobalRect);
        int offsetX = tempGlobalRect[0];
        int offsetY = tempGlobalRect[1];
        tempScreenRect.set(tempParentRect);
        tempScreenRect.offset(offsetX, offsetY);
        node.setBoundsInScreen(tempScreenRect);
        return node;
    }

    private void ensureTempRects() {
        this.mTempGlobalRect = new int[2];
        this.mTempParentRect = new Rect();
        this.mTempScreenRect = new Rect();
    }

    private boolean performAction(int virtualViewId, int action2, Bundle arguments) {
        switch (virtualViewId) {
            case -1: {
                return this.performActionForHost(action2, arguments);
            }
        }
        return this.performActionForChild(virtualViewId, action2, arguments);
    }

    private boolean performActionForHost(int action2, Bundle arguments) {
        return this.mView.performAccessibilityAction(action2, arguments);
    }

    private boolean performActionForChild(int virtualViewId, int action2, Bundle arguments) {
        switch (action2) {
            case 64: 
            case 128: {
                return this.manageFocusForChild(virtualViewId, action2);
            }
        }
        return this.onPerformActionForVirtualView(virtualViewId, action2, arguments);
    }

    private boolean manageFocusForChild(int virtualViewId, int action2) {
        switch (action2) {
            case 64: {
                return this.requestAccessibilityFocus(virtualViewId);
            }
            case 128: {
                return this.clearAccessibilityFocus(virtualViewId);
            }
        }
        return false;
    }

    private boolean intersectVisibleToUser(Rect localRect) {
        Rect tempVisibleRect;
        if (localRect == null || localRect.isEmpty()) {
            return false;
        }
        if (this.mView.getWindowVisibility() != 0) {
            return false;
        }
        ViewParent viewParent = this.mView.getParent();
        while (viewParent instanceof View) {
            View view = (View)((Object)viewParent);
            if (view.getAlpha() <= 0.0f || view.getVisibility() != 0) {
                return false;
            }
            viewParent = view.getParent();
        }
        if (viewParent == null) {
            return false;
        }
        if (this.mTempVisibleRect == null) {
            this.mTempVisibleRect = new Rect();
        }
        if (!this.mView.getLocalVisibleRect(tempVisibleRect = this.mTempVisibleRect)) {
            return false;
        }
        return localRect.intersect(tempVisibleRect);
    }

    private boolean isAccessibilityFocused(int virtualViewId) {
        return this.mFocusedVirtualViewId == virtualViewId;
    }

    private boolean requestAccessibilityFocus(int virtualViewId) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        if (!this.mManager.isEnabled() || !accessibilityManager.isTouchExplorationEnabled()) {
            return false;
        }
        if (!this.isAccessibilityFocused(virtualViewId)) {
            if (this.mFocusedVirtualViewId != Integer.MIN_VALUE) {
                this.sendEventForVirtualView(this.mFocusedVirtualViewId, 65536);
            }
            this.mFocusedVirtualViewId = virtualViewId;
            this.mView.invalidate();
            this.sendEventForVirtualView(virtualViewId, 32768);
            return true;
        }
        return false;
    }

    private boolean clearAccessibilityFocus(int virtualViewId) {
        if (this.isAccessibilityFocused(virtualViewId)) {
            this.mFocusedVirtualViewId = Integer.MIN_VALUE;
            this.mView.invalidate();
            this.sendEventForVirtualView(virtualViewId, 65536);
            return true;
        }
        return false;
    }

    protected abstract int getVirtualViewAt(float var1, float var2);

    protected abstract void getVisibleVirtualViews(IntArray var1);

    protected abstract void onPopulateEventForVirtualView(int var1, AccessibilityEvent var2);

    protected void onPopulateEventForHost(AccessibilityEvent event) {
    }

    protected abstract void onPopulateNodeForVirtualView(int var1, AccessibilityNodeInfo var2);

    protected void onPopulateNodeForHost(AccessibilityNodeInfo node) {
    }

    protected abstract boolean onPerformActionForVirtualView(int var1, int var2, Bundle var3);

    private class ExploreByTouchNodeProvider
    extends AccessibilityNodeProvider {
        private ExploreByTouchNodeProvider() {
        }

        @Override
        public AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
            return ExploreByTouchHelper.this.createNode(virtualViewId);
        }

        @Override
        public boolean performAction(int virtualViewId, int action2, Bundle arguments) {
            return ExploreByTouchHelper.this.performAction(virtualViewId, action2, arguments);
        }
    }
}

