/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.widget.ColoredIconHelper;
import java.util.Objects;
import java.util.function.Consumer;

@RemoteViews.RemoteView
public class CachingIconView
extends ImageView {
    private String mLastPackage;
    private int mLastResId;
    private boolean mInternalSetDrawable;
    private boolean mForceHidden;
    private int mDesiredVisibility;
    private Consumer<Integer> mOnVisibilityChangedListener;
    private Consumer<Boolean> mOnForceHiddenChangedListener;
    private int mIconColor;
    private int mBackgroundColor;
    private boolean mWillBeForceHidden;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public CachingIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(Icon icon2) {
        if (!this.testAndSetCache(icon2)) {
            this.mInternalSetDrawable = true;
            super.setImageIcon(icon2);
            this.mInternalSetDrawable = false;
        }
    }

    @Override
    public Runnable setImageIconAsync(Icon icon2) {
        this.resetCache();
        return super.setImageIconAsync(icon2);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageResourceAsync")
    public void setImageResource(int resId) {
        if (!this.testAndSetCache(resId)) {
            this.mInternalSetDrawable = true;
            super.setImageResource(resId);
            this.mInternalSetDrawable = false;
        }
    }

    @Override
    public Runnable setImageResourceAsync(int resId) {
        this.resetCache();
        return super.setImageResourceAsync(resId);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageURIAsync")
    public void setImageURI(Uri uri) {
        this.resetCache();
        super.setImageURI(uri);
    }

    @Override
    public Runnable setImageURIAsync(Uri uri) {
        this.resetCache();
        return super.setImageURIAsync(uri);
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        if (!this.mInternalSetDrawable) {
            this.resetCache();
        }
        super.setImageDrawable(drawable2);
    }

    @Override
    @RemotableViewMethod
    public void setImageBitmap(Bitmap bm) {
        this.resetCache();
        super.setImageBitmap(bm);
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resetCache();
    }

    private synchronized boolean testAndSetCache(Icon icon2) {
        if (icon2 != null && icon2.getType() == 2) {
            String iconPackage = this.normalizeIconPackage(icon2);
            boolean isCached = this.mLastResId != 0 && icon2.getResId() == this.mLastResId && Objects.equals(iconPackage, this.mLastPackage);
            this.mLastPackage = iconPackage;
            this.mLastResId = icon2.getResId();
            return isCached;
        }
        this.resetCache();
        return false;
    }

    private synchronized boolean testAndSetCache(int resId) {
        boolean isCached = resId == 0 || this.mLastResId == 0 ? false : resId == this.mLastResId && null == this.mLastPackage;
        this.mLastPackage = null;
        this.mLastResId = resId;
        return isCached;
    }

    private String normalizeIconPackage(Icon icon2) {
        if (icon2 == null) {
            return null;
        }
        String pkg = icon2.getResPackage();
        if (TextUtils.isEmpty(pkg)) {
            return null;
        }
        if (pkg.equals(this.mContext.getPackageName())) {
            return null;
        }
        return pkg;
    }

    private synchronized void resetCache() {
        this.mLastResId = 0;
        this.mLastPackage = null;
    }

    public void setForceHidden(boolean forceHidden) {
        if (forceHidden != this.mForceHidden) {
            this.mForceHidden = forceHidden;
            this.mWillBeForceHidden = false;
            this.updateVisibility();
            if (this.mOnForceHiddenChangedListener != null) {
                this.mOnForceHiddenChangedListener.accept(forceHidden);
            }
        }
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int visibility) {
        this.mDesiredVisibility = visibility;
        this.updateVisibility();
    }

    private void updateVisibility() {
        int visibility;
        int n = visibility = this.mDesiredVisibility == 0 && this.mForceHidden ? 4 : this.mDesiredVisibility;
        if (this.mOnVisibilityChangedListener != null) {
            this.mOnVisibilityChangedListener.accept(visibility);
        }
        super.setVisibility(visibility);
    }

    public void setOnVisibilityChangedListener(Consumer<Integer> listener2) {
        this.mOnVisibilityChangedListener = listener2;
    }

    public void setOnForceHiddenChangedListener(Consumer<Boolean> listener2) {
        this.mOnForceHiddenChangedListener = listener2;
    }

    public boolean isForceHidden() {
        return this.mForceHidden;
    }

    @Override
    @RemotableViewMethod
    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
    }

    @RemotableViewMethod
    public void setOriginalIconColor(int color2) {
        boolean hasColor;
        this.mIconColor = color2;
        Drawable background = this.getBackground();
        Drawable icon2 = this.getDrawable();
        boolean bl = hasColor = color2 != 1;
        if (background == null) {
            if (hasColor && icon2 != null) {
                icon2.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
            }
        } else if (hasColor) {
            background.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
            if (icon2 != null) {
                icon2.mutate().setColorFilter(this.mBackgroundColor, PorterDuff.Mode.SRC_ATOP);
            }
        } else {
            background.mutate().setColorFilter(this.mBackgroundColor, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void setGrayedOut(boolean grayedOut) {
        Drawable drawable2 = this.getBackground();
        if (drawable2 == null) {
            drawable2 = this.getDrawable();
        }
        ColoredIconHelper.applyGrayTint(this.mContext, drawable2, grayedOut, this.mIconColor);
    }

    public int getOriginalIconColor() {
        return this.mIconColor;
    }

    public boolean willBeForceHidden() {
        return this.mWillBeForceHidden;
    }

    public void setWillBeForceHidden(boolean forceHidden) {
        this.mWillBeForceHidden = forceHidden;
    }
}

