/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.internal.widget.AccountItemView;
import java.util.List;

public class AccountViewAdapter
extends BaseAdapter {
    private List<AccountElements> mData;
    private Context mContext;

    public AccountViewAdapter(Context context, List<AccountElements> data) {
        this.mContext = context;
        this.mData = data;
    }

    @Override
    public int getCount() {
        return this.mData.size();
    }

    @Override
    public Object getItem(int position) {
        return this.mData.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public void updateData(List<AccountElements> data) {
        this.mData = data;
        this.notifyDataSetChanged();
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        AccountItemView view = convertView == null ? new AccountItemView(this.mContext) : (AccountItemView)convertView;
        AccountElements elements = (AccountElements)this.getItem(position);
        view.setViewItem(elements);
        return view;
    }

    public static class AccountElements {
        private int mIcon;
        private Drawable mDrawable;
        private String mName;
        private String mNumber;

        public AccountElements(int icon2, String name, String number) {
            this(icon2, null, name, number);
        }

        public AccountElements(Drawable drawable2, String name, String number) {
            this(0, drawable2, name, number);
        }

        private AccountElements(int icon2, Drawable drawable2, String name, String number) {
            this.mIcon = icon2;
            this.mDrawable = drawable2;
            this.mName = name;
            this.mNumber = number;
        }

        public int getIcon() {
            return this.mIcon;
        }

        public String getName() {
            return this.mName;
        }

        public String getNumber() {
            return this.mNumber;
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }
    }
}

