/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.inline;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.util.Slog;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.autofill.Helper;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.inline.InlineContentView;
import java.io.PrintWriter;

public class InlineTooltipUi
extends PopupWindow
implements AutoCloseable {
    private static final String TAG = "InlineTooltipUi";
    private final WindowManager mWm;
    private final ViewGroup mContentContainer;
    private boolean mShowing;
    private WindowManager.LayoutParams mWindowLayoutParams;
    private final View.OnAttachStateChangeListener mAnchorOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){

        @Override
        public void onViewAttachedToWindow(View v) {
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            InlineTooltipUi.this.dismiss();
        }
    };
    private final View.OnLayoutChangeListener mAnchoredOnLayoutChangeListener = new View.OnLayoutChangeListener(){
        int mHeight;

        @Override
        public void onLayoutChange(View v, int left, int top, int right2, int bottom2, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (this.mHeight != bottom2 - top) {
                this.mHeight = bottom2 - top;
                InlineTooltipUi.this.adjustPosition();
            }
        }
    };

    public InlineTooltipUi(Context context) {
        this.mContentContainer = new LinearLayout(new ContextWrapper(context));
        this.mWm = context.getSystemService(WindowManager.class);
        this.setTouchModal(false);
        this.setOutsideTouchable(true);
        this.setInputMethodMode(2);
        this.setFocusable(false);
    }

    public void setTooltipView(InlineContentView v) {
        this.mContentContainer.removeAllViews();
        this.mContentContainer.addView(v);
        this.mContentContainer.setVisibility(0);
    }

    @Override
    public void close() {
        this.hide();
    }

    @Override
    protected boolean hasContentView() {
        return true;
    }

    @Override
    protected boolean hasDecorView() {
        return true;
    }

    @Override
    protected WindowManager.LayoutParams getDecorViewLayoutParams() {
        return this.mWindowLayoutParams;
    }

    public void update(View anchor) {
        int offsetY;
        this.setWindowLayoutType(1005);
        int achoredHeight = this.mContentContainer.getHeight();
        int n = offsetY = achoredHeight == 0 ? -anchor.getHeight() << 1 : -anchor.getHeight() - achoredHeight;
        if (!this.isShowing()) {
            this.setWidth(-2);
            this.setHeight(-2);
            this.showAsDropDown(anchor, 0, offsetY, 49);
        } else {
            this.update(anchor, 0, offsetY, -2, -2);
        }
    }

    @Override
    protected void update(View anchor, WindowManager.LayoutParams params) {
        if (anchor.isVisibleToUser()) {
            this.show(params);
        } else {
            this.hide();
        }
    }

    @Override
    public void showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        if (this.isShowing()) {
            return;
        }
        this.setShowing(true);
        this.setDropDown(true);
        this.attachToAnchor(anchor, xoff, yoff, gravity);
        WindowManager.LayoutParams p = this.mWindowLayoutParams = this.createPopupLayoutParams(anchor.getWindowToken());
        boolean aboveAnchor = this.findDropDownPosition(anchor, p, xoff, yoff, p.width, p.height, gravity, this.getAllowScrollingAnchorParent());
        this.updateAboveAnchor(aboveAnchor);
        p.accessibilityIdOfAnchor = anchor.getAccessibilityViewId();
        p.packageName = anchor.getContext().getPackageName();
        this.show(p);
    }

    @Override
    protected void attachToAnchor(View anchor, int xoff, int yoff, int gravity) {
        super.attachToAnchor(anchor, xoff, yoff, gravity);
        anchor.addOnAttachStateChangeListener(this.mAnchorOnAttachStateChangeListener);
    }

    @Override
    protected void detachFromAnchor() {
        View anchor = this.getAnchor();
        if (anchor != null) {
            anchor.removeOnAttachStateChangeListener(this.mAnchorOnAttachStateChangeListener);
        }
        super.detachFromAnchor();
    }

    @Override
    public void dismiss() {
        if (!this.isShowing() || this.isTransitioningToDismiss()) {
            return;
        }
        this.setShowing(false);
        this.setTransitioningToDismiss(true);
        this.hide();
        this.detachFromAnchor();
        if (this.getOnDismissListener() != null) {
            this.getOnDismissListener().onDismiss();
        }
    }

    private void adjustPosition() {
        View anchor = this.getAnchor();
        if (anchor == null) {
            return;
        }
        this.update(anchor);
    }

    private void show(WindowManager.LayoutParams params) {
        if (Helper.sVerbose) {
            Slog.v(TAG, "show()");
        }
        this.mWindowLayoutParams = params;
        try {
            params.packageName = "android";
            params.setTitle("Autofill Inline Tooltip");
            if (!this.mShowing) {
                params.flags = 40;
                params.privateFlags |= 0x400000;
                this.mContentContainer.addOnLayoutChangeListener(this.mAnchoredOnLayoutChangeListener);
                this.mWm.addView(this.mContentContainer, params);
                this.mShowing = true;
            } else {
                this.mWm.updateViewLayout(this.mContentContainer, params);
            }
        }
        catch (WindowManager.BadTokenException e) {
            Slog.d(TAG, "Failed with token " + params.token + " gone.");
        }
        catch (IllegalStateException e) {
            Slog.wtf(TAG, "Exception showing window " + params, e);
        }
    }

    private void hide() {
        if (Helper.sVerbose) {
            Slog.v(TAG, "hide()");
        }
        try {
            if (this.mShowing) {
                this.mContentContainer.removeOnLayoutChangeListener(this.mAnchoredOnLayoutChangeListener);
                this.mWm.removeView(this.mContentContainer);
                this.mShowing = false;
            }
        }
        catch (IllegalStateException e) {
            Slog.e(TAG, "Exception hiding window ", e);
        }
    }

    @Override
    public int getAnimationStyle() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Drawable getBackground() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public View getContentView() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public float getElevation() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Transition getEnterTransition() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Transition getExitTransition() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setBackgroundDrawable(Drawable background) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setContentView(View contentView) {
        if (contentView != null) {
            throw new IllegalStateException("You can't call this!");
        }
    }

    @Override
    public void setElevation(float elevation) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setEnterTransition(Transition enterTransition) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setExitTransition(Transition exitTransition) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setTouchInterceptor(View.OnTouchListener l) {
        throw new IllegalStateException("You can't call this!");
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        if (this.mContentContainer != null) {
            pw.print(prefix);
            pw.print("Window: ");
            String prefix2 = prefix + "  ";
            pw.println();
            pw.print(prefix2);
            pw.print("showing: ");
            pw.println(this.mShowing);
            pw.print(prefix2);
            pw.print("view: ");
            pw.println(this.mContentContainer);
            if (this.mWindowLayoutParams != null) {
                pw.print(prefix2);
                pw.print("params: ");
                pw.println(this.mWindowLayoutParams);
            }
            pw.print(prefix2);
            pw.print("screen coordinates: ");
            if (this.mContentContainer == null) {
                pw.println("N/A");
            } else {
                int[] coordinates = this.mContentContainer.getLocationOnScreen();
                pw.print(coordinates[0]);
                pw.print("x");
                pw.println(coordinates[1]);
            }
        }
    }
}

