/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.inline;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.view.inline.IInlineContentCallback;

public interface IInlineContentProvider
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.view.inline.IInlineContentProvider";

    public void provideContent(int var1, int var2, IInlineContentCallback var3) throws RemoteException;

    public void requestSurfacePackage() throws RemoteException;

    public void onSurfacePackageReleased() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInlineContentProvider {
        static final int TRANSACTION_provideContent = 1;
        static final int TRANSACTION_requestSurfacePackage = 2;
        static final int TRANSACTION_onSurfacePackageReleased = 3;

        public Stub() {
            this.attachInterface(this, IInlineContentProvider.DESCRIPTOR);
        }

        public static IInlineContentProvider asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInlineContentProvider.DESCRIPTOR);
            if (iin != null && iin instanceof IInlineContentProvider) {
                return (IInlineContentProvider)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "provideContent";
                }
                case 2: {
                    return "requestSurfacePackage";
                }
                case 3: {
                    return "onSurfacePackageReleased";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInlineContentProvider.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInlineContentCallback _arg2 = IInlineContentCallback.Stub.asInterface(data.readStrongBinder());
                    this.provideContent(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.requestSurfacePackage();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onSurfacePackageReleased();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IInlineContentProvider impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IInlineContentProvider getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IInlineContentProvider {
            private IBinder mRemote;
            public static IInlineContentProvider sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInlineContentProvider.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideContent(int width, int height, IInlineContentCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInlineContentProvider.DESCRIPTOR);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().provideContent(width, height, callback2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void requestSurfacePackage() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInlineContentProvider.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestSurfacePackage();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSurfacePackageReleased() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInlineContentProvider.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSurfacePackageReleased();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInlineContentProvider {
        @Override
        public void provideContent(int width, int height, IInlineContentCallback callback2) throws RemoteException {
        }

        @Override
        public void requestSurfacePackage() throws RemoteException {
        }

        @Override
        public void onSurfacePackageReleased() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

