/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;

public interface ScrollCaptureViewHelper<V extends View> {
    public static final int UP = -1;
    public static final int DOWN = 1;

    default public boolean onAcceptSession(V view) {
        return ((View)view).isVisibleToUser() && (((View)view).canScrollVertically(-1) || ((View)view).canScrollVertically(1));
    }

    default public Rect onComputeScrollBounds(V view) {
        Rect bounds2 = new Rect(0, 0, ((View)view).getWidth(), ((View)view).getHeight());
        if (view instanceof ViewGroup && ((ViewGroup)view).getClipToPadding()) {
            bounds2.inset(((View)view).getPaddingLeft(), ((View)view).getPaddingTop(), ((View)view).getPaddingRight(), ((View)view).getPaddingBottom());
        }
        return bounds2;
    }

    public void onPrepareForStart(V var1, Rect var2);

    public ScrollResult onScrollRequested(V var1, Rect var2, Rect var3);

    public void onPrepareForEnd(V var1);

    public static class ScrollResult {
        public Rect requestedArea;
        public Rect availableArea;
        public int scrollDelta;

        public String toString() {
            return "ScrollResult{requestedArea=" + this.requestedArea + ", availableArea=" + this.availableArea + ", scrollDelta=" + this.scrollDelta + '}';
        }
    }
}

