/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.Log;
import android.view.ScrollCaptureCallback;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import com.android.internal.view.ListViewCaptureHelper;
import com.android.internal.view.RecyclerViewCaptureHelper;
import com.android.internal.view.ScrollCaptureViewSupport;
import com.android.internal.view.ScrollViewCaptureHelper;

public class ScrollCaptureInternal {
    private static final String TAG = "ScrollCaptureInternal";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VERBOSE = false;
    private static final int UP = -1;
    private static final int DOWN = 1;
    public static final int TYPE_FIXED = 0;
    public static final int TYPE_SCROLLING = 1;
    public static final int TYPE_RECYCLING = 2;
    private static final int TYPE_OPAQUE = 3;

    private static int detectScrollingType(View view) {
        if (!(view instanceof ViewGroup)) {
            return 0;
        }
        if (!view.canScrollVertically(1) && !view.canScrollVertically(-1)) {
            return 0;
        }
        if (((ViewGroup)view).getChildCount() > 1) {
            return 2;
        }
        if (((ViewGroup)view).getChildCount() < 1) {
            return 3;
        }
        if (view.getScrollY() != 0) {
            return 1;
        }
        Log.v(TAG, "hint: scrollY == 0");
        if (view.canScrollVertically(-1)) {
            return 2;
        }
        view.scrollTo(view.getScrollX(), 1);
        if (view.getScrollY() == 1) {
            view.scrollTo(view.getScrollX(), 0);
            return 1;
        }
        return 2;
    }

    public ScrollCaptureCallback requestCallback(View view, Rect localVisibleRect, Point positionInWindow) {
        int i = ScrollCaptureInternal.detectScrollingType(view);
        switch (i) {
            case 1: {
                return new ScrollCaptureViewSupport<ViewGroup>((ViewGroup)view, new ScrollViewCaptureHelper());
            }
            case 2: {
                if (view instanceof ListView) {
                    return new ScrollCaptureViewSupport<ListView>((ListView)view, new ListViewCaptureHelper());
                }
                return new ScrollCaptureViewSupport<ViewGroup>((ViewGroup)view, new RecyclerViewCaptureHelper());
            }
        }
        return null;
    }

    private static String formatIntToHexString(int value2) {
        return "0x" + Integer.toHexString(value2).toUpperCase();
    }

    static String resolveId(Context context, int id2) {
        String fieldValue;
        Resources resources = context.getResources();
        if (id2 >= 0) {
            try {
                fieldValue = resources.getResourceTypeName(id2) + '/' + resources.getResourceEntryName(id2);
            }
            catch (Resources.NotFoundException e) {
                fieldValue = "id/" + ScrollCaptureInternal.formatIntToHexString(id2);
            }
        } else {
            fieldValue = "NO_ID";
        }
        return fieldValue;
    }
}

