/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.Trace;
import android.util.Log;
import android.util.imetracing.ImeTracing;
import android.util.imetracing.InputConnectionHelper;
import android.util.proto.ProtoOutputStream;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.DumpableInputConnection;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionInspector;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.SurroundingText;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.ICharSequenceResultCallback;
import com.android.internal.inputmethod.IExtractedTextResultCallback;
import com.android.internal.inputmethod.IIntResultCallback;
import com.android.internal.inputmethod.ISurroundingTextResultCallback;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputContext;
import java.lang.ref.WeakReference;

public class IInputConnectionWrapper
extends IInputContext.Stub {
    private static final String TAG = "IInputConnectionWrapper";
    private static final boolean DEBUG = false;
    private static final int DO_GET_TEXT_AFTER_CURSOR = 10;
    private static final int DO_GET_TEXT_BEFORE_CURSOR = 20;
    private static final int DO_GET_SELECTED_TEXT = 25;
    private static final int DO_GET_CURSOR_CAPS_MODE = 30;
    private static final int DO_GET_EXTRACTED_TEXT = 40;
    private static final int DO_COMMIT_TEXT = 50;
    private static final int DO_COMMIT_COMPLETION = 55;
    private static final int DO_COMMIT_CORRECTION = 56;
    private static final int DO_SET_SELECTION = 57;
    private static final int DO_PERFORM_EDITOR_ACTION = 58;
    private static final int DO_PERFORM_CONTEXT_MENU_ACTION = 59;
    private static final int DO_SET_COMPOSING_TEXT = 60;
    private static final int DO_SET_COMPOSING_REGION = 63;
    private static final int DO_FINISH_COMPOSING_TEXT = 65;
    private static final int DO_SEND_KEY_EVENT = 70;
    private static final int DO_DELETE_SURROUNDING_TEXT = 80;
    private static final int DO_DELETE_SURROUNDING_TEXT_IN_CODE_POINTS = 81;
    private static final int DO_BEGIN_BATCH_EDIT = 90;
    private static final int DO_END_BATCH_EDIT = 95;
    private static final int DO_PERFORM_SPELL_CHECK = 110;
    private static final int DO_PERFORM_PRIVATE_COMMAND = 120;
    private static final int DO_CLEAR_META_KEY_STATES = 130;
    private static final int DO_REQUEST_UPDATE_CURSOR_ANCHOR_INFO = 140;
    private static final int DO_CLOSE_CONNECTION = 150;
    private static final int DO_COMMIT_CONTENT = 160;
    private static final int DO_GET_SURROUNDING_TEXT = 41;
    private static final int DO_SET_IME_CONSUMES_INPUT = 170;
    @GuardedBy(value={"mLock"})
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private InputConnection mInputConnection;
    private Looper mMainLooper;
    private Handler mH;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mFinished = false;
    private final InputMethodManager mParentInputMethodManager;
    private final WeakReference<View> mServedView;

    public IInputConnectionWrapper(Looper mainLooper, InputConnection inputConnection, InputMethodManager inputMethodManager, View servedView) {
        this.mInputConnection = inputConnection;
        this.mMainLooper = mainLooper;
        this.mH = new MyHandler(this.mMainLooper);
        this.mParentInputMethodManager = inputMethodManager;
        this.mServedView = new WeakReference<View>(servedView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputConnection getInputConnection() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFinished() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFinished;
        }
    }

    public boolean isActive() {
        return this.mParentInputMethodManager.isActive() && !this.isFinished();
    }

    public View getServedView() {
        return (View)this.mServedView.get();
    }

    public void deactivate() {
        Handler handler;
        if (this.isFinished()) {
            return;
        }
        this.closeConnection();
        View servedView = (View)this.mServedView.get();
        if (servedView != null && (handler = servedView.getHandler()) != null) {
            if (handler.getLooper().isCurrentThread()) {
                servedView.onInputConnectionClosedInternal();
            } else {
                handler.post(servedView::onInputConnectionClosedInternal);
            }
        }
    }

    public String toString() {
        return "IInputConnectionWrapper{connection=" + this.getInputConnection() + " finished=" + this.isFinished() + " mParentInputMethodManager.isActive()=" + this.mParentInputMethodManager.isActive() + " mServedView=" + this.mServedView.get() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInputConnection instanceof DumpableInputConnection && Looper.myLooper() == this.mMainLooper) {
                ((DumpableInputConnection)((Object)this.mInputConnection)).dumpDebug(proto, fieldId);
            }
        }
    }

    @Override
    public void getTextAfterCursor(int length, int flags, ICharSequenceResultCallback callback2) {
        this.dispatchMessage(this.mH.obtainMessage(10, length, flags, callback2));
    }

    @Override
    public void getTextBeforeCursor(int length, int flags, ICharSequenceResultCallback callback2) {
        this.dispatchMessage(this.mH.obtainMessage(20, length, flags, callback2));
    }

    @Override
    public void getSelectedText(int flags, ICharSequenceResultCallback callback2) {
        this.dispatchMessage(this.mH.obtainMessage(25, flags, 0, callback2));
    }

    @Override
    public void getSurroundingText(int beforeLength, int afterLength, int flags, ISurroundingTextResultCallback callback2) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = beforeLength;
        args.arg2 = afterLength;
        args.arg3 = flags;
        args.arg4 = callback2;
        this.dispatchMessage(this.mH.obtainMessage(41, flags, 0, args));
    }

    @Override
    public void getCursorCapsMode(int reqModes, IIntResultCallback callback2) {
        this.dispatchMessage(this.mH.obtainMessage(30, reqModes, 0, callback2));
    }

    @Override
    public void getExtractedText(ExtractedTextRequest request, int flags, IExtractedTextResultCallback callback2) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = request;
        args.arg2 = callback2;
        this.dispatchMessage(this.mH.obtainMessage(40, flags, 0, args));
    }

    @Override
    public void commitText(CharSequence text, int newCursorPosition) {
        this.dispatchMessage(this.obtainMessageIO(50, newCursorPosition, text));
    }

    @Override
    public void commitCompletion(CompletionInfo text) {
        this.dispatchMessage(this.obtainMessageO(55, text));
    }

    @Override
    public void commitCorrection(CorrectionInfo info) {
        this.dispatchMessage(this.obtainMessageO(56, info));
    }

    @Override
    public void setSelection(int start, int end) {
        this.dispatchMessage(this.obtainMessageII(57, start, end));
    }

    @Override
    public void performEditorAction(int id2) {
        this.dispatchMessage(this.obtainMessageII(58, id2, 0));
    }

    @Override
    public void performContextMenuAction(int id2) {
        this.dispatchMessage(this.obtainMessageII(59, id2, 0));
    }

    @Override
    public void setComposingRegion(int start, int end) {
        this.dispatchMessage(this.obtainMessageII(63, start, end));
    }

    @Override
    public void setComposingText(CharSequence text, int newCursorPosition) {
        this.dispatchMessage(this.obtainMessageIO(60, newCursorPosition, text));
    }

    @Override
    public void finishComposingText() {
        this.dispatchMessage(this.obtainMessage(65));
    }

    @Override
    public void sendKeyEvent(KeyEvent event) {
        this.dispatchMessage(this.obtainMessageO(70, event));
    }

    @Override
    public void clearMetaKeyStates(int states) {
        this.dispatchMessage(this.obtainMessageII(130, states, 0));
    }

    @Override
    public void deleteSurroundingText(int beforeLength, int afterLength) {
        this.dispatchMessage(this.obtainMessageII(80, beforeLength, afterLength));
    }

    @Override
    public void deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        this.dispatchMessage(this.obtainMessageII(81, beforeLength, afterLength));
    }

    @Override
    public void beginBatchEdit() {
        this.dispatchMessage(this.obtainMessage(90));
    }

    @Override
    public void endBatchEdit() {
        this.dispatchMessage(this.obtainMessage(95));
    }

    @Override
    public void performSpellCheck() {
        this.dispatchMessage(this.obtainMessage(110));
    }

    @Override
    public void performPrivateCommand(String action2, Bundle data) {
        this.dispatchMessage(this.obtainMessageOO(120, action2, data));
    }

    @Override
    public void requestUpdateCursorAnchorInfo(int cursorUpdateMode, IIntResultCallback callback2) {
        this.dispatchMessage(this.mH.obtainMessage(140, cursorUpdateMode, 0, callback2));
    }

    public void closeConnection() {
        this.dispatchMessage(this.obtainMessage(150));
    }

    @Override
    public void commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts, IIntResultCallback callback2) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = inputContentInfo;
        args.arg2 = opts;
        args.arg3 = callback2;
        this.dispatchMessage(this.mH.obtainMessage(160, flags, 0, args));
    }

    @Override
    public void setImeConsumesInput(boolean imeConsumesInput) {
        this.dispatchMessage(this.obtainMessageB(170, imeConsumesInput));
    }

    void dispatchMessage(Message msg) {
        if (Looper.myLooper() == this.mMainLooper) {
            this.executeMessage(msg);
            msg.recycle();
            return;
        }
        this.mH.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeMessage(Message msg) {
        switch (msg.what) {
            case 10: {
                Trace.traceBegin(4L, "InputConnection#getTextAfterCursor");
                try {
                    CharSequence result;
                    ICharSequenceResultCallback callback2 = (ICharSequenceResultCallback)msg.obj;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getTextAfterCursor on inactive InputConnection");
                        result = null;
                    } else {
                        result = ic.getTextAfterCursor(msg.arg1, msg.arg2);
                    }
                    if (ImeTracing.getInstance().isEnabled()) {
                        ProtoOutputStream icProto = InputConnectionHelper.buildGetTextAfterCursorProto(msg.arg1, msg.arg2, result);
                        ImeTracing.getInstance().triggerClientDump("IInputConnectionWrapper#getTextAfterCursor", this.mParentInputMethodManager, icProto);
                    }
                    try {
                        callback2.onResult(result);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to getTextAfterCursor(). result=" + result, e);
                    }
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 20: {
                Trace.traceBegin(4L, "InputConnection#getTextBeforeCursor");
                try {
                    CharSequence result;
                    ICharSequenceResultCallback callback3 = (ICharSequenceResultCallback)msg.obj;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getTextBeforeCursor on inactive InputConnection");
                        result = null;
                    } else {
                        result = ic.getTextBeforeCursor(msg.arg1, msg.arg2);
                    }
                    if (ImeTracing.getInstance().isEnabled()) {
                        ProtoOutputStream icProto = InputConnectionHelper.buildGetTextBeforeCursorProto(msg.arg1, msg.arg2, result);
                        ImeTracing.getInstance().triggerClientDump("IInputConnectionWrapper#getTextBeforeCursor", this.mParentInputMethodManager, icProto);
                    }
                    try {
                        callback3.onResult(result);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to getTextBeforeCursor(). result=" + result, e);
                    }
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 25: {
                Trace.traceBegin(4L, "InputConnection#getSelectedText");
                try {
                    CharSequence result;
                    ICharSequenceResultCallback callback4 = (ICharSequenceResultCallback)msg.obj;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getSelectedText on inactive InputConnection");
                        result = null;
                    } else {
                        result = ic.getSelectedText(msg.arg1);
                    }
                    if (ImeTracing.getInstance().isEnabled()) {
                        ProtoOutputStream icProto = InputConnectionHelper.buildGetSelectedTextProto(msg.arg1, result);
                        ImeTracing.getInstance().triggerClientDump("IInputConnectionWrapper#getSelectedText", this.mParentInputMethodManager, icProto);
                    }
                    try {
                        callback4.onResult(result);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to getSelectedText(). result=" + result, e);
                    }
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 41: {
                SomeArgs args = (SomeArgs)msg.obj;
                Trace.traceBegin(4L, "InputConnection#getSurroundingText");
                try {
                    SurroundingText result;
                    int beforeLength = (Integer)args.arg1;
                    int afterLength = (Integer)args.arg2;
                    int flags = (Integer)args.arg3;
                    ISurroundingTextResultCallback callback5 = (ISurroundingTextResultCallback)args.arg4;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getSurroundingText on inactive InputConnection");
                        result = null;
                    } else {
                        result = ic.getSurroundingText(beforeLength, afterLength, flags);
                    }
                    if (ImeTracing.getInstance().isEnabled()) {
                        ProtoOutputStream icProto = InputConnectionHelper.buildGetSurroundingTextProto(beforeLength, afterLength, flags, result);
                        ImeTracing.getInstance().triggerClientDump("IInputConnectionWrapper#getSurroundingText", this.mParentInputMethodManager, icProto);
                    }
                    try {
                        callback5.onResult(result);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to getSurroundingText(). result=" + result, e);
                    }
                }
                finally {
                    Trace.traceEnd(4L);
                    args.recycle();
                }
                return;
            }
            case 30: {
                Trace.traceBegin(4L, "InputConnection#getCursorCapsMode");
                try {
                    int result;
                    IIntResultCallback callback6 = (IIntResultCallback)msg.obj;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getCursorCapsMode on inactive InputConnection");
                        result = 0;
                    } else {
                        result = ic.getCursorCapsMode(msg.arg1);
                    }
                    if (ImeTracing.getInstance().isEnabled()) {
                        ProtoOutputStream icProto = InputConnectionHelper.buildGetCursorCapsModeProto(msg.arg1, result);
                        ImeTracing.getInstance().triggerClientDump("IInputConnectionWrapper#getCursorCapsMode", this.mParentInputMethodManager, icProto);
                    }
                    try {
                        callback6.onResult(result);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to getCursorCapsMode(). result=" + result, e);
                    }
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 40: {
                SomeArgs args = (SomeArgs)msg.obj;
                Trace.traceBegin(4L, "InputConnection#getExtractedText");
                try {
                    ExtractedText result;
                    ExtractedTextRequest request = (ExtractedTextRequest)args.arg1;
                    IExtractedTextResultCallback callback7 = (IExtractedTextResultCallback)args.arg2;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getExtractedText on inactive InputConnection");
                        result = null;
                    } else {
                        result = ic.getExtractedText(request, msg.arg1);
                    }
                    if (ImeTracing.getInstance().isEnabled()) {
                        ProtoOutputStream icProto = InputConnectionHelper.buildGetExtractedTextProto(request, msg.arg1, result);
                        ImeTracing.getInstance().triggerClientDump("IInputConnectionWrapper#getExtractedText", this.mParentInputMethodManager, icProto);
                    }
                    try {
                        callback7.onResult(result);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to getExtractedText(). result=" + result, e);
                    }
                }
                finally {
                    Trace.traceEnd(4L);
                    args.recycle();
                }
                return;
            }
            case 50: {
                Trace.traceBegin(4L, "InputConnection#commitText");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "commitText on inactive InputConnection");
                        return;
                    }
                    ic.commitText((CharSequence)msg.obj, msg.arg1);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 57: {
                Trace.traceBegin(4L, "InputConnection#setSelection");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "setSelection on inactive InputConnection");
                        return;
                    }
                    ic.setSelection(msg.arg1, msg.arg2);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 58: {
                Trace.traceBegin(4L, "InputConnection#performEditorAction");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "performEditorAction on inactive InputConnection");
                        return;
                    }
                    ic.performEditorAction(msg.arg1);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 59: {
                Trace.traceBegin(4L, "InputConnection#performContextMenuAction");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "performContextMenuAction on inactive InputConnection");
                        return;
                    }
                    ic.performContextMenuAction(msg.arg1);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 55: {
                Trace.traceBegin(4L, "InputConnection#commitCompletion");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "commitCompletion on inactive InputConnection");
                        return;
                    }
                    ic.commitCompletion((CompletionInfo)msg.obj);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 56: {
                Trace.traceBegin(4L, "InputConnection#commitCorrection");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "commitCorrection on inactive InputConnection");
                        return;
                    }
                    ic.commitCorrection((CorrectionInfo)msg.obj);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 60: {
                Trace.traceBegin(4L, "InputConnection#setComposingText");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "setComposingText on inactive InputConnection");
                        return;
                    }
                    ic.setComposingText((CharSequence)msg.obj, msg.arg1);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 63: {
                Trace.traceBegin(4L, "InputConnection#setComposingRegion");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "setComposingRegion on inactive InputConnection");
                        return;
                    }
                    ic.setComposingRegion(msg.arg1, msg.arg2);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 65: {
                Trace.traceBegin(4L, "InputConnection#finishComposingText");
                try {
                    if (this.isFinished()) {
                        return;
                    }
                    InputConnection ic = this.getInputConnection();
                    if (ic == null) {
                        Log.w(TAG, "finishComposingText on inactive InputConnection");
                        return;
                    }
                    ic.finishComposingText();
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 70: {
                Trace.traceBegin(4L, "InputConnection#sendKeyEvent");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "sendKeyEvent on inactive InputConnection");
                        return;
                    }
                    ic.sendKeyEvent((KeyEvent)msg.obj);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 130: {
                Trace.traceBegin(4L, "InputConnection#clearMetaKeyStates");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "clearMetaKeyStates on inactive InputConnection");
                        return;
                    }
                    ic.clearMetaKeyStates(msg.arg1);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 80: {
                Trace.traceBegin(4L, "InputConnection#deleteSurroundingText");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "deleteSurroundingText on inactive InputConnection");
                        return;
                    }
                    ic.deleteSurroundingText(msg.arg1, msg.arg2);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 81: {
                Trace.traceBegin(4L, "InputConnection#deleteSurroundingTextInCodePoints");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "deleteSurroundingTextInCodePoints on inactive InputConnection");
                        return;
                    }
                    ic.deleteSurroundingTextInCodePoints(msg.arg1, msg.arg2);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 90: {
                Trace.traceBegin(4L, "InputConnection#beginBatchEdit");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "beginBatchEdit on inactive InputConnection");
                        return;
                    }
                    ic.beginBatchEdit();
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 95: {
                Trace.traceBegin(4L, "InputConnection#endBatchEdit");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "endBatchEdit on inactive InputConnection");
                        return;
                    }
                    ic.endBatchEdit();
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 110: {
                Trace.traceBegin(4L, "InputConnection#performSpellCheck");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "performSpellCheck on inactive InputConnection");
                        return;
                    }
                    ic.performSpellCheck();
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 120: {
                SomeArgs args = (SomeArgs)msg.obj;
                Trace.traceBegin(4L, "InputConnection#performPrivateCommand");
                try {
                    String action2 = (String)args.arg1;
                    Bundle data = (Bundle)args.arg2;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "performPrivateCommand on inactive InputConnection");
                        return;
                    }
                    ic.performPrivateCommand(action2, data);
                }
                finally {
                    Trace.traceEnd(4L);
                    args.recycle();
                }
                return;
            }
            case 140: {
                Trace.traceBegin(4L, "InputConnection#requestCursorUpdates");
                try {
                    boolean result;
                    IIntResultCallback callback8 = (IIntResultCallback)msg.obj;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "requestCursorAnchorInfo on inactive InputConnection");
                        result = false;
                    } else {
                        result = ic.requestCursorUpdates(msg.arg1);
                    }
                    try {
                        callback8.onResult(result ? 1 : 0);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to requestCursorUpdates(). result=" + result, e);
                    }
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 150: {
                if (this.isFinished()) {
                    return;
                }
                Trace.traceBegin(4L, "InputConnection#closeConnection");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null) {
                        return;
                    }
                    int missingMethods = InputConnectionInspector.getMissingMethodFlags(ic);
                    if ((missingMethods & 0x40) == 0) {
                        ic.closeConnection();
                    }
                }
                finally {
                    Object ic = this.mLock;
                    synchronized (ic) {
                        this.mInputConnection = null;
                        this.mFinished = true;
                    }
                    Trace.traceEnd(4L);
                }
                return;
            }
            case 160: {
                int flags = msg.arg1;
                SomeArgs args = (SomeArgs)msg.obj;
                Trace.traceBegin(4L, "InputConnection#commitContent");
                try {
                    boolean result;
                    IIntResultCallback callback9 = (IIntResultCallback)args.arg3;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "commitContent on inactive InputConnection");
                        result = false;
                    } else {
                        InputContentInfo inputContentInfo = (InputContentInfo)args.arg1;
                        if (inputContentInfo == null || !inputContentInfo.validate()) {
                            Log.w(TAG, "commitContent with invalid inputContentInfo=" + inputContentInfo);
                            result = false;
                        } else {
                            result = ic.commitContent(inputContentInfo, flags, (Bundle)args.arg2);
                        }
                    }
                    try {
                        callback9.onResult(result ? 1 : 0);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to commitContent(). result=" + result, e);
                    }
                }
                finally {
                    Trace.traceEnd(4L);
                    args.recycle();
                }
                return;
            }
            case 170: {
                Trace.traceBegin(4L, "InputConnection#setImeConsumesInput");
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "setImeConsumesInput on inactive InputConnection");
                        return;
                    }
                    ic.setImeConsumesInput(msg.arg1 == 1);
                }
                finally {
                    Trace.traceEnd(4L);
                }
                return;
            }
        }
        Log.w(TAG, "Unhandled message code: " + msg.what);
    }

    Message obtainMessage(int what) {
        return this.mH.obtainMessage(what);
    }

    Message obtainMessageII(int what, int arg1, int arg2) {
        return this.mH.obtainMessage(what, arg1, arg2);
    }

    Message obtainMessageO(int what, Object arg1) {
        return this.mH.obtainMessage(what, 0, 0, arg1);
    }

    Message obtainMessageIO(int what, int arg1, Object arg2) {
        return this.mH.obtainMessage(what, arg1, 0, arg2);
    }

    Message obtainMessageOO(int what, Object arg1, Object arg2) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = arg1;
        args.arg2 = arg2;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    Message obtainMessageB(int what, boolean arg1) {
        return this.mH.obtainMessage(what, arg1 ? 1 : 0, 0);
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            IInputConnectionWrapper.this.executeMessage(msg);
        }
    }
}

