/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TypedProperties
extends HashMap<String, Object> {
    static final String NULL_STRING = new String("<TypedProperties:NULL_STRING>");
    static final int TYPE_UNSET = 120;
    static final int TYPE_BOOLEAN = 90;
    static final int TYPE_BYTE = 329;
    static final int TYPE_SHORT = 585;
    static final int TYPE_INT = 1097;
    static final int TYPE_LONG = 2121;
    static final int TYPE_FLOAT = 1094;
    static final int TYPE_DOUBLE = 2118;
    static final int TYPE_STRING = 29516;
    static final int TYPE_ERROR = -1;
    public static final int STRING_TYPE_MISMATCH = -2;
    public static final int STRING_NOT_SET = -1;
    public static final int STRING_NULL = 0;
    public static final int STRING_SET = 1;

    static StreamTokenizer initTokenizer(Reader r) {
        StreamTokenizer st = new StreamTokenizer(r);
        st.resetSyntax();
        st.wordChars(48, 57);
        st.wordChars(65, 90);
        st.wordChars(97, 122);
        st.wordChars(95, 95);
        st.wordChars(36, 36);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.ordinaryChar(61);
        st.whitespaceChars(32, 32);
        st.whitespaceChars(9, 9);
        st.whitespaceChars(10, 10);
        st.whitespaceChars(13, 13);
        st.quoteChar(34);
        st.slashStarComments(true);
        st.slashSlashComments(true);
        return st;
    }

    static int interpretType(String typeName) {
        if ("unset".equals(typeName)) {
            return 120;
        }
        if ("boolean".equals(typeName)) {
            return 90;
        }
        if ("byte".equals(typeName)) {
            return 329;
        }
        if ("short".equals(typeName)) {
            return 585;
        }
        if ("int".equals(typeName)) {
            return 1097;
        }
        if ("long".equals(typeName)) {
            return 2121;
        }
        if ("float".equals(typeName)) {
            return 1094;
        }
        if ("double".equals(typeName)) {
            return 2118;
        }
        if ("String".equals(typeName)) {
            return 29516;
        }
        return -1;
    }

    static void parse(Reader r, Map<String, Object> map2) throws ParseException, IOException {
        int token;
        StreamTokenizer st = TypedProperties.initTokenizer(r);
        String identifierPattern = "[a-zA-Z_$][0-9a-zA-Z_$]*";
        Pattern propertyNamePattern = Pattern.compile("([a-zA-Z_$][0-9a-zA-Z_$]*\\.)*[a-zA-Z_$][0-9a-zA-Z_$]*");
        while ((token = st.nextToken()) != -1) {
            if (token != -3) {
                throw new ParseException(st, "type name");
            }
            int type = TypedProperties.interpretType(st.sval);
            if (type == -1) {
                throw new ParseException(st, "valid type name");
            }
            st.sval = null;
            if (type == 120 && (token = st.nextToken()) != 40) {
                throw new ParseException(st, "'('");
            }
            token = st.nextToken();
            if (token != -3) {
                throw new ParseException(st, "property name");
            }
            String propertyName = st.sval;
            if (!propertyNamePattern.matcher(propertyName).matches()) {
                throw new ParseException(st, "valid property name");
            }
            st.sval = null;
            if (type == 120) {
                token = st.nextToken();
                if (token != 41) {
                    throw new ParseException(st, "')'");
                }
                map2.remove(propertyName);
            } else {
                token = st.nextToken();
                if (token != 61) {
                    throw new ParseException(st, "'='");
                }
                Object value2 = TypedProperties.parseValue(st, type);
                Object oldValue = map2.remove(propertyName);
                if (oldValue != null && value2.getClass() != oldValue.getClass()) {
                    throw new ParseException(st, "(property previously declared as a different type)");
                }
                map2.put(propertyName, value2);
            }
            if ((token = st.nextToken()) == 59) continue;
            throw new ParseException(st, "';'");
        }
    }

    static Object parseValue(StreamTokenizer st, int type) throws IOException {
        int token = st.nextToken();
        if (type == 90) {
            if (token != -3) {
                throw new ParseException(st, "boolean constant");
            }
            if ("true".equals(st.sval)) {
                return Boolean.TRUE;
            }
            if ("false".equals(st.sval)) {
                return Boolean.FALSE;
            }
            throw new ParseException(st, "boolean constant");
        }
        if ((type & 0xFF) == 73) {
            long value2;
            if (token != -3) {
                throw new ParseException(st, "integer constant");
            }
            try {
                value2 = Long.decode(st.sval);
            }
            catch (NumberFormatException ex) {
                throw new ParseException(st, "integer constant");
            }
            int width = type >> 8 & 0xFF;
            switch (width) {
                case 1: {
                    if (value2 < -128L || value2 > 127L) {
                        throw new ParseException(st, "8-bit integer constant");
                    }
                    return new Byte((byte)value2);
                }
                case 2: {
                    if (value2 < -32768L || value2 > 32767L) {
                        throw new ParseException(st, "16-bit integer constant");
                    }
                    return new Short((short)value2);
                }
                case 4: {
                    if (value2 < Integer.MIN_VALUE || value2 > Integer.MAX_VALUE) {
                        throw new ParseException(st, "32-bit integer constant");
                    }
                    return new Integer((int)value2);
                }
                case 8: {
                    if (value2 < Long.MIN_VALUE || value2 > Long.MAX_VALUE) {
                        throw new ParseException(st, "64-bit integer constant");
                    }
                    return new Long(value2);
                }
            }
            throw new IllegalStateException("Internal error; unexpected integer type width " + width);
        }
        if ((type & 0xFF) == 70) {
            double value3;
            if (token != -3) {
                throw new ParseException(st, "float constant");
            }
            try {
                value3 = Double.parseDouble(st.sval);
            }
            catch (NumberFormatException ex) {
                throw new ParseException(st, "float constant");
            }
            if ((type >> 8 & 0xFF) == 4) {
                double absValue = Math.abs(value3);
                if (absValue != 0.0 && !Double.isInfinite(value3) && !Double.isNaN(value3) && (absValue < (double)1.4E-45f || absValue > 3.4028234663852886E38)) {
                    throw new ParseException(st, "32-bit float constant");
                }
                return new Float((float)value3);
            }
            return new Double(value3);
        }
        if (type == 29516) {
            if (token == 34) {
                return st.sval;
            }
            if (token == -3 && "null".equals(st.sval)) {
                return NULL_STRING;
            }
            throw new ParseException(st, "double-quoted string or 'null'");
        }
        throw new IllegalStateException("Internal error; unknown type " + type);
    }

    public void load(Reader r) throws IOException {
        TypedProperties.parse(r, this);
    }

    @Override
    public Object get(Object key) {
        Object value2 = super.get(key);
        if (value2 == NULL_STRING) {
            return null;
        }
        return value2;
    }

    public boolean getBoolean(String property, boolean def) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        throw new TypeException(property, value2, "boolean");
    }

    public byte getByte(String property, byte def) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof Byte) {
            return (Byte)value2;
        }
        throw new TypeException(property, value2, "byte");
    }

    public short getShort(String property, short def) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof Short) {
            return (Short)value2;
        }
        throw new TypeException(property, value2, "short");
    }

    public int getInt(String property, int def) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        throw new TypeException(property, value2, "int");
    }

    public long getLong(String property, long def) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof Long) {
            return (Long)value2;
        }
        throw new TypeException(property, value2, "long");
    }

    public float getFloat(String property, float def) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof Float) {
            return ((Float)value2).floatValue();
        }
        throw new TypeException(property, value2, "float");
    }

    public double getDouble(String property, double def) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        throw new TypeException(property, value2, "double");
    }

    public String getString(String property, String def) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return def;
        }
        if (value2 == NULL_STRING) {
            return null;
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        throw new TypeException(property, value2, "string");
    }

    public boolean getBoolean(String property) {
        return this.getBoolean(property, false);
    }

    public byte getByte(String property) {
        return this.getByte(property, (byte)0);
    }

    public short getShort(String property) {
        return this.getShort(property, (short)0);
    }

    public int getInt(String property) {
        return this.getInt(property, 0);
    }

    public long getLong(String property) {
        return this.getLong(property, 0L);
    }

    public float getFloat(String property) {
        return this.getFloat(property, 0.0f);
    }

    public double getDouble(String property) {
        return this.getDouble(property, 0.0);
    }

    public String getString(String property) {
        return this.getString(property, "");
    }

    public int getStringInfo(String property) {
        Object value2 = super.get(property);
        if (value2 == null) {
            return -1;
        }
        if (value2 == NULL_STRING) {
            return 0;
        }
        if (value2 instanceof String) {
            return 1;
        }
        return -2;
    }

    public static class TypeException
    extends IllegalArgumentException {
        TypeException(String property, Object value2, String requestedType) {
            super(property + " has type " + value2.getClass().getName() + ", not " + requestedType);
        }
    }

    public static class ParseException
    extends IllegalArgumentException {
        ParseException(StreamTokenizer state, String expected2) {
            super("expected " + expected2 + ", saw " + state.toString());
        }
    }
}

