/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Bundle;
import android.os.Parcelable;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SyncResultReceiver
extends IResultReceiver.Stub {
    private static final String EXTRA = "EXTRA";
    private final CountDownLatch mLatch = new CountDownLatch(1);
    private final int mTimeoutMs;
    private int mResult;
    private Bundle mBundle;

    public SyncResultReceiver(int timeoutMs) {
        this.mTimeoutMs = timeoutMs;
    }

    private void waitResult() throws TimeoutException {
        try {
            if (!this.mLatch.await(this.mTimeoutMs, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Not called in " + this.mTimeoutMs + "ms");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TimeoutException("Interrupted");
        }
    }

    public int getIntResult() throws TimeoutException {
        this.waitResult();
        return this.mResult;
    }

    public String getStringResult() throws TimeoutException {
        this.waitResult();
        return this.mBundle == null ? null : this.mBundle.getString(EXTRA);
    }

    public String[] getStringArrayResult() throws TimeoutException {
        this.waitResult();
        return this.mBundle == null ? null : this.mBundle.getStringArray(EXTRA);
    }

    public <P extends Parcelable> P getParcelableResult() throws TimeoutException {
        this.waitResult();
        return this.mBundle == null ? null : (P)this.mBundle.getParcelable(EXTRA);
    }

    public <P extends Parcelable> ArrayList<P> getParcelableListResult() throws TimeoutException {
        this.waitResult();
        return this.mBundle == null ? null : this.mBundle.getParcelableArrayList(EXTRA);
    }

    public int getOptionalExtraIntResult(int defaultValue2) throws TimeoutException {
        this.waitResult();
        if (this.mBundle == null || !this.mBundle.containsKey(EXTRA)) {
            return defaultValue2;
        }
        return this.mBundle.getInt(EXTRA);
    }

    @Override
    public void send(int resultCode, Bundle resultData) {
        this.mResult = resultCode;
        this.mBundle = resultData;
        this.mLatch.countDown();
    }

    public static Bundle bundleFor(String value2) {
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA, value2);
        return bundle;
    }

    public static Bundle bundleFor(String[] value2) {
        Bundle bundle = new Bundle();
        bundle.putStringArray(EXTRA, value2);
        return bundle;
    }

    public static Bundle bundleFor(Parcelable value2) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(EXTRA, value2);
        return bundle;
    }

    public static Bundle bundleFor(ArrayList<? extends Parcelable> value2) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(EXTRA, value2);
        return bundle;
    }

    public static Bundle bundleFor(int value2) {
        Bundle bundle = new Bundle();
        bundle.putInt(EXTRA, value2);
        return bundle;
    }

    public static class TimeoutException
    extends Exception {
        private TimeoutException(String msg) {
            super(msg);
        }
    }
}

