/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.Log;
import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class MessageUtils {
    private static final String TAG = MessageUtils.class.getSimpleName();
    private static final boolean DBG = false;
    public static final String[] DEFAULT_PREFIXES = new String[]{"CMD_", "EVENT_"};

    public static SparseArray<String> findMessageNames(Class[] classes2, String[] prefixes) {
        SparseArray<String> messageNames = new SparseArray<String>();
        for (Class c : classes2) {
            Field[] fields;
            String className2 = c.getName();
            try {
                fields = c.getDeclaredFields();
            }
            catch (SecurityException e) {
                Log.e(TAG, "Can't list fields of class " + className2);
                continue;
            }
            block7: for (Field field : fields) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) | !Modifier.isFinal(modifiers)) continue;
                String name = field.getName();
                for (String prefix : prefixes) {
                    if (!name.startsWith(prefix)) continue;
                    try {
                        int value2;
                        field.setAccessible(true);
                        try {
                            value2 = field.getInt(null);
                        }
                        catch (ExceptionInInitializerError | IllegalArgumentException e) {
                            continue block7;
                        }
                        String previousName = messageNames.get(value2);
                        if (previousName != null && !previousName.equals(name)) {
                            throw new DuplicateConstantError(name, previousName, value2);
                        }
                        messageNames.put(value2, name);
                    }
                    catch (IllegalAccessException | SecurityException e) {
                        // empty catch block
                    }
                }
            }
        }
        return messageNames;
    }

    public static SparseArray<String> findMessageNames(Class[] classNames) {
        return MessageUtils.findMessageNames(classNames, DEFAULT_PREFIXES);
    }

    public static class DuplicateConstantError
    extends Error {
        private DuplicateConstantError() {
        }

        public DuplicateConstantError(String name1, String name2, int value2) {
            super(String.format("Duplicate constant value: both %s and %s = %d", name1, name2, value2));
        }
    }
}

