/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.AppIdInt;
import android.annotation.ColorInt;
import android.annotation.FloatRange;
import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.Size;
import android.annotation.UserIdInt;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.android.internal.util.BitUtils;
import java.lang.annotation.Annotation;

public class AnnotationValidations {
    private AnnotationValidations() {
    }

    public static void validate(Class<UserIdInt> annotation, UserIdInt ignored, int value2) {
        if (value2 != -10000 && value2 < -3 || value2 > 21474) {
            AnnotationValidations.invalid(annotation, (Object)value2);
        }
    }

    public static void validate(Class<AppIdInt> annotation, AppIdInt ignored, int value2) {
        if (value2 / 100000 != 0 || value2 < 0) {
            AnnotationValidations.invalid(annotation, (Object)value2);
        }
    }

    public static void validate(Class<IntRange> annotation, IntRange ignored, int value2, String paramName1, long param1, String paramName2, long param2) {
        AnnotationValidations.validate(annotation, ignored, value2, paramName1, param1);
        AnnotationValidations.validate(annotation, ignored, value2, paramName2, param2);
    }

    public static void validate(Class<IntRange> annotation, IntRange ignored, int value2, String paramName, long param) {
        switch (paramName) {
            case "from": {
                if ((long)value2 >= param) break;
                AnnotationValidations.invalid(annotation, value2, paramName, param);
                break;
            }
            case "to": {
                if ((long)value2 <= param) break;
                AnnotationValidations.invalid(annotation, value2, paramName, param);
            }
        }
    }

    public static void validate(Class<IntRange> annotation, IntRange ignored, long value2, String paramName1, long param1, String paramName2, long param2) {
        AnnotationValidations.validate(annotation, ignored, value2, paramName1, param1);
        AnnotationValidations.validate(annotation, ignored, value2, paramName2, param2);
    }

    public static void validate(Class<IntRange> annotation, IntRange ignored, long value2, String paramName, long param) {
        switch (paramName) {
            case "from": {
                if (value2 >= param) break;
                AnnotationValidations.invalid(annotation, value2, paramName, param);
                break;
            }
            case "to": {
                if (value2 <= param) break;
                AnnotationValidations.invalid(annotation, value2, paramName, param);
            }
        }
    }

    public static void validate(Class<FloatRange> annotation, FloatRange ignored, float value2, String paramName1, float param1, String paramName2, float param2) {
        AnnotationValidations.validate(annotation, ignored, value2, paramName1, param1);
        AnnotationValidations.validate(annotation, ignored, value2, paramName2, param2);
    }

    public static void validate(Class<FloatRange> annotation, FloatRange ignored, float value2, String paramName, float param) {
        switch (paramName) {
            case "from": {
                if (!(value2 < param)) break;
                AnnotationValidations.invalid(annotation, Float.valueOf(value2), paramName, Float.valueOf(param));
                break;
            }
            case "to": {
                if (!(value2 > param)) break;
                AnnotationValidations.invalid(annotation, Float.valueOf(value2), paramName, Float.valueOf(param));
            }
        }
    }

    public static void validate(Class<NonNull> annotation, NonNull ignored, Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
    }

    public static void validate(Class<Size> annotation, Size ignored, int value2, String paramName1, int param1, String paramName2, int param2) {
        AnnotationValidations.validate(annotation, ignored, value2, paramName1, param1);
        AnnotationValidations.validate(annotation, ignored, value2, paramName2, param2);
    }

    public static void validate(Class<Size> annotation, Size ignored, int value2, String paramName, int param) {
        switch (paramName) {
            case "value": {
                if (param == -1 || value2 == param) break;
                AnnotationValidations.invalid(annotation, value2, paramName, param);
                break;
            }
            case "min": {
                if (value2 >= param) break;
                AnnotationValidations.invalid(annotation, value2, paramName, param);
                break;
            }
            case "max": {
                if (value2 <= param) break;
                AnnotationValidations.invalid(annotation, value2, paramName, param);
                break;
            }
            case "multiple": {
                if (value2 % param == 0) break;
                AnnotationValidations.invalid(annotation, value2, paramName, param);
            }
        }
    }

    public static void validate(Class<PackageManager.PermissionResult> annotation, PackageManager.PermissionResult ignored, int value2) {
        AnnotationValidations.validateIntEnum(annotation, value2, 0);
    }

    public static void validate(Class<PackageManager.PackageInfoFlags> annotation, PackageManager.PackageInfoFlags ignored, int value2) {
        AnnotationValidations.validateIntFlags(annotation, value2, BitUtils.flagsUpTo(0x20000000));
    }

    public static void validate(Class<Intent.Flags> annotation, Intent.Flags ignored, int value2) {
        AnnotationValidations.validateIntFlags(annotation, value2, BitUtils.flagsUpTo(Integer.MIN_VALUE));
    }

    @Deprecated
    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, Object value2, Object ... params) {
    }

    @Deprecated
    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, Object value2) {
    }

    @Deprecated
    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, int value2, Object ... params) {
    }

    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, int value2) {
        if (("android.annotation".equals(annotation.getPackageName()) && annotation.getSimpleName().endsWith("Res") || ColorInt.class.equals(annotation)) && value2 < 0) {
            AnnotationValidations.invalid(annotation, (Object)value2);
        }
    }

    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, long value2) {
        if ("android.annotation".equals(annotation.getPackageName()) && annotation.getSimpleName().endsWith("Long") && value2 < 0L) {
            AnnotationValidations.invalid(annotation, (Object)value2);
        }
    }

    private static void validateIntEnum(Class<? extends Annotation> annotation, int value2, int lastValid) {
        if (value2 > lastValid) {
            AnnotationValidations.invalid(annotation, (Object)value2);
        }
    }

    private static void validateIntFlags(Class<? extends Annotation> annotation, int value2, int validBits) {
        if ((validBits & value2) != validBits) {
            AnnotationValidations.invalid(annotation, (Object)("0x" + Integer.toHexString(value2)));
        }
    }

    private static void invalid(Class<? extends Annotation> annotation, Object value2) {
        AnnotationValidations.invalid("@" + annotation.getSimpleName(), value2);
    }

    private static void invalid(Class<? extends Annotation> annotation, Object value2, String paramName, Object param) {
        String paramPrefix = "value".equals(paramName) ? "" : paramName + " = ";
        AnnotationValidations.invalid("@" + annotation.getSimpleName() + "(" + paramPrefix + param + ")", value2);
    }

    private static void invalid(String valueKind, Object value2) {
        throw new IllegalStateException("Invalid " + valueKind + ": " + value2);
    }
}

