/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.Uri;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SipMessageParsingUtils {
    private static final String TAG = "SipMessageParsingUtils";
    private static final String[] SIP_REQUEST_METHODS = new String[]{"INVITE", "ACK", "OPTIONS", "BYE", "CANCEL", "REGISTER", "PRACK", "SUBSCRIBE", "NOTIFY", "PUBLISH", "INFO", "REFER", "MESSAGE", "UPDATE"};
    private static final String SIP_VERSION_2 = "SIP/2.0";
    private static final String HEADER_KEY_VALUE_SEPARATOR = ":";
    private static final String SUBHEADER_VALUE_SEPARATOR = ",";
    private static final String PARAM_SEPARATOR = ";";
    private static final String PARAM_KEY_VALUE_SEPARATOR = "=";
    private static final String BRANCH_PARAM_KEY = "branch";
    private static final String VIA_SIP_HEADER_KEY = "via";
    private static final String VIA_SIP_HEADER_KEY_COMPACT = "v";
    private static final String CALL_ID_SIP_HEADER_KEY = "call-id";
    private static final String CALL_ID_SIP_HEADER_KEY_COMPACT = "i";
    private static final String FROM_HEADER_KEY = "from";
    private static final String FROM_HEADER_KEY_COMPACT = "f";
    private static final String TO_HEADER_KEY = "to";
    private static final String TO_HEADER_KEY_COMPACT = "t";
    private static final String TAG_PARAM_KEY = "tag";
    private static final String ACCEPT_CONTACT_HEADER_KEY = "accept-contact";
    private static final String ACCEPT_CONTACT_HEADER_KEY_COMPACT = "a";

    public static boolean isSipRequest(String startLine) {
        String[] splitLine = SipMessageParsingUtils.splitStartLineAndVerify(startLine);
        if (splitLine == null) {
            return false;
        }
        return SipMessageParsingUtils.verifySipRequest(splitLine);
    }

    public static boolean isSipResponse(String startLine) {
        String[] splitLine = SipMessageParsingUtils.splitStartLineAndVerify(startLine);
        if (splitLine == null) {
            return false;
        }
        return SipMessageParsingUtils.verifySipResponse(splitLine);
    }

    public static String getTransactionId(String headerString) {
        List<Pair<String, String>> headers = SipMessageParsingUtils.parseHeaders(headerString, true, VIA_SIP_HEADER_KEY, VIA_SIP_HEADER_KEY_COMPACT);
        for (Pair<String, String> header : headers) {
            String[] subHeaders;
            for (String subHeader : subHeaders = ((String)header.second).split(SUBHEADER_VALUE_SEPARATOR)) {
                String paramValue = SipMessageParsingUtils.getParameterValue(subHeader, BRANCH_PARAM_KEY);
                if (paramValue == null) continue;
                return paramValue;
            }
        }
        return null;
    }

    private static String getParameterValue(String headerValue, String parameterKey) {
        String[] params = headerValue.split(PARAM_SEPARATOR);
        if (params.length < 2) {
            return null;
        }
        for (String param : params) {
            Object[] pair = param.split(PARAM_KEY_VALUE_SEPARATOR);
            if (pair.length < 2) continue;
            if (pair.length > 2) {
                Log.w(TAG, "getParameterValue: unexpected parameter" + Arrays.toString(pair));
            }
            pair[0] = pair[0].trim();
            pair[1] = ((String)pair[1]).trim();
            if (!parameterKey.equalsIgnoreCase((String)pair[0])) continue;
            return pair[1];
        }
        return null;
    }

    public static String getCallId(String headerString) {
        List<Pair<String, String>> headers = SipMessageParsingUtils.parseHeaders(headerString, true, CALL_ID_SIP_HEADER_KEY, CALL_ID_SIP_HEADER_KEY_COMPACT);
        return !headers.isEmpty() ? (String)headers.get((int)0).second : null;
    }

    public static String getFromTag(String headerString) {
        List<Pair<String, String>> headers = SipMessageParsingUtils.parseHeaders(headerString, true, FROM_HEADER_KEY, FROM_HEADER_KEY_COMPACT);
        if (headers.isEmpty()) {
            return null;
        }
        return SipMessageParsingUtils.getParameterValue((String)headers.get((int)0).second, TAG_PARAM_KEY);
    }

    public static String getToTag(String headerString) {
        List<Pair<String, String>> headers = SipMessageParsingUtils.parseHeaders(headerString, true, TO_HEADER_KEY, TO_HEADER_KEY_COMPACT);
        if (headers.isEmpty()) {
            return null;
        }
        return SipMessageParsingUtils.getParameterValue((String)headers.get((int)0).second, TAG_PARAM_KEY);
    }

    public static String[] splitStartLineAndVerify(String startLine) {
        String[] splitLine = startLine.split(" ", 3);
        if (SipMessageParsingUtils.isStartLineMalformed(splitLine)) {
            return null;
        }
        return splitLine;
    }

    public static Set<String> getAcceptContactFeatureTags(String headerString) {
        List<Pair<String, String>> headers = SipMessageParsingUtils.parseHeaders(headerString, false, ACCEPT_CONTACT_HEADER_KEY, ACCEPT_CONTACT_HEADER_KEY_COMPACT);
        if (headerString.isEmpty()) {
            return Collections.emptySet();
        }
        ArraySet<String> featureTags = new ArraySet<String>();
        for (Pair<String, String> header : headers) {
            String[] splitParams = ((String)header.second).split(PARAM_SEPARATOR);
            if (splitParams.length < 2) continue;
            Set fts = Arrays.asList(splitParams).subList(1, splitParams.length).stream().map(String::trim).filter(p -> p.startsWith("+")).collect(Collectors.toSet());
            for (String ft : fts) {
                String[] splitValue;
                String[] paramKeyValue = ft.split(PARAM_KEY_VALUE_SEPARATOR, 2);
                if (paramKeyValue.length < 2) {
                    featureTags.add(ft);
                    continue;
                }
                for (String value2 : splitValue = SipMessageParsingUtils.splitParamValue(paramKeyValue[1])) {
                    featureTags.add(paramKeyValue[0] + PARAM_KEY_VALUE_SEPARATOR + value2);
                }
            }
        }
        return featureTags;
    }

    private static String[] splitParamValue(String paramValue) {
        if (!paramValue.startsWith("\"") && !paramValue.endsWith("\"")) {
            return new String[]{paramValue};
        }
        paramValue = paramValue.substring(1, paramValue.length() - 1);
        String[] splitValues = paramValue.split(SUBHEADER_VALUE_SEPARATOR);
        for (int i = 0; i < splitValues.length; ++i) {
            splitValues[i] = "\"" + splitValues[i] + "\"";
        }
        return splitValues;
    }

    private static boolean isStartLineMalformed(String[] startLine) {
        if (startLine == null || startLine.length == 0) {
            return true;
        }
        return startLine.length != 3;
    }

    private static boolean verifySipRequest(String[] request) {
        if (!request[2].contains(SIP_VERSION_2)) {
            return false;
        }
        try {
            boolean verified = Uri.parse(request[1]).getScheme() != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
        return verified &= Arrays.stream(SIP_REQUEST_METHODS).anyMatch(s -> request[0].contains((CharSequence)s));
    }

    private static boolean verifySipResponse(String[] response) {
        int statusCode;
        if (!response[0].contains(SIP_VERSION_2)) {
            return false;
        }
        try {
            statusCode = Integer.parseInt(response[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return statusCode >= 100 && statusCode < 700;
    }

    public static List<Pair<String, String>> parseHeaders(String headerString, boolean stopAtFirstMatch, String ... matchingHeaderKeys) {
        headerString = SipMessageParsingUtils.removeLeadingWhitespace(headerString);
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        String[] headerLines = headerString.split("\\r?\\n");
        if (headerLines.length == 0) {
            return Collections.emptyList();
        }
        String headerKey = null;
        StringBuilder headerValueSegment = new StringBuilder();
        for (String line : headerLines) {
            String[] pair;
            if (line.startsWith("\t") || line.startsWith(" ")) {
                headerValueSegment.append(SipMessageParsingUtils.removeLeadingWhitespace(line));
                continue;
            }
            if (headerKey != null) {
                String key = headerKey;
                if (matchingHeaderKeys == null || matchingHeaderKeys.length == 0 || Arrays.stream(matchingHeaderKeys).anyMatch(s -> s.equalsIgnoreCase(key))) {
                    result.add(new Pair<Object, String>(key, headerValueSegment.toString()));
                    if (stopAtFirstMatch) {
                        return result;
                    }
                }
                headerKey = null;
                headerValueSegment = new StringBuilder();
            }
            if ((pair = line.split(HEADER_KEY_VALUE_SEPARATOR, 2)).length < 2) {
                Log.w(TAG, "parseHeaders - received malformed line: " + line);
                continue;
            }
            headerKey = pair[0].trim();
            for (int i = 1; i < pair.length; ++i) {
                headerValueSegment.append(SipMessageParsingUtils.removeLeadingWhitespace(pair[i]));
            }
        }
        if (headerKey != null) {
            String key = headerKey;
            if (matchingHeaderKeys == null || matchingHeaderKeys.length == 0 || Arrays.stream(matchingHeaderKeys).anyMatch(s -> s.equalsIgnoreCase(key))) {
                result.add(new Pair<Object, String>(key, headerValueSegment.toString()));
            }
        }
        return result;
    }

    private static String removeLeadingWhitespace(String line) {
        return line.replaceFirst("^\\s*", "");
    }
}

