/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.power;

import android.os.Parcel;
import android.text.TextUtils;
import android.util.DebugUtils;
import android.util.Slog;
import android.view.Display;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

@VisibleForTesting
public class MeasuredEnergyStats {
    private static final String TAG = "MeasuredEnergyStats";
    public static final int POWER_BUCKET_UNKNOWN = -1;
    public static final int POWER_BUCKET_SCREEN_ON = 0;
    public static final int POWER_BUCKET_SCREEN_DOZE = 1;
    public static final int POWER_BUCKET_SCREEN_OTHER = 2;
    public static final int POWER_BUCKET_CPU = 3;
    public static final int POWER_BUCKET_WIFI = 4;
    public static final int POWER_BUCKET_BLUETOOTH = 5;
    public static final int POWER_BUCKET_GNSS = 6;
    public static final int POWER_BUCKET_MOBILE_RADIO = 7;
    public static final int NUMBER_STANDARD_POWER_BUCKETS = 8;
    private final long[] mAccumulatedChargeMicroCoulomb;
    private final String[] mCustomBucketNames;

    public MeasuredEnergyStats(boolean[] supportedStandardBuckets, String[] customBucketNames) {
        this.mCustomBucketNames = customBucketNames == null ? new String[]{} : customBucketNames;
        int numTotalBuckets = 8 + this.mCustomBucketNames.length;
        this.mAccumulatedChargeMicroCoulomb = new long[numTotalBuckets];
        for (int stdBucket = 0; stdBucket < 8; ++stdBucket) {
            if (supportedStandardBuckets[stdBucket]) continue;
            this.mAccumulatedChargeMicroCoulomb[stdBucket] = -1L;
        }
    }

    private MeasuredEnergyStats(MeasuredEnergyStats template) {
        int numIndices = template.getNumberOfIndices();
        this.mAccumulatedChargeMicroCoulomb = new long[numIndices];
        for (int stdBucket = 0; stdBucket < 8; ++stdBucket) {
            if (template.isIndexSupported(stdBucket)) continue;
            this.mAccumulatedChargeMicroCoulomb[stdBucket] = -1L;
        }
        this.mCustomBucketNames = template.getCustomBucketNames();
    }

    public static MeasuredEnergyStats createFromTemplate(MeasuredEnergyStats template) {
        return new MeasuredEnergyStats(template);
    }

    private MeasuredEnergyStats(int numIndices) {
        this.mAccumulatedChargeMicroCoulomb = new long[numIndices];
        this.mCustomBucketNames = new String[numIndices - 8];
    }

    public MeasuredEnergyStats(Parcel in) {
        int size = in.readInt();
        this.mAccumulatedChargeMicroCoulomb = new long[size];
        in.readLongArray(this.mAccumulatedChargeMicroCoulomb);
        this.mCustomBucketNames = in.readStringArray();
    }

    public void writeToParcel(Parcel out) {
        out.writeInt(this.mAccumulatedChargeMicroCoulomb.length);
        out.writeLongArray(this.mAccumulatedChargeMicroCoulomb);
        out.writeStringArray(this.mCustomBucketNames);
    }

    private void readSummaryFromParcel(Parcel in, boolean overwriteAvailability) {
        int numWrittenEntries = in.readInt();
        for (int entry = 0; entry < numWrittenEntries; ++entry) {
            int index = in.readInt();
            long chargeUC = in.readLong();
            if (overwriteAvailability) {
                this.mAccumulatedChargeMicroCoulomb[index] = chargeUC;
                continue;
            }
            this.setValueIfSupported(index, chargeUC);
        }
    }

    private void writeSummaryToParcel(Parcel out, boolean skipZero) {
        int posOfNumWrittenEntries = out.dataPosition();
        out.writeInt(0);
        int numWrittenEntries = 0;
        for (int index = 0; index < this.mAccumulatedChargeMicroCoulomb.length; ++index) {
            long charge = this.mAccumulatedChargeMicroCoulomb[index];
            if (charge < 0L || charge == 0L && skipZero) continue;
            out.writeInt(index);
            out.writeLong(charge);
            ++numWrittenEntries;
        }
        int currPos = out.dataPosition();
        out.setDataPosition(posOfNumWrittenEntries);
        out.writeInt(numWrittenEntries);
        out.setDataPosition(currPos);
    }

    private int getNumberOfIndices() {
        return this.mAccumulatedChargeMicroCoulomb.length;
    }

    public void updateStandardBucket(int bucket, long chargeDeltaUC) {
        MeasuredEnergyStats.checkValidStandardBucket(bucket);
        this.updateEntry(bucket, chargeDeltaUC);
    }

    public void updateCustomBucket(int customBucket, long chargeDeltaUC) {
        if (!this.isValidCustomBucket(customBucket)) {
            Slog.e(TAG, "Attempted to update invalid custom bucket " + customBucket);
            return;
        }
        int index = MeasuredEnergyStats.customBucketToIndex(customBucket);
        this.updateEntry(index, chargeDeltaUC);
    }

    private void updateEntry(int index, long chargeDeltaUC) {
        if (this.mAccumulatedChargeMicroCoulomb[index] >= 0L) {
            int n = index;
            this.mAccumulatedChargeMicroCoulomb[n] = this.mAccumulatedChargeMicroCoulomb[n] + chargeDeltaUC;
        } else {
            Slog.wtf(TAG, "Attempting to add " + chargeDeltaUC + " to unavailable bucket " + this.getBucketName(index) + " whose value was " + this.mAccumulatedChargeMicroCoulomb[index]);
        }
    }

    public long getAccumulatedStandardBucketCharge(int bucket) {
        MeasuredEnergyStats.checkValidStandardBucket(bucket);
        return this.mAccumulatedChargeMicroCoulomb[bucket];
    }

    @VisibleForTesting
    public long getAccumulatedCustomBucketCharge(int customBucket) {
        if (!this.isValidCustomBucket(customBucket)) {
            return -1L;
        }
        return this.mAccumulatedChargeMicroCoulomb[MeasuredEnergyStats.customBucketToIndex(customBucket)];
    }

    public long[] getAccumulatedCustomBucketCharges() {
        long[] charges = new long[this.getNumberCustomPowerBuckets()];
        for (int bucket = 0; bucket < charges.length; ++bucket) {
            charges[bucket] = this.mAccumulatedChargeMicroCoulomb[MeasuredEnergyStats.customBucketToIndex(bucket)];
        }
        return charges;
    }

    public static int getDisplayPowerBucket(int screenState) {
        if (Display.isOnState(screenState)) {
            return 0;
        }
        if (Display.isDozeState(screenState)) {
            return 1;
        }
        return 2;
    }

    public static MeasuredEnergyStats createAndReadSummaryFromParcel(Parcel in) {
        int arraySize = in.readInt();
        if (arraySize == 0) {
            return null;
        }
        String[] customBucketNames = in.readBoolean() ? in.readStringArray() : new String[]{};
        MeasuredEnergyStats stats = new MeasuredEnergyStats(new boolean[8], customBucketNames);
        stats.readSummaryFromParcel(in, true);
        return stats;
    }

    public static MeasuredEnergyStats createAndReadSummaryFromParcel(Parcel in, MeasuredEnergyStats template) {
        int arraySize = in.readInt();
        if (arraySize == 0) {
            return null;
        }
        boolean includesCustomBucketNames = in.readBoolean();
        if (includesCustomBucketNames) {
            in.readStringArray();
        }
        if (template == null) {
            MeasuredEnergyStats mes = new MeasuredEnergyStats(arraySize);
            mes.readSummaryFromParcel(in, false);
            return null;
        }
        if (arraySize != template.getNumberOfIndices()) {
            Slog.wtf(TAG, "Size of MeasuredEnergyStats parcel (" + arraySize + ") does not match template (" + template.getNumberOfIndices() + ").");
            MeasuredEnergyStats mes = new MeasuredEnergyStats(arraySize);
            mes.readSummaryFromParcel(in, false);
            return null;
        }
        MeasuredEnergyStats stats = MeasuredEnergyStats.createFromTemplate(template);
        stats.readSummaryFromParcel(in, false);
        if (stats.containsInterestingData()) {
            return stats;
        }
        return null;
    }

    private boolean containsInterestingData() {
        for (int index = 0; index < this.mAccumulatedChargeMicroCoulomb.length; ++index) {
            if (this.mAccumulatedChargeMicroCoulomb[index] <= 0L) continue;
            return true;
        }
        return false;
    }

    public static void writeSummaryToParcel(MeasuredEnergyStats stats, Parcel dest, boolean skipZero, boolean skipCustomBucketNames) {
        if (stats == null) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(stats.getNumberOfIndices());
        if (!skipCustomBucketNames) {
            dest.writeBoolean(true);
            dest.writeStringArray(stats.getCustomBucketNames());
        } else {
            dest.writeBoolean(false);
        }
        stats.writeSummaryToParcel(dest, skipZero);
    }

    private void reset() {
        int numIndices = this.getNumberOfIndices();
        for (int index = 0; index < numIndices; ++index) {
            this.setValueIfSupported(index, 0L);
        }
    }

    public static void resetIfNotNull(MeasuredEnergyStats stats) {
        if (stats != null) {
            stats.reset();
        }
    }

    private void setValueIfSupported(int index, long value2) {
        if (this.mAccumulatedChargeMicroCoulomb[index] != -1L) {
            this.mAccumulatedChargeMicroCoulomb[index] = value2;
        }
    }

    public boolean isStandardBucketSupported(int bucket) {
        MeasuredEnergyStats.checkValidStandardBucket(bucket);
        return this.isIndexSupported(bucket);
    }

    private boolean isIndexSupported(int index) {
        return this.mAccumulatedChargeMicroCoulomb[index] != -1L;
    }

    public boolean isSupportEqualTo(boolean[] queriedStandardBuckets, String[] customBucketNames) {
        int numCustomBuckets;
        if (customBucketNames == null) {
            customBucketNames = new String[]{};
        }
        int numBuckets = this.getNumberOfIndices();
        int n = numCustomBuckets = customBucketNames == null ? 0 : customBucketNames.length;
        if (numBuckets != 8 + numCustomBuckets) {
            return false;
        }
        if (!Arrays.equals(this.mCustomBucketNames, customBucketNames)) {
            return false;
        }
        for (int stdBucket = 0; stdBucket < 8; ++stdBucket) {
            if (this.isStandardBucketSupported(stdBucket) == queriedStandardBuckets[stdBucket]) continue;
            return false;
        }
        return true;
    }

    public String[] getCustomBucketNames() {
        return this.mCustomBucketNames;
    }

    public void dump(PrintWriter pw) {
        pw.print("   ");
        for (int index = 0; index < this.mAccumulatedChargeMicroCoulomb.length; ++index) {
            pw.print(this.getBucketName(index));
            pw.print(" : ");
            pw.print(this.mAccumulatedChargeMicroCoulomb[index]);
            if (!this.isIndexSupported(index)) {
                pw.print(" (unsupported)");
            }
            if (index == this.mAccumulatedChargeMicroCoulomb.length - 1) continue;
            pw.print(", ");
        }
        pw.println();
    }

    private String getBucketName(int index) {
        if (MeasuredEnergyStats.isValidStandardBucket(index)) {
            return DebugUtils.valueToString(MeasuredEnergyStats.class, "POWER_BUCKET_", index);
        }
        int customBucket = MeasuredEnergyStats.indexToCustomBucket(index);
        StringBuilder name = new StringBuilder().append("CUSTOM_").append(customBucket);
        if (this.mCustomBucketNames != null && !TextUtils.isEmpty(this.mCustomBucketNames[customBucket])) {
            name.append('(').append(this.mCustomBucketNames[customBucket]).append(')');
        }
        return name.toString();
    }

    public int getNumberCustomPowerBuckets() {
        return this.mAccumulatedChargeMicroCoulomb.length - 8;
    }

    private static int customBucketToIndex(int customBucket) {
        return customBucket + 8;
    }

    private static int indexToCustomBucket(int index) {
        return index - 8;
    }

    private static void checkValidStandardBucket(int bucket) {
        if (!MeasuredEnergyStats.isValidStandardBucket(bucket)) {
            throw new IllegalArgumentException("Illegal StandardPowerBucket " + bucket);
        }
    }

    private static boolean isValidStandardBucket(int bucket) {
        return bucket >= 0 && bucket < 8;
    }

    @VisibleForTesting
    public boolean isValidCustomBucket(int customBucket) {
        return customBucket >= 0 && MeasuredEnergyStats.customBucketToIndex(customBucket) < this.mAccumulatedChargeMicroCoulomb.length;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StandardPowerBucket {
    }
}

