/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.util.ArrayUtils;
import java.util.List;

public class UserPowerCalculator
extends PowerCalculator {
    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        int[] userIds = query.getUserIds();
        if (ArrayUtils.contains(userIds, -1)) {
            return;
        }
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            int userId;
            UidBatteryConsumer.Builder uidBuilder = uidBatteryConsumerBuilders.valueAt(i);
            int uid = uidBuilder.getUid();
            if (UserHandle.getAppId(uid) < 10000 || ArrayUtils.contains(userIds, userId = UserHandle.getUserId(uid))) continue;
            uidBuilder.excludeFromBatteryUsageStats();
            builder2.getOrCreateUserBatteryConsumerBuilder(userId).addUidBatteryConsumer(uidBuilder);
        }
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        BatterySipper sipper;
        int i;
        boolean forAllUsers;
        boolean bl = forAllUsers = asUsers.get(-1) != null;
        if (forAllUsers) {
            return;
        }
        SparseArray<BatterySipper> userSippers = new SparseArray<BatterySipper>();
        for (i = sippers.size() - 1; i >= 0; --i) {
            sipper = sippers.get(i);
            int uid = sipper.getUid();
            int userId = UserHandle.getUserId(uid);
            if (asUsers.get(userId) != null || UserHandle.getAppId(uid) < 10000) continue;
            BatterySipper userSipper = (BatterySipper)userSippers.get(userId);
            if (userSipper == null) {
                userSipper = new BatterySipper(BatterySipper.DrainType.USER, null, 0.0);
                userSipper.userId = userId;
                userSippers.put(userId, userSipper);
            }
            userSipper.add(sipper);
            sipper.isAggregated = true;
        }
        for (i = 0; i < userSippers.size(); ++i) {
            sipper = (BatterySipper)userSippers.valueAt(i);
            if (!(sipper.sumPower() > 0.0)) continue;
            sippers.add(sipper);
        }
    }
}

