/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseLongArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.List;

public class ScreenPowerCalculator
extends PowerCalculator {
    private static final String TAG = "ScreenPowerCalculator";
    private static final boolean DEBUG = false;
    public static final long MIN_ACTIVE_TIME_FOR_SMEARING = 600000L;
    private final UsageBasedPowerEstimator mScreenOnPowerEstimator;
    private final UsageBasedPowerEstimator mScreenFullPowerEstimator;

    public ScreenPowerCalculator(PowerProfile powerProfile) {
        this.mScreenOnPowerEstimator = new UsageBasedPowerEstimator(powerProfile.getAveragePower("screen.on"));
        this.mScreenFullPowerEstimator = new UsageBasedPowerEstimator(powerProfile.getAveragePower("screen.full"));
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        PowerAndDuration totalPowerAndDuration = new PowerAndDuration();
        long consumptionUC = batteryStats.getScreenOnMeasuredBatteryConsumptionUC();
        int powerModel = ScreenPowerCalculator.getPowerModel(consumptionUC, query);
        this.calculateTotalDurationAndPower(totalPowerAndDuration, powerModel, batteryStats, rawRealtimeUs, 0, consumptionUC);
        double totalAppPower = 0.0;
        long totalAppDuration = 0L;
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        switch (powerModel) {
            case 2: {
                PowerAndDuration appPowerAndDuration = new PowerAndDuration();
                for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
                    UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
                    this.calculateAppUsingMeasuredEnergy(appPowerAndDuration, app.getBatteryStatsUid(), rawRealtimeUs);
                    ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(0, appPowerAndDuration.durationMs)).setConsumedPower(0, appPowerAndDuration.powerMah, powerModel);
                    totalAppPower += appPowerAndDuration.powerMah;
                    totalAppDuration += appPowerAndDuration.durationMs;
                }
                break;
            }
            default: {
                this.smearScreenBatteryDrain(uidBatteryConsumerBuilders, totalPowerAndDuration, rawRealtimeUs);
                totalAppPower = totalPowerAndDuration.powerMah;
                totalAppDuration = totalPowerAndDuration.durationMs;
            }
        }
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setConsumedPower(0, Math.max(totalPowerAndDuration.powerMah, totalAppPower), powerModel)).setUsageDurationMillis(0, totalPowerAndDuration.durationMs);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(1).setConsumedPower(0, totalAppPower, powerModel)).setUsageDurationMillis(0, totalAppDuration);
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        PowerAndDuration totalPowerAndDuration = new PowerAndDuration();
        long consumptionUC = batteryStats.getScreenOnMeasuredBatteryConsumptionUC();
        int powerModel = ScreenPowerCalculator.getPowerModel(consumptionUC);
        this.calculateTotalDurationAndPower(totalPowerAndDuration, powerModel, batteryStats, rawRealtimeUs, statsType, consumptionUC);
        if (totalPowerAndDuration.powerMah == 0.0) {
            return;
        }
        BatterySipper bs = new BatterySipper(BatterySipper.DrainType.SCREEN, null, 0.0);
        bs.usagePowerMah = totalPowerAndDuration.powerMah;
        bs.usageTimeMs = totalPowerAndDuration.durationMs;
        bs.sumPower();
        sippers.add(bs);
        switch (powerModel) {
            case 2: {
                PowerAndDuration appPowerAndDuration = new PowerAndDuration();
                for (int i = sippers.size() - 1; i >= 0; --i) {
                    BatterySipper app = sippers.get(i);
                    if (app.drainType != BatterySipper.DrainType.APP) continue;
                    this.calculateAppUsingMeasuredEnergy(appPowerAndDuration, app.uidObj, rawRealtimeUs);
                    app.screenPowerMah = appPowerAndDuration.powerMah;
                }
                break;
            }
            default: {
                this.smearScreenBatterySipper(sippers, bs, rawRealtimeUs);
            }
        }
    }

    private void calculateTotalDurationAndPower(PowerAndDuration totalPowerAndDuration, int powerModel, BatteryStats batteryStats, long rawRealtimeUs, int statsType, long consumptionUC) {
        totalPowerAndDuration.durationMs = this.calculateDuration(batteryStats, rawRealtimeUs, statsType);
        switch (powerModel) {
            case 2: {
                totalPowerAndDuration.powerMah = ScreenPowerCalculator.uCtoMah(consumptionUC);
                break;
            }
            default: {
                totalPowerAndDuration.powerMah = this.calculateTotalPowerFromBrightness(batteryStats, rawRealtimeUs, statsType, totalPowerAndDuration.durationMs);
            }
        }
    }

    private void calculateAppUsingMeasuredEnergy(PowerAndDuration appPowerAndDuration, BatteryStats.Uid u, long rawRealtimeUs) {
        appPowerAndDuration.durationMs = this.getProcessForegroundTimeMs(u, rawRealtimeUs);
        long chargeUC = u.getScreenOnMeasuredBatteryConsumptionUC();
        if (chargeUC < 0L) {
            Slog.wtf(TAG, "Screen energy not supported, so calculateApp shouldn't de called");
            appPowerAndDuration.powerMah = 0.0;
            return;
        }
        appPowerAndDuration.powerMah = ScreenPowerCalculator.uCtoMah(chargeUC);
    }

    private long calculateDuration(BatteryStats batteryStats, long rawRealtimeUs, int statsType) {
        return batteryStats.getScreenOnTime(rawRealtimeUs, statsType) / 1000L;
    }

    private double calculateTotalPowerFromBrightness(BatteryStats batteryStats, long rawRealtimeUs, int statsType, long durationMs) {
        double power = this.mScreenOnPowerEstimator.calculatePower(durationMs);
        for (int i = 0; i < 5; ++i) {
            long brightnessTime = batteryStats.getScreenBrightnessTime(i, rawRealtimeUs, statsType) / 1000L;
            double binPowerMah = this.mScreenFullPowerEstimator.calculatePower(brightnessTime) * (double)((float)i + 0.5f) / 5.0;
            power += binPowerMah;
        }
        return power;
    }

    @VisibleForTesting
    public void smearScreenBatterySipper(List<BatterySipper> sippers, BatterySipper screenSipper, long rawRealtimeUs) {
        long totalActivityTimeMs = 0L;
        SparseLongArray activityTimeArray = new SparseLongArray();
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatteryStats.Uid uid = sippers.get((int)i).uidObj;
            if (uid == null) continue;
            long timeMs = this.getProcessForegroundTimeMs(uid, rawRealtimeUs);
            activityTimeArray.put(uid.getUid(), timeMs);
            totalActivityTimeMs += timeMs;
        }
        if (screenSipper != null && totalActivityTimeMs >= 600000L) {
            double totalScreenPowerMah = screenSipper.totalPowerMah;
            for (int i = sippers.size() - 1; i >= 0; --i) {
                BatterySipper sipper = sippers.get(i);
                sipper.screenPowerMah = totalScreenPowerMah * (double)activityTimeArray.get(sipper.getUid(), 0L) / (double)totalActivityTimeMs;
            }
        }
    }

    private void smearScreenBatteryDrain(SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders, PowerAndDuration totalPowerAndDuration, long rawRealtimeUs) {
        long totalActivityTimeMs = 0L;
        SparseLongArray activityTimeArray = new SparseLongArray();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            BatteryStats.Uid uid = uidBatteryConsumerBuilders.valueAt(i).getBatteryStatsUid();
            long timeMs = this.getProcessForegroundTimeMs(uid, rawRealtimeUs);
            activityTimeArray.put(uid.getUid(), timeMs);
            totalActivityTimeMs += timeMs;
        }
        if (totalActivityTimeMs >= 600000L) {
            double totalScreenPowerMah = totalPowerAndDuration.powerMah;
            for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
                UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
                long durationMs = activityTimeArray.get(app.getUid(), 0L);
                double powerMah = totalScreenPowerMah * (double)durationMs / (double)totalActivityTimeMs;
                ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(0, durationMs)).setConsumedPower(0, powerMah, 1);
            }
        }
    }

    @VisibleForTesting
    public long getProcessForegroundTimeMs(BatteryStats.Uid uid, long rawRealTimeUs) {
        int[] foregroundTypes = new int[]{0};
        long timeUs = 0L;
        for (int type : foregroundTypes) {
            long localTime = uid.getProcessStateTime(type, rawRealTimeUs, 0);
            timeUs += localTime;
        }
        return Math.min(timeUs, this.getForegroundActivityTotalTimeUs(uid, rawRealTimeUs)) / 1000L;
    }

    @VisibleForTesting
    public long getForegroundActivityTotalTimeUs(BatteryStats.Uid uid, long rawRealtimeUs) {
        BatteryStats.Timer timer = uid.getForegroundActivityTimer();
        if (timer == null) {
            return 0L;
        }
        return timer.getTotalTimeLocked(rawRealtimeUs, 0);
    }

    private static class PowerAndDuration {
        public long durationMs;
        public double powerMah;

        private PowerAndDuration() {
        }
    }
}

