/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;

public abstract class PowerCalculator {
    protected static final double MILLIAMPHOUR_PER_MICROCOULOMB = 2.777777777777778E-7;

    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper app = sippers.get(i);
            if (app.drainType != BatterySipper.DrainType.APP) continue;
            this.calculateApp(app, app.uidObj, rawRealtimeUs, rawUptimeUs, statsType);
        }
    }

    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder2.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            this.calculateApp(app, app.getBatteryStatsUid(), rawRealtimeUs, rawUptimeUs, query);
        }
    }

    protected void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
    }

    protected void calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
    }

    public void reset() {
    }

    protected static int getPowerModel(long measuredEnergyUC, BatteryUsageStatsQuery query) {
        if (measuredEnergyUC != -1L && !query.shouldForceUsePowerProfileModel()) {
            return 2;
        }
        return 1;
    }

    protected static int getPowerModel(long measuredEnergyUC) {
        return measuredEnergyUC != -1L ? 2 : 1;
    }

    protected static double getMeasuredOrEstimatedPower(int powerModel, long measuredEnergyUC, UsageBasedPowerEstimator powerEstimator, long durationMs) {
        switch (powerModel) {
            case 2: {
                return PowerCalculator.uCtoMah(measuredEnergyUC);
            }
        }
        return powerEstimator.calculatePower(durationMs);
    }

    protected static double getMeasuredOrEstimatedPower(long measuredEnergyUC, UsageBasedPowerEstimator powerEstimator, long durationMs) {
        if (measuredEnergyUC != -1L) {
            return PowerCalculator.uCtoMah(measuredEnergyUC);
        }
        return powerEstimator.calculatePower(durationMs);
    }

    public static void printPowerMah(PrintWriter pw, double powerMah) {
        pw.print(PowerCalculator.formatCharge(powerMah));
    }

    public static String formatCharge(double power) {
        if (power == 0.0) {
            return "0";
        }
        String format = power < 1.0E-5 ? "%.8f" : (power < 1.0E-4 ? "%.7f" : (power < 0.001 ? "%.6f" : (power < 0.01 ? "%.5f" : (power < 0.1 ? "%.4f" : (power < 1.0 ? "%.3f" : (power < 10.0 ? "%.2f" : (power < 100.0 ? "%.1f" : "%.0f")))))));
        return String.format(Locale.ENGLISH, format, power);
    }

    static double uCtoMah(long chargeUC) {
        return (double)chargeUC * 2.777777777777778E-7;
    }
}

