/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.List;

public class PhonePowerCalculator
extends PowerCalculator {
    private final UsageBasedPowerEstimator mPowerEstimator;

    public PhonePowerCalculator(PowerProfile powerProfile) {
        this.mPowerEstimator = new UsageBasedPowerEstimator(powerProfile.getAveragePower("radio.active"));
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long phoneOnTimeMs = batteryStats.getPhoneOnTime(rawRealtimeUs, 0) / 1000L;
        double phoneOnPower = this.mPowerEstimator.calculatePower(phoneOnTimeMs);
        if (phoneOnPower != 0.0) {
            ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setConsumedPower(14, phoneOnPower)).setUsageDurationMillis(14, phoneOnTimeMs);
        }
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        long phoneOnTimeMs = batteryStats.getPhoneOnTime(rawRealtimeUs, statsType) / 1000L;
        double phoneOnPower = this.mPowerEstimator.calculatePower(phoneOnTimeMs);
        if (phoneOnPower != 0.0) {
            BatterySipper bs = new BatterySipper(BatterySipper.DrainType.PHONE, null, 0.0);
            bs.usagePowerMah = phoneOnPower;
            bs.usageTimeMs = phoneOnTimeMs;
            bs.sumPower();
            sippers.add(bs);
        }
    }
}

