/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class MediaPowerCalculator
extends PowerCalculator {
    private static final int MS_IN_HR = 3600000;
    private final double mAudioAveragePowerMa;
    private final double mVideoAveragePowerMa;

    public MediaPowerCalculator(PowerProfile profile) {
        this.mAudioAveragePowerMa = profile.getAveragePower("audio");
        this.mVideoAveragePowerMa = profile.getAveragePower("video");
    }

    @Override
    protected void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.Timer audioTimer = u.getAudioTurnedOnTimer();
        if (audioTimer == null) {
            app.audioTimeMs = 0L;
            app.audioPowerMah = 0.0;
        } else {
            long totalTime;
            app.audioTimeMs = totalTime = audioTimer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
            app.audioPowerMah = (double)totalTime * this.mAudioAveragePowerMa / 3600000.0;
        }
        BatteryStats.Timer videoTimer = u.getVideoTurnedOnTimer();
        if (videoTimer == null) {
            app.videoTimeMs = 0L;
            app.videoPowerMah = 0.0;
        } else {
            long totalTime;
            app.videoTimeMs = totalTime = videoTimer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
            app.videoPowerMah = (double)totalTime * this.mVideoAveragePowerMa / 3600000.0;
        }
    }
}

