/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.List;

public class IdlePowerCalculator
extends PowerCalculator {
    private static final String TAG = "IdlePowerCalculator";
    private static final boolean DEBUG = false;
    private final double mAveragePowerCpuSuspendMahPerUs;
    private final double mAveragePowerCpuIdleMahPerUs;
    public long mDurationMs;
    public double mPowerMah;

    public IdlePowerCalculator(PowerProfile powerProfile) {
        this.mAveragePowerCpuSuspendMahPerUs = powerProfile.getAveragePower("cpu.suspend") / 3.6E9;
        this.mAveragePowerCpuIdleMahPerUs = powerProfile.getAveragePower("cpu.idle") / 3.6E9;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        this.calculatePowerAndDuration(batteryStats, rawRealtimeUs, rawUptimeUs, 0);
        if (this.mPowerMah != 0.0) {
            ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setConsumedPower(16, this.mPowerMah)).setUsageDurationMillis(16, this.mDurationMs);
        }
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        this.calculatePowerAndDuration(batteryStats, rawRealtimeUs, rawUptimeUs, statsType);
        if (this.mPowerMah != 0.0) {
            BatterySipper bs = new BatterySipper(BatterySipper.DrainType.IDLE, null, 0.0);
            bs.usagePowerMah = this.mPowerMah;
            bs.usageTimeMs = this.mDurationMs;
            bs.sumPower();
            sippers.add(bs);
        }
    }

    private void calculatePowerAndDuration(BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long batteryRealtimeUs = batteryStats.computeBatteryRealtime(rawRealtimeUs, statsType);
        long batteryUptimeUs = batteryStats.computeBatteryUptime(rawUptimeUs, statsType);
        double suspendPowerMah = (double)batteryRealtimeUs * this.mAveragePowerCpuSuspendMahPerUs;
        double idlePowerMah = (double)batteryUptimeUs * this.mAveragePowerCpuIdleMahPerUs;
        this.mPowerMah = suspendPowerMah + idlePowerMah;
        this.mDurationMs = batteryRealtimeUs / 1000L;
    }
}

