/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.ProxyFileDescriptorCallback;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.FuseUnavailableMountException;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;

public class FuseAppLoop
implements Handler.Callback {
    private static final String TAG = "FuseAppLoop";
    private static final boolean DEBUG = Log.isLoggable("FuseAppLoop", 3);
    public static final int ROOT_INODE = 1;
    private static final int MIN_INODE = 2;
    private static final ThreadFactory sDefaultThreadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, FuseAppLoop.TAG);
        }
    };
    private static final int FUSE_OK = 0;
    private static final int ARGS_POOL_SIZE = 50;
    private final Object mLock = new Object();
    private final int mMountPointId;
    private final Thread mThread;
    @GuardedBy(value={"mLock"})
    private final SparseArray<CallbackEntry> mCallbackMap = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final BytesMap mBytesMap = new BytesMap();
    @GuardedBy(value={"mLock"})
    private final LinkedList<Args> mArgsPool = new LinkedList();
    @GuardedBy(value={"mLock"})
    private int mNextInode = 2;
    @GuardedBy(value={"mLock"})
    private long mInstance;
    private static final int FUSE_LOOKUP = 1;
    private static final int FUSE_GETATTR = 3;
    private static final int FUSE_OPEN = 14;
    private static final int FUSE_READ = 15;
    private static final int FUSE_WRITE = 16;
    private static final int FUSE_RELEASE = 18;
    private static final int FUSE_FSYNC = 20;
    private static final int FUSE_MAX_WRITE = 131072;

    public FuseAppLoop(int mountPointId, ParcelFileDescriptor fd, ThreadFactory factory) {
        this.mMountPointId = mountPointId;
        if (factory == null) {
            factory = sDefaultThreadFactory;
        }
        this.mInstance = this.native_new(fd.detachFd());
        this.mThread = factory.newThread(() -> {
            this.native_start(this.mInstance);
            Object object = this.mLock;
            synchronized (object) {
                this.native_delete(this.mInstance);
                this.mInstance = 0L;
                this.mBytesMap.clear();
            }
        });
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerCallback(ProxyFileDescriptorCallback callback2, Handler handler) throws FuseUnavailableMountException {
        Object object = this.mLock;
        synchronized (object) {
            int id2;
            Objects.requireNonNull(callback2);
            Objects.requireNonNull(handler);
            Preconditions.checkState(this.mCallbackMap.size() < 0x7FFFFFFD, "Too many opened files.");
            Preconditions.checkArgument(Thread.currentThread().getId() != handler.getLooper().getThread().getId(), "Handler must be different from the current thread");
            if (this.mInstance == 0L) {
                throw new FuseUnavailableMountException(this.mMountPointId);
            }
            do {
                id2 = this.mNextInode++;
                if (this.mNextInode >= 0) continue;
                this.mNextInode = 2;
            } while (this.mCallbackMap.get(id2) != null);
            this.mCallbackMap.put(id2, new CallbackEntry(callback2, new Handler(handler.getLooper(), this)));
            return id2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(int id2) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackMap.remove(id2);
        }
    }

    public int getMountPointId() {
        return this.mMountPointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(Message msg) {
        Args args = (Args)msg.obj;
        CallbackEntry entry = args.entry;
        long inode = args.inode;
        long unique = args.unique;
        int size = args.size;
        long offset2 = args.offset;
        byte[] data = args.data;
        try {
            switch (msg.what) {
                case 1: {
                    long fileSize = entry.callback.onGetSize();
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replyLookup(this.mInstance, unique, inode, fileSize);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 3: {
                    long fileSize = entry.callback.onGetSize();
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replyGetAttr(this.mInstance, unique, inode, fileSize);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 15: {
                    int readSize = entry.callback.onRead(offset2, size, data);
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replyRead(this.mInstance, unique, readSize, data);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 16: {
                    int writeSize = entry.callback.onWrite(offset2, size, data);
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replyWrite(this.mInstance, unique, writeSize);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 20: {
                    entry.callback.onFsync();
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replySimple(this.mInstance, unique, 0);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 18: {
                    entry.callback.onRelease();
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replySimple(this.mInstance, unique, 0);
                        }
                        this.mBytesMap.stopUsing(inode);
                        this.recycleLocked(args);
                        break;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown FUSE command: " + msg.what);
                }
            }
        }
        catch (Exception error) {
            Object object = this.mLock;
            synchronized (object) {
                Log.e(TAG, "", error);
                this.replySimpleLocked(unique, FuseAppLoop.getError(error));
                this.recycleLocked(args);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void onCommand(int command, long unique, long inode, long offset2, int size, byte[] data) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                Args args = this.mArgsPool.size() == 0 ? new Args() : this.mArgsPool.pop();
                args.unique = unique;
                args.inode = inode;
                args.offset = offset2;
                args.size = size;
                args.data = data;
                args.entry = this.getCallbackEntryOrThrowLocked(inode);
                if (!args.entry.handler.sendMessage(Message.obtain(args.entry.handler, command, 0, 0, args))) {
                    throw new ErrnoException("onCommand", OsConstants.EBADF);
                }
            }
            catch (Exception error) {
                this.replySimpleLocked(unique, FuseAppLoop.getError(error));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private byte[] onOpen(long unique, long inode) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                CallbackEntry entry = this.getCallbackEntryOrThrowLocked(inode);
                if (entry.opened) {
                    throw new ErrnoException("onOpen", OsConstants.EMFILE);
                }
                if (this.mInstance != 0L) {
                    this.native_replyOpen(this.mInstance, unique, inode);
                    entry.opened = true;
                    return this.mBytesMap.startUsing(inode);
                }
            }
            catch (ErrnoException error) {
                this.replySimpleLocked(unique, FuseAppLoop.getError(error));
            }
            return null;
        }
    }

    private static int getError(Exception error) {
        int errno;
        if (error instanceof ErrnoException && (errno = ((ErrnoException)error).errno) != OsConstants.ENOSYS) {
            return -errno;
        }
        return -OsConstants.EBADF;
    }

    @GuardedBy(value={"mLock"})
    private CallbackEntry getCallbackEntryOrThrowLocked(long inode) throws ErrnoException {
        CallbackEntry entry = this.mCallbackMap.get(FuseAppLoop.checkInode(inode));
        if (entry == null) {
            throw new ErrnoException("getCallbackEntryOrThrowLocked", OsConstants.ENOENT);
        }
        return entry;
    }

    @GuardedBy(value={"mLock"})
    private void recycleLocked(Args args) {
        if (this.mArgsPool.size() < 50) {
            this.mArgsPool.add(args);
        }
    }

    @GuardedBy(value={"mLock"})
    private void replySimpleLocked(long unique, int result) {
        if (this.mInstance != 0L) {
            this.native_replySimple(this.mInstance, unique, result);
        }
    }

    long native_new(int n) {
        return OverrideMethod.invokeL("com.android.internal.os.FuseAppLoop#native_new(I)J", true, this);
    }

    void native_delete(long l) {
        OverrideMethod.invokeV("com.android.internal.os.FuseAppLoop#native_delete(J)V", true, this);
    }

    void native_start(long l) {
        OverrideMethod.invokeV("com.android.internal.os.FuseAppLoop#native_start(J)V", true, this);
    }

    void native_replySimple(long l, long l2, int n) {
        OverrideMethod.invokeV("com.android.internal.os.FuseAppLoop#native_replySimple(JJI)V", true, this);
    }

    void native_replyOpen(long l, long l2, long l3) {
        OverrideMethod.invokeV("com.android.internal.os.FuseAppLoop#native_replyOpen(JJJ)V", true, this);
    }

    void native_replyLookup(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("com.android.internal.os.FuseAppLoop#native_replyLookup(JJJJ)V", true, this);
    }

    void native_replyGetAttr(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("com.android.internal.os.FuseAppLoop#native_replyGetAttr(JJJJ)V", true, this);
    }

    void native_replyWrite(long l, long l2, int n) {
        OverrideMethod.invokeV("com.android.internal.os.FuseAppLoop#native_replyWrite(JJI)V", true, this);
    }

    void native_replyRead(long l, long l2, int n, byte[] byArray) {
        OverrideMethod.invokeV("com.android.internal.os.FuseAppLoop#native_replyRead(JJI[B)V", true, this);
    }

    private static int checkInode(long inode) {
        Preconditions.checkArgumentInRange(inode, 2L, Integer.MAX_VALUE, "checkInode");
        return (int)inode;
    }

    private static class Args {
        long unique;
        long inode;
        long offset;
        int size;
        byte[] data;
        CallbackEntry entry;

        private Args() {
        }
    }

    private static class BytesMap {
        final Map<Long, BytesMapEntry> mEntries = new HashMap<Long, BytesMapEntry>();

        private BytesMap() {
        }

        byte[] startUsing(long inode) {
            BytesMapEntry entry = this.mEntries.get(inode);
            if (entry == null) {
                entry = new BytesMapEntry();
                this.mEntries.put(inode, entry);
            }
            ++entry.counter;
            return entry.bytes;
        }

        void stopUsing(long inode) {
            BytesMapEntry entry = this.mEntries.get(inode);
            Objects.requireNonNull(entry);
            --entry.counter;
            if (entry.counter <= 0) {
                this.mEntries.remove(inode);
            }
        }

        void clear() {
            this.mEntries.clear();
        }
    }

    private static class BytesMapEntry {
        int counter = 0;
        byte[] bytes = new byte[131072];

        private BytesMapEntry() {
        }
    }

    private static class CallbackEntry {
        final ProxyFileDescriptorCallback callback;
        final Handler handler;
        boolean opened;

        CallbackEntry(ProxyFileDescriptorCallback callback2, Handler handler) {
            this.callback = Objects.requireNonNull(callback2);
            this.handler = Objects.requireNonNull(handler);
        }

        long getThreadId() {
            return this.handler.getLooper().getThread().getId();
        }
    }

    public static class UnmountedException
    extends Exception {
    }
}

