/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;

public class CameraPowerCalculator
extends PowerCalculator {
    private final UsageBasedPowerEstimator mPowerEstimator;

    public CameraPowerCalculator(PowerProfile profile) {
        this.mPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("camera.avg"));
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        super.calculate(builder2, batteryStats, rawRealtimeUs, rawUptimeUs, query);
        long durationMs = batteryStats.getCameraOnTime(rawRealtimeUs, 0) / 1000L;
        double powerMah = this.mPowerEstimator.calculatePower(durationMs);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(3, durationMs)).setConsumedPower(3, powerMah);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(1).setUsageDurationMillis(3, durationMs)).setConsumedPower(3, powerMah);
    }

    @Override
    protected void calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long durationMs = this.mPowerEstimator.calculateDuration(u.getCameraTurnedOnTimer(), rawRealtimeUs, 0);
        double powerMah = this.mPowerEstimator.calculatePower(durationMs);
        ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(3, durationMs)).setConsumedPower(3, powerMah);
    }

    @Override
    protected void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long durationMs = this.mPowerEstimator.calculateDuration(u.getCameraTurnedOnTimer(), rawRealtimeUs, statsType);
        double powerMah = this.mPowerEstimator.calculatePower(durationMs);
        app.cameraTimeMs = durationMs;
        app.cameraPowerMah = powerMah;
    }
}

