/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.Handler;
import android.util.AtomicFile;
import android.util.LongArray;
import android.util.Slog;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.BatteryUsageStatsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.xmlpull.v1.XmlPullParserException;

public class BatteryUsageStatsStore {
    private static final String TAG = "BatteryUsageStatsStore";
    private static final List<BatteryUsageStatsQuery> BATTERY_USAGE_STATS_QUERY = List.of(new BatteryUsageStatsQuery.Builder().setMaxStatsAgeMs(0L).includePowerModels().build());
    private static final String BATTERY_USAGE_STATS_DIR = "battery-usage-stats";
    private static final String SNAPSHOT_FILE_EXTENSION = ".bus";
    private static final String DIR_LOCK_FILENAME = ".lock";
    private static final String CONFIG_FILENAME = "config";
    private static final String BATTERY_USAGE_STATS_BEFORE_RESET_TIMESTAMP_PROPERTY = "BATTERY_USAGE_STATS_BEFORE_RESET_TIMESTAMP";
    private static final long MAX_BATTERY_STATS_SNAPSHOT_STORAGE_BYTES = 102400L;
    private final Context mContext;
    private final BatteryStatsImpl mBatteryStats;
    private boolean mSystemReady;
    private final File mStoreDir;
    private final File mLockFile;
    private final AtomicFile mConfigFile;
    private final long mMaxStorageBytes;
    private final Handler mHandler;
    private final BatteryUsageStatsProvider mBatteryUsageStatsProvider;

    public BatteryUsageStatsStore(Context context, BatteryStatsImpl stats, File systemDir, Handler handler) {
        this(context, stats, systemDir, handler, 102400L);
    }

    @VisibleForTesting
    public BatteryUsageStatsStore(Context context, BatteryStatsImpl batteryStats, File systemDir, Handler handler, long maxStorageBytes) {
        this.mContext = context;
        this.mBatteryStats = batteryStats;
        this.mStoreDir = new File(systemDir, BATTERY_USAGE_STATS_DIR);
        this.mLockFile = new File(this.mStoreDir, DIR_LOCK_FILENAME);
        this.mConfigFile = new AtomicFile(new File(this.mStoreDir, CONFIG_FILENAME));
        this.mHandler = handler;
        this.mMaxStorageBytes = maxStorageBytes;
        this.mBatteryStats.setBatteryResetListener(this::prepareForBatteryStatsReset);
        this.mBatteryUsageStatsProvider = new BatteryUsageStatsProvider(this.mContext, this.mBatteryStats);
    }

    public void onSystemReady() {
        this.mSystemReady = true;
    }

    private void prepareForBatteryStatsReset(int resetReason) {
        if (resetReason == 1 || !this.mSystemReady) {
            return;
        }
        List<BatteryUsageStats> stats = this.mBatteryUsageStatsProvider.getBatteryUsageStats(BATTERY_USAGE_STATS_QUERY);
        if (stats.isEmpty()) {
            Slog.wtf(TAG, "No battery usage stats generated");
            return;
        }
        this.mHandler.post(() -> this.storeBatteryUsageStats((BatteryUsageStats)stats.get(0)));
    }

    private void storeBatteryUsageStats(BatteryUsageStats stats) {
        try (FileLock lock = this.lockSnapshotDirectory();){
            if (!this.mStoreDir.exists() && !this.mStoreDir.mkdirs()) {
                Slog.e(TAG, "Could not create a directory for battery usage stats snapshots");
                return;
            }
            File file2 = this.makeSnapshotFilename(stats.getStatsEndTimestamp());
            try {
                this.writeXmlFileLocked(stats, file2);
            }
            catch (Exception e) {
                Slog.e(TAG, "Cannot save battery usage stats", e);
            }
            this.removeOldSnapshotsLocked();
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot lock battery usage stats directory", e);
        }
    }

    public long[] listBatteryUsageStatsTimestamps() {
        LongArray timestamps = new LongArray(100);
        try (FileLock lock = this.lockSnapshotDirectory();){
            for (File file2 : this.mStoreDir.listFiles()) {
                String fileName = file2.getName();
                if (!fileName.endsWith(SNAPSHOT_FILE_EXTENSION)) continue;
                try {
                    String fileNameWithoutExtension = fileName.substring(0, fileName.length() - SNAPSHOT_FILE_EXTENSION.length());
                    timestamps.add(Long.parseLong(fileNameWithoutExtension));
                }
                catch (NumberFormatException e) {
                    Slog.wtf(TAG, "Invalid format of BatteryUsageStats snapshot file name: " + fileName);
                }
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot lock battery usage stats directory", e);
        }
        return timestamps.toArray();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public BatteryUsageStats loadBatteryUsageStats(long timestamp) {
        try {
            lock = this.lockSnapshotDirectory();
            try {
                file = this.makeSnapshotFilename(timestamp);
                try {
                    var5_6 = this.readXmlFileLocked(file);
                    return var5_6;
                }
                catch (Exception e) {
                    Slog.e("BatteryUsageStatsStore", "Cannot read battery usage stats", e);
                    ** if (lock == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        lock.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
            finally {
                if (lock != null) {
                    lock.close();
                }
            }
        }
        catch (IOException e) {
            Slog.e("BatteryUsageStatsStore", "Cannot lock battery usage stats directory", e);
        }
        return null;
    }

    public void setLastBatteryUsageStatsBeforeResetAtomPullTimestamp(long timestamp) {
        Properties props = new Properties();
        try (FileLock lock = this.lockSnapshotDirectory();){
            try (FileInputStream in = this.mConfigFile.openRead();){
                props.load(in);
            }
            catch (IOException e) {
                Slog.e(TAG, "Cannot load config file " + this.mConfigFile, e);
            }
            props.put(BATTERY_USAGE_STATS_BEFORE_RESET_TIMESTAMP_PROPERTY, String.valueOf(timestamp));
            FileOutputStream out = null;
            try {
                out = this.mConfigFile.startWrite();
                props.store(out, "Statsd atom pull timestamps");
                this.mConfigFile.finishWrite(out);
            }
            catch (IOException e) {
                this.mConfigFile.failWrite(out);
                Slog.e(TAG, "Cannot save config file " + this.mConfigFile, e);
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot lock battery usage stats directory", e);
        }
    }

    public long getLastBatteryUsageStatsBeforeResetAtomPullTimestamp() {
        Properties props = new Properties();
        try (FileLock lock = this.lockSnapshotDirectory();){
            try (FileInputStream in = this.mConfigFile.openRead();){
                props.load(in);
            }
            catch (IOException e) {
                Slog.e(TAG, "Cannot load config file " + this.mConfigFile, e);
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot lock battery usage stats directory", e);
        }
        return Long.parseLong(props.getProperty(BATTERY_USAGE_STATS_BEFORE_RESET_TIMESTAMP_PROPERTY, "0"));
    }

    private FileLock lockSnapshotDirectory() throws IOException {
        this.mLockFile.getParentFile().mkdirs();
        this.mLockFile.createNewFile();
        return FileChannel.open(this.mLockFile.toPath(), StandardOpenOption.WRITE).lock();
    }

    private File makeSnapshotFilename(long statsEndTimestamp) {
        return new File(this.mStoreDir, String.format(Locale.ENGLISH, "%019d", statsEndTimestamp) + SNAPSHOT_FILE_EXTENSION);
    }

    private void writeXmlFileLocked(BatteryUsageStats stats, File file2) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file2);){
            TypedXmlSerializer serializer = Xml.newBinarySerializer();
            serializer.setOutput(out, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            stats.writeXml(serializer);
            serializer.endDocument();
        }
    }

    private BatteryUsageStats readXmlFileLocked(File file2) throws IOException, XmlPullParserException {
        try (FileInputStream in = new FileInputStream(file2);){
            TypedXmlPullParser parser = Xml.newBinaryPullParser();
            parser.setInput(in, StandardCharsets.UTF_8.name());
            BatteryUsageStats batteryUsageStats = BatteryUsageStats.createFromXml(parser);
            return batteryUsageStats;
        }
    }

    private void removeOldSnapshotsLocked() {
        Map.Entry entry;
        long totalSize = 0L;
        TreeMap<File, Long> mFileSizes = new TreeMap<File, Long>();
        for (File file2 : this.mStoreDir.listFiles()) {
            long fileSize = file2.length();
            totalSize += fileSize;
            if (!file2.getName().endsWith(SNAPSHOT_FILE_EXTENSION)) continue;
            mFileSizes.put(file2, fileSize);
        }
        while (totalSize > this.mMaxStorageBytes && (entry = mFileSizes.firstEntry()) != null) {
            File file3 = (File)entry.getKey();
            if (!file3.delete()) {
                Slog.e(TAG, "Cannot delete battery usage stats " + file3);
            }
            totalSize -= ((Long)entry.getValue()).longValue();
            mFileSizes.remove(file3);
        }
    }
}

