/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.Parcel;
import android.os.StatFs;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.util.ParseUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class BatteryStatsHistory {
    private static final boolean DEBUG = false;
    private static final String TAG = "BatteryStatsHistory";
    public static final String HISTORY_DIR = "battery-history";
    public static final String FILE_SUFFIX = ".bin";
    private static final int MIN_FREE_SPACE = 0x6400000;
    private final BatteryStatsImpl mStats;
    private final Parcel mHistoryBuffer;
    private final File mHistoryDir;
    private AtomicFile mActiveFile;
    private final List<Integer> mFileNumbers = new ArrayList<Integer>();
    private List<Parcel> mHistoryParcels = null;
    private int mCurrentFileIndex;
    private Parcel mCurrentParcel;
    private int mCurrentParcelEnd;
    private int mRecordCount = 0;
    private int mParcelIndex = 0;

    public BatteryStatsHistory(BatteryStatsImpl stats, File systemDir, Parcel historyBuffer) {
        this.mStats = stats;
        this.mHistoryBuffer = historyBuffer;
        this.mHistoryDir = new File(systemDir, HISTORY_DIR);
        this.mHistoryDir.mkdirs();
        if (!this.mHistoryDir.exists()) {
            Slog.wtf(TAG, "HistoryDir does not exist:" + this.mHistoryDir.getPath());
        }
        final ArraySet dedup = new ArraySet();
        this.mHistoryDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int b = name.lastIndexOf(BatteryStatsHistory.FILE_SUFFIX);
                if (b <= 0) {
                    return false;
                }
                Integer c = ParseUtils.parseInt(name.substring(0, b), -1);
                if (c != -1) {
                    dedup.add(c);
                    return true;
                }
                return false;
            }
        });
        if (!dedup.isEmpty()) {
            this.mFileNumbers.addAll(dedup);
            Collections.sort(this.mFileNumbers);
            this.setActiveFile(this.mFileNumbers.get(this.mFileNumbers.size() - 1));
        } else {
            this.mFileNumbers.add(0);
            this.setActiveFile(0);
        }
    }

    public BatteryStatsHistory(Parcel historyBuffer) {
        this.mStats = null;
        this.mHistoryDir = null;
        this.mHistoryBuffer = historyBuffer;
    }

    private void setActiveFile(int fileNumber) {
        this.mActiveFile = this.getFile(fileNumber);
    }

    private AtomicFile getFile(int num) {
        return new AtomicFile(new File(this.mHistoryDir, num + FILE_SUFFIX));
    }

    public void startNextFile() {
        int oldest;
        if (this.mStats == null) {
            Slog.wtf(TAG, "mStats should not be null when writing history");
            return;
        }
        if (this.mFileNumbers.isEmpty()) {
            Slog.wtf(TAG, "mFileNumbers should never be empty");
            return;
        }
        int next = this.mFileNumbers.get(this.mFileNumbers.size() - 1) + 1;
        this.mFileNumbers.add(next);
        this.setActiveFile(next);
        if (!this.hasFreeDiskSpace()) {
            oldest = this.mFileNumbers.remove(0);
            this.getFile(oldest).delete();
        }
        while (this.mFileNumbers.size() > this.mStats.mConstants.MAX_HISTORY_FILES) {
            oldest = this.mFileNumbers.get(0);
            this.getFile(oldest).delete();
            this.mFileNumbers.remove(0);
        }
    }

    public void resetAllFiles() {
        for (Integer i : this.mFileNumbers) {
            this.getFile(i).delete();
        }
        this.mFileNumbers.clear();
        this.mFileNumbers.add(0);
        this.setActiveFile(0);
    }

    public boolean startIteratingHistory() {
        this.mRecordCount = 0;
        this.mCurrentFileIndex = 0;
        this.mCurrentParcel = null;
        this.mCurrentParcelEnd = 0;
        this.mParcelIndex = 0;
        return true;
    }

    public void finishIteratingHistory() {
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
    }

    public Parcel getNextParcel(BatteryStats.HistoryItem out) {
        Parcel p;
        if (this.mRecordCount == 0) {
            out.clear();
        }
        ++this.mRecordCount;
        if (this.mCurrentParcel != null) {
            if (this.mCurrentParcel.dataPosition() < this.mCurrentParcelEnd) {
                return this.mCurrentParcel;
            }
            if (this.mHistoryBuffer == this.mCurrentParcel) {
                return null;
            }
            if (this.mHistoryParcels == null || !this.mHistoryParcels.contains(this.mCurrentParcel)) {
                this.mCurrentParcel.recycle();
            }
        }
        while (this.mCurrentFileIndex < this.mFileNumbers.size() - 1) {
            AtomicFile file2;
            this.mCurrentParcel = null;
            this.mCurrentParcelEnd = 0;
            p = Parcel.obtain();
            if (this.readFileToParcel(p, file2 = this.getFile(this.mFileNumbers.get(this.mCurrentFileIndex++)))) {
                int bufSize = p.readInt();
                int curPos = p.dataPosition();
                this.mCurrentParcelEnd = curPos + bufSize;
                this.mCurrentParcel = p;
                if (curPos >= this.mCurrentParcelEnd) continue;
                return this.mCurrentParcel;
            }
            p.recycle();
        }
        if (this.mHistoryParcels != null) {
            while (this.mParcelIndex < this.mHistoryParcels.size()) {
                if (!this.skipHead(p = this.mHistoryParcels.get(this.mParcelIndex++))) continue;
                int bufSize = p.readInt();
                int curPos = p.dataPosition();
                this.mCurrentParcelEnd = curPos + bufSize;
                this.mCurrentParcel = p;
                if (curPos >= this.mCurrentParcelEnd) continue;
                return this.mCurrentParcel;
            }
        }
        if (this.mHistoryBuffer.dataSize() <= 0) {
            return null;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mCurrentParcel = this.mHistoryBuffer;
        this.mCurrentParcelEnd = this.mCurrentParcel.dataSize();
        return this.mCurrentParcel;
    }

    public boolean readFileToParcel(Parcel out, AtomicFile file2) {
        byte[] raw2 = null;
        try {
            long start = SystemClock.uptimeMillis();
            raw2 = file2.readFully();
        }
        catch (Exception e) {
            Slog.e(TAG, "Error reading file " + file2.getBaseFile().getPath(), e);
            return false;
        }
        out.unmarshall(raw2, 0, raw2.length);
        out.setDataPosition(0);
        return this.skipHead(out);
    }

    private boolean skipHead(Parcel p) {
        p.setDataPosition(0);
        int version = p.readInt();
        if (version != 200) {
            return false;
        }
        p.readLong();
        return true;
    }

    public void writeToParcel(Parcel out) {
        long start = SystemClock.uptimeMillis();
        out.writeInt(this.mFileNumbers.size() - 1);
        for (int i = 0; i < this.mFileNumbers.size() - 1; ++i) {
            AtomicFile file2 = this.getFile(this.mFileNumbers.get(i));
            byte[] raw2 = new byte[]{};
            try {
                raw2 = file2.readFully();
            }
            catch (Exception e) {
                Slog.e(TAG, "Error reading file " + file2.getBaseFile().getPath(), e);
            }
            out.writeByteArray(raw2);
        }
    }

    public void readFromParcel(Parcel in) {
        long start = SystemClock.uptimeMillis();
        this.mHistoryParcels = new ArrayList<Parcel>();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            byte[] temp = in.createByteArray();
            if (temp.length == 0) continue;
            Parcel p = Parcel.obtain();
            p.unmarshall(temp, 0, temp.length);
            p.setDataPosition(0);
            this.mHistoryParcels.add(p);
        }
    }

    private boolean hasFreeDiskSpace() {
        StatFs stats = new StatFs(this.mHistoryDir.getAbsolutePath());
        return stats.getAvailableBytes() > 0x6400000L;
    }

    public List<Integer> getFilesNumbers() {
        return this.mFileNumbers;
    }

    public AtomicFile getActiveFile() {
        return this.mActiveFile;
    }

    public int getHistoryUsedSize() {
        int i;
        int ret = 0;
        for (i = 0; i < this.mFileNumbers.size() - 1; ++i) {
            ret = (int)((long)ret + this.getFile(this.mFileNumbers.get(i)).getBaseFile().length());
        }
        ret += this.mHistoryBuffer.dataSize();
        if (this.mHistoryParcels != null) {
            for (i = 0; i < this.mHistoryParcels.size(); ++i) {
                ret += this.mHistoryParcels.get(i).dataSize();
            }
        }
        return ret;
    }
}

