/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import java.util.List;

public class BatteryChargeCalculator
extends PowerCalculator {
    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long dischargeMah;
        long chargeTimeRemainingMs;
        builder2.setDischargePercentage(batteryStats.getDischargeAmount(0));
        int batteryCapacityMah = batteryStats.getLearnedBatteryCapacity() / 1000;
        if (batteryCapacityMah <= 0 && (batteryCapacityMah = batteryStats.getMinLearnedBatteryCapacity() / 1000) <= 0) {
            batteryCapacityMah = batteryStats.getEstimatedBatteryCapacity();
        }
        builder2.setBatteryCapacity(batteryCapacityMah);
        double dischargedPowerLowerBoundMah = (double)(batteryStats.getLowDischargeAmountSinceCharge() * batteryCapacityMah) / 100.0;
        double dischargedPowerUpperBoundMah = (double)(batteryStats.getHighDischargeAmountSinceCharge() * batteryCapacityMah) / 100.0;
        builder2.setDischargePercentage(batteryStats.getDischargeAmount(0)).setDischargedPowerRange(dischargedPowerLowerBoundMah, dischargedPowerUpperBoundMah);
        long batteryTimeRemainingMs = batteryStats.computeBatteryTimeRemaining(rawRealtimeUs);
        if (batteryTimeRemainingMs != -1L) {
            builder2.setBatteryTimeRemainingMs(batteryTimeRemainingMs / 1000L);
        }
        if ((chargeTimeRemainingMs = batteryStats.computeChargeTimeRemaining(rawRealtimeUs)) != -1L) {
            builder2.setChargeTimeRemainingMs(chargeTimeRemainingMs / 1000L);
        }
        if ((dischargeMah = batteryStats.getUahDischarge(0) / 1000L) == 0L) {
            dischargeMah = (long)((dischargedPowerLowerBoundMah + dischargedPowerUpperBoundMah) / 2.0 + 0.5);
        }
        builder2.getAggregateBatteryConsumerBuilder(0).setConsumedPower(dischargeMah);
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
    }
}

