/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.List;

public class AmbientDisplayPowerCalculator
extends PowerCalculator {
    private final UsageBasedPowerEstimator mPowerEstimator;

    public AmbientDisplayPowerCalculator(PowerProfile powerProfile) {
        this.mPowerEstimator = new UsageBasedPowerEstimator(powerProfile.getAveragePower("ambient.on"));
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder2, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long measuredEnergyUC = batteryStats.getScreenDozeMeasuredBatteryConsumptionUC();
        int powerModel = AmbientDisplayPowerCalculator.getPowerModel(measuredEnergyUC, query);
        long durationMs = this.calculateDuration(batteryStats, rawRealtimeUs, 0);
        double powerMah = AmbientDisplayPowerCalculator.getMeasuredOrEstimatedPower(powerModel, measuredEnergyUC, this.mPowerEstimator, durationMs);
        ((AggregateBatteryConsumer.Builder)builder2.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(15, durationMs)).setConsumedPower(15, powerMah, powerModel);
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        long measuredEnergyUC = batteryStats.getScreenDozeMeasuredBatteryConsumptionUC();
        long durationMs = this.calculateDuration(batteryStats, rawRealtimeUs, statsType);
        int powerModel = AmbientDisplayPowerCalculator.getPowerModel(measuredEnergyUC);
        double powerMah = AmbientDisplayPowerCalculator.getMeasuredOrEstimatedPower(powerModel, batteryStats.getScreenDozeMeasuredBatteryConsumptionUC(), this.mPowerEstimator, durationMs);
        if (powerMah > 0.0) {
            BatterySipper bs = new BatterySipper(BatterySipper.DrainType.AMBIENT_DISPLAY, null, 0.0);
            bs.usagePowerMah = powerMah;
            bs.usageTimeMs = durationMs;
            bs.sumPower();
            sippers.add(bs);
        }
    }

    private long calculateDuration(BatteryStats batteryStats, long rawRealtimeUs, int statsType) {
        return batteryStats.getScreenDozeTime(rawRealtimeUs, statsType) / 1000L;
    }
}

