/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.org.bouncycastle.asn1;

import com.android.internal.org.bouncycastle.asn1.ASN1BitString;
import com.android.internal.org.bouncycastle.asn1.ASN1Encodable;
import com.android.internal.org.bouncycastle.asn1.ASN1OctetString;
import com.android.internal.org.bouncycastle.asn1.ASN1OutputStream;
import com.android.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.android.internal.org.bouncycastle.asn1.ASN1TaggedObject;
import com.android.internal.org.bouncycastle.asn1.DLBitString;
import com.android.internal.org.bouncycastle.asn1.StreamUtil;
import java.io.IOException;

public class DERBitString
extends ASN1BitString {
    public static DERBitString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBitString) {
            return (DERBitString)obj;
        }
        if (obj instanceof DLBitString) {
            return new DERBitString(((DLBitString)obj).data, ((DLBitString)obj).padBits);
        }
        if (obj instanceof byte[]) {
            try {
                return (DERBitString)DERBitString.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBitString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERBitString) {
            return DERBitString.getInstance(o);
        }
        return DERBitString.fromOctetString(ASN1OctetString.getInstance(o).getOctets());
    }

    protected DERBitString(byte data, int padBits) {
        super(data, padBits);
    }

    public DERBitString(byte[] data, int padBits) {
        super(data, padBits);
    }

    public DERBitString(byte[] data) {
        this(data, 0);
    }

    public DERBitString(int value2) {
        super(DERBitString.getBytes(value2), DERBitString.getPadBits(value2));
    }

    public DERBitString(ASN1Encodable obj) throws IOException {
        super(obj.toASN1Primitive().getEncoded("DER"), 0);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.data.length + 1) + this.data.length + 1;
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        int len = this.data.length;
        if (0 == len || 0 == this.padBits || this.data[len - 1] == (byte)(this.data[len - 1] & 255 << this.padBits)) {
            out.writeEncoded(withTag, 3, (byte)this.padBits, this.data);
        } else {
            byte der = (byte)(this.data[len - 1] & 255 << this.padBits);
            out.writeEncoded(withTag, 3, (byte)this.padBits, this.data, 0, len - 1, der);
        }
    }

    @Override
    ASN1Primitive toDERObject() {
        return this;
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }

    static DERBitString fromOctetString(byte[] bytes) {
        if (bytes.length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        byte padBits = bytes[0];
        byte[] data = new byte[bytes.length - 1];
        if (data.length != 0) {
            System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
        }
        return new DERBitString(data, (int)padBits);
    }
}

