/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.org.bouncycastle.asn1;

import com.android.internal.org.bouncycastle.asn1.ASN1OctetString;
import com.android.internal.org.bouncycastle.asn1.ASN1OutputStream;
import com.android.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.android.internal.org.bouncycastle.asn1.ASN1TaggedObject;
import java.io.IOException;

public class ASN1Boolean
extends ASN1Primitive {
    private static final byte FALSE_VALUE = 0;
    private static final byte TRUE_VALUE = -1;
    public static final ASN1Boolean FALSE = new ASN1Boolean(0);
    public static final ASN1Boolean TRUE = new ASN1Boolean(-1);
    private final byte value;

    public static ASN1Boolean getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Boolean) {
            return (ASN1Boolean)obj;
        }
        if (obj instanceof byte[]) {
            byte[] enc = (byte[])obj;
            try {
                return (ASN1Boolean)ASN1Boolean.fromByteArray(enc);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct boolean from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Boolean getInstance(boolean value2) {
        return value2 ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(int value2) {
        return value2 != 0 ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(byte[] octets) {
        return octets[0] != 0 ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof ASN1Boolean) {
            return ASN1Boolean.getInstance(o);
        }
        return ASN1Boolean.fromOctetString(ASN1OctetString.getInstance(o).getOctets());
    }

    private ASN1Boolean(byte value2) {
        this.value = value2;
    }

    public boolean isTrue() {
        return this.value != 0;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 3;
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncoded(withTag, 1, this.value);
    }

    @Override
    boolean asn1Equals(ASN1Primitive other) {
        if (!(other instanceof ASN1Boolean)) {
            return false;
        }
        ASN1Boolean that = (ASN1Boolean)other;
        return this.isTrue() == that.isTrue();
    }

    @Override
    public int hashCode() {
        return this.isTrue() ? 1 : 0;
    }

    @Override
    ASN1Primitive toDERObject() {
        return this.isTrue() ? TRUE : FALSE;
    }

    public String toString() {
        return this.isTrue() ? "TRUE" : "FALSE";
    }

    static ASN1Boolean fromOctetString(byte[] value2) {
        if (value2.length != 1) {
            throw new IllegalArgumentException("BOOLEAN value should have 1 byte in it");
        }
        byte b = value2[0];
        switch (b) {
            case 0: {
                return FALSE;
            }
            case -1: {
                return TRUE;
            }
        }
        return new ASN1Boolean(b);
    }
}

