/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.system.Os;
import android.system.OsConstants;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;

public class NetworkUtilsInternal {
    private static final int[] ADDRESS_FAMILIES = new int[]{OsConstants.AF_INET, OsConstants.AF_INET6};

    public static void setAllowNetworkingForProcess(boolean bl) {
        OverrideMethod.invokeV("com.android.internal.net.NetworkUtilsInternal#setAllowNetworkingForProcess(Z)V", true, null);
    }

    public static boolean protectFromVpn(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("com.android.internal.net.NetworkUtilsInternal#protectFromVpn(Ljava/io/FileDescriptor;)Z", true, null) != 0;
    }

    public static boolean protectFromVpn(int n) {
        return OverrideMethod.invokeI("com.android.internal.net.NetworkUtilsInternal#protectFromVpn(I)Z", true, null) != 0;
    }

    public static boolean isWeaklyValidatedHostname(String hostname) {
        String weakHostnameRegex = "^[a-zA-Z0-9_.-]+$";
        if (!hostname.matches("^[a-zA-Z0-9_.-]+$")) {
            return false;
        }
        for (int address_family : ADDRESS_FAMILIES) {
            if (Os.inet_pton(address_family, hostname) == null) continue;
            return false;
        }
        return true;
    }

    public static long multiplySafeByRational(long value2, long num, long den) {
        long ay;
        if (den == 0L) {
            throw new ArithmeticException("Invalid Denominator");
        }
        long x = value2;
        long y = num;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return (long)((double)num / (double)den * (double)value2);
        }
        return r / den;
    }
}

