/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.midi;

import android.media.midi.MidiReceiver;
import android.media.midi.MidiSender;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;

public class MidiDispatcher
extends MidiReceiver {
    private final MidiReceiverFailureHandler mFailureHandler;
    private final CopyOnWriteArrayList<MidiReceiver> mReceivers = new CopyOnWriteArrayList();
    private final MidiSender mSender = new MidiSender(){

        @Override
        public void onConnect(MidiReceiver receiver) {
            MidiDispatcher.this.mReceivers.add(receiver);
        }

        @Override
        public void onDisconnect(MidiReceiver receiver) {
            MidiDispatcher.this.mReceivers.remove(receiver);
        }
    };

    public MidiDispatcher() {
        this(null);
    }

    public MidiDispatcher(MidiReceiverFailureHandler failureHandler) {
        this.mFailureHandler = failureHandler;
    }

    public int getReceiverCount() {
        return this.mReceivers.size();
    }

    public MidiSender getSender() {
        return this.mSender;
    }

    @Override
    public void onSend(byte[] msg, int offset2, int count, long timestamp) throws IOException {
        for (MidiReceiver receiver : this.mReceivers) {
            try {
                receiver.send(msg, offset2, count, timestamp);
            }
            catch (IOException e) {
                this.mReceivers.remove(receiver);
                if (this.mFailureHandler == null) continue;
                this.mFailureHandler.onReceiverFailure(receiver, e);
            }
        }
    }

    @Override
    public void onFlush() throws IOException {
        for (MidiReceiver receiver : this.mReceivers) {
            try {
                receiver.flush();
            }
            catch (IOException e) {
                this.mReceivers.remove(receiver);
                if (this.mFailureHandler == null) continue;
                this.mFailureHandler.onReceiverFailure(receiver, e);
            }
        }
    }

    public static interface MidiReceiverFailureHandler {
        public void onReceiverFailure(MidiReceiver var1, IOException var2);
    }
}

