/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.logging;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.metrics.LogMaker;
import android.os._Original_Build;
import com.android.internal.logging.EventLogTags;
import com.android.internal.util.FrameworkStatsLog;

public class MetricsLogger {
    private static MetricsLogger sMetricsLogger;
    public static final int VIEW_UNKNOWN = 0;
    public static final int LOGTAG = 524292;

    @UnsupportedAppUsage
    public MetricsLogger() {
    }

    private static MetricsLogger getLogger() {
        if (sMetricsLogger == null) {
            sMetricsLogger = new MetricsLogger();
        }
        return sMetricsLogger;
    }

    protected void saveLog(LogMaker log) {
        EventLogTags.writeSysuiMultiAction(log.serialize());
        FrameworkStatsLog.write(83, 0, log.getEntries());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void write(LogMaker content2) {
        if (content2.getType() == 0) {
            content2.setType(4);
        }
        this.saveLog(content2);
    }

    public void count(String name, int value2) {
        this.saveLog(new LogMaker(803).setCounterName(name).setCounterValue(value2));
    }

    public void histogram(String name, int bucket) {
        this.saveLog(new LogMaker(804).setCounterName(name).setCounterBucket(bucket).setCounterValue(1));
    }

    public void visible(int category) throws IllegalArgumentException {
        if (_Original_Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        this.saveLog(new LogMaker(category).setType(1));
    }

    public void hidden(int category) throws IllegalArgumentException {
        if (_Original_Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        this.saveLog(new LogMaker(category).setType(2));
    }

    public void visibility(int category, boolean visible) throws IllegalArgumentException {
        if (visible) {
            this.visible(category);
        } else {
            this.hidden(category);
        }
    }

    public void visibility(int category, int vis) throws IllegalArgumentException {
        this.visibility(category, vis == 0);
    }

    public void action(int category) {
        this.saveLog(new LogMaker(category).setType(4));
    }

    public void action(int category, int value2) {
        this.saveLog(new LogMaker(category).setType(4).setSubtype(value2));
    }

    public void action(int category, boolean value2) {
        this.saveLog(new LogMaker(category).setType(4).setSubtype(value2 ? 1 : 0));
    }

    public void action(int category, String pkg) {
        if (_Original_Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        this.saveLog(new LogMaker(category).setType(4).setPackageName(pkg));
    }

    @Deprecated
    public static void visible(Context context, int category) throws IllegalArgumentException {
        MetricsLogger.getLogger().visible(category);
    }

    @Deprecated
    public static void hidden(Context context, int category) throws IllegalArgumentException {
        MetricsLogger.getLogger().hidden(category);
    }

    @Deprecated
    public static void visibility(Context context, int category, boolean visibile) throws IllegalArgumentException {
        MetricsLogger.getLogger().visibility(category, visibile);
    }

    @Deprecated
    public static void visibility(Context context, int category, int vis) throws IllegalArgumentException {
        MetricsLogger.visibility(context, category, vis == 0);
    }

    @Deprecated
    public static void action(Context context, int category) {
        MetricsLogger.getLogger().action(category);
    }

    @Deprecated
    public static void action(Context context, int category, int value2) {
        MetricsLogger.getLogger().action(category, value2);
    }

    @Deprecated
    public static void action(Context context, int category, boolean value2) {
        MetricsLogger.getLogger().action(category, value2);
    }

    @Deprecated
    public static void action(LogMaker content2) {
        MetricsLogger.getLogger().write(content2);
    }

    @Deprecated
    public static void action(Context context, int category, String pkg) {
        MetricsLogger.getLogger().action(category, pkg);
    }

    @Deprecated
    public static void count(Context context, String name, int value2) {
        MetricsLogger.getLogger().count(name, value2);
    }

    @Deprecated
    public static void histogram(Context context, String name, int bucket) {
        MetricsLogger.getLogger().histogram(name, bucket);
    }
}

