/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.inputmethod.IBooleanResultCallback;
import com.android.internal.inputmethod.IIInputContentUriTokenResultCallback;
import com.android.internal.inputmethod.IVoidResultCallback;

public interface IInputMethodPrivilegedOperations
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IInputMethodPrivilegedOperations";

    public void setImeWindowStatusAsync(int var1, int var2) throws RemoteException;

    public void reportStartInputAsync(IBinder var1) throws RemoteException;

    public void createInputContentUriToken(Uri var1, String var2, IIInputContentUriTokenResultCallback var3) throws RemoteException;

    public void reportFullscreenModeAsync(boolean var1) throws RemoteException;

    public void setInputMethod(String var1, IVoidResultCallback var2) throws RemoteException;

    public void setInputMethodAndSubtype(String var1, InputMethodSubtype var2, IVoidResultCallback var3) throws RemoteException;

    public void hideMySoftInput(int var1, IVoidResultCallback var2) throws RemoteException;

    public void showMySoftInput(int var1, IVoidResultCallback var2) throws RemoteException;

    public void updateStatusIconAsync(String var1, int var2) throws RemoteException;

    public void switchToPreviousInputMethod(IBooleanResultCallback var1) throws RemoteException;

    public void switchToNextInputMethod(boolean var1, IBooleanResultCallback var2) throws RemoteException;

    public void shouldOfferSwitchingToNextInputMethod(IBooleanResultCallback var1) throws RemoteException;

    public void notifyUserActionAsync() throws RemoteException;

    public void applyImeVisibilityAsync(IBinder var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodPrivilegedOperations {
        static final int TRANSACTION_setImeWindowStatusAsync = 1;
        static final int TRANSACTION_reportStartInputAsync = 2;
        static final int TRANSACTION_createInputContentUriToken = 3;
        static final int TRANSACTION_reportFullscreenModeAsync = 4;
        static final int TRANSACTION_setInputMethod = 5;
        static final int TRANSACTION_setInputMethodAndSubtype = 6;
        static final int TRANSACTION_hideMySoftInput = 7;
        static final int TRANSACTION_showMySoftInput = 8;
        static final int TRANSACTION_updateStatusIconAsync = 9;
        static final int TRANSACTION_switchToPreviousInputMethod = 10;
        static final int TRANSACTION_switchToNextInputMethod = 11;
        static final int TRANSACTION_shouldOfferSwitchingToNextInputMethod = 12;
        static final int TRANSACTION_notifyUserActionAsync = 13;
        static final int TRANSACTION_applyImeVisibilityAsync = 14;

        public Stub() {
            this.attachInterface(this, IInputMethodPrivilegedOperations.DESCRIPTOR);
        }

        public static IInputMethodPrivilegedOperations asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInputMethodPrivilegedOperations.DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethodPrivilegedOperations) {
                return (IInputMethodPrivilegedOperations)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setImeWindowStatusAsync";
                }
                case 2: {
                    return "reportStartInputAsync";
                }
                case 3: {
                    return "createInputContentUriToken";
                }
                case 4: {
                    return "reportFullscreenModeAsync";
                }
                case 5: {
                    return "setInputMethod";
                }
                case 6: {
                    return "setInputMethodAndSubtype";
                }
                case 7: {
                    return "hideMySoftInput";
                }
                case 8: {
                    return "showMySoftInput";
                }
                case 9: {
                    return "updateStatusIconAsync";
                }
                case 10: {
                    return "switchToPreviousInputMethod";
                }
                case 11: {
                    return "switchToNextInputMethod";
                }
                case 12: {
                    return "shouldOfferSwitchingToNextInputMethod";
                }
                case 13: {
                    return "notifyUserActionAsync";
                }
                case 14: {
                    return "applyImeVisibilityAsync";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInputMethodPrivilegedOperations.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setImeWindowStatusAsync(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.reportStartInputAsync(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    IIInputContentUriTokenResultCallback _arg2 = IIInputContentUriTokenResultCallback.Stub.asInterface(data.readStrongBinder());
                    this.createInputContentUriToken(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.reportFullscreenModeAsync(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IVoidResultCallback _arg1 = IVoidResultCallback.Stub.asInterface(data.readStrongBinder());
                    this.setInputMethod(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    InputMethodSubtype _arg1 = 0 != data.readInt() ? InputMethodSubtype.CREATOR.createFromParcel(data) : null;
                    IVoidResultCallback _arg2 = IVoidResultCallback.Stub.asInterface(data.readStrongBinder());
                    this.setInputMethodAndSubtype(_arg0, _arg1, _arg2);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IVoidResultCallback _arg1 = IVoidResultCallback.Stub.asInterface(data.readStrongBinder());
                    this.hideMySoftInput(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IVoidResultCallback _arg1 = IVoidResultCallback.Stub.asInterface(data.readStrongBinder());
                    this.showMySoftInput(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.updateStatusIconAsync(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IBooleanResultCallback _arg0 = IBooleanResultCallback.Stub.asInterface(data.readStrongBinder());
                    this.switchToPreviousInputMethod(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    IBooleanResultCallback _arg1 = IBooleanResultCallback.Stub.asInterface(data.readStrongBinder());
                    this.switchToNextInputMethod(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    IBooleanResultCallback _arg0 = IBooleanResultCallback.Stub.asInterface(data.readStrongBinder());
                    this.shouldOfferSwitchingToNextInputMethod(_arg0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    this.notifyUserActionAsync();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.applyImeVisibilityAsync(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IInputMethodPrivilegedOperations impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IInputMethodPrivilegedOperations getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IInputMethodPrivilegedOperations {
            private IBinder mRemote;
            public static IInputMethodPrivilegedOperations sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInputMethodPrivilegedOperations.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeWindowStatusAsync(int vis, int backDisposition) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(vis);
                    _data.writeInt(backDisposition);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setImeWindowStatusAsync(vis, backDisposition);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportStartInputAsync(IBinder startInputToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeStrongBinder(startInputToken);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportStartInputAsync(startInputToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createInputContentUriToken(Uri contentUri, String packageName, IIInputContentUriTokenResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    if (contentUri != null) {
                        _data.writeInt(1);
                        contentUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    _data.writeStrongBinder(resultCallback != null ? resultCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().createInputContentUriToken(contentUri, packageName, resultCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportFullscreenModeAsync(boolean fullscreen) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(fullscreen ? 1 : 0);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportFullscreenModeAsync(fullscreen);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInputMethod(String id2, IVoidResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeStrongBinder(resultCallback != null ? resultCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setInputMethod(id2, resultCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInputMethodAndSubtype(String id2, InputMethodSubtype subtype, IVoidResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeString(id2);
                    if (subtype != null) {
                        _data.writeInt(1);
                        subtype.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(resultCallback != null ? resultCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setInputMethodAndSubtype(id2, subtype, resultCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideMySoftInput(int flags, IVoidResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeStrongBinder(resultCallback != null ? resultCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideMySoftInput(flags, resultCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showMySoftInput(int flags, IVoidResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeStrongBinder(resultCallback != null ? resultCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showMySoftInput(flags, resultCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateStatusIconAsync(String packageName, int iconId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(iconId);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateStatusIconAsync(packageName, iconId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToPreviousInputMethod(IBooleanResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeStrongBinder(resultCallback != null ? resultCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().switchToPreviousInputMethod(resultCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToNextInputMethod(boolean onlyCurrentIme, IBooleanResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(onlyCurrentIme ? 1 : 0);
                    _data.writeStrongBinder(resultCallback != null ? resultCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().switchToNextInputMethod(onlyCurrentIme, resultCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shouldOfferSwitchingToNextInputMethod(IBooleanResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeStrongBinder(resultCallback != null ? resultCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().shouldOfferSwitchingToNextInputMethod(resultCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyUserActionAsync() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyUserActionAsync();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyImeVisibilityAsync(IBinder showOrHideInputToken, boolean setVisible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeStrongBinder(showOrHideInputToken);
                    _data.writeInt(setVisible ? 1 : 0);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().applyImeVisibilityAsync(showOrHideInputToken, setVisible);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethodPrivilegedOperations {
        @Override
        public void setImeWindowStatusAsync(int vis, int backDisposition) throws RemoteException {
        }

        @Override
        public void reportStartInputAsync(IBinder startInputToken) throws RemoteException {
        }

        @Override
        public void createInputContentUriToken(Uri contentUri, String packageName, IIInputContentUriTokenResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void reportFullscreenModeAsync(boolean fullscreen) throws RemoteException {
        }

        @Override
        public void setInputMethod(String id2, IVoidResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void setInputMethodAndSubtype(String id2, InputMethodSubtype subtype, IVoidResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void hideMySoftInput(int flags, IVoidResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void showMySoftInput(int flags, IVoidResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void updateStatusIconAsync(String packageName, int iconId) throws RemoteException {
        }

        @Override
        public void switchToPreviousInputMethod(IBooleanResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void switchToNextInputMethod(boolean onlyCurrentIme, IBooleanResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void shouldOfferSwitchingToNextInputMethod(IBooleanResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void notifyUserActionAsync() throws RemoteException {
        }

        @Override
        public void applyImeVisibilityAsync(IBinder showOrHideInputToken, boolean setVisible) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

