/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.util.Log;
import android.view.inputmethod.InputMethodInfo;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.CancellationGroup;
import com.android.internal.inputmethod.ThrowableHolder;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Completable {
    private Completable() {
    }

    public static Int createInt() {
        return new Int();
    }

    public static Boolean createBoolean() {
        return new Boolean();
    }

    public static CharSequence createCharSequence() {
        return new CharSequence();
    }

    public static ExtractedText createExtractedText() {
        return new ExtractedText();
    }

    public static SurroundingText createSurroundingText() {
        return new SurroundingText();
    }

    public static InputBindResult createInputBindResult() {
        return new InputBindResult();
    }

    public static InputMethodSubtype createInputMethodSubtype() {
        return new InputMethodSubtype();
    }

    public static InputMethodSubtypeList createInputMethodSubtypeList() {
        return new InputMethodSubtypeList();
    }

    public static InputMethodInfoList createInputMethodInfoList() {
        return new InputMethodInfoList();
    }

    public static IInputContentUriToken createIInputContentUriToken() {
        return new IInputContentUriToken();
    }

    public static Void createVoid() {
        return new Void();
    }

    public static <T> T getResult(Values<T> value2) {
        value2.await();
        return value2.getValue();
    }

    public static int getIntResult(Int value2) {
        value2.await();
        return value2.getValue();
    }

    public static void getResult(Void value2) {
        value2.await();
        value2.getValue();
    }

    public static int getResultOrZero(Int value2, String tag, String methodName, CancellationGroup cancellationGroup, int maxWaitTime) {
        boolean timedOut = value2.await(maxWaitTime, TimeUnit.MILLISECONDS, cancellationGroup);
        if (value2.hasValue()) {
            return value2.getValue();
        }
        Completable.logInternal(tag, methodName, timedOut, maxWaitTime, 0);
        return 0;
    }

    public static <T> T getResultOrNull(Values<T> value2, String tag, String methodName, CancellationGroup cancellationGroup, int maxWaitTime) {
        boolean timedOut = value2.await(maxWaitTime, TimeUnit.MILLISECONDS, cancellationGroup);
        if (value2.hasValue()) {
            return value2.getValue();
        }
        Completable.logInternal(tag, methodName, timedOut, maxWaitTime, null);
        return null;
    }

    private static void logInternal(String tag, String methodName, boolean timedOut, int maxWaitTime, Object defaultValue2) {
        if (timedOut) {
            Log.w(tag, methodName + " didn't respond in " + maxWaitTime + " msec. Returning default: " + defaultValue2);
        } else {
            Log.w(tag, methodName + " was canceled before complete. Returning default: " + defaultValue2);
        }
    }

    public static class IInputContentUriToken
    extends Values<com.android.internal.inputmethod.IInputContentUriToken> {
    }

    public static class InputMethodInfoList
    extends Values<List<InputMethodInfo>> {
    }

    public static class InputMethodSubtypeList
    extends Values<List<android.view.inputmethod.InputMethodSubtype>> {
    }

    public static class InputMethodSubtype
    extends Values<android.view.inputmethod.InputMethodSubtype> {
    }

    public static class InputBindResult
    extends Values<com.android.internal.view.InputBindResult> {
    }

    public static class SurroundingText
    extends Values<android.view.inputmethod.SurroundingText> {
    }

    public static class ExtractedText
    extends Values<android.view.inputmethod.ExtractedText> {
    }

    public static class CharSequence
    extends Values<java.lang.CharSequence> {
    }

    public static class Boolean
    extends Values<java.lang.Boolean> {
    }

    public static class Values<T>
    extends ValueBase {
        @GuardedBy(value={"mStateLock"})
        private T mValue = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onComplete(T value2) {
            Object object = this.mStateLock;
            synchronized (object) {
                switch (this.mState) {
                    case 0: {
                        this.mValue = value2;
                        this.mState = 1;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("onComplete() is not allowed on state=" + Values.stateToString(this.mState));
                    }
                }
            }
            this.onComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getValue() {
            Object object = this.mStateLock;
            synchronized (object) {
                this.enforceGetValueLocked();
                return this.mValue;
            }
        }
    }

    public static class Void
    extends ValueBase {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onComplete() {
            Object object = this.mStateLock;
            synchronized (object) {
                switch (this.mState) {
                    case 0: {
                        this.mState = 1;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("onComplete() is not allowed on state=" + Void.stateToString(this.mState));
                    }
                }
            }
            super.onComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getValue() {
            Object object = this.mStateLock;
            synchronized (object) {
                this.enforceGetValueLocked();
            }
        }
    }

    public static class Int
    extends ValueBase {
        @GuardedBy(value={"mStateLock"})
        private int mValue = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onComplete(int value2) {
            Object object = this.mStateLock;
            synchronized (object) {
                switch (this.mState) {
                    case 0: {
                        this.mValue = value2;
                        this.mState = 1;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("onComplete() is not allowed on state=" + Int.stateToString(this.mState));
                    }
                }
            }
            this.onComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getValue() {
            Object object = this.mStateLock;
            synchronized (object) {
                this.enforceGetValueLocked();
                return this.mValue;
            }
        }
    }

    protected static class ValueBase {
        private final CountDownLatch mLatch = new CountDownLatch(1);
        protected final Object mStateLock = new Object();
        @GuardedBy(value={"mStateLock"})
        protected int mState = 0;
        @GuardedBy(value={"mStateLock"})
        protected String mMessage = null;

        protected ValueBase() {
        }

        protected static String stateToString(int state) {
            switch (state) {
                case 0: {
                    return "NOT_COMPLETED";
                }
                case 1: {
                    return "COMPLETED_WITH_VALUE";
                }
                case 2: {
                    return "COMPLETED_WITH_ERROR";
                }
            }
            return "Unknown(value=" + state + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasValue() {
            Object object = this.mStateLock;
            synchronized (object) {
                return this.mState == 1;
            }
        }

        @GuardedBy(value={"mStateLock"})
        protected void enforceGetValueLocked() {
            switch (this.mState) {
                case 0: {
                    throw new UnsupportedOperationException("getValue() is allowed only if hasValue() returns true");
                }
                case 1: {
                    return;
                }
                case 2: {
                    throw new RuntimeException(this.mMessage);
                }
            }
            throw new UnsupportedOperationException("getValue() is not allowed on state=" + ValueBase.stateToString(this.mState));
        }

        protected void onComplete() {
            this.mLatch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onError(ThrowableHolder throwableHolder) {
            Object object = this.mStateLock;
            synchronized (object) {
                switch (this.mState) {
                    case 0: {
                        this.mMessage = throwableHolder.getMessage();
                        this.mState = 2;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("onError() is not allowed on state=" + ValueBase.stateToString(this.mState));
                    }
                }
            }
            this.onComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(int timeout, TimeUnit timeUnit, CancellationGroup cancellationGroup) {
            if (cancellationGroup == null) {
                return this.awaitInner(timeout, timeUnit);
            }
            if (!cancellationGroup.registerLatch(this.mLatch)) {
                return false;
            }
            try {
                boolean bl = this.awaitInner(timeout, timeUnit);
                return bl;
            }
            finally {
                cancellationGroup.unregisterLatch(this.mLatch);
            }
        }

        private boolean awaitInner(int timeout, TimeUnit timeUnit) {
            try {
                return this.mLatch.await(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                return true;
            }
        }

        public void await() {
            boolean interrupted = false;
            while (true) {
                try {
                    this.mLatch.await();
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        protected static @interface CompletionState {
            public static final int NOT_COMPLETED = 0;
            public static final int COMPLETED_WITH_VALUE = 1;
            public static final int COMPLETED_WITH_ERROR = 2;
        }
    }
}

