/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.infra;

import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.infra.IAndroidFuture;
import com.android.internal.util.Preconditions;
import java.lang.reflect.Constructor;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class AndroidFuture<T>
extends CompletableFuture<T>
implements Parcelable {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = AndroidFuture.class.getSimpleName();
    private static final Executor DIRECT_EXECUTOR = Runnable::run;
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static Handler sMainHandler;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private BiConsumer<? super T, ? super Throwable> mListener;
    @GuardedBy(value={"mLock"})
    private Executor mListenerExecutor = DIRECT_EXECUTOR;
    private Handler mTimeoutHandler = AndroidFuture.getMainHandler();
    private final IAndroidFuture mRemoteOrigin;
    public static final Parcelable.Creator<AndroidFuture> CREATOR;

    public AndroidFuture() {
        this.mRemoteOrigin = null;
    }

    AndroidFuture(Parcel in) {
        if (in.readBoolean()) {
            if (in.readBoolean()) {
                this.completeExceptionally(AndroidFuture.readThrowable(in));
            } else {
                this.complete(in.readValue(null));
            }
            this.mRemoteOrigin = null;
        } else {
            this.mRemoteOrigin = IAndroidFuture.Stub.asInterface(in.readStrongBinder());
        }
    }

    private static Handler getMainHandler() {
        if (sMainHandler == null) {
            sMainHandler = new Handler(Looper.getMainLooper());
        }
        return sMainHandler;
    }

    public static <U> AndroidFuture<U> completedFuture(U value2) {
        AndroidFuture<U> future2 = new AndroidFuture<U>();
        future2.complete(value2);
        return future2;
    }

    @Override
    public boolean complete(T value2) {
        boolean changed = super.complete(value2);
        if (changed) {
            this.onCompleted(value2, null);
        }
        return changed;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean changed = super.completeExceptionally(ex);
        if (changed) {
            this.onCompleted(null, ex);
        }
        return changed;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean changed = super.cancel(mayInterruptIfRunning);
        if (changed) {
            try {
                this.get();
                throw new IllegalStateException("Expected CancellationException");
            }
            catch (CancellationException ex) {
                this.onCompleted(null, ex);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Expected CancellationException", e);
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompleted(T res, Throwable err) {
        BiConsumer<? super T, ? super Throwable> listener2;
        this.cancelTimeout();
        Object object = this.mLock;
        synchronized (object) {
            listener2 = this.mListener;
            this.mListener = null;
        }
        if (listener2 != null) {
            this.callListenerAsync(listener2, res, err);
        }
        if (this.mRemoteOrigin != null) {
            try {
                this.mRemoteOrigin.complete(this);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Failed to propagate completion", e);
            }
        }
    }

    @Override
    public AndroidFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action2) {
        return this.whenCompleteAsync((BiConsumer)action2, DIRECT_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AndroidFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action2, Executor executor) {
        Preconditions.checkNotNull(action2);
        Preconditions.checkNotNull(executor);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDone()) {
                BiConsumer oldListener = this.mListener;
                if (oldListener != null && executor != this.mListenerExecutor) {
                    super.whenCompleteAsync(action2, executor);
                    return this;
                }
                this.mListenerExecutor = executor;
                this.mListener = oldListener == null ? action2 : (res, err) -> {
                    AndroidFuture.callListener(oldListener, res, err);
                    AndroidFuture.callListener(action2, res, err);
                };
                return this;
            }
        }
        T res2 = null;
        Throwable err2 = null;
        try {
            res2 = this.get();
        }
        catch (ExecutionException e) {
            err2 = e.getCause();
        }
        catch (Throwable e) {
            err2 = e;
        }
        this.callListenerAsync(action2, res2, err2);
        return this;
    }

    private void callListenerAsync(BiConsumer<? super T, ? super Throwable> listener2, T res, Throwable err) {
        if (this.mListenerExecutor == DIRECT_EXECUTOR) {
            AndroidFuture.callListener(listener2, res, err);
        } else {
            this.mListenerExecutor.execute(() -> AndroidFuture.callListener(listener2, res, err));
        }
    }

    static <TT> void callListener(BiConsumer<? super TT, ? super Throwable> listener2, TT res, Throwable err) {
        block5: {
            try {
                try {
                    listener2.accept(res, err);
                }
                catch (Throwable t) {
                    if (err == null) {
                        listener2.accept(null, t);
                        break block5;
                    }
                    t.addSuppressed(err);
                    throw t;
                }
            }
            catch (Throwable t2) {
                Log.e(LOG_TAG, "Failed to call whenComplete listener. res = " + res, t2);
            }
        }
    }

    @Override
    public AndroidFuture<T> orTimeout(long timeout, TimeUnit unit) {
        this.mTimeoutHandler.postDelayed(this::triggerTimeout, this, unit.toMillis(timeout));
        return this;
    }

    void triggerTimeout() {
        this.cancelTimeout();
        if (!this.isDone()) {
            this.completeExceptionally(new TimeoutException());
        }
    }

    public AndroidFuture<T> cancelTimeout() {
        this.mTimeoutHandler.removeCallbacksAndMessages(this);
        return this;
    }

    public AndroidFuture<T> setTimeoutHandler(Handler h) {
        this.cancelTimeout();
        this.mTimeoutHandler = Preconditions.checkNotNull(h);
        return this;
    }

    @Override
    public <U> AndroidFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, DIRECT_EXECUTOR);
    }

    @Override
    public <U> AndroidFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return new ThenComposeAsync(this, fn, executor);
    }

    @Override
    public <U> AndroidFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, DIRECT_EXECUTOR);
    }

    @Override
    public <U> AndroidFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return new ThenApplyAsync<T, U>(this, fn, executor);
    }

    @Override
    public <U, V> AndroidFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> combineResults) {
        return new ThenCombine<T, U, V>(this, other, combineResults);
    }

    public AndroidFuture<T> thenCombine(CompletionStage<Void> other) {
        return this.thenCombine(other, (T res, U aVoid) -> res);
    }

    public static <T> AndroidFuture<T> supply(Supplier<T> supplier) {
        return AndroidFuture.supplyAsync(supplier, DIRECT_EXECUTOR);
    }

    public static <T> AndroidFuture<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        return new SupplyAsync<T>(supplier, executor);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        boolean done = this.isDone();
        dest.writeBoolean(done);
        if (done) {
            Object result;
            try {
                result = this.get();
            }
            catch (Throwable t) {
                dest.writeBoolean(true);
                AndroidFuture.writeThrowable(dest, this.unwrapExecutionException(t));
                return;
            }
            dest.writeBoolean(false);
            dest.writeValue(result);
        } else {
            dest.writeStrongBinder(new IAndroidFuture.Stub(){

                @Override
                public void complete(AndroidFuture resultContainer) {
                    boolean changed;
                    try {
                        changed = AndroidFuture.this.complete(resultContainer.get());
                    }
                    catch (Throwable t) {
                        changed = AndroidFuture.this.completeExceptionally(AndroidFuture.this.unwrapExecutionException(t));
                    }
                    if (!changed) {
                        Log.w(LOG_TAG, "Remote result " + resultContainer + " ignored, as local future is already completed: " + AndroidFuture.this);
                    }
                }
            }.asBinder());
        }
    }

    Throwable unwrapExecutionException(Throwable t) {
        return t instanceof ExecutionException ? t.getCause() : t;
    }

    private static void writeThrowable(Parcel parcel, Throwable throwable) {
        boolean hasThrowable = throwable != null;
        parcel.writeBoolean(hasThrowable);
        if (!hasThrowable) {
            return;
        }
        boolean isFrameworkParcelable = throwable instanceof Parcelable && throwable.getClass().getClassLoader() == Parcelable.class.getClassLoader();
        parcel.writeBoolean(isFrameworkParcelable);
        if (isFrameworkParcelable) {
            parcel.writeParcelable((Parcelable)((Object)throwable), 1);
            return;
        }
        parcel.writeString(throwable.getClass().getName());
        parcel.writeString(throwable.getMessage());
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        StringBuilder stackTraceBuilder = new StringBuilder();
        int truncatedStackTraceLength = Math.min(stackTrace != null ? stackTrace.length : 0, 5);
        for (int i = 0; i < truncatedStackTraceLength; ++i) {
            if (i > 0) {
                stackTraceBuilder.append('\n');
            }
            stackTraceBuilder.append("\tat ").append(stackTrace[i]);
        }
        parcel.writeString(stackTraceBuilder.toString());
        AndroidFuture.writeThrowable(parcel, throwable.getCause());
    }

    private static Throwable readThrowable(Parcel parcel) {
        Throwable throwable;
        boolean hasThrowable = parcel.readBoolean();
        if (!hasThrowable) {
            return null;
        }
        boolean isFrameworkParcelable = parcel.readBoolean();
        if (isFrameworkParcelable) {
            return (Throwable)parcel.readParcelable(Parcelable.class.getClassLoader());
        }
        String className2 = parcel.readString();
        String message = parcel.readString();
        String stackTrace = parcel.readString();
        String messageWithStackTrace = message + '\n' + stackTrace;
        try {
            Class<?> clazz = Class.forName(className2, true, Parcelable.class.getClassLoader());
            if (Throwable.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                throwable = (Throwable)constructor.newInstance(messageWithStackTrace);
            } else {
                EventLog.writeEvent(1397638484, "186530450", -1, "");
                throwable = new RuntimeException(className2 + ": " + messageWithStackTrace);
            }
        }
        catch (Throwable t) {
            throwable = new RuntimeException(className2 + ": " + messageWithStackTrace);
            throwable.addSuppressed(t);
        }
        throwable.setStackTrace(EMPTY_STACK_TRACE);
        Throwable cause = AndroidFuture.readThrowable(parcel);
        if (cause != null) {
            throwable.initCause(cause);
        }
        return throwable;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static {
        CREATOR = new Parcelable.Creator<AndroidFuture>(){

            @Override
            public AndroidFuture createFromParcel(Parcel parcel) {
                return new AndroidFuture(parcel);
            }

            public AndroidFuture[] newArray(int size) {
                return new AndroidFuture[size];
            }
        };
    }

    private static class SupplyAsync<T>
    extends AndroidFuture<T>
    implements Runnable {
        private final Supplier<T> mSupplier;

        SupplyAsync(Supplier<T> supplier, Executor executor) {
            this.mSupplier = supplier;
            executor.execute(this);
        }

        @Override
        public void run() {
            try {
                this.complete(this.mSupplier.get());
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
            }
        }
    }

    private static class ThenCombine<T, U, V>
    extends AndroidFuture<V>
    implements BiConsumer<Object, Throwable> {
        private volatile T mResultT = null;
        private volatile CompletionStage<? extends U> mSourceU;
        private final BiFunction<? super T, ? super U, ? extends V> mCombineResults;

        ThenCombine(CompletableFuture<T> sourceT, CompletionStage<? extends U> sourceU, BiFunction<? super T, ? super U, ? extends V> combineResults) {
            this.mSourceU = Preconditions.checkNotNull(sourceU);
            this.mCombineResults = Preconditions.checkNotNull(combineResults);
            sourceT.whenComplete((BiConsumer)this);
        }

        @Override
        public void accept(Object res, Throwable err) {
            if (err != null) {
                this.completeExceptionally(err);
                return;
            }
            if (this.mSourceU != null) {
                this.mResultT = res;
                this.mSourceU.whenComplete(this);
            } else {
                try {
                    this.complete(this.mCombineResults.apply(this.mResultT, res));
                }
                catch (Throwable t) {
                    this.completeExceptionally(t);
                }
            }
        }
    }

    private static class ThenApplyAsync<T, U>
    extends AndroidFuture<U>
    implements BiConsumer<T, Throwable>,
    Runnable {
        private volatile T mSourceResult = null;
        private final Executor mExecutor;
        private final Function<? super T, ? extends U> mFn;

        ThenApplyAsync(AndroidFuture<T> source, Function<? super T, ? extends U> fn, Executor executor) {
            this.mExecutor = Preconditions.checkNotNull(executor);
            this.mFn = Preconditions.checkNotNull(fn);
            source.whenComplete((BiConsumer)this);
        }

        @Override
        public void accept(T res, Throwable err) {
            if (err != null) {
                this.completeExceptionally(err);
            } else {
                this.mSourceResult = res;
                this.mExecutor.execute(this);
            }
        }

        @Override
        public void run() {
            try {
                this.complete(this.mFn.apply(this.mSourceResult));
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
            }
        }
    }

    private static class ThenComposeAsync<T, U>
    extends AndroidFuture<U>
    implements BiConsumer<Object, Throwable>,
    Runnable {
        private volatile T mSourceResult = null;
        private final Executor mExecutor;
        private volatile Function<? super T, ? extends CompletionStage<U>> mFn;

        ThenComposeAsync(AndroidFuture<T> source, Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
            this.mFn = Preconditions.checkNotNull(fn);
            this.mExecutor = Preconditions.checkNotNull(executor);
            source.whenComplete((BiConsumer)this);
        }

        @Override
        public void accept(Object res, Throwable err) {
            if (err != null) {
                this.completeExceptionally(err);
            } else if (this.mFn != null) {
                this.mSourceResult = res;
                this.mExecutor.execute(this);
            } else {
                this.complete(res);
            }
        }

        @Override
        public void run() {
            CompletionStage<U> secondJob;
            try {
                secondJob = Preconditions.checkNotNull(this.mFn.apply(this.mSourceResult));
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
                return;
            }
            finally {
                this.mFn = null;
            }
            secondJob.whenComplete(this);
        }
    }
}

