/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.drawable;

import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationScaleListDrawable
extends DrawableContainer
implements Animatable {
    private static final String TAG = "AnimationScaleListDrawable";
    private AnimationScaleListState mAnimationScaleListState;
    private boolean mMutated;

    public AnimationScaleListDrawable() {
        this(null, null);
    }

    private AnimationScaleListDrawable(AnimationScaleListState state, Resources res) {
        AnimationScaleListState newState2 = new AnimationScaleListState(state, this, res);
        this.setConstantState(newState2);
        this.onStateChange(this.getState());
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        int idx = this.mAnimationScaleListState.getCurrentDrawableIndexBasedOnScale();
        return this.selectDrawable(idx) || changed;
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimationScaleListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimationScaleListDrawable);
        this.updateDensity(r);
        a.recycle();
        this.inflateChildElements(r, parser, attrs, theme);
        this.onStateChange(this.getState());
    }

    private void inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        AnimationScaleListState state = this.mAnimationScaleListState;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = AnimationScaleListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimationScaleListDrawableItem);
            Drawable dr = a.getDrawable(0);
            a.recycle();
            if (dr == null) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            state.addDrawable(dr);
        }
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimationScaleListState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    public void start() {
        Drawable dr = this.getCurrent();
        if (dr != null && dr instanceof Animatable) {
            ((Animatable)((Object)dr)).start();
        }
    }

    @Override
    public void stop() {
        Drawable dr = this.getCurrent();
        if (dr != null && dr instanceof Animatable) {
            ((Animatable)((Object)dr)).stop();
        }
    }

    @Override
    public boolean isRunning() {
        boolean result = false;
        Drawable dr = this.getCurrent();
        if (dr != null && dr instanceof Animatable) {
            result = ((Animatable)((Object)dr)).isRunning();
        }
        return result;
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        this.onStateChange(this.getState());
    }

    @Override
    protected void setConstantState(DrawableContainer.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof AnimationScaleListState) {
            this.mAnimationScaleListState = (AnimationScaleListState)state;
        }
    }

    static class AnimationScaleListState
    extends DrawableContainer.DrawableContainerState {
        int[] mThemeAttrs = null;
        int mStaticDrawableIndex = -1;
        int mAnimatableDrawableIndex = -1;

        AnimationScaleListState(AnimationScaleListState orig, AnimationScaleListDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mStaticDrawableIndex = orig.mStaticDrawableIndex;
                this.mAnimatableDrawableIndex = orig.mAnimatableDrawableIndex;
            }
        }

        void mutate() {
            this.mThemeAttrs = this.mThemeAttrs != null ? (int[])this.mThemeAttrs.clone() : null;
        }

        int addDrawable(Drawable drawable2) {
            int pos = this.addChild(drawable2);
            if (drawable2 instanceof Animatable) {
                this.mAnimatableDrawableIndex = pos;
            } else {
                this.mStaticDrawableIndex = pos;
            }
            return pos;
        }

        @Override
        public Drawable newDrawable() {
            return new AnimationScaleListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new AnimationScaleListDrawable(this, res);
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || super.canApplyTheme();
        }

        public int getCurrentDrawableIndexBasedOnScale() {
            if (ValueAnimator.getDurationScale() == 0.0f) {
                return this.mStaticDrawableIndex;
            }
            return this.mAnimatableDrawableIndex;
        }
    }
}

