/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.ActivityThread;
import android.app.VoiceInteractor;
import android.app.admin.DevicePolicyEventLogger;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.PermissionChecker;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Insets;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PatternMatcher;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.Space;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.ResolverMultiProfilePagerAdapter;
import com.android.internal.app.chooser.ChooserTargetInfo;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.app.chooser.TargetInfo;
import com.android.internal.content.PackageMonitor;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.widget.ResolverDrawerLayout;
import com.android.internal.widget.ViewPager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ResolverActivity
extends Activity
implements ResolverListAdapter.ResolverListCommunicator {
    private boolean mSafeForwardingMode;
    private Button mAlwaysButton;
    private Button mOnceButton;
    protected View mProfileView;
    private int mLastSelected = -1;
    private boolean mResolvingHome = false;
    private int mProfileSwitchMessageId = -1;
    private int mLayoutId;
    @VisibleForTesting
    protected final ArrayList<Intent> mIntents = new ArrayList();
    private PickTargetOptionRequest mPickOptionRequest;
    private String mReferrerPackage;
    private CharSequence mTitle;
    private int mDefaultTitleResId;
    @VisibleForTesting
    protected boolean mSupportsAlwaysUseOption;
    protected ResolverDrawerLayout mResolverDrawerLayout;
    @UnsupportedAppUsage
    protected PackageManager mPm;
    protected int mLaunchedFromUid;
    private static final String TAG = "ResolverActivity";
    private static final boolean DEBUG = false;
    private static final String LAST_SHOWN_TAB_KEY = "last_shown_tab_key";
    private boolean mRegistered;
    protected Insets mSystemWindowInsets = null;
    private Space mFooterSpacer = null;
    private boolean mRetainInOnStop;
    private static final String EXTRA_SHOW_FRAGMENT_ARGS = ":settings:show_fragment_args";
    private static final String EXTRA_FRAGMENT_ARG_KEY = ":settings:fragment_args_key";
    private static final String OPEN_LINKS_COMPONENT_KEY = "app_link_state";
    protected static final String METRICS_CATEGORY_RESOLVER = "intent_resolver";
    protected static final String METRICS_CATEGORY_CHOOSER = "intent_chooser";
    private boolean mWorkProfileHasBeenEnabled = false;
    @VisibleForTesting
    public static boolean ENABLE_TABBED_VIEW = true;
    private static final String TAB_TAG_PERSONAL = "personal";
    private static final String TAB_TAG_WORK = "work";
    private PackageMonitor mPersonalPackageMonitor;
    private PackageMonitor mWorkPackageMonitor;
    @VisibleForTesting
    protected AbstractMultiProfilePagerAdapter mMultiProfilePagerAdapter;
    public static final String EXTRA_IS_AUDIO_CAPTURE_DEVICE = "is_audio_capture_device";
    static final String EXTRA_SELECTED_PROFILE = "com.android.internal.app.ResolverActivity.EXTRA_SELECTED_PROFILE";
    static final String EXTRA_CALLING_USER = "com.android.internal.app.ResolverActivity.EXTRA_CALLING_USER";
    static final int PROFILE_PERSONAL = 0;
    static final int PROFILE_WORK = 1;
    private BroadcastReceiver mWorkProfileStateReceiver;
    private UserHandle mHeaderCreatorUser;
    private UserHandle mWorkProfileUserHandle;

    @UnsupportedAppUsage
    public ResolverActivity() {
    }

    public static int getLabelRes(String action2) {
        return ActionTitle.forAction((String)action2).labelRes;
    }

    protected PackageMonitor createPackageMonitor(final ResolverListAdapter listAdapter) {
        return new PackageMonitor(){

            @Override
            public void onSomePackagesChanged() {
                listAdapter.handlePackagesChanged();
                ResolverActivity.this.updateProfileViewButton();
            }

            @Override
            public boolean onPackageChanged(String packageName, int uid, String[] components) {
                return true;
            }
        };
    }

    private Intent makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setComponent(null);
        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent = this.makeMyIntent();
        Set<String> categories = intent.getCategories();
        if ("android.intent.action.MAIN".equals(intent.getAction()) && categories != null && categories.size() == 1 && categories.contains("android.intent.category.HOME")) {
            this.mResolvingHome = true;
        }
        this.setSafeForwardingMode(true);
        this.onCreate(savedInstanceState, intent, null, 0, null, null, true);
    }

    @UnsupportedAppUsage
    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, Intent[] initialIntents, List<ResolveInfo> rList, boolean supportsAlwaysUseOption) {
        this.onCreate(savedInstanceState, intent, title, 0, initialIntents, rList, supportsAlwaysUseOption);
    }

    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, int defaultTitleRes, Intent[] initialIntents, List<ResolveInfo> rList, boolean supportsAlwaysUseOption) {
        this.setTheme(this.appliedThemeResId());
        super.onCreate(savedInstanceState);
        this.setProfileSwitchMessageId(intent.getContentUserHint());
        this.mLaunchedFromUid = this.getLaunchedFromUid();
        if (this.mLaunchedFromUid < 0 || UserHandle.isIsolated(this.mLaunchedFromUid)) {
            this.finish();
            return;
        }
        this.mPm = this.getPackageManager();
        this.mReferrerPackage = this.getReferrerPackageName();
        this.mIntents.add(0, new Intent(intent));
        this.mTitle = title;
        this.mDefaultTitleResId = defaultTitleRes;
        this.mSupportsAlwaysUseOption = supportsAlwaysUseOption;
        this.mWorkProfileUserHandle = this.fetchWorkProfileUserProfile();
        boolean filterLastUsed = this.mSupportsAlwaysUseOption && !this.isVoiceInteraction() && !this.shouldShowTabs();
        this.mMultiProfilePagerAdapter = this.createMultiProfilePagerAdapter(initialIntents, rList, filterLastUsed);
        if (this.configureContentView()) {
            return;
        }
        this.mPersonalPackageMonitor = this.createPackageMonitor(this.mMultiProfilePagerAdapter.getPersonalListAdapter());
        this.mPersonalPackageMonitor.register((Context)this, this.getMainLooper(), this.getPersonalProfileUserHandle(), false);
        if (this.shouldShowTabs()) {
            this.mWorkPackageMonitor = this.createPackageMonitor(this.mMultiProfilePagerAdapter.getWorkListAdapter());
            this.mWorkPackageMonitor.register((Context)this, this.getMainLooper(), this.getWorkProfileUserHandle(), false);
        }
        this.mRegistered = true;
        ResolverDrawerLayout rdl = (ResolverDrawerLayout)this.findViewById(16908870);
        if (rdl != null) {
            rdl.setOnDismissedListener(new ResolverDrawerLayout.OnDismissedListener(){

                @Override
                public void onDismissed() {
                    ResolverActivity.this.finish();
                }
            });
            boolean hasTouchScreen = this.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
            if (this.isVoiceInteraction() || !hasTouchScreen) {
                rdl.setCollapsed(false);
            }
            rdl.setSystemUiVisibility(768);
            rdl.setOnApplyWindowInsetsListener(this::onApplyWindowInsets);
            this.mResolverDrawerLayout = rdl;
        }
        this.mProfileView = this.findViewById(16909326);
        if (this.mProfileView != null) {
            this.mProfileView.setOnClickListener(this::onProfileClick);
            this.updateProfileViewButton();
        }
        Set<String> categories = intent.getCategories();
        MetricsLogger.action((Context)this, this.mMultiProfilePagerAdapter.getActiveListAdapter().hasFilteredItem() ? 451 : 453, intent.getAction() + ":" + intent.getType() + ":" + (categories != null ? Arrays.toString(categories.toArray()) : ""));
    }

    private boolean isIntentPicker() {
        return this.getClass().equals(ResolverActivity.class);
    }

    protected AbstractMultiProfilePagerAdapter createMultiProfilePagerAdapter(Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed) {
        ResolverMultiProfilePagerAdapter resolverMultiProfilePagerAdapter = null;
        resolverMultiProfilePagerAdapter = this.shouldShowTabs() ? this.createResolverMultiProfilePagerAdapterForTwoProfiles(initialIntents, rList, filterLastUsed) : this.createResolverMultiProfilePagerAdapterForOneProfile(initialIntents, rList, filterLastUsed);
        return resolverMultiProfilePagerAdapter;
    }

    private ResolverMultiProfilePagerAdapter createResolverMultiProfilePagerAdapterForOneProfile(Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed) {
        ResolverListAdapter adapter = this.createResolverListAdapter(this, this.mIntents, initialIntents, rList, filterLastUsed, UserHandle.of(UserHandle.myUserId()));
        return new ResolverMultiProfilePagerAdapter((Context)this, adapter, this.getPersonalProfileUserHandle(), null);
    }

    private ResolverMultiProfilePagerAdapter createResolverMultiProfilePagerAdapterForTwoProfiles(Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed) {
        UserHandle intentUser;
        int selectedProfile = this.getCurrentProfile();
        UserHandle userHandle = intentUser = this.getIntent().hasExtra(EXTRA_CALLING_USER) ? (UserHandle)this.getIntent().getParcelableExtra(EXTRA_CALLING_USER) : this.getUser();
        if (!this.getUser().equals(intentUser)) {
            if (this.getPersonalProfileUserHandle().equals(intentUser)) {
                selectedProfile = 0;
            } else if (this.getWorkProfileUserHandle().equals(intentUser)) {
                selectedProfile = 1;
            }
        } else {
            int selectedProfileExtra = this.getSelectedProfileExtra();
            if (selectedProfileExtra != -1) {
                selectedProfile = selectedProfileExtra;
            }
        }
        ResolverListAdapter personalAdapter = this.createResolverListAdapter(this, this.mIntents, (Intent[])(selectedProfile == 0 ? initialIntents : null), rList, filterLastUsed && UserHandle.myUserId() == this.getPersonalProfileUserHandle().getIdentifier(), this.getPersonalProfileUserHandle());
        UserHandle workProfileUserHandle = this.getWorkProfileUserHandle();
        ResolverListAdapter workAdapter = this.createResolverListAdapter(this, this.mIntents, (Intent[])(selectedProfile == 1 ? initialIntents : null), rList, filterLastUsed && UserHandle.myUserId() == workProfileUserHandle.getIdentifier(), workProfileUserHandle);
        return new ResolverMultiProfilePagerAdapter(this, personalAdapter, workAdapter, selectedProfile, this.getPersonalProfileUserHandle(), this.getWorkProfileUserHandle(), this.getUser().equals(intentUser));
    }

    protected int appliedThemeResId() {
        return 16974834;
    }

    int getSelectedProfileExtra() {
        int selectedProfile = -1;
        if (this.getIntent().hasExtra(EXTRA_SELECTED_PROFILE) && (selectedProfile = this.getIntent().getIntExtra(EXTRA_SELECTED_PROFILE, -1)) != 0 && selectedProfile != 1) {
            throw new IllegalArgumentException("com.android.internal.app.ResolverActivity.EXTRA_SELECTED_PROFILE has invalid value " + selectedProfile + ". Must be either ResolverActivity.PROFILE_PERSONAL or ResolverActivity.PROFILE_WORK.");
        }
        return selectedProfile;
    }

    @AbstractMultiProfilePagerAdapter.Profile
    protected int getCurrentProfile() {
        return UserHandle.myUserId() == 0 ? 0 : 1;
    }

    protected UserHandle getPersonalProfileUserHandle() {
        return UserHandle.of(ActivityManager.getCurrentUser());
    }

    protected UserHandle getWorkProfileUserHandle() {
        return this.mWorkProfileUserHandle;
    }

    protected UserHandle fetchWorkProfileUserProfile() {
        this.mWorkProfileUserHandle = null;
        UserManager userManager = this.getSystemService(UserManager.class);
        for (UserInfo userInfo : userManager.getProfiles(ActivityManager.getCurrentUser())) {
            if (!userInfo.isManagedProfile()) continue;
            this.mWorkProfileUserHandle = userInfo.getUserHandle();
        }
        return this.mWorkProfileUserHandle;
    }

    private boolean hasWorkProfile() {
        return this.getWorkProfileUserHandle() != null;
    }

    protected boolean shouldShowTabs() {
        return this.hasWorkProfile() && ENABLE_TABBED_VIEW;
    }

    protected void onProfileClick(View v) {
        DisplayResolveInfo dri = this.mMultiProfilePagerAdapter.getActiveListAdapter().getOtherProfile();
        if (dri == null) {
            return;
        }
        this.mProfileSwitchMessageId = -1;
        this.onTargetSelected(dri, false);
        this.finish();
    }

    protected boolean shouldAddFooterView() {
        if (this.useLayoutWithDefault()) {
            return true;
        }
        Object buttonBar = this.findViewById(16908814);
        return buttonBar == null || ((View)buttonBar).getVisibility() == 8;
    }

    protected void applyFooterView(int height) {
        if (this.mFooterSpacer == null) {
            this.mFooterSpacer = new Space(this.getApplicationContext());
        } else {
            ((ResolverMultiProfilePagerAdapter)this.mMultiProfilePagerAdapter).getActiveAdapterView().removeFooterView(this.mFooterSpacer);
        }
        this.mFooterSpacer.setLayoutParams(new AbsListView.LayoutParams(-1, this.mSystemWindowInsets.bottom));
        ((ResolverMultiProfilePagerAdapter)this.mMultiProfilePagerAdapter).getActiveAdapterView().addFooterView(this.mFooterSpacer);
    }

    protected WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
        this.mSystemWindowInsets = insets.getSystemWindowInsets();
        this.mResolverDrawerLayout.setPadding(this.mSystemWindowInsets.left, this.mSystemWindowInsets.top, this.mSystemWindowInsets.right, 0);
        this.resetButtonBar();
        if (this.shouldAddFooterView()) {
            this.applyFooterView(this.mSystemWindowInsets.bottom);
        }
        return insets.consumeSystemWindowInsets();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mMultiProfilePagerAdapter.getActiveListAdapter().handlePackagesChanged();
        if (this.isIntentPicker() && this.shouldShowTabs() && !this.useLayoutWithDefault()) {
            this.updateIntentPickerPaddings();
        }
        if (this.mSystemWindowInsets != null) {
            this.mResolverDrawerLayout.setPadding(this.mSystemWindowInsets.left, this.mSystemWindowInsets.top, this.mSystemWindowInsets.right, 0);
        }
    }

    private void updateIntentPickerPaddings() {
        Object titleCont = this.findViewById(16909565);
        ((View)titleCont).setPadding(((View)titleCont).getPaddingLeft(), ((View)titleCont).getPaddingTop(), ((View)titleCont).getPaddingRight(), this.getResources().getDimensionPixelSize(17105494));
        Object buttonBar = this.findViewById(16908814);
        ((View)buttonBar).setPadding(((View)buttonBar).getPaddingLeft(), this.getResources().getDimensionPixelSize(17105478), ((View)buttonBar).getPaddingRight(), this.getResources().getDimensionPixelSize(17105478));
        this.mMultiProfilePagerAdapter.updateAfterConfigChange();
    }

    @Override
    public void sendVoiceChoicesIfNeeded() {
        if (!this.isVoiceInteraction()) {
            return;
        }
        int count = this.mMultiProfilePagerAdapter.getActiveListAdapter().getCount();
        VoiceInteractor.PickOptionRequest.Option[] options = new VoiceInteractor.PickOptionRequest.Option[count];
        int N = options.length;
        for (int i = 0; i < N; ++i) {
            TargetInfo target = this.mMultiProfilePagerAdapter.getActiveListAdapter().getItem(i);
            if (target == null) {
                return;
            }
            options[i] = this.optionForChooserTarget(target, i);
        }
        this.mPickOptionRequest = new PickTargetOptionRequest(new VoiceInteractor.Prompt(this.getTitle()), options, null);
        this.getVoiceInteractor().submitRequest(this.mPickOptionRequest);
    }

    VoiceInteractor.PickOptionRequest.Option optionForChooserTarget(TargetInfo target, int index) {
        return new VoiceInteractor.PickOptionRequest.Option(target.getDisplayLabel(), index);
    }

    protected void setAdditionalTargets(Intent[] intents) {
        if (intents != null) {
            for (Intent intent : intents) {
                this.mIntents.add(intent);
            }
        }
    }

    @Override
    public Intent getTargetIntent() {
        return this.mIntents.isEmpty() ? null : this.mIntents.get(0);
    }

    protected String getReferrerPackageName() {
        Uri referrer = this.getReferrer();
        if (referrer != null && "android-app".equals(referrer.getScheme())) {
            return referrer.getHost();
        }
        return null;
    }

    public int getLayoutResource() {
        return 17367282;
    }

    @Override
    public void updateProfileViewButton() {
        if (this.mProfileView == null) {
            return;
        }
        DisplayResolveInfo dri = this.mMultiProfilePagerAdapter.getActiveListAdapter().getOtherProfile();
        if (dri != null && !this.shouldShowTabs()) {
            this.mProfileView.setVisibility(0);
            Object text = this.mProfileView.findViewById(16909326);
            if (!(text instanceof TextView)) {
                text = this.mProfileView.findViewById(16908308);
            }
            ((TextView)text).setText(dri.getDisplayLabel());
        } else {
            this.mProfileView.setVisibility(8);
        }
    }

    private void setProfileSwitchMessageId(int contentUserHint) {
        if (contentUserHint != -2 && contentUserHint != UserHandle.myUserId()) {
            UserManager userManager = (UserManager)this.getSystemService("user");
            UserInfo originUserInfo = userManager.getUserInfo(contentUserHint);
            boolean originIsManaged = originUserInfo != null ? originUserInfo.isManagedProfile() : false;
            boolean targetIsManaged = userManager.isManagedProfile();
            if (originIsManaged && !targetIsManaged) {
                this.mProfileSwitchMessageId = 17040309;
            } else if (!originIsManaged && targetIsManaged) {
                this.mProfileSwitchMessageId = 17040310;
            }
        }
    }

    public void setSafeForwardingMode(boolean safeForwarding) {
        this.mSafeForwardingMode = safeForwarding;
    }

    protected CharSequence getTitleForAction(Intent intent, int defaultTitleRes) {
        boolean named;
        ActionTitle title = this.mResolvingHome ? ActionTitle.HOME : ActionTitle.forAction(intent.getAction());
        boolean bl = named = this.mMultiProfilePagerAdapter.getActiveListAdapter().getFilteredPosition() >= 0;
        if (title == ActionTitle.DEFAULT && defaultTitleRes != 0) {
            return this.getString(defaultTitleRes);
        }
        return named ? this.getString(title.namedTitleRes, this.mMultiProfilePagerAdapter.getActiveListAdapter().getFilteredItem().getDisplayLabel()) : this.getString(title.titleRes);
    }

    void dismiss() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        if (!this.mRegistered) {
            this.mPersonalPackageMonitor.register((Context)this, this.getMainLooper(), this.getPersonalProfileUserHandle(), false);
            if (this.shouldShowTabs()) {
                if (this.mWorkPackageMonitor == null) {
                    this.mWorkPackageMonitor = this.createPackageMonitor(this.mMultiProfilePagerAdapter.getWorkListAdapter());
                }
                this.mWorkPackageMonitor.register((Context)this, this.getMainLooper(), this.getWorkProfileUserHandle(), false);
            }
            this.mRegistered = true;
        }
        if (this.shouldShowTabs() && this.mMultiProfilePagerAdapter.isWaitingToEnableWorkProfile() && this.mMultiProfilePagerAdapter.isQuietModeEnabled(this.getWorkProfileUserHandle())) {
            this.mMultiProfilePagerAdapter.markWorkProfileEnabledBroadcastReceived();
        }
        this.mMultiProfilePagerAdapter.getActiveListAdapter().handlePackagesChanged();
        this.updateProfileViewButton();
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.getWindow().addSystemFlags(524288);
        if (this.shouldShowTabs()) {
            this.mWorkProfileStateReceiver = this.createWorkProfileStateReceiver();
            this.registerWorkProfileStateReceiver();
            this.mWorkProfileHasBeenEnabled = this.isWorkProfileEnabled();
        }
    }

    private boolean isWorkProfileEnabled() {
        UserHandle workUserHandle = this.getWorkProfileUserHandle();
        UserManager userManager = this.getSystemService(UserManager.class);
        return !userManager.isQuietModeEnabled(workUserHandle) && userManager.isUserUnlocked(workUserHandle);
    }

    private void registerWorkProfileStateReceiver() {
        IntentFilter filter2 = new IntentFilter();
        filter2.addAction("android.intent.action.USER_UNLOCKED");
        filter2.addAction("android.intent.action.MANAGED_PROFILE_AVAILABLE");
        filter2.addAction("android.intent.action.MANAGED_PROFILE_UNAVAILABLE");
        this.registerReceiverAsUser(this.mWorkProfileStateReceiver, UserHandle.ALL, filter2, null, null);
    }

    @Override
    protected void onStop() {
        Intent intent;
        super.onStop();
        Window window = this.getWindow();
        WindowManager.LayoutParams attrs = window.getAttributes();
        attrs.privateFlags &= 0xFFF7FFFF;
        window.setAttributes(attrs);
        if (this.mRegistered) {
            this.mPersonalPackageMonitor.unregister();
            if (this.mWorkPackageMonitor != null) {
                this.mWorkPackageMonitor.unregister();
            }
            this.mRegistered = false;
        }
        if (!(((intent = this.getIntent()).getFlags() & 0x10000000) == 0 || this.isVoiceInteraction() || this.mResolvingHome || this.mRetainInOnStop || this.isChangingConfigurations())) {
            this.finish();
        }
        if (this.mWorkPackageMonitor != null) {
            this.unregisterReceiver(this.mWorkProfileStateReceiver);
            this.mWorkPackageMonitor = null;
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (!this.isChangingConfigurations() && this.mPickOptionRequest != null) {
            this.mPickOptionRequest.cancel();
        }
        if (this.mMultiProfilePagerAdapter.getActiveListAdapter() != null) {
            this.mMultiProfilePagerAdapter.getActiveListAdapter().onDestroy();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        ViewPager viewPager = (ViewPager)this.findViewById(16909327);
        outState.putInt(LAST_SHOWN_TAB_KEY, viewPager.getCurrentItem());
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.resetButtonBar();
        ViewPager viewPager = (ViewPager)this.findViewById(16909327);
        viewPager.setCurrentItem(savedInstanceState.getInt(LAST_SHOWN_TAB_KEY));
        this.mMultiProfilePagerAdapter.clearInactiveProfileCache();
    }

    private boolean hasManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        if (userManager == null) {
            return false;
        }
        try {
            List<UserInfo> profiles = userManager.getProfiles(this.getUserId());
            for (UserInfo userInfo : profiles) {
                if (userInfo == null || !userInfo.isManagedProfile()) continue;
                return true;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return false;
    }

    private boolean supportsManagedProfiles(ResolveInfo resolveInfo) {
        try {
            ApplicationInfo appInfo = this.getPackageManager().getApplicationInfo(resolveInfo.activityInfo.packageName, 0);
            return appInfo.targetSdkVersion >= 21;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private void setAlwaysButtonEnabled(boolean hasValidSelection, int checkedPos, boolean filtered) {
        if (!this.mMultiProfilePagerAdapter.getCurrentUserHandle().equals(this.getUser())) {
            this.mAlwaysButton.setEnabled(false);
            return;
        }
        boolean enabled = false;
        ResolveInfo ri = null;
        if (hasValidSelection) {
            ri = this.mMultiProfilePagerAdapter.getActiveListAdapter().resolveInfoForPosition(checkedPos, filtered);
            if (ri == null) {
                Log.e(TAG, "Invalid position supplied to setAlwaysButtonEnabled");
                return;
            }
            if (ri.targetUserId != -2) {
                Log.e(TAG, "Attempted to set selection to resolve info for another user");
                return;
            }
            enabled = true;
            this.mAlwaysButton.setText(this.getResources().getString(17039619));
        }
        if (ri != null) {
            boolean hasRecordPermission;
            ActivityInfo activityInfo = ri.activityInfo;
            boolean bl = hasRecordPermission = this.mPm.checkPermission("android.permission.RECORD_AUDIO", activityInfo.packageName) == 0;
            if (!hasRecordPermission) {
                boolean hasAudioCapture = this.getIntent().getBooleanExtra(EXTRA_IS_AUDIO_CAPTURE_DEVICE, false);
                enabled = !hasAudioCapture;
            }
        }
        this.mAlwaysButton.setEnabled(enabled);
    }

    public void onButtonClick(View v) {
        int id2 = v.getId();
        ListView listView = (ListView)this.mMultiProfilePagerAdapter.getActiveAdapterView();
        ResolverListAdapter currentListAdapter = this.mMultiProfilePagerAdapter.getActiveListAdapter();
        int which = currentListAdapter.hasFilteredItem() ? currentListAdapter.getFilteredPosition() : listView.getCheckedItemPosition();
        boolean hasIndexBeenFiltered = !currentListAdapter.hasFilteredItem();
        this.startSelected(which, id2 == 16908813, hasIndexBeenFiltered);
    }

    public void startSelected(int which, boolean always, boolean hasIndexBeenFiltered) {
        if (this.isFinishing()) {
            return;
        }
        ResolveInfo ri = this.mMultiProfilePagerAdapter.getActiveListAdapter().resolveInfoForPosition(which, hasIndexBeenFiltered);
        if (this.mResolvingHome && this.hasManagedProfile() && !this.supportsManagedProfiles(ri)) {
            Toast.makeText((Context)this, String.format(this.getResources().getString(17039621), ri.activityInfo.loadLabel(this.getPackageManager()).toString()), 1).show();
            return;
        }
        TargetInfo target = this.mMultiProfilePagerAdapter.getActiveListAdapter().targetInfoForPosition(which, hasIndexBeenFiltered);
        if (target == null) {
            return;
        }
        if (this.onTargetSelected(target, always)) {
            if (always && this.mSupportsAlwaysUseOption) {
                MetricsLogger.action(this, 455);
            } else if (this.mSupportsAlwaysUseOption) {
                MetricsLogger.action(this, 456);
            } else {
                MetricsLogger.action(this, 457);
            }
            MetricsLogger.action(this, this.mMultiProfilePagerAdapter.getActiveListAdapter().hasFilteredItem() ? 452 : 454);
            this.finish();
        }
    }

    @Override
    public Intent getReplacementIntent(ActivityInfo aInfo, Intent defIntent) {
        return defIntent;
    }

    @Override
    public void onPostListReady(ResolverListAdapter listAdapter, boolean doPostProcessing, boolean rebuildCompleted) {
        if (this.isAutolaunching()) {
            return;
        }
        if (this.isIntentPicker()) {
            ((ResolverMultiProfilePagerAdapter)this.mMultiProfilePagerAdapter).setUseLayoutWithDefault(this.useLayoutWithDefault());
        }
        if (this.mMultiProfilePagerAdapter.shouldShowEmptyStateScreen(listAdapter)) {
            this.mMultiProfilePagerAdapter.showEmptyResolverListEmptyState(listAdapter);
        } else {
            this.mMultiProfilePagerAdapter.showListView(listAdapter);
        }
        if (rebuildCompleted && this.maybeAutolaunchActivity()) {
            return;
        }
        if (doPostProcessing) {
            this.maybeCreateHeader(listAdapter);
            this.resetButtonBar();
            this.onListRebuilt(listAdapter);
        }
    }

    protected void onListRebuilt(ResolverListAdapter listAdapter) {
        ResolverDrawerLayout rdl;
        ItemClickListener listener2 = new ItemClickListener();
        this.setupAdapterListView((ListView)this.mMultiProfilePagerAdapter.getActiveAdapterView(), listener2);
        if (this.shouldShowTabs() && this.isIntentPicker() && (rdl = (ResolverDrawerLayout)this.findViewById(16908870)) != null) {
            rdl.setMaxCollapsedHeight(this.getResources().getDimensionPixelSize(this.useLayoutWithDefault() ? 17105489 : 17105490));
        }
    }

    protected boolean onTargetSelected(TargetInfo target, boolean always) {
        Intent intent;
        ResolveInfo ri = target.getResolveInfo();
        Intent intent2 = intent = target != null ? target.getResolvedIntent() : null;
        if (intent != null && (this.mSupportsAlwaysUseOption || this.mMultiProfilePagerAdapter.getActiveListAdapter().hasFilteredItem()) && this.mMultiProfilePagerAdapter.getActiveListAdapter().getUnfilteredResolveList() != null) {
            String mimeType;
            Set<String> categories;
            IntentFilter filter2 = new IntentFilter();
            Intent filterIntent = intent.getSelector() != null ? intent.getSelector() : intent;
            String action2 = filterIntent.getAction();
            if (action2 != null) {
                filter2.addAction(action2);
            }
            if ((categories = filterIntent.getCategories()) != null) {
                for (String cat : categories) {
                    filter2.addCategory(cat);
                }
            }
            filter2.addCategory("android.intent.category.DEFAULT");
            int cat = ri.match & 0xFFF0000;
            Uri data = filterIntent.getData();
            if (cat == 0x600000 && (mimeType = filterIntent.resolveType(this)) != null) {
                try {
                    filter2.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w(TAG, e);
                    filter2 = null;
                }
            }
            if (data != null && data.getScheme() != null && (cat != 0x600000 || !"file".equals(data.getScheme()) && !"content".equals(data.getScheme()))) {
                Iterator<IntentFilter.AuthorityEntry> aIt;
                filter2.addDataScheme(data.getScheme());
                Iterator<PatternMatcher> pIt = ri.filter.schemeSpecificPartsIterator();
                if (pIt != null) {
                    String ssp = data.getSchemeSpecificPart();
                    while (ssp != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(ssp)) continue;
                        filter2.addDataSchemeSpecificPart(p.getPath(), p.getType());
                        break;
                    }
                }
                if ((aIt = ri.filter.authoritiesIterator()) != null) {
                    while (aIt.hasNext()) {
                        IntentFilter.AuthorityEntry a = aIt.next();
                        if (a.match(data) < 0) continue;
                        int port = a.getPort();
                        filter2.addDataAuthority(a.getHost(), port >= 0 ? Integer.toString(port) : null);
                        break;
                    }
                }
                if ((pIt = ri.filter.pathsIterator()) != null) {
                    String path = data.getPath();
                    while (path != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(path)) continue;
                        filter2.addDataPath(p.getPath(), p.getType());
                        break;
                    }
                }
            }
            if (filter2 != null) {
                int N = this.mMultiProfilePagerAdapter.getActiveListAdapter().getUnfilteredResolveList().size();
                boolean needToAddBackProfileForwardingComponent = this.mMultiProfilePagerAdapter.getActiveListAdapter().getOtherProfile() != null;
                ComponentName[] set = !needToAddBackProfileForwardingComponent ? new ComponentName[N] : new ComponentName[N + 1];
                int bestMatch = 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo r = this.mMultiProfilePagerAdapter.getActiveListAdapter().getUnfilteredResolveList().get(i).getResolveInfoAt(0);
                    set[i] = new ComponentName(r.activityInfo.packageName, r.activityInfo.name);
                    if (r.match <= bestMatch) continue;
                    bestMatch = r.match;
                }
                if (needToAddBackProfileForwardingComponent) {
                    set[N] = this.mMultiProfilePagerAdapter.getActiveListAdapter().getOtherProfile().getResolvedComponentName();
                    int otherProfileMatch = this.mMultiProfilePagerAdapter.getActiveListAdapter().getOtherProfile().getResolveInfo().match;
                    if (otherProfileMatch > bestMatch) {
                        bestMatch = otherProfileMatch;
                    }
                }
                if (always) {
                    String packageName;
                    int userId = this.getUserId();
                    PackageManager pm = this.getPackageManager();
                    pm.addUniquePreferredActivity(filter2, bestMatch, set, intent.getComponent());
                    if (ri.handleAllWebDataURI && TextUtils.isEmpty(packageName = pm.getDefaultBrowserPackageNameAsUser(userId))) {
                        pm.setDefaultBrowserPackageNameAsUser(ri.activityInfo.packageName, userId);
                    }
                } else {
                    try {
                        this.mMultiProfilePagerAdapter.getActiveListAdapter().mResolverListController.setLastChosen(intent, filter2, bestMatch);
                    }
                    catch (RemoteException re) {
                        Log.d(TAG, "Error calling setLastChosenActivity\n" + re);
                    }
                }
            }
        }
        if (target != null) {
            if (intent != null && this.isLaunchingTargetInOtherProfile()) {
                this.prepareIntentForCrossProfileLaunch(intent);
            }
            this.safelyStartActivity(target);
            if (target.isSuspended()) {
                return false;
            }
        }
        return true;
    }

    private void prepareIntentForCrossProfileLaunch(Intent intent) {
        intent.fixUris(UserHandle.myUserId());
    }

    private boolean isLaunchingTargetInOtherProfile() {
        return this.mMultiProfilePagerAdapter.getCurrentUserHandle().getIdentifier() != UserHandle.myUserId();
    }

    @VisibleForTesting
    public void safelyStartActivity(TargetInfo cti) {
        StrictMode.disableDeathOnFileUriExposure();
        try {
            UserHandle currentUserHandle = this.mMultiProfilePagerAdapter.getCurrentUserHandle();
            this.safelyStartActivityInternal(cti, currentUserHandle);
        }
        finally {
            StrictMode.enableDeathOnFileUriExposure();
        }
    }

    @VisibleForTesting
    public void safelyStartActivityAsUser(TargetInfo cti, UserHandle user) {
        StrictMode.disableDeathOnFileUriExposure();
        try {
            this.safelyStartActivityInternal(cti, user);
        }
        finally {
            StrictMode.enableDeathOnFileUriExposure();
        }
    }

    private void safelyStartActivityInternal(TargetInfo cti, UserHandle user) {
        if (!cti.isSuspended() && this.mRegistered) {
            if (this.mPersonalPackageMonitor != null) {
                this.mPersonalPackageMonitor.unregister();
            }
            if (this.mWorkPackageMonitor != null) {
                this.mWorkPackageMonitor.unregister();
            }
            this.mRegistered = false;
        }
        if (this.mProfileSwitchMessageId != -1) {
            Toast.makeText((Context)this, this.getString(this.mProfileSwitchMessageId), 1).show();
        }
        if (!this.mSafeForwardingMode) {
            if (cti.startAsUser(this, null, user)) {
                this.onActivityStarted(cti);
                this.maybeLogCrossProfileTargetLaunch(cti, user);
            }
            return;
        }
        try {
            if (cti.startAsCaller(this, null, user.getIdentifier())) {
                this.onActivityStarted(cti);
                this.maybeLogCrossProfileTargetLaunch(cti, user);
            }
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unable to launch as uid " + this.mLaunchedFromUid + " package " + this.getLaunchedFromPackage() + ", while running in " + ActivityThread.currentProcessName(), e);
        }
    }

    private void maybeLogCrossProfileTargetLaunch(TargetInfo cti, UserHandle currentUserHandle) {
        if (!this.hasWorkProfile() || currentUserHandle.equals(this.getUser())) {
            return;
        }
        DevicePolicyEventLogger.createEvent(155).setBoolean(currentUserHandle.equals(this.getPersonalProfileUserHandle())).setStrings(this.getMetricsCategory(), cti instanceof ChooserTargetInfo ? "direct_share" : "other_target").write();
    }

    public boolean startAsCallerImpl(Intent intent, Bundle options, boolean ignoreTargetSecurity, int userId) {
        try {
            IBinder permissionToken = ActivityTaskManager.getService().requestStartActivityPermissionToken(this.getActivityToken());
            Intent chooserIntent = new Intent();
            ComponentName delegateActivity = ComponentName.unflattenFromString(Resources.getSystem().getString(17039874));
            chooserIntent.setClassName(delegateActivity.getPackageName(), delegateActivity.getClassName());
            chooserIntent.putExtra("android.app.extra.PERMISSION_TOKEN", permissionToken);
            chooserIntent.putExtra("android.intent.extra.INTENT", intent);
            chooserIntent.putExtra("android.app.extra.OPTIONS", options);
            chooserIntent.putExtra("android.app.extra.EXTRA_IGNORE_TARGET_SECURITY", ignoreTargetSecurity);
            chooserIntent.putExtra("android.intent.extra.USER_ID", userId);
            chooserIntent.addFlags(0x3000000);
            this.startActivity(chooserIntent);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString());
        }
        return true;
    }

    public void onActivityStarted(TargetInfo cti) {
    }

    @Override
    public boolean shouldGetActivityMetadata() {
        return false;
    }

    public boolean shouldAutoLaunchSingleChoice(TargetInfo target) {
        return !target.isSuspended();
    }

    void showTargetDetails(ResolveInfo ri) {
        Intent in = new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts("package", ri.activityInfo.packageName, null)).addFlags(524288);
        this.startActivityAsUser(in, this.mMultiProfilePagerAdapter.getCurrentUserHandle());
    }

    @VisibleForTesting
    protected ResolverListAdapter createResolverListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed, UserHandle userHandle) {
        Intent startIntent = this.getIntent();
        boolean isAudioCaptureDevice = startIntent.getBooleanExtra(EXTRA_IS_AUDIO_CAPTURE_DEVICE, false);
        return new ResolverListAdapter(context, payloadIntents, initialIntents, rList, filterLastUsed, this.createListController(userHandle), this, isAudioCaptureDevice);
    }

    @VisibleForTesting
    protected ResolverListController createListController(UserHandle userHandle) {
        return new ResolverListController(this, this.mPm, this.getTargetIntent(), this.getReferrerPackageName(), this.mLaunchedFromUid, userHandle);
    }

    private boolean configureContentView() {
        boolean rebuildCompleted;
        if (this.mMultiProfilePagerAdapter.getActiveListAdapter() == null) {
            throw new IllegalStateException("mMultiProfilePagerAdapter.getCurrentListAdapter() cannot be null.");
        }
        boolean bl = rebuildCompleted = this.mMultiProfilePagerAdapter.rebuildActiveTab(true) || this.mMultiProfilePagerAdapter.getActiveListAdapter().isTabLoaded();
        if (this.shouldShowTabs()) {
            boolean rebuildInactiveCompleted = this.mMultiProfilePagerAdapter.rebuildInactiveTab(false) || this.mMultiProfilePagerAdapter.getInactiveListAdapter().isTabLoaded();
            rebuildCompleted = rebuildCompleted && rebuildInactiveCompleted;
        }
        this.mLayoutId = this.useLayoutWithDefault() ? 17367284 : this.getLayoutResource();
        this.setContentView(this.mLayoutId);
        this.mMultiProfilePagerAdapter.setupViewPager((ViewPager)this.findViewById(16909327));
        return this.postRebuildList(rebuildCompleted);
    }

    protected boolean postRebuildList(boolean rebuildCompleted) {
        return this.postRebuildListInternal(rebuildCompleted);
    }

    boolean postRebuildListInternal(boolean rebuildCompleted) {
        int count = this.mMultiProfilePagerAdapter.getActiveListAdapter().getUnfilteredCount();
        if (rebuildCompleted && this.maybeAutolaunchActivity()) {
            return true;
        }
        this.setupViewVisibilities();
        if (this.shouldShowTabs()) {
            this.setupProfileTabs();
        }
        return false;
    }

    private int isPermissionGranted(String permission2, int uid) {
        return ActivityManager.checkComponentPermission(permission2, uid, -1, true);
    }

    private boolean maybeAutolaunchActivity() {
        int numberOfProfiles = this.mMultiProfilePagerAdapter.getItemCount();
        if (numberOfProfiles == 1 && this.maybeAutolaunchIfSingleTarget()) {
            return true;
        }
        return numberOfProfiles == 2 && this.mMultiProfilePagerAdapter.getActiveListAdapter().isTabLoaded() && this.mMultiProfilePagerAdapter.getInactiveListAdapter().isTabLoaded() && (this.maybeAutolaunchIfNoAppsOnInactiveTab() || this.maybeAutolaunchIfCrossProfileSupported());
    }

    private boolean maybeAutolaunchIfSingleTarget() {
        int count = this.mMultiProfilePagerAdapter.getActiveListAdapter().getUnfilteredCount();
        if (count != 1) {
            return false;
        }
        if (this.mMultiProfilePagerAdapter.getActiveListAdapter().getOtherProfile() != null) {
            return false;
        }
        TargetInfo target = this.mMultiProfilePagerAdapter.getActiveListAdapter().targetInfoForPosition(0, false);
        if (this.shouldAutoLaunchSingleChoice(target)) {
            this.safelyStartActivity(target);
            this.finish();
            return true;
        }
        return false;
    }

    private boolean maybeAutolaunchIfNoAppsOnInactiveTab() {
        int count = this.mMultiProfilePagerAdapter.getActiveListAdapter().getUnfilteredCount();
        if (count != 1) {
            return false;
        }
        ResolverListAdapter inactiveListAdapter = this.mMultiProfilePagerAdapter.getInactiveListAdapter();
        if (inactiveListAdapter.getUnfilteredCount() != 0) {
            return false;
        }
        TargetInfo target = this.mMultiProfilePagerAdapter.getActiveListAdapter().targetInfoForPosition(0, false);
        this.safelyStartActivity(target);
        this.finish();
        return true;
    }

    private boolean maybeAutolaunchIfCrossProfileSupported() {
        ResolverListAdapter activeListAdapter = this.mMultiProfilePagerAdapter.getActiveListAdapter();
        int count = activeListAdapter.getUnfilteredCount();
        if (count != 1) {
            return false;
        }
        ResolverListAdapter inactiveListAdapter = this.mMultiProfilePagerAdapter.getInactiveListAdapter();
        if (inactiveListAdapter.getUnfilteredCount() != 1) {
            return false;
        }
        TargetInfo activeProfileTarget = activeListAdapter.targetInfoForPosition(0, false);
        TargetInfo inactiveProfileTarget = inactiveListAdapter.targetInfoForPosition(0, false);
        if (!Objects.equals(activeProfileTarget.getResolvedComponentName(), inactiveProfileTarget.getResolvedComponentName())) {
            return false;
        }
        if (!this.shouldAutoLaunchSingleChoice(activeProfileTarget)) {
            return false;
        }
        String packageName = activeProfileTarget.getResolvedComponentName().getPackageName();
        if (!this.canAppInteractCrossProfiles(packageName)) {
            return false;
        }
        DevicePolicyEventLogger.createEvent(161).setBoolean(activeListAdapter.getUserHandle().equals(this.getPersonalProfileUserHandle())).setStrings(this.getMetricsCategory()).write();
        this.safelyStartActivity(activeProfileTarget);
        this.finish();
        return true;
    }

    private boolean canAppInteractCrossProfiles(String packageName) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = this.getPackageManager().getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Package " + packageName + " does not exist on current user.");
            return false;
        }
        if (!applicationInfo.crossProfile) {
            return false;
        }
        int packageUid = applicationInfo.uid;
        if (this.isPermissionGranted("android.permission.INTERACT_ACROSS_USERS_FULL", packageUid) == 0) {
            return true;
        }
        if (this.isPermissionGranted("android.permission.INTERACT_ACROSS_USERS", packageUid) == 0) {
            return true;
        }
        return PermissionChecker.checkPermissionForPreflight(this, "android.permission.INTERACT_ACROSS_PROFILES", -1, packageUid, packageName) == 0;
    }

    private boolean isAutolaunching() {
        return !this.mRegistered && this.isFinishing();
    }

    private void setupProfileTabs() {
        this.maybeHideDivider();
        final TabHost tabHost = (TabHost)this.findViewById(16909328);
        tabHost.setup();
        ViewPager viewPager = (ViewPager)this.findViewById(16909327);
        viewPager.setSaveEnabled(false);
        TabHost.TabSpec tabSpec = tabHost.newTabSpec(TAB_TAG_PERSONAL).setContent(16909327).setIndicator(this.getString(17041286));
        tabHost.addTab(tabSpec);
        tabSpec = tabHost.newTabSpec(TAB_TAG_WORK).setContent(16909327).setIndicator(this.getString(17041290));
        tabHost.addTab(tabSpec);
        TabWidget tabWidget = tabHost.getTabWidget();
        tabWidget.setVisibility(0);
        this.resetTabsHeaderStyle(tabWidget);
        this.updateActiveTabStyle(tabHost);
        tabHost.setOnTabChangedListener(tabId -> {
            this.resetTabsHeaderStyle(tabWidget);
            this.updateActiveTabStyle(tabHost);
            if (TAB_TAG_PERSONAL.equals(tabId)) {
                viewPager.setCurrentItem(0);
            } else {
                viewPager.setCurrentItem(1);
            }
            this.setupViewVisibilities();
            this.maybeLogProfileChange();
            this.onProfileTabSelected();
            DevicePolicyEventLogger.createEvent(156).setInt(viewPager.getCurrentItem()).setStrings(this.getMetricsCategory()).write();
        });
        viewPager.setVisibility(0);
        tabHost.setCurrentTab(this.mMultiProfilePagerAdapter.getCurrentPage());
        this.mMultiProfilePagerAdapter.setOnProfileSelectedListener(new AbstractMultiProfilePagerAdapter.OnProfileSelectedListener(){

            @Override
            public void onProfileSelected(int index) {
                tabHost.setCurrentTab(index);
                ResolverActivity.this.resetButtonBar();
                ResolverActivity.this.resetCheckedItem();
            }

            @Override
            public void onProfilePageStateChanged(int state) {
                ResolverActivity.this.onHorizontalSwipeStateChanged(state);
            }
        });
        this.mMultiProfilePagerAdapter.setOnSwitchOnWorkSelectedListener(() -> {
            View workTab = tabHost.getTabWidget().getChildAt(1);
            workTab.setFocusable(true);
            workTab.setFocusableInTouchMode(true);
            workTab.requestFocus();
        });
        ((View)this.findViewById(16909368)).setVisibility(0);
    }

    void onHorizontalSwipeStateChanged(int state) {
    }

    private void maybeHideDivider() {
        if (!this.isIntentPicker()) {
            return;
        }
        Object divider = this.findViewById(16908938);
        if (divider == null) {
            return;
        }
        ((View)divider).setVisibility(8);
    }

    protected void onProfileTabSelected() {
    }

    private void resetCheckedItem() {
        if (!this.isIntentPicker()) {
            return;
        }
        this.mLastSelected = -1;
        ListView inactiveListView = (ListView)this.mMultiProfilePagerAdapter.getInactiveAdapterView();
        if (inactiveListView.getCheckedItemCount() > 0) {
            inactiveListView.setItemChecked(inactiveListView.getCheckedItemPosition(), false);
        }
    }

    private void resetTabsHeaderStyle(TabWidget tabWidget) {
        String workContentDescription = this.getString(17041291);
        String personalContentDescription = this.getString(17041287);
        for (int i = 0; i < tabWidget.getChildCount(); ++i) {
            View tabView = tabWidget.getChildAt(i);
            TextView title = (TextView)tabView.findViewById(16908310);
            title.setTextAppearance(16974264);
            title.setTextColor(ResolverActivity.getAttrColor(this, 0x1010212));
            title.setTextSize(0, this.getResources().getDimension(17105493));
            if (title.getText().equals(this.getString(17041286))) {
                tabView.setContentDescription(personalContentDescription);
                continue;
            }
            if (!title.getText().equals(this.getString(17041290))) continue;
            tabView.setContentDescription(workContentDescription);
        }
    }

    private static int getAttrColor(Context context, int attr2) {
        TypedArray ta = context.obtainStyledAttributes(new int[]{attr2});
        int colorAccent = ta.getColor(0, 0);
        ta.recycle();
        return colorAccent;
    }

    private void updateActiveTabStyle(TabHost tabHost) {
        TextView title = (TextView)tabHost.getTabWidget().getChildAt(tabHost.getCurrentTab()).findViewById(16908310);
        title.setTextColor(ResolverActivity.getAttrColor(this, 16843829));
    }

    private void setupViewVisibilities() {
        ResolverListAdapter activeListAdapter = this.mMultiProfilePagerAdapter.getActiveListAdapter();
        if (!this.mMultiProfilePagerAdapter.shouldShowEmptyStateScreen(activeListAdapter)) {
            this.addUseDifferentAppLabelIfNecessary(activeListAdapter);
        }
    }

    public void addUseDifferentAppLabelIfNecessary(ResolverListAdapter adapter) {
        boolean useHeader = adapter.hasFilteredItem();
        if (useHeader) {
            FrameLayout stub = (FrameLayout)this.findViewById(16909498);
            stub.setVisibility(0);
            TextView textView = (TextView)LayoutInflater.from(this).inflate(17367280, null, false);
            if (this.shouldShowTabs()) {
                textView.setGravity(17);
            }
            stub.addView(textView);
        }
    }

    private void setupAdapterListView(ListView listView, ItemClickListener listener2) {
        listView.setOnItemClickListener(listener2);
        listView.setOnItemLongClickListener(listener2);
        if (this.mSupportsAlwaysUseOption) {
            listView.setChoiceMode(1);
        }
    }

    private void maybeCreateHeader(ResolverListAdapter listAdapter) {
        ImageView iconView;
        CharSequence title;
        TextView titleView;
        if (this.mHeaderCreatorUser != null && !listAdapter.getUserHandle().equals(this.mHeaderCreatorUser)) {
            return;
        }
        if (!this.shouldShowTabs() && listAdapter.getCount() == 0 && listAdapter.getPlaceholderCount() == 0 && (titleView = (TextView)this.findViewById(16908310)) != null) {
            titleView.setVisibility(8);
        }
        CharSequence charSequence = title = this.mTitle != null ? this.mTitle : this.getTitleForAction(this.getTargetIntent(), this.mDefaultTitleResId);
        if (!TextUtils.isEmpty(title)) {
            TextView titleView2 = (TextView)this.findViewById(16908310);
            if (titleView2 != null) {
                titleView2.setText(title);
            }
            this.setTitle(title);
        }
        if ((iconView = (ImageView)this.findViewById(16908294)) != null) {
            listAdapter.loadFilteredItemIconTaskAsync(iconView);
        }
        this.mHeaderCreatorUser = listAdapter.getUserHandle();
    }

    protected void resetButtonBar() {
        if (!this.mSupportsAlwaysUseOption) {
            return;
        }
        ViewGroup buttonLayout = (ViewGroup)this.findViewById(16908814);
        if (buttonLayout == null) {
            Log.e(TAG, "Layout unexpectedly does not have a button bar");
            return;
        }
        ResolverListAdapter activeListAdapter = this.mMultiProfilePagerAdapter.getActiveListAdapter();
        Object buttonBarDivider = this.findViewById(16909359);
        if (!this.useLayoutWithDefault()) {
            int inset = this.mSystemWindowInsets != null ? this.mSystemWindowInsets.bottom : 0;
            buttonLayout.setPadding(buttonLayout.getPaddingLeft(), buttonLayout.getPaddingTop(), buttonLayout.getPaddingRight(), this.getResources().getDimensionPixelSize(17105478) + inset);
        }
        if (activeListAdapter.isTabLoaded() && this.mMultiProfilePagerAdapter.shouldShowEmptyStateScreen(activeListAdapter) && !this.useLayoutWithDefault()) {
            buttonLayout.setVisibility(4);
            if (buttonBarDivider != null) {
                ((View)buttonBarDivider).setVisibility(4);
            }
            this.setButtonBarIgnoreOffset(false);
            return;
        }
        if (buttonBarDivider != null) {
            ((View)buttonBarDivider).setVisibility(0);
        }
        buttonLayout.setVisibility(0);
        this.setButtonBarIgnoreOffset(true);
        this.mOnceButton = (Button)buttonLayout.findViewById(0x1020210);
        this.mAlwaysButton = (Button)buttonLayout.findViewById(16908813);
        this.resetAlwaysOrOnceButtonBar();
    }

    private void setButtonBarIgnoreOffset(boolean ignoreOffset) {
        Object buttonBarContainer = this.findViewById(16908815);
        if (buttonBarContainer != null) {
            ResolverDrawerLayout.LayoutParams layoutParams = (ResolverDrawerLayout.LayoutParams)((View)buttonBarContainer).getLayoutParams();
            layoutParams.ignoreOffset = ignoreOffset;
            ((View)buttonBarContainer).setLayoutParams(layoutParams);
        }
    }

    private void resetAlwaysOrOnceButtonBar() {
        this.setAlwaysButtonEnabled(false, -1, false);
        this.mOnceButton.setEnabled(false);
        int filteredPosition = this.mMultiProfilePagerAdapter.getActiveListAdapter().getFilteredPosition();
        if (this.useLayoutWithDefault() && filteredPosition != -1) {
            this.setAlwaysButtonEnabled(true, filteredPosition, false);
            this.mOnceButton.setEnabled(true);
            this.mOnceButton.requestFocus();
            return;
        }
        ListView currentAdapterView = (ListView)this.mMultiProfilePagerAdapter.getActiveAdapterView();
        if (currentAdapterView != null && currentAdapterView.getCheckedItemPosition() != -1) {
            this.setAlwaysButtonEnabled(true, currentAdapterView.getCheckedItemPosition(), true);
            this.mOnceButton.setEnabled(true);
        }
    }

    @Override
    public boolean useLayoutWithDefault() {
        boolean currentUserAdapterHasFilteredItem = this.mMultiProfilePagerAdapter.getCurrentUserHandle().getIdentifier() == UserHandle.myUserId() ? this.mMultiProfilePagerAdapter.getActiveListAdapter().hasFilteredItem() : this.mMultiProfilePagerAdapter.getInactiveListAdapter().hasFilteredItem();
        return this.mSupportsAlwaysUseOption && currentUserAdapterHasFilteredItem;
    }

    protected void setRetainInOnStop(boolean retainInOnStop) {
        this.mRetainInOnStop = retainInOnStop;
    }

    @Override
    public boolean resolveInfoMatch(ResolveInfo lhs, ResolveInfo rhs) {
        return lhs == null ? rhs == null : (lhs.activityInfo == null ? rhs.activityInfo == null : Objects.equals(lhs.activityInfo.name, rhs.activityInfo.name) && Objects.equals(lhs.activityInfo.packageName, rhs.activityInfo.packageName));
    }

    protected String getMetricsCategory() {
        return METRICS_CATEGORY_RESOLVER;
    }

    @Override
    public void onHandlePackagesChanged(ResolverListAdapter listAdapter) {
        if (listAdapter == this.mMultiProfilePagerAdapter.getActiveListAdapter()) {
            if (listAdapter.getUserHandle().equals(this.getWorkProfileUserHandle()) && this.mMultiProfilePagerAdapter.isWaitingToEnableWorkProfile()) {
                return;
            }
            boolean listRebuilt = this.mMultiProfilePagerAdapter.rebuildActiveTab(true);
            if (listRebuilt) {
                ResolverListAdapter activeListAdapter = this.mMultiProfilePagerAdapter.getActiveListAdapter();
                activeListAdapter.notifyDataSetChanged();
                if (activeListAdapter.getCount() == 0 && !this.inactiveListAdapterHasItems()) {
                    this.finish();
                }
            }
        } else {
            this.mMultiProfilePagerAdapter.clearInactiveProfileCache();
        }
    }

    private boolean inactiveListAdapterHasItems() {
        if (!this.shouldShowTabs()) {
            return false;
        }
        return this.mMultiProfilePagerAdapter.getInactiveListAdapter().getCount() > 0;
    }

    private BroadcastReceiver createWorkProfileStateReceiver() {
        return new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action2 = intent.getAction();
                if (!(TextUtils.equals(action2, "android.intent.action.USER_UNLOCKED") || TextUtils.equals(action2, "android.intent.action.MANAGED_PROFILE_UNAVAILABLE") || TextUtils.equals(action2, "android.intent.action.MANAGED_PROFILE_AVAILABLE"))) {
                    return;
                }
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userId != ResolverActivity.this.getWorkProfileUserHandle().getIdentifier()) {
                    return;
                }
                if (ResolverActivity.this.isWorkProfileEnabled()) {
                    if (ResolverActivity.this.mWorkProfileHasBeenEnabled) {
                        return;
                    }
                    ResolverActivity.this.mWorkProfileHasBeenEnabled = true;
                    ResolverActivity.this.mMultiProfilePagerAdapter.markWorkProfileEnabledBroadcastReceived();
                } else {
                    ResolverActivity.this.mWorkProfileHasBeenEnabled = false;
                }
                if (ResolverActivity.this.mMultiProfilePagerAdapter.getCurrentUserHandle().equals(ResolverActivity.this.getWorkProfileUserHandle())) {
                    ResolverActivity.this.mMultiProfilePagerAdapter.rebuildActiveTab(true);
                } else {
                    ResolverActivity.this.mMultiProfilePagerAdapter.clearInactiveProfileCache();
                }
            }
        };
    }

    static boolean isSpecificUriMatch(int match) {
        return (match &= 0xFFF0000) >= 0x300000 && match <= 0x500000;
    }

    protected void maybeLogProfileChange() {
    }

    static class PickTargetOptionRequest
    extends VoiceInteractor.PickOptionRequest {
        public PickTargetOptionRequest(VoiceInteractor.Prompt prompt, VoiceInteractor.PickOptionRequest.Option[] options, Bundle extras) {
            super(prompt, options, extras);
        }

        @Override
        public void onCancel() {
            super.onCancel();
            ResolverActivity ra = (ResolverActivity)this.getActivity();
            if (ra != null) {
                ra.mPickOptionRequest = null;
                ra.finish();
            }
        }

        @Override
        public void onPickOptionResult(boolean finished, VoiceInteractor.PickOptionRequest.Option[] selections, Bundle result) {
            TargetInfo ti;
            super.onPickOptionResult(finished, selections, result);
            if (selections.length != 1) {
                return;
            }
            ResolverActivity ra = (ResolverActivity)this.getActivity();
            if (ra != null && ra.onTargetSelected(ti = ra.mMultiProfilePagerAdapter.getActiveListAdapter().getItem(selections[0].getIndex()), false)) {
                ra.mPickOptionRequest = null;
                ra.finish();
            }
        }
    }

    class ItemClickListener
    implements AdapterView.OnItemClickListener,
    AdapterView.OnItemLongClickListener {
        ItemClickListener() {
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            boolean hasValidSelection;
            ListView listView;
            ListView listView2 = listView = parent instanceof ListView ? (ListView)parent : null;
            if (listView != null) {
                position -= listView.getHeaderViewsCount();
            }
            if (position < 0) {
                return;
            }
            if (ResolverActivity.this.mMultiProfilePagerAdapter.getActiveListAdapter().resolveInfoForPosition(position, true) == null) {
                return;
            }
            ListView currentAdapterView = (ListView)ResolverActivity.this.mMultiProfilePagerAdapter.getActiveAdapterView();
            int checkedPos = currentAdapterView.getCheckedItemPosition();
            boolean bl = hasValidSelection = checkedPos != -1;
            if (!(ResolverActivity.this.useLayoutWithDefault() || hasValidSelection && ResolverActivity.this.mLastSelected == checkedPos || ResolverActivity.this.mAlwaysButton == null)) {
                ResolverActivity.this.setAlwaysButtonEnabled(hasValidSelection, checkedPos, true);
                ResolverActivity.this.mOnceButton.setEnabled(hasValidSelection);
                if (hasValidSelection) {
                    currentAdapterView.smoothScrollToPosition(checkedPos);
                    ResolverActivity.this.mOnceButton.requestFocus();
                }
                ResolverActivity.this.mLastSelected = checkedPos;
            } else {
                ResolverActivity.this.startSelected(position, false, true);
            }
        }

        @Override
        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
            ListView listView;
            ListView listView2 = listView = parent instanceof ListView ? (ListView)parent : null;
            if (listView != null) {
                position -= listView.getHeaderViewsCount();
            }
            if (position < 0) {
                return false;
            }
            ResolveInfo ri = ResolverActivity.this.mMultiProfilePagerAdapter.getActiveListAdapter().resolveInfoForPosition(position, true);
            ResolverActivity.this.showTargetDetails(ri);
            return true;
        }
    }

    @VisibleForTesting
    public static class ResolvedComponentInfo {
        public final ComponentName name;
        private final List<Intent> mIntents = new ArrayList<Intent>();
        private final List<ResolveInfo> mResolveInfos = new ArrayList<ResolveInfo>();
        private boolean mPinned;

        public ResolvedComponentInfo(ComponentName name, Intent intent, ResolveInfo info) {
            this.name = name;
            this.add(intent, info);
        }

        public void add(Intent intent, ResolveInfo info) {
            this.mIntents.add(intent);
            this.mResolveInfos.add(info);
        }

        public int getCount() {
            return this.mIntents.size();
        }

        public Intent getIntentAt(int index) {
            return index >= 0 ? this.mIntents.get(index) : null;
        }

        public ResolveInfo getResolveInfoAt(int index) {
            return index >= 0 ? this.mResolveInfos.get(index) : null;
        }

        public int findIntent(Intent intent) {
            int N = this.mIntents.size();
            for (int i = 0; i < N; ++i) {
                if (!intent.equals(this.mIntents.get(i))) continue;
                return i;
            }
            return -1;
        }

        public int findResolveInfo(ResolveInfo info) {
            int N = this.mResolveInfos.size();
            for (int i = 0; i < N; ++i) {
                if (!info.equals(this.mResolveInfos.get(i))) continue;
                return i;
            }
            return -1;
        }

        public boolean isPinned() {
            return this.mPinned;
        }

        public void setPinned(boolean pinned) {
            this.mPinned = pinned;
        }
    }

    private static enum ActionTitle {
        VIEW("android.intent.action.VIEW", 17041647, 17041649, 17041648),
        EDIT("android.intent.action.EDIT", 17041627, 17041629, 17041628),
        SEND("android.intent.action.SEND", 17041641, 17041643, 17041642),
        SENDTO("android.intent.action.SENDTO", 17041644, 17041646, 17041645),
        SEND_MULTIPLE("android.intent.action.SEND_MULTIPLE", 17041641, 17041643, 17041642),
        CAPTURE_IMAGE("android.media.action.IMAGE_CAPTURE", 17041634, 17041636, 17041635),
        DEFAULT(null, 17041624, 17041626, 17041625),
        HOME("android.intent.action.MAIN", 17041631, 17041633, 17041632);

        public static final int BROWSABLE_TITLE_RES = 17041639;
        public static final int BROWSABLE_HOST_TITLE_RES = 17041637;
        public static final int BROWSABLE_HOST_APP_TITLE_RES = 17041638;
        public static final int BROWSABLE_APP_TITLE_RES = 17041640;
        public final String action;
        public final int titleRes;
        public final int namedTitleRes;
        public final int labelRes;

        private ActionTitle(String action2, int titleRes, int namedTitleRes, int labelRes) {
            this.action = action2;
            this.titleRes = titleRes;
            this.namedTitleRes = namedTitleRes;
            this.labelRes = labelRes;
        }

        public static ActionTitle forAction(String action2) {
            for (ActionTitle title : ActionTitle.values()) {
                if (title == HOME || action2 == null || !action2.equals(title.action)) continue;
                return title;
            }
            return DEFAULT;
        }
    }
}

