/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.ObjectAnimator;
import android.app.ActionBar;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.AnalogClock;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.android.internal.lang.System_Delegate;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.json.JSONObject;

public class PlatLogoActivity
extends Activity {
    private static final String TAG = "PlatLogoActivity";
    private static final String S_EGG_UNLOCK_SETTING = "egg_mode_s";
    private SettableAnalogClock mClock;
    private ImageView mLogo;
    private BubblesDrawable mBg;
    static final String TOUCH_STATS = "touch.stats";
    double mPressureMin = 0.0;
    double mPressureMax = -1.0;

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setNavigationBarColor(0);
        this.getWindow().setStatusBarColor(0);
        ActionBar ab = this.getActionBar();
        if (ab != null) {
            ab.hide();
        }
        FrameLayout layout2 = new FrameLayout(this);
        this.mClock = new SettableAnalogClock(this);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float dp = dm.density;
        int minSide = Math.min(dm.widthPixels, dm.heightPixels);
        int widgetSize = (int)((double)minSide * 0.75);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(widgetSize, widgetSize);
        lp.gravity = 17;
        layout2.addView((View)this.mClock, lp);
        this.mLogo = new ImageView(this);
        this.mLogo.setVisibility(8);
        this.mLogo.setImageResource(17303167);
        layout2.addView((View)this.mLogo, lp);
        this.mBg = new BubblesDrawable();
        this.mBg.setLevel(0);
        this.mBg.avoid = widgetSize / 2;
        this.mBg.padding = 0.5f * dp;
        this.mBg.minR = 1.0f * dp;
        layout2.setBackground(this.mBg);
        this.setContentView(layout2);
    }

    private boolean shouldWriteSettings() {
        return this.getPackageName().equals("android");
    }

    private void launchNextStage(boolean locked) {
        this.mClock.animate().alpha(0.0f).scaleX(0.5f).scaleY(0.5f).withEndAction(() -> this.mClock.setVisibility(8)).start();
        this.mLogo.setAlpha(0.0f);
        this.mLogo.setScaleX(0.5f);
        this.mLogo.setScaleY(0.5f);
        this.mLogo.setVisibility(0);
        this.mLogo.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setInterpolator(new OvershootInterpolator()).start();
        this.mLogo.postDelayed(() -> {
            ObjectAnimator anim2 = ObjectAnimator.ofInt((Object)this.mBg, "level", 0, 10000);
            anim2.setInterpolator(new DecelerateInterpolator(1.0f));
            anim2.start();
        }, 500L);
        ContentResolver cr = this.getContentResolver();
        try {
            if (this.shouldWriteSettings()) {
                Log.v(TAG, "Saving egg unlock=" + locked);
                this.syncTouchPressure();
                Settings.System.putLong(cr, S_EGG_UNLOCK_SETTING, locked ? 0L : System_Delegate.currentTimeMillis());
            }
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Can't write settings", e);
        }
        try {
            this.startActivity(new Intent("android.intent.action.MAIN").setFlags(0x10008000).addCategory("com.android.internal.category.PLATLOGO"));
        }
        catch (ActivityNotFoundException ex) {
            Log.e("com.android.internal.app.PlatLogoActivity", "No more eggs.");
        }
    }

    private void measureTouchPressure(MotionEvent event) {
        float pressure = event.getPressure();
        switch (event.getActionMasked()) {
            case 0: {
                if (!(this.mPressureMax < 0.0)) break;
                this.mPressureMin = this.mPressureMax = (double)pressure;
                break;
            }
            case 2: {
                if ((double)pressure < this.mPressureMin) {
                    this.mPressureMin = pressure;
                }
                if (!((double)pressure > this.mPressureMax)) break;
                this.mPressureMax = pressure;
            }
        }
    }

    private void syncTouchPressure() {
        try {
            String touchDataJson = Settings.System.getString(this.getContentResolver(), TOUCH_STATS);
            JSONObject touchData = new JSONObject(touchDataJson != null ? touchDataJson : "{}");
            if (touchData.has("min")) {
                this.mPressureMin = Math.min(this.mPressureMin, touchData.getDouble("min"));
            }
            if (touchData.has("max")) {
                this.mPressureMax = Math.max(this.mPressureMax, touchData.getDouble("max"));
            }
            if (this.mPressureMax >= 0.0) {
                touchData.put("min", this.mPressureMin);
                touchData.put("max", this.mPressureMax);
                if (this.shouldWriteSettings()) {
                    Settings.System.putString(this.getContentResolver(), TOUCH_STATS, touchData.toString());
                }
            }
        }
        catch (Exception e) {
            Log.e("com.android.internal.app.PlatLogoActivity", "Can't write touch settings", e);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.syncTouchPressure();
    }

    @Override
    public void onStop() {
        this.syncTouchPressure();
        super.onStop();
    }

    class BubblesDrawable
    extends Drawable {
        private static final int MAX_BUBBS = 2000;
        private final int[] mColorIds = new int[]{17170493, 17170494, 17170495, 17170506, 17170507, 17170508};
        private int[] mColors = new int[this.mColorIds.length];
        private final Bubble[] mBubbs = new Bubble[2000];
        private int mNumBubbs;
        private final Paint mPaint = new Paint(1);
        public float avoid = 0.0f;
        public float padding = 0.0f;
        public float minR = 0.0f;

        BubblesDrawable() {
            for (int i = 0; i < this.mColorIds.length; ++i) {
                this.mColors[i] = PlatLogoActivity.this.getColor(this.mColorIds[i]);
            }
            for (int j = 0; j < this.mBubbs.length; ++j) {
                this.mBubbs[j] = new Bubble();
            }
        }

        @Override
        public void draw(Canvas canvas) {
            float f = (float)this.getLevel() / 10000.0f;
            this.mPaint.setStyle(Paint.Style.FILL);
            int drawn = 0;
            for (int j = 0; j < this.mNumBubbs; ++j) {
                if (this.mBubbs[j].color == 0 || this.mBubbs[j].r == 0.0f) continue;
                this.mPaint.setColor(this.mBubbs[j].color);
                canvas.drawCircle(this.mBubbs[j].x, this.mBubbs[j].y, this.mBubbs[j].r * f, this.mPaint);
                ++drawn;
            }
        }

        @Override
        protected boolean onLevelChange(int level) {
            this.invalidateSelf();
            return true;
        }

        @Override
        protected void onBoundsChange(Rect bounds2) {
            super.onBoundsChange(bounds2);
            this.randomize();
        }

        private void randomize() {
            float w = this.getBounds().width();
            float h = this.getBounds().height();
            float maxR = Math.min(w, h) / 3.0f;
            this.mNumBubbs = 0;
            if (this.avoid > 0.0f) {
                this.mBubbs[this.mNumBubbs].x = w / 2.0f;
                this.mBubbs[this.mNumBubbs].y = h / 2.0f;
                this.mBubbs[this.mNumBubbs].r = this.avoid;
                this.mBubbs[this.mNumBubbs].color = 0;
                ++this.mNumBubbs;
            }
            block0: for (int j = 0; j < 2000; ++j) {
                int tries = 5;
                while (tries-- > 0) {
                    float x = (float)Math.random() * w;
                    float y = (float)Math.random() * h;
                    float r = Math.min(Math.min(x, w - x), Math.min(y, h - y));
                    for (int i = 0; i < this.mNumBubbs && !((r = (float)Math.min((double)r, Math.hypot(x - this.mBubbs[i].x, y - this.mBubbs[i].y) - (double)this.mBubbs[i].r - (double)this.padding)) < this.minR); ++i) {
                    }
                    if (!(r >= this.minR)) continue;
                    r = Math.min(maxR, r);
                    this.mBubbs[this.mNumBubbs].x = x;
                    this.mBubbs[this.mNumBubbs].y = y;
                    this.mBubbs[this.mNumBubbs].r = r;
                    this.mBubbs[this.mNumBubbs].color = this.mColors[(int)(Math.random() * (double)this.mColors.length)];
                    ++this.mNumBubbs;
                    continue block0;
                }
            }
            Log.v(PlatLogoActivity.TAG, String.format("successfully placed %d bubbles (%d%%)", this.mNumBubbs, (int)(100.0f * (float)this.mNumBubbs / 2000.0f)));
        }

        @Override
        public void setAlpha(int alpha) {
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
        }

        @Override
        public int getOpacity() {
            return -3;
        }
    }

    static class Bubble {
        public float x;
        public float y;
        public float r;
        public int color;

        Bubble() {
        }
    }

    public class SettableAnalogClock
    extends AnalogClock {
        private int mOverrideHour;
        private int mOverrideMinute;
        private boolean mOverride;

        public SettableAnalogClock(Context context) {
            super(context);
            this.mOverrideHour = -1;
            this.mOverrideMinute = -1;
            this.mOverride = false;
        }

        @Override
        protected Instant now() {
            Instant realNow = super.now();
            ZoneId tz = Clock.systemDefaultZone().getZone();
            ZonedDateTime zdTime = realNow.atZone(tz);
            if (this.mOverride) {
                if (this.mOverrideHour < 0) {
                    this.mOverrideHour = zdTime.getHour();
                }
                return Clock.fixed(zdTime.withHour(this.mOverrideHour).withMinute(this.mOverrideMinute).withSecond(0).toInstant(), tz).instant();
            }
            return realNow;
        }

        double toPositiveDegrees(double rad) {
            return (Math.toDegrees(rad) + 360.0 - 90.0) % 360.0;
        }

        @Override
        public boolean onTouchEvent(MotionEvent ev) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mOverride = true;
                }
                case 2: {
                    PlatLogoActivity.this.measureTouchPressure(ev);
                    float x = ev.getX();
                    float y = ev.getY();
                    float cx = (float)this.getWidth() / 2.0f;
                    float cy = (float)this.getHeight() / 2.0f;
                    float angle = (float)this.toPositiveDegrees(Math.atan2(x - cx, y - cy));
                    int minutes = (75 - (int)(angle / 6.0f)) % 60;
                    int minuteDelta = minutes - this.mOverrideMinute;
                    if (minuteDelta != 0) {
                        if (Math.abs(minuteDelta) > 45 && this.mOverrideHour >= 0) {
                            int hourDelta = minuteDelta < 0 ? 1 : -1;
                            this.mOverrideHour = (this.mOverrideHour + 24 + hourDelta) % 24;
                        }
                        this.mOverrideMinute = minutes;
                        if (this.mOverrideMinute == 0) {
                            this.performHapticFeedback(0);
                            if (this.getScaleX() == 1.0f) {
                                this.setScaleX(1.05f);
                                this.setScaleY(1.05f);
                                this.animate().scaleX(1.0f).scaleY(1.0f).setDuration(150L).start();
                            }
                        } else {
                            this.performHapticFeedback(4);
                        }
                        this.onTimeChanged();
                        this.postInvalidate();
                    }
                    return true;
                }
                case 1: {
                    if (this.mOverrideMinute == 0 && this.mOverrideHour % 12 == 0) {
                        Log.v(PlatLogoActivity.TAG, "12:00 let's gooooo");
                        this.performHapticFeedback(0);
                        PlatLogoActivity.this.launchNextStage(false);
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

